/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.TreeBackedLighterAST;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Trinity;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LanguageStubDefinition;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LanguageStubDescriptor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBuilderType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElementRegistryService;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexedFile;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;
import org.jetbrains.kotlin.com.intellij.util.indexing.PsiDependentFileContent;

public final class StubTreeBuilder {
    private static final Logger LOG = Logger.getInstance(StubTreeBuilder.class);
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    public static StubBuilderType getStubBuilderType(@NotNull IndexedFile file, boolean toBuild) {
        FileType fileType;
        BinaryFileStubBuilder builder2;
        if (file == null) {
            StubTreeBuilder.$$$reportNull$$$0(1);
        }
        if ((builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType = file.getFileType())) != null) {
            if (builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
                Object subBuilder = ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2).getSubBuilder((FileContent)file);
                return new StubBuilderType((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2, subBuilder);
            }
            return new StubBuilderType(builder2);
        }
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            StubElementRegistryService stubElementRegistryService = StubElementRegistryService.getInstance();
            LanguageStubDescriptor stubDescriptor = stubElementRegistryService.getStubDescriptor(l);
            if (stubDescriptor == null) {
                return null;
            }
            VirtualFile vFile = file.getFile();
            boolean shouldBuildStubFor = stubDescriptor.getStubDefinition().shouldBuildStubFor(vFile);
            if (toBuild && !shouldBuildStubFor) {
                return null;
            }
            PushedFilePropertiesRetriever pushedFilePropertiesRetriever = PushedFilePropertiesRetriever.getInstance();
            @NotNull List<String> properties2 = pushedFilePropertiesRetriever != null ? pushedFilePropertiesRetriever.dumpSortedPushedProperties(vFile) : Collections.emptyList();
            return new StubBuilderType(stubDescriptor, properties2);
        }
        return null;
    }

    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData) {
        StubBuilderType type;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(2);
        }
        if ((type = StubTreeBuilder.getStubBuilderType(inputData, false)) == null) {
            return null;
        }
        return StubTreeBuilder.buildStubTree(inputData, type);
    }

    @Nullable
    private static <T> T handleStubBuilderException(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType, @NotNull ThrowableComputable<T, Exception> builder2) {
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(3);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(5);
        }
        try {
            return builder2.compute();
        }
        catch (CancellationException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrowUnchecked(e);
            }
            LOG.error(PluginException.createByClass("Failed to build stub tree for " + inputData.getFileName(), e, stubBuilderType.getClassToBlameInCaseOfException()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType) {
        Stub data;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(6);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(7);
        }
        if ((data = inputData.getUserData(stubElementKey)) != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            BinaryFileStubBuilder builder2 = stubBuilderType.getBinaryFileStubBuilder();
            if (builder2 != null) {
                data = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> builder2.buildStubTree(inputData));
                if (data instanceof PsiFileStubImpl && !((PsiFileStubImpl)data).rootsAreSet()) {
                    ((PsiFileStubImpl)data).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data});
                }
            } else {
                CharSequence contentAsText = inputData.getContentAsText();
                PsiDependentFileContent fileContent2 = (PsiDependentFileContent)inputData;
                FileViewProvider viewProvider = fileContent2.getPsiFile().getViewProvider();
                PsiFile psi = viewProvider.getStubBindingRoot();
                data = psi.getManager().runInBatchFilesMode(() -> {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                    StubElement built = null;
                    try {
                        LanguageStubDescriptor stubDescriptor = ((PsiFileImpl)psi).getStubDescriptor();
                        if (stubDescriptor != null) {
                            PsiFileStub<?>[] stubsArray;
                            LanguageStubDefinition stubDefinition = stubDescriptor.getStubDefinition();
                            StubBuilder stubBuilder = stubDefinition.getBuilder();
                            if (stubBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set(fileContent2.getLighterAST());
                            }
                            built = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> stubBuilder.buildStubTree(psi));
                            List<Pair<LanguageStubDescriptor, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRootDescriptors(viewProvider);
                            ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                            stubs.add((PsiFileStub)built);
                            for (Pair<LanguageStubDescriptor, PsiFile> stubbedRoot : stubbedRoots) {
                                StubElement element;
                                PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                                if (psi == secondaryPsi) continue;
                                StubBuilder stubbedRootBuilder = ((LanguageStubDescriptor)stubbedRoot.first).getStubDefinition().getBuilder();
                                if (stubbedRootBuilder instanceof LightStubBuilder) {
                                    LightStubBuilder.FORCED_AST.set(new TreeBackedLighterAST(secondaryPsi.getNode()));
                                }
                                if ((element = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> stubbedRootBuilder.buildStubTree(secondaryPsi))) instanceof PsiFileStub) {
                                    stubs.add((PsiFileStub)element);
                                }
                                StubTreeBuilder.ensureNormalizedOrder(element);
                            }
                            for (PsiFileStub<?> stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
                                if (!(stub instanceof PsiFileStubImpl)) continue;
                                ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                            }
                        }
                    }
                    finally {
                        psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    }
                    return built;
                });
            }
            StubTreeBuilder.ensureNormalizedOrder(data);
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }

    private static void ensureNormalizedOrder(Stub element) {
        if (element instanceof StubBase) {
            ((StubBase)element).getStubList().finalizeLoadingStage();
        }
    }

    @Deprecated
    public static @Unmodifiable @NotNull List<Pair<IStubFileElementType<?>, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            StubTreeBuilder.$$$reportNull$$$0(8);
        }
        List<Pair<LanguageStubDescriptor, PsiFile>> descriptors = StubTreeBuilder.getStubbedRootDescriptors(viewProvider);
        List<Pair<IStubFileElementType<?>, PsiFile>> list = ContainerUtil.map(descriptors, pair -> Pair.create((IStubFileElementType)((LanguageStubDescriptor)pair.first).getFileElementType(), (PsiFile)pair.second));
        if (list == null) {
            StubTreeBuilder.$$$reportNull$$$0(9);
        }
        return list;
    }

    @ApiStatus.Experimental
    public static @Unmodifiable @NotNull List<Pair<LanguageStubDescriptor, PsiFile>> getStubbedRootDescriptors(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            StubTreeBuilder.$$$reportNull$$$0(10);
        }
        SmartList<Trinity<Language, LanguageStubDescriptor, PsiFile>> roots = new SmartList<Trinity<Language, LanguageStubDescriptor, PsiFile>>();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language : viewProvider.getLanguages()) {
            LanguageStubDescriptor descriptor;
            PsiFile file = viewProvider.getPsi(language);
            if (!(file instanceof PsiFileImpl) || (descriptor = ((PsiFileImpl)file).getStubDescriptor()) == null) continue;
            roots.add(Trinity.create(language, descriptor, file));
        }
        ContainerUtil.sort(roots, (o1, o2) -> {
            if (o1.third == stubBindingRoot) {
                return o2.third == stubBindingRoot ? 0 : -1;
            }
            if (o2.third == stubBindingRoot) {
                return 1;
            }
            return StringUtil.compare(((Language)o1.first).getID(), ((Language)o2.first).getID(), false);
        });
        List<Pair<LanguageStubDescriptor, PsiFile>> list = ContainerUtil.map(roots, trinity -> Pair.create((LanguageStubDescriptor)trinity.second, (PsiFile)trinity.third));
        if (list == null) {
            StubTreeBuilder.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubBuilderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedRootDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requiresContentToFindBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilderType";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleStubBuilderException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedRoots";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedRootDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

