/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.ArchiveFileType;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaMultiReleaseModuleSupport;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public final class JavaMultiReleaseUtil {
    public static final LanguageLevel MAX_NON_MULTI_RELEASE_VERSION = LanguageLevel.JDK_1_8;
    public static final LanguageLevel MIN_MULTI_RELEASE_VERSION = LanguageLevel.JDK_1_9;
    private static final Pattern javaVersionPattern = Pattern.compile("java\\d+");

    @Contract(value="null, _ -> false; !null, null -> false")
    @ApiStatus.Internal
    public static boolean areMainAndAdditionalMultiReleaseModules(@Nullable Module mainModule, @Nullable Module additionalModule) {
        if (mainModule == null || additionalModule == null) {
            return false;
        }
        if (JavaMultiReleaseUtil.getMainMultiReleaseModule(additionalModule) == mainModule) {
            return true;
        }
        String mainModuleName = mainModule.getName();
        if (mainModuleName.endsWith(".main")) {
            String baseModuleName = StringUtil.substringBeforeLast(mainModuleName, "main");
            String moduleName2 = additionalModule.getName();
            return javaVersionPattern.matcher(ObjectUtils.coalesce(StringUtil.substringAfter(moduleName2, baseModuleName), moduleName2)).matches();
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public static Module getMainMultiReleaseModule(@NotNull Module additionalModule) {
        if (additionalModule == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(0);
        }
        for (JavaMultiReleaseModuleSupport support : JavaMultiReleaseModuleSupport.EP_NAME.getExtensionList()) {
            Module result2 = support.getMainMultiReleaseModule(additionalModule);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private static VersionRootInfo getVersionRootInfo(@NotNull VirtualFile file) {
        VirtualFile root;
        if (file == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(1);
        }
        if (!((root = VfsUtilCore.getRootFile(file)).getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        for (VirtualFile parent2 = file.getParent(); parent2 != null && !parent2.equals(root); parent2 = parent2.getParent()) {
            LanguageLevel level = JavaMultiReleaseUtil.getVersionForVersionRoot(root, parent2);
            if (level == null) continue;
            return new VersionRootInfo(level, parent2, root);
        }
        return null;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    @Nullable
    public static LanguageLevel getVersionForVersionRoot(@Nullable VirtualFile root, @Nullable VirtualFile directory) {
        VirtualFile grandParent;
        if (root == null || directory == null) {
            return null;
        }
        VirtualFile parent2 = directory.getParent();
        if (parent2 == null) {
            return null;
        }
        if (parent2.getName().equals("versions") && (grandParent = parent2.getParent()) != null && grandParent.getName().equals("META-INF") && root.equals(grandParent.getParent())) {
            try {
                LanguageLevel level = LanguageLevel.forFeature(Integer.parseInt(directory.getName()));
                return level != null && level.isAtLeast(MIN_MULTI_RELEASE_VERSION) ? level : null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findBaseFile(@NotNull VirtualFile file) {
        VersionRootInfo info;
        if (file == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(2);
        }
        if ((info = JavaMultiReleaseUtil.getVersionRootInfo(file)) == null) {
            return null;
        }
        VirtualFile versionRoot = info.versionRoot;
        VirtualFile classRoot = info.classRoot;
        String relativePath = VfsUtilCore.getRelativePath(file, versionRoot);
        if (relativePath == null) {
            return null;
        }
        return classRoot.findFileByRelativePath(relativePath);
    }

    @NotNull
    public static VirtualFile findVersionSpecificFile(@NotNull VirtualFile file, @NotNull LanguageLevel level) {
        VirtualFile root;
        if (file == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(3);
        }
        if (level == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(4);
        }
        if (!((root = VfsUtilCore.getRootFile(file)).getFileType() instanceof ArchiveFileType)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                JavaMultiReleaseUtil.$$$reportNull$$$0(5);
            }
            return virtualFile;
        }
        String relativePath = VfsUtilCore.getRelativePath(file, root);
        if (relativePath == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                JavaMultiReleaseUtil.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = JavaMultiReleaseUtil.findFileImpl(file, level, root, relativePath);
        if (virtualFile == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile findVersionSpecificFile(@NotNull VirtualFile root, @NotNull String relativePath, @NotNull LanguageLevel level) {
        if (root == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(9);
        }
        if (level == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(10);
        }
        VirtualFile file = root.findFileByRelativePath(relativePath);
        if (!(root.getFileType() instanceof ArchiveFileType)) {
            return file;
        }
        return JavaMultiReleaseUtil.findFileImpl(file, level, root, relativePath);
    }

    @Contract(value="!null, _, _, _ -> !null")
    @Nullable
    private static VirtualFile findFileImpl(@Nullable VirtualFile defaultFile, @NotNull LanguageLevel level, @NotNull VirtualFile root, @NotNull String relativePath) {
        VirtualFile metaInf;
        if (level == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(11);
        }
        if (root == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(13);
        }
        if ((metaInf = root.findChild("META-INF")) == null) {
            return defaultFile;
        }
        VirtualFile versions = metaInf.findChild("versions");
        if (versions == null) {
            return defaultFile;
        }
        int minFeature = MIN_MULTI_RELEASE_VERSION.feature();
        for (int feature = level.feature(); feature >= minFeature; --feature) {
            VirtualFile target;
            VirtualFile versionRoot = versions.findChild(String.valueOf(feature));
            if (versionRoot == null || (target = versionRoot.findFileByRelativePath(relativePath)) == null) continue;
            return target;
        }
        return defaultFile;
    }

    @Nullable
    public static LanguageLevel getVersion(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(14);
        }
        return (virtualFile = file.getVirtualFile()) == null ? null : JavaMultiReleaseUtil.getVersion(virtualFile);
    }

    @Nullable
    public static LanguageLevel getVersion(@NotNull VirtualFile file) {
        VersionRootInfo version2;
        if (file == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(15);
        }
        return (version2 = JavaMultiReleaseUtil.getVersionRootInfo(file)) == null ? null : version2.level;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaMultiReleaseUtil";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaMultiReleaseUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findVersionSpecificFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMainMultiReleaseModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVersionRootInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBaseFile";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findVersionSpecificFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFileImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionRootInfo {
        @NotNull
        final LanguageLevel level;
        @NotNull
        final VirtualFile versionRoot;
        @NotNull
        final VirtualFile classRoot;

        private VersionRootInfo(@NotNull LanguageLevel level, @NotNull VirtualFile versionRoot, @NotNull VirtualFile classRoot) {
            if (level == null) {
                VersionRootInfo.$$$reportNull$$$0(0);
            }
            if (versionRoot == null) {
                VersionRootInfo.$$$reportNull$$$0(1);
            }
            if (classRoot == null) {
                VersionRootInfo.$$$reportNull$$$0(2);
            }
            this.level = level;
            this.versionRoot = versionRoot;
            this.classRoot = classRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "versionRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classRoot";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaMultiReleaseUtil$VersionRootInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

