/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.pom.java.JavaFeature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElementList;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalLoopStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeconstructionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeconstructionPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachPatternStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimaryPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabeledRuleStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeTestPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiUnnamedPattern;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaVarTypeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.one.util.streamex.AbstractStreamEx;
import org.jetbrains.kotlin.one.util.streamex.StreamEx;

public final class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(0);
        }
        List<PatternVariableWrapper> list = JavaPsiPatternUtil.collectPatternVariableWrappers(expression2);
        List<PsiPatternVariable> list2 = ((AbstractStreamEx)((StreamEx)StreamEx.of(list).filter(base -> !base.isFake())).map(PatternVariableWrapper::getVariable)).toList();
        if (list2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PatternVariableWrapper> collectPatternVariableWrappers(@NotNull PsiExpression expression2) {
        PsiElement parent2;
        boolean parentMayAccept;
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(2);
        }
        boolean bl = parentMayAccept = (parent2 = PsiUtil.skipParenthesizedExprUp(expression2.getParent())) instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent2).getOperationTokenType().equals(JavaTokenType.EXCL) || parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.OROR) || parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiIfStatement || parent2 instanceof PsiConditionalLoopStatement || parent2 instanceof PsiSwitchLabeledRuleStatement;
        if (!parentMayAccept) {
            List<PatternVariableWrapper> list = Collections.emptyList();
            if (list == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<PatternVariableWrapper> list = new ArrayList<PatternVariableWrapper>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, false);
        ArrayList<PatternVariableWrapper> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(5);
        }
        ArrayList<PatternVariableWrapper> list = new ArrayList<PatternVariableWrapper>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, true);
        List<PsiPatternVariable> list2 = ((AbstractStreamEx)((StreamEx)StreamEx.of(list).filter(base -> !base.isFake())).map(PatternVariableWrapper::getVariable)).toList();
        if (list2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern;
        PsiInstanceOfExpression instanceOf;
        if (variable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(7);
        }
        if ((instanceOf = ObjectUtils.tryCast((pattern = variable.getPattern()).getParent(), PsiInstanceOfExpression.class)) == null) {
            return null;
        }
        PsiExpression operand = instanceOf.getOperand();
        PsiTypeElement checkType = pattern instanceof PsiTypeTestPattern ? ((PsiTypeTestPattern)pattern).getCheckType() : (pattern instanceof PsiDeconstructionPattern ? ((PsiDeconstructionPattern)pattern).getTypeElement() : null);
        if (checkType == null) {
            return null;
        }
        if (checkType.getType().equals(operand.getType())) {
            return operand.getText();
        }
        return "(" + checkType.getText() + ")" + operand.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPatternVariable getPatternVariable(@Nullable PsiCaseLabelElement pattern) {
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable();
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return ((PsiDeconstructionPattern)pattern).getPatternVariable();
        }
        return null;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPrimaryPattern getTypedPattern(@Nullable PsiCaseLabelElement element) {
        if (element instanceof PsiDeconstructionPattern) {
            return (PsiDeconstructionPattern)element;
        }
        if (element instanceof PsiTypeTestPattern) {
            return (PsiTypeTestPattern)element;
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean containsNamedPatternVariable(@Nullable PsiCaseLabelElement pattern) {
        if (pattern instanceof PsiTypeTestPattern) {
            PsiPatternVariable variable = ((PsiTypeTestPattern)pattern).getPatternVariable();
            return variable != null && !variable.isUnnamed();
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)pattern;
            return deconstructionPattern.getPatternVariable() != null || ContainerUtil.exists(deconstructionPattern.getDeconstructionList().getDeconstructionComponents(), component2 -> JavaPsiPatternUtil.containsNamedPatternVariable(component2));
        }
        return false;
    }

    public static boolean isGuarded(@NotNull PsiCaseLabelElement pattern) {
        PsiExpression guardExpression;
        PsiElement gParent;
        PsiElement parent2;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(8);
        }
        return (parent2 = pattern.getParent()) instanceof PsiCaseLabelElementList && (gParent = parent2.getParent()) instanceof PsiSwitchLabelStatementBase && (guardExpression = ((PsiSwitchLabelStatementBase)gParent).getGuardExpression()) != null && !Boolean.TRUE.equals(JavaPsiPatternUtil.evaluateConstant(guardExpression));
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiType getPatternType(@Nullable PsiCaseLabelElement pattern) {
        PsiTypeElement typeElement = JavaPsiPatternUtil.getPatternTypeElement(pattern);
        if (typeElement == null) {
            return null;
        }
        return typeElement.getType();
    }

    @Nullable
    public static PsiTypeElement getPatternTypeElement(@Nullable PsiCaseLabelElement pattern) {
        if (pattern == null) {
            return null;
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return ((PsiDeconstructionPattern)pattern).getTypeElement();
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getCheckType();
        }
        if (pattern instanceof PsiUnnamedPattern) {
            return ((PsiUnnamedPattern)pattern).getTypeElement();
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isUnconditionalForType(@Nullable PsiCaseLabelElement pattern, @NotNull PsiType type) {
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(9);
        }
        return JavaPsiPatternUtil.isUnconditionalForType(pattern, type, false) && !JavaPsiPatternUtil.isGuarded(pattern);
    }

    @Nullable
    public static PsiPrimaryPattern findUnconditionalPattern(@Nullable PsiCaseLabelElement pattern) {
        if (pattern == null || JavaPsiPatternUtil.isGuarded(pattern)) {
            return null;
        }
        if (pattern instanceof PsiDeconstructionPattern || pattern instanceof PsiTypeTestPattern || pattern instanceof PsiUnnamedPattern) {
            return (PsiPrimaryPattern)pattern;
        }
        return null;
    }

    @Contract(value="null,_,_ -> false")
    public static boolean isUnconditionalForType(@Nullable PsiCaseLabelElement pattern, @NotNull PsiType type, boolean forDominationOfDeconstructionPatternType) {
        PsiPrimaryPattern unconditionalPattern;
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(10);
        }
        if ((unconditionalPattern = JavaPsiPatternUtil.findUnconditionalPattern(pattern)) == null) {
            return false;
        }
        PsiType patternType = JavaPsiPatternUtil.getPatternType(unconditionalPattern);
        if (unconditionalPattern instanceof PsiDeconstructionPattern) {
            return forDominationOfDeconstructionPatternType && JavaPsiPatternUtil.dominates(patternType, type);
        }
        if (unconditionalPattern instanceof PsiTypeTestPattern || unconditionalPattern instanceof PsiUnnamedPattern) {
            return JavaPsiPatternUtil.isUnconditionallyExactForType(pattern, type, patternType);
        }
        return false;
    }

    public static boolean isUnconditionallyExactForType(@NotNull PsiElement context2, @NotNull PsiType type, PsiType patternType) {
        if (context2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(11);
        }
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(12);
        }
        if (((type = TypeConversionUtil.erasure(type)) instanceof PsiPrimitiveType || patternType instanceof PsiPrimitiveType) && PsiUtil.isAvailable(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS, context2)) {
            if (type.equals(patternType)) {
                return true;
            }
            if (type instanceof PsiPrimitiveType && patternType instanceof PsiPrimitiveType) {
                return JavaPsiPatternUtil.isExactPrimitiveWideningConversion(type, patternType);
            }
            if (!(type instanceof PsiPrimitiveType)) {
                return false;
            }
            PsiClassType boxedType = ((PsiPrimitiveType)type).getBoxedType(context2);
            return JavaPsiPatternUtil.dominates(patternType, boxedType);
        }
        return JavaPsiPatternUtil.dominates(patternType, type);
    }

    @NotNull
    public static PsiType getExactlyPromotedType(@NotNull PsiElement context2, @NotNull PsiType type, @NotNull PsiType patternType) {
        if (context2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(13);
        }
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(14);
        }
        if (patternType == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(15);
        }
        if (type.equals(patternType)) {
            PsiType psiType = type;
            if (psiType == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(16);
            }
            return psiType;
        }
        if ((type.equals(PsiTypes.byteType()) || type.equals(PsiTypes.shortType())) && patternType.equals(PsiTypes.charType())) {
            PsiPrimitiveType psiPrimitiveType = PsiTypes.intType();
            if (psiPrimitiveType == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(17);
            }
            return psiPrimitiveType;
        }
        if ((patternType.equals(PsiTypes.byteType()) || patternType.equals(PsiTypes.shortType())) && type.equals(PsiTypes.charType())) {
            PsiPrimitiveType psiPrimitiveType = PsiTypes.intType();
            if (psiPrimitiveType == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(18);
            }
            return psiPrimitiveType;
        }
        if (type.equals(PsiTypes.intType()) && patternType.equals(PsiTypes.floatType()) || type.equals(PsiTypes.floatType()) && patternType.equals(PsiTypes.intType())) {
            PsiPrimitiveType psiPrimitiveType = PsiTypes.doubleType();
            if (psiPrimitiveType == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(19);
            }
            return psiPrimitiveType;
        }
        if (type.equals(PsiTypes.longType()) && patternType.equals(PsiTypes.floatType()) || type.equals(PsiTypes.floatType()) && patternType.equals(PsiTypes.longType()) || type.equals(PsiTypes.longType()) && patternType.equals(PsiTypes.doubleType()) || type.equals(PsiTypes.doubleType()) && patternType.equals(PsiTypes.longType())) {
            PsiClassType psiClassType = PsiType.getTypeByName("java.math.BigDecimal", context2.getProject(), context2.getResolveScope());
            if (psiClassType == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(20);
            }
            return psiClassType;
        }
        PsiType psiType = TypeConversionUtil.isAssignable(patternType, type) ? patternType : type;
        if (psiType == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(21);
        }
        return psiType;
    }

    public static boolean isExactPrimitiveWideningConversion(@NotNull PsiType type, @NotNull PsiType patternType) {
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(22);
        }
        if (patternType == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(23);
        }
        if (type.equals(PsiTypes.byteType())) {
            return patternType.equals(PsiTypes.shortType()) || patternType.equals(PsiTypes.intType()) || patternType.equals(PsiTypes.longType()) || patternType.equals(PsiTypes.floatType()) || patternType.equals(PsiTypes.doubleType());
        }
        if (type.equals(PsiTypes.shortType())) {
            return patternType.equals(PsiTypes.intType()) || patternType.equals(PsiTypes.longType()) || patternType.equals(PsiTypes.floatType()) || patternType.equals(PsiTypes.doubleType());
        }
        if (type.equals(PsiTypes.charType())) {
            return patternType.equals(PsiTypes.intType()) || patternType.equals(PsiTypes.longType()) || patternType.equals(PsiTypes.floatType()) || patternType.equals(PsiTypes.doubleType());
        }
        if (type.equals(PsiTypes.intType())) {
            return patternType.equals(PsiTypes.longType()) || patternType.equals(PsiTypes.doubleType());
        }
        if (type.equals(PsiTypes.floatType())) {
            return patternType.equals(PsiTypes.doubleType());
        }
        return false;
    }

    public static boolean hasUnconditionalComponents(@NotNull PsiDeconstructionPattern pattern) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(24);
        }
        PsiType type = pattern.getTypeElement().getType();
        PsiPattern[] patternComponents = pattern.getDeconstructionList().getDeconstructionComponents();
        PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly(type);
        if (selectorClass == null) {
            return false;
        }
        PsiRecordComponent[] recordComponents = selectorClass.getRecordComponents();
        if (patternComponents.length != recordComponents.length) {
            return false;
        }
        for (int i = 0; i < patternComponents.length; ++i) {
            PsiPattern patternComponent = patternComponents[i];
            PsiType componentType = recordComponents[i].getType();
            if (JavaPsiPatternUtil.isUnconditionalForType(patternComponent, componentType)) continue;
            return false;
        }
        return true;
    }

    private static boolean dominates(@Nullable PsiType who, @Nullable PsiType overWhom) {
        if (who == null || overWhom == null) {
            return false;
        }
        if (who.getCanonicalText().equals(overWhom.getCanonicalText())) {
            return true;
        }
        overWhom = TypeConversionUtil.erasure(overWhom);
        PsiType baseType = TypeConversionUtil.erasure(who);
        if (overWhom.equals(PsiTypes.nullType())) {
            return who instanceof PsiClassType || who instanceof PsiArrayType;
        }
        if (overWhom instanceof PsiArrayType || baseType instanceof PsiArrayType) {
            return baseType != null && TypeConversionUtil.isAssignable(baseType, overWhom);
        }
        PsiClass typeClass = PsiTypesUtil.getPsiClass(overWhom);
        PsiClass baseTypeClass = PsiTypesUtil.getPsiClass(baseType);
        return typeClass != null && baseTypeClass != null && InheritanceUtil.isInheritorOrSelf(typeClass, baseTypeClass, true);
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean dominates(@Nullable PsiCaseLabelElement who, @NotNull PsiCaseLabelElement overWhom) {
        if (overWhom == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(25);
        }
        if (who == null) {
            return false;
        }
        PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
        if (overWhomType == null || !JavaPsiPatternUtil.isUnconditionalForType(who, overWhomType, true)) {
            return false;
        }
        PsiDeconstructionPattern whoDeconstruction = JavaPsiPatternUtil.findDeconstructionPattern(who);
        if (whoDeconstruction != null) {
            PsiDeconstructionPattern overWhomDeconstruction = JavaPsiPatternUtil.findDeconstructionPattern(overWhom);
            return JavaPsiPatternUtil.dominatesComponents(whoDeconstruction, overWhomDeconstruction);
        }
        return true;
    }

    private static boolean dominatesComponents(@NotNull PsiDeconstructionPattern who, @Nullable PsiDeconstructionPattern overWhom) {
        PsiPattern[] overWhomComponents;
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(26);
        }
        if (overWhom == null) {
            return false;
        }
        PsiPattern[] whoComponents = who.getDeconstructionList().getDeconstructionComponents();
        if (whoComponents.length != (overWhomComponents = overWhom.getDeconstructionList().getDeconstructionComponents()).length) {
            return false;
        }
        for (int i = 0; i < whoComponents.length; ++i) {
            PsiPattern whoComponent = whoComponents[i];
            PsiPattern overWhomComponent = overWhomComponents[i];
            if (JavaPsiPatternUtil.dominates(whoComponent, overWhomComponent)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiDeconstructionPattern findDeconstructionPattern(@Nullable PsiCaseLabelElement element) {
        return ObjectUtils.tryCast(element, PsiDeconstructionPattern.class);
    }

    @Contract(value="_,null -> false", pure=true)
    public static boolean dominatesOverConstant(@NotNull PsiCaseLabelElement who, @Nullable PsiType overWhom) {
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(27);
        }
        if (overWhom == null) {
            return false;
        }
        PsiType whoType = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(who = JavaPsiPatternUtil.findUnconditionalPattern(who)));
        if (whoType == null) {
            return false;
        }
        PsiType overWhomType = null;
        if (overWhom instanceof PsiPrimitiveType) {
            overWhomType = ((PsiPrimitiveType)overWhom).getBoxedType(who);
        } else if (overWhom instanceof PsiClassType) {
            overWhomType = overWhom;
        }
        return overWhomType != null && TypeConversionUtil.areTypesConvertible(overWhomType, whoType);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiRecordComponent getRecordComponentForPattern(@NotNull PsiPattern pattern) {
        PsiDeconstructionList deconstructionList;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(28);
        }
        if ((deconstructionList = ObjectUtils.tryCast(pattern.getParent(), PsiDeconstructionList.class)) == null) {
            return null;
        }
        @NotNull Object @NotNull [] patterns = deconstructionList.getDeconstructionComponents();
        int index = ArrayUtil.indexOf(patterns, pattern);
        PsiDeconstructionPattern deconstructionPattern = ObjectUtils.tryCast(deconstructionList.getParent(), PsiDeconstructionPattern.class);
        if (deconstructionPattern == null) {
            return null;
        }
        PsiClassType classType = ObjectUtils.tryCast(deconstructionPattern.getTypeElement().getType(), PsiClassType.class);
        if (classType == null) {
            return null;
        }
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        PsiRecordComponent[] components = aClass.getRecordComponents();
        if (components.length <= index) {
            return null;
        }
        return components[index];
    }

    @Nullable
    public static PsiType getDeconstructedImplicitPatternVariableType(@NotNull PsiPatternVariable parameter) {
        if (parameter == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(29);
        }
        return JavaPsiPatternUtil.getDeconstructedImplicitPatternType(parameter.getPattern());
    }

    @Nullable
    public static PsiType getDeconstructedImplicitPatternType(@NotNull PsiPattern pattern) {
        PsiRecordComponent recordComponent;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(30);
        }
        if ((recordComponent = JavaPsiPatternUtil.getRecordComponentForPattern(pattern)) != null) {
            PsiDeconstructionList deconstructionList = ObjectUtils.tryCast(pattern.getParent(), PsiDeconstructionList.class);
            if (deconstructionList == null) {
                return null;
            }
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)deconstructionList.getParent();
            PsiType patternType = deconstructionPattern.getTypeElement().getType();
            if (patternType instanceof PsiClassType) {
                patternType = PsiUtil.captureToplevelWildcards(patternType, pattern);
                PsiSubstitutor substitutor2 = ((PsiClassType)patternType).resolveGenerics().getSubstitutor();
                PsiType recordComponentType = recordComponent.getType();
                return JavaVarTypeUtil.getUpwardProjection(substitutor2.substitute(recordComponentType));
            }
        }
        return null;
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope2, @NotNull PsiExpression expression2, Collection<PatternVariableWrapper> candidates, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPrimaryPattern pattern;
        if (scope2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(31);
        }
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(32);
        }
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression2).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression2 = ((PsiPrefixExpression)expression2).getOperand();
        }
        if (expression2 instanceof PsiInstanceOfExpression && ((pattern = ((PsiInstanceOfExpression)expression2).getPattern()) instanceof PsiTypeTestPattern || pattern instanceof PsiDeconstructionPattern)) {
            JavaPsiPatternUtil.collectPatternVariableCandidates(pattern, scope2, null, candidates, strict);
        }
        if (expression2 instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope2, operand, candidates, strict);
            }
        }
    }

    private static void collectPatternVariableCandidates(@NotNull PsiPattern pattern, @NotNull PsiExpression scope2, @Nullable Pair<PsiPatternVariable, PsiRecordComponent> parent2, Collection<PatternVariableWrapper> candidates, boolean strict) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(33);
        }
        if (scope2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(34);
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiPatternVariable variable = ((PsiTypeTestPattern)pattern).getPatternVariable();
            if (variable != null && !PsiTreeUtil.isAncestor(scope2, variable.getDeclarationScope(), strict)) {
                if (parent2 == null) {
                    candidates.add(new PatternVariableWrapper(variable, false));
                } else {
                    candidates.add(new DestructionComponent(variable, parent2.getFirst(), parent2.getSecond(), false));
                }
            }
        } else if (pattern instanceof PsiDeconstructionPattern) {
            PsiPattern[] components;
            PsiRecordComponent[] recordComponents;
            boolean isFake;
            PsiDeconstructionPattern deconstruction = (PsiDeconstructionPattern)pattern;
            PsiTypeElement typeElement = deconstruction.getTypeElement();
            PsiType type = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type);
            PsiPatternVariable variable = deconstruction.getPatternVariable();
            boolean bl = isFake = variable == null;
            if (aClass != null && (recordComponents = aClass.getRecordComponents()).length == (components = deconstruction.getDeconstructionList().getDeconstructionComponents()).length && recordComponents.length != 0) {
                if (isFake) {
                    variable = JavaPsiPatternUtil.createFakePatternVariable(pattern, typeElement, type);
                }
                PatternVariableWrapper patternVariableWrapper = parent2 == null ? new PatternVariableWrapper(variable, isFake) : new DestructionComponent(variable, parent2.getFirst(), parent2.getSecond(), isFake);
                candidates.add(patternVariableWrapper);
                for (int i = 0; i < components.length; ++i) {
                    JavaPsiPatternUtil.collectPatternVariableCandidates(components[i], scope2, Pair.pair(variable, recordComponents[i]), candidates, strict);
                }
            }
        }
    }

    @NotNull
    private static PsiPatternVariable createFakePatternVariable(@NotNull PsiPattern pattern, @NotNull PsiTypeElement typeElement, @NotNull PsiType type) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(35);
        }
        if (typeElement == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(36);
        }
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(37);
        }
        Project project = pattern.getProject();
        PsiElementFactory factory = PsiElementFactory.getInstance(project);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(project);
        String name2 = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
        name2 = styleManager.suggestUniqueVariableName(name2, (PsiElement)pattern, true);
        PsiElement parent2 = pattern.getParent();
        String operand = parent2 instanceof PsiInstanceOfExpression ? ((PsiInstanceOfExpression)parent2).getOperand().getText() : "x";
        String text = operand + " instanceof " + typeElement.getText() + " " + name2;
        PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)factory.createExpressionFromText(text, null);
        PsiPatternVariable variable = ((PsiTypeTestPattern)Objects.requireNonNull(instanceOf.getPattern())).getPatternVariable();
        assert (variable != null);
        PsiPatternVariable psiPatternVariable = variable;
        if (psiPatternVariable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(38);
        }
        return psiPatternVariable;
    }

    @Nullable
    public static PsiType getContextType(@NotNull PsiPattern pattern) {
        PsiDeconstructionPattern parentPattern;
        PsiExpression expression2;
        PsiSwitchBlock block;
        PsiSwitchLabelStatementBase label;
        PsiElement parent2;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(39);
        }
        if ((parent2 = pattern.getParent()) instanceof PsiInstanceOfExpression) {
            return ((PsiInstanceOfExpression)parent2).getOperand().getType();
        }
        if (parent2 instanceof PsiForeachPatternStatement) {
            PsiExpression iteratedValue = ((PsiForeachPatternStatement)parent2).getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            return JavaGenericsUtil.getCollectionItemType(iteratedValue);
        }
        if (parent2 instanceof PsiCaseLabelElementList && (label = ObjectUtils.tryCast(parent2.getParent(), PsiSwitchLabelStatementBase.class)) != null && (block = label.getEnclosingSwitchBlock()) != null && (expression2 = block.getExpression()) != null) {
            return expression2.getType();
        }
        if (parent2 instanceof PsiDeconstructionList && (parentPattern = ObjectUtils.tryCast(parent2.getParent(), PsiDeconstructionPattern.class)) != null) {
            int index = ArrayUtil.indexOf(((PsiDeconstructionList)parent2).getDeconstructionComponents(), pattern);
            if (index < 0) {
                return null;
            }
            PsiType patternType = parentPattern.getTypeElement().getType();
            if (!(patternType instanceof PsiClassType)) {
                return null;
            }
            PsiSubstitutor parentSubstitutor = ((PsiClassType)patternType).resolveGenerics().getSubstitutor();
            PsiClass parentRecord = PsiUtil.resolveClassInClassTypeOnly(parentPattern.getTypeElement().getType());
            if (parentRecord == null) {
                return null;
            }
            PsiRecordComponent[] components = parentRecord.getRecordComponents();
            if (index >= components.length) {
                return null;
            }
            return parentSubstitutor.substitute(components[index].getType());
        }
        return null;
    }

    public static List<PsiType> deconstructSelectorType(@NotNull PsiType selectorType) {
        if (selectorType == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(40);
        }
        ArrayList<PsiType> selectorTypes = new ArrayList<PsiType>();
        PsiClass resolvedClass = PsiUtil.resolveClassInClassTypeOnly(selectorType);
        if (resolvedClass instanceof PsiTypeParameter) {
            PsiClassType[] types2 = resolvedClass.getExtendsListTypes();
            Arrays.stream(types2).filter(t -> t != null).forEach(t -> selectorTypes.add((PsiType)t));
        }
        if (selectorType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)selectorType).getConjuncts()) {
                selectorTypes.addAll(JavaPsiPatternUtil.deconstructSelectorType(conjunct));
            }
        }
        if (selectorTypes.isEmpty()) {
            selectorTypes.add(selectorType);
        }
        return selectorTypes;
    }

    public static boolean covers(@NotNull PsiElement context2, @NotNull PsiType whoType, @NotNull PsiType overWhom) {
        if (context2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(41);
        }
        if (whoType == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(42);
        }
        if (overWhom == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(43);
        }
        List<PsiType> whoTypes = JavaPsiPatternUtil.deconstructSelectorType(whoType);
        List<PsiType> overWhomTypes = JavaPsiPatternUtil.deconstructSelectorType(overWhom);
        for (PsiType currentWhoType : whoTypes) {
            if (ContainerUtil.exists(overWhomTypes, currentOverWhomType -> {
                boolean unconditionallyExactForType = JavaPsiPatternUtil.isUnconditionallyExactForType(context2, currentOverWhomType, currentWhoType);
                if (unconditionallyExactForType) {
                    return true;
                }
                PsiPrimitiveType unboxedOverWhomType = PsiPrimitiveType.getUnboxedType(currentOverWhomType);
                if (unboxedOverWhomType == null) {
                    return false;
                }
                return JavaPsiPatternUtil.isUnconditionallyExactForType(context2, unboxedOverWhomType, currentWhoType);
            })) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Object evaluateConstant(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(expression2.getProject()).getConstantEvaluationHelper().computeConstantExpression(expression2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 24: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 13: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternType";
                break;
            }
            case 25: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whoType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariables";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPatternVariableWrappers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactlyPromotedType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakePatternVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariables";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 38: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableWrappers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveInitializerText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGuarded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnconditionalForType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isUnconditionallyExactForType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExactlyPromotedType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isExactPrimitiveWideningConversion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasUnconditionalComponents";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "dominatesComponents";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "dominatesOverConstant";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRecordComponentForPattern";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDeconstructedImplicitPatternVariableType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDeconstructedImplicitPatternType";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableCandidates";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createFakePatternVariable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getContextType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "deconstructSelectorType";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "covers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PatternVariableWrapper {
        @NotNull
        private final PsiPatternVariable myVariable;
        private final boolean myIsFake;

        PatternVariableWrapper(@NotNull PsiPatternVariable variable, boolean isFake) {
            if (variable == null) {
                PatternVariableWrapper.$$$reportNull$$$0(0);
            }
            this.myVariable = variable;
            this.myIsFake = isFake;
        }

        @NotNull
        public PsiPatternVariable getVariable() {
            PsiPatternVariable psiPatternVariable = this.myVariable;
            if (psiPatternVariable == null) {
                PatternVariableWrapper.$$$reportNull$$$0(1);
            }
            return psiPatternVariable;
        }

        boolean isFake() {
            return this.myIsFake;
        }

        public String getEffectiveInitializerText() {
            return JavaPsiPatternUtil.getEffectiveInitializerText(this.myVariable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil$PatternVariableWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil$PatternVariableWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DestructionComponent
    extends PatternVariableWrapper {
        @NotNull
        private final PsiPatternVariable myParent;
        @NotNull
        private final PsiRecordComponent myRecordComponent;

        DestructionComponent(@NotNull PsiPatternVariable variable, @NotNull PsiPatternVariable parent2, @NotNull PsiRecordComponent recordComponent, boolean isFake) {
            if (variable == null) {
                DestructionComponent.$$$reportNull$$$0(0);
            }
            if (parent2 == null) {
                DestructionComponent.$$$reportNull$$$0(1);
            }
            if (recordComponent == null) {
                DestructionComponent.$$$reportNull$$$0(2);
            }
            super(variable, isFake);
            this.myParent = parent2;
            this.myRecordComponent = recordComponent;
        }

        @Override
        public String getEffectiveInitializerText() {
            String text = this.myParent.getName() + "." + this.myRecordComponent.getName() + "()";
            PsiType type = this.getVariable().getType();
            if (!type.equals(this.myRecordComponent.getType())) {
                return "(" + type.getCanonicalText() + ")" + text;
            }
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordComponent";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil$DestructionComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

