/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.pom.java.JavaFeature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElementList;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiDefaultCaseLabelElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.util.ConstantExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaPsiPatternUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;

public final class JavaPsiSwitchUtil {
    public static boolean isEnhancedSwitch(@NotNull PsiSwitchBlock statement) {
        if (statement == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(0);
        }
        if (statement instanceof PsiSwitchExpression) {
            return true;
        }
        PsiExpression selector = statement.getExpression();
        if (selector == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return false;
        }
        PsiCodeBlock body = statement.getBody();
        if (body == null) {
            return false;
        }
        ArrayList<PsiCaseLabelElement> cases = new ArrayList<PsiCaseLabelElement>();
        for (PsiStatement psiStatement : body.getStatements()) {
            PsiCaseLabelElement[] elements;
            PsiSwitchLabelStatementBase labelStatementBase;
            PsiCaseLabelElementList elementList;
            if (!(psiStatement instanceof PsiSwitchLabelStatementBase) || (elementList = (labelStatementBase = (PsiSwitchLabelStatementBase)psiStatement).getCaseLabelElementList()) == null) continue;
            for (PsiCaseLabelElement caseLabelElement : elements = elementList.getElements()) {
                if (caseLabelElement == null) continue;
                cases.add(caseLabelElement);
            }
        }
        return JavaPsiSwitchUtil.isEnhancedSwitch(cases, selectorType);
    }

    public static boolean isEnhancedSwitch(@NotNull List<? extends PsiCaseLabelElement> labelElements, @NotNull PsiType selectorType) {
        if (labelElements == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(1);
        }
        if (selectorType == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(2);
        }
        if (JavaPsiSwitchUtil.isEnhancedSelectorType(selectorType)) {
            return true;
        }
        return ContainerUtil.exists(labelElements, st -> st instanceof PsiPattern || JavaPsiSwitchUtil.isNullType(st));
    }

    private static boolean isNullType(@NotNull PsiElement element) {
        if (element == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(3);
        }
        return element instanceof PsiExpression && TypeConversionUtil.isNullType(((PsiExpression)element).getType());
    }

    private static boolean isEnhancedSelectorType(@NotNull PsiType type) {
        PsiPrimitiveType unboxedType;
        if (type == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(4);
        }
        if ((unboxedType = PsiPrimitiveType.getOptionallyUnboxedType(type)) != null && (unboxedType.equals(PsiTypes.booleanType()) || unboxedType.equals(PsiTypes.floatType()) || unboxedType.equals(PsiTypes.doubleType()) || unboxedType.equals(PsiTypes.longType()))) {
            return true;
        }
        if (TypeConversionUtil.getTypeRank(type) <= 4) {
            return false;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return false;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return false;
            }
            String fqn = psiClass.getQualifiedName();
            if (Comparing.strEqual(fqn, "java.lang.String")) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static SelectorKind getSwitchSelectorKind(@NotNull PsiType selectorType) {
        PsiType unboxedType;
        if (selectorType == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(5);
        }
        if (TypeConversionUtil.getTypeRank(selectorType) <= 4) {
            SelectorKind selectorKind = SelectorKind.INT;
            if (selectorKind == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(6);
            }
            return selectorKind;
        }
        PsiType psiType = unboxedType = selectorType instanceof PsiClassType && JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(((PsiClassType)selectorType).getLanguageLevel()) ? PsiPrimitiveType.getOptionallyUnboxedType(selectorType) : selectorType;
        if (unboxedType != null) {
            if (unboxedType.equals(PsiTypes.longType())) {
                SelectorKind selectorKind = SelectorKind.LONG;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(7);
                }
                return selectorKind;
            }
            if (unboxedType.equals(PsiTypes.booleanType())) {
                SelectorKind selectorKind = SelectorKind.BOOLEAN;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(8);
                }
                return selectorKind;
            }
            if (unboxedType.equals(PsiTypes.floatType())) {
                SelectorKind selectorKind = SelectorKind.FLOAT;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(9);
                }
                return selectorKind;
            }
            if (unboxedType.equals(PsiTypes.doubleType())) {
                SelectorKind selectorKind = SelectorKind.DOUBLE;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(10);
                }
                return selectorKind;
            }
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(selectorType)) {
            SelectorKind selectorKind = SelectorKind.INVALID;
            if (selectorKind == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(11);
            }
            return selectorKind;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(selectorType);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                SelectorKind selectorKind = SelectorKind.ENUM;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(12);
                }
                return selectorKind;
            }
            String fqn = psiClass.getQualifiedName();
            if (Comparing.strEqual(fqn, "java.lang.String")) {
                SelectorKind selectorKind = SelectorKind.STRING;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(13);
                }
                return selectorKind;
            }
        }
        SelectorKind selectorKind = SelectorKind.CLASS_OR_ARRAY;
        if (selectorKind == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(14);
        }
        return selectorKind;
    }

    @Contract(pure=true)
    public static boolean hasAnyCaseLabels(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(15);
        }
        if ((body = block.getBody()) == null) {
            return false;
        }
        for (PsiElement st = body.getFirstChild(); st != null; st = st.getNextSibling()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            if (labelStatement.isDefaultCase()) {
                return true;
            }
            PsiCaseLabelElementList labelElementList = labelStatement.getCaseLabelElementList();
            if (labelElementList == null || labelElementList.getElementCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiEnumConstant getEnumConstant(@Nullable PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            return ObjectUtils.tryCast(((PsiReferenceExpression)element).resolve(), PsiEnumConstant.class);
        }
        return null;
    }

    private static void addValueLabel(@NotNull MultiMap<Object, PsiElement> elements, @NotNull PsiCaseLabelElement labelElement, @NotNull PsiType selectorType) {
        if (elements == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(16);
        }
        if (labelElement == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(17);
        }
        if (selectorType == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(18);
        }
        if (labelElement instanceof PsiExpression) {
            PsiEnumConstant enumConstant;
            PsiExpression expr = (PsiExpression)labelElement;
            if (expr instanceof PsiReferenceExpression && (enumConstant = JavaPsiSwitchUtil.getEnumConstant(expr)) != null) {
                elements.putValue(enumConstant, labelElement);
                return;
            }
            Object operand = JavaPsiFacade.getInstance(labelElement.getProject()).getConstantEvaluationHelper().computeConstantExpression(labelElement, false);
            if (operand != null) {
                if (operand instanceof Boolean && JavaPsiSwitchUtil.getSwitchSelectorKind(selectorType) == SelectorKind.BOOLEAN) {
                    elements.putValue((boolean)((Boolean)operand), labelElement);
                } else {
                    Object casted = ConstantExpressionUtil.computeCastTo(operand, selectorType);
                    if (casted != null) {
                        elements.putValue(casted, labelElement);
                    }
                }
            } else if (labelElement instanceof PsiLiteralExpression && ((PsiLiteralExpression)labelElement).getType() == PsiTypes.nullType()) {
                elements.putValue((Object)SwitchSpecialValue.NULL_VALUE, labelElement);
            }
        } else if (labelElement instanceof PsiDefaultCaseLabelElement) {
            elements.putValue((Object)SwitchSpecialValue.DEFAULT_VALUE, labelElement);
        } else if (JavaPsiPatternUtil.isUnconditionalForType(labelElement, selectorType)) {
            elements.putValue((Object)SwitchSpecialValue.UNCONDITIONAL_PATTERN, labelElement);
        }
    }

    @NotNull
    public static MultiMap<Object, PsiElement> getValuesAndLabels(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(19);
        }
        MultiMap<Object, PsiElement> elementsToCheckDuplicates = new MultiMap<Object, PsiElement>();
        PsiCodeBlock body = block.getBody();
        if (body == null) {
            MultiMap<Object, PsiElement> multiMap = elementsToCheckDuplicates;
            if (multiMap == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(20);
            }
            return multiMap;
        }
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            MultiMap<Object, PsiElement> multiMap = elementsToCheckDuplicates;
            if (multiMap == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(21);
            }
            return multiMap;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            MultiMap<Object, PsiElement> multiMap = elementsToCheckDuplicates;
            if (multiMap == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(22);
            }
            return multiMap;
        }
        for (PsiStatement st : body.getStatements()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            if (labelStatement.isDefaultCase()) {
                elementsToCheckDuplicates.putValue((Object)SwitchSpecialValue.DEFAULT_VALUE, Objects.requireNonNull(labelStatement.getFirstChild()));
                continue;
            }
            PsiCaseLabelElementList labelElementList = labelStatement.getCaseLabelElementList();
            if (labelElementList == null) continue;
            for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                JavaPsiSwitchUtil.addValueLabel(elementsToCheckDuplicates, labelElement, selectorType);
            }
        }
        MultiMap<Object, PsiElement> multiMap = elementsToCheckDuplicates;
        if (multiMap == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(23);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElements";
                break;
            }
            case 2: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiSwitchUtil";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiSwitchUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchSelectorKind";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesAndLabels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnhancedSwitch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNullType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnhancedSelectorType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchSelectorKind";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyCaseLabels";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addValueLabel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getValuesAndLabels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SelectorKind {
        INT(null),
        ENUM(JavaFeature.ENUMS),
        STRING(JavaFeature.STRING_SWITCH),
        CLASS_OR_ARRAY(JavaFeature.PATTERNS_IN_SWITCH),
        BOOLEAN(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        LONG(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        FLOAT(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        DOUBLE(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        INVALID(null);

        @Nullable
        private final JavaFeature myFeature;

        private SelectorKind(JavaFeature feature) {
            this.myFeature = feature;
        }

        @Nullable
        public JavaFeature getFeature() {
            return this.myFeature;
        }
    }

    public static enum SwitchSpecialValue {
        UNCONDITIONAL_PATTERN,
        DEFAULT_VALUE,
        NULL_VALUE;

    }
}

