/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.serialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.serialization.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.serialization.SerializationException;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;

@ApiStatus.Internal
public final class PropertyAccessor
implements MutableAccessor {
    private static final Logger LOG = Logger.getInstance(PropertyAccessor.class);
    private final String name;
    private final Class<?> type;
    private final Method readMethod;
    private final Method writeMethod;
    private final Type genericType;

    PropertyAccessor(@NotNull String name2, @NotNull Class<?> type, @NotNull Method readMethod, @Nullable Method writeMethod) {
        if (name2 == null) {
            PropertyAccessor.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PropertyAccessor.$$$reportNull$$$0(1);
        }
        if (readMethod == null) {
            PropertyAccessor.$$$reportNull$$$0(2);
        }
        this.name = name2;
        this.type = type;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.genericType = readMethod.getGenericReturnType();
        try {
            this.readMethod.setAccessible(true);
            if (writeMethod != null) {
                writeMethod.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            PropertyAccessor.$$$reportNull$$$0(4);
        }
        try {
            return this.readMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            ExceptionUtilRt.rethrowUnchecked(e.getTargetException());
            throw new SerializationException(e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(11);
        }
        if (this.writeMethod == null) {
            throw new SerializationException(host.getClass().getName() + "::" + this.name + " lacks a setter");
        }
        try {
            this.writeMethod.invoke(host, value2);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            T[] constants;
            Throwable cause = e.getCause();
            if (cause instanceof NullPointerException && this.genericType instanceof Class && ((Class)this.genericType).isEnum() && cause.getMessage().contains("Parameter specified as non-null is null:") && (constants = ((Class)this.genericType).getEnumConstants()).length > 0) {
                try {
                    LOG.warn("Cannot set enum value, will be set to first enum value", e);
                    this.writeMethod.invoke(host, constants[0]);
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e1) {
                    throw new SerializationException(e);
                }
            }
            throw new SerializationException(cause);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(12);
        }
        this.set(host, value2);
    }

    @Override
    public void setInt(@NotNull Object host, int value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(13);
        }
        this.set(host, value2);
    }

    @Override
    public void setShort(@NotNull Object host, short value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(14);
        }
        this.set(host, value2);
    }

    @Override
    public void setLong(@NotNull Object host, long value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(15);
        }
        this.set(host, value2);
    }

    @Override
    public void setDouble(@NotNull Object host, double value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(16);
        }
        this.set(host, value2);
    }

    @Override
    public void setFloat(@NotNull Object host, float value2) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(17);
        }
        this.set(host, Float.valueOf(value2));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        T annotation;
        if (annotationClass == null) {
            PropertyAccessor.$$$reportNull$$$0(18);
        }
        return (annotation = this.readMethod.getAnnotation(annotationClass)) != null || this.writeMethod == null ? annotation : this.writeMethod.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(@NotNull Class<T> annotationClass) {
        boolean isPresent;
        if (annotationClass == null) {
            PropertyAccessor.$$$reportNull$$$0(19);
        }
        return (isPresent = this.readMethod.isAnnotationPresent(annotationClass)) || this.writeMethod == null ? isPresent : this.writeMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            PropertyAccessor.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    public Class<?> getValueClass() {
        Class<?> clazz = this.type;
        if (clazz == null) {
            PropertyAccessor.$$$reportNull$$$0(21);
        }
        return clazz;
    }

    @Override
    @NotNull
    public Type getGenericType() {
        Type type = this.genericType;
        if (type == null) {
            PropertyAccessor.$$$reportNull$$$0(22);
        }
        return type;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethod != null && this.writeMethod.isAccessible();
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor(name=" + this.name + ", class=" + this.readMethod.getDeclaringClass().getName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readMethod";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/serialization/PropertyAccessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/serialization/PropertyAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetterName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readUnsafe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readInt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readLong";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readFloat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readDouble";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readBoolean";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBoolean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setInt";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setShort";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLong";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDouble";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setFloat";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationPresent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

