/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.CachedValueBase;
import org.jetbrains.kotlin.com.intellij.util.CachedValueLeakChecker;
import org.jetbrains.kotlin.com.intellij.util.CachedValueStabilityChecker;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class CachedValuesManagerImpl
extends CachedValuesManager {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = CollectionFactory.createConcurrentWeakIdentityMap();
    private Set<Key<?>> myKeys = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull UserDataHolder userDataHolder, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (userDataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(userDataHolder, provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        return parameterizedCachedValue;
    }

    @Override
    @NotNull
    protected <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull UserDataHolder userDataHolder, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (userDataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(8);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(userDataHolder, provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(9);
        }
        return parameterizedCachedValue;
    }

    @Override
    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value2;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(10);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(11);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(12);
        }
        if ((value2 = dataHolder.getUserData(key)) instanceof CachedValueBase && ((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject)) {
            Getter<T> data = value2.getUpToDateOrNull();
            if (data != null) {
                return data.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value2.getValueProvider(), key);
        }
        if (value2 == null) {
            value2 = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider, trackValue));
        }
        return value2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value2) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(13);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(14);
        }
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return ((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value2);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue<T> existing = dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value2);
            return value2;
        }
    }

    @Override
    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(15);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(16);
        }
        if (!CachedValuesManagerImpl.isClearedOnPluginUnload(dataHolder)) {
            this.myCacheHolders.put(dataHolder, NULL);
            this.myKeys.add(key);
        }
    }

    private static boolean isClearedOnPluginUnload(@NotNull UserDataHolder dataHolder) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(17);
        }
        return dataHolder instanceof PsiElement || dataHolder instanceof ASTNode || dataHolder instanceof FileViewProvider;
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProviderDoesNotLeakPSI(provider, key, dh);
        CachedValue<T> value2 = this.myFactory.createCachedValue(dh, provider, trackValue);
        assert (((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject));
        return value2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveInUserData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trackKeyHolder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isClearedOnPluginUnload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

