/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.Nullable;

public final class ExceptionUtilRt {
    public static void rethrowUnchecked(@Nullable Throwable t) throws RuntimeException, Error {
        if (t instanceof Error) {
            throw ExceptionUtilRt.addRethrownStackAsSuppressed((Error)t);
        }
        if (t instanceof RuntimeException) {
            throw ExceptionUtilRt.addRethrownStackAsSuppressed((RuntimeException)t);
        }
    }

    public static <T extends Throwable> T addRethrownStackAsSuppressed(T throwable) {
        throwable.addSuppressed(new RethrownStack());
        return throwable;
    }

    static class RethrownStack
    extends Throwable {
        RethrownStack() {
            super("Rethrown at");
        }
    }
}

