/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.model.Symbol;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationManagerEx;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Trinity;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.util.CachedValueBase;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SynchronizedClearableLazy;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public final class IdempotenceChecker {
    private static final Logger LOG = Logger.getInstance(IdempotenceChecker.class);
    private static final Set<Class<?>> ourReportedValueClasses = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<AtomicInteger> ourRandomCheckNesting = ThreadLocal.withInitial(() -> new AtomicInteger());
    private static final ThreadLocal<List<String>> ourLog = new ThreadLocal();
    private static final Supplier<RegistryValue> rateCheckProperty = new SynchronizedClearableLazy<RegistryValue>(() -> Registry.get("platform.random.idempotence.check.rate"));
    private static final Map<Class, Set<Class>> allSupersWithEquals = ConcurrentFactoryMap.createMap(clazz -> JBIterable.generate(clazz, Class::getSuperclass).filter(c -> c != Object.class && ReflectionUtil.getDeclaredMethod(c, "equals", Object.class) != null).toSet());

    public static <T> void checkEquivalence(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue) {
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(0);
        }
        IdempotenceChecker.checkEquivalence(existing, fresh, providerClass, recomputeValue, null);
    }

    static <T> void checkEquivalence(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue, @Nullable Supplier<String> contextInfoSupplier) {
        String msg;
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(1);
        }
        if ((msg = IdempotenceChecker.checkValueEquivalence(existing, fresh)) != null) {
            IdempotenceChecker.reportFailure(existing, fresh, providerClass, recomputeValue, msg + (contextInfoSupplier == null ? "" : "\n" + contextInfoSupplier.get()));
        }
    }

    private static <T> void reportFailure(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue, String msg) {
        boolean shouldReport;
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(2);
        }
        boolean bl = shouldReport = (ApplicationManager.getApplication().isUnitTestMode() || ourReportedValueClasses.add(providerClass)) && !"true".equals(System.getProperty("idea.disable.idempotence.checker", "false"));
        if (shouldReport) {
            if (recomputeValue != null) {
                msg = msg + IdempotenceChecker.recomputeWithLogging(existing, fresh, recomputeValue);
            }
            LOG.error(PluginException.createByClass(msg, null, providerClass));
        }
    }

    @NotNull
    private static <T> String recomputeWithLogging(@Nullable T existing, @Nullable T fresh, @NotNull Computable<? extends T> recomputeValue) {
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(3);
        }
        ResultWithLog<T> rwl = IdempotenceChecker.computeWithLogging(recomputeValue);
        Object freshest = ((ResultWithLog)rwl).result;
        @NonNls String msg = "\n\nRecomputation gives " + IdempotenceChecker.objAndClass(freshest);
        msg = IdempotenceChecker.checkValueEquivalence(existing, freshest) == null ? msg + " which is equivalent to 'existing'" : (IdempotenceChecker.checkValueEquivalence(fresh, freshest) == null ? msg + " which is equivalent to 'fresh'" : msg + " which is different from both values");
        if (!((ResultWithLog)rwl).log.isEmpty() && !(freshest instanceof ResultWithLog)) {
            msg = msg + "\nRecomputation log:\n" + rwl.printLog();
        }
        String string = msg;
        if (string == null) {
            IdempotenceChecker.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> ResultWithLog<T> computeWithLogging(@NotNull Computable<? extends T> recomputeValue) {
        List<String> threadLog;
        boolean outermost;
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(5);
        }
        boolean bl = outermost = (threadLog = ourLog.get()) == null;
        if (outermost) {
            threadLog = new ArrayList<String>();
            ourLog.set(threadLog);
        }
        int start = threadLog.size();
        T result2 = recomputeValue.compute();
        ResultWithLog resultWithLog = new ResultWithLog(result2, new ArrayList<String>(threadLog.subList(start, threadLog.size())));
        ResultWithLog resultWithLog2 = resultWithLog;
        if (resultWithLog2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(6);
        }
        return resultWithLog2;
        finally {
            if (outermost) {
                ourLog.remove();
            }
        }
    }

    @NonNls
    private static String objAndClass(Object o) {
        String s;
        if (o == null) {
            return "null";
        }
        String string = s = o instanceof Object[] ? Arrays.toString((Object[])o) : o.toString();
        return s.contains(o.getClass().getSimpleName()) || o instanceof String || o instanceof Number || o instanceof Class ? s : s + " (" + (o.getClass().isArray() ? o.getClass().getComponentType() + "[]" : o.getClass()) + ")";
    }

    private static String checkValueEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        if (existing == fresh) {
            return null;
        }
        String eqMsg = IdempotenceChecker.checkClassEquivalence(existing, fresh);
        if (eqMsg != null) {
            return eqMsg;
        }
        Object[] eArray = IdempotenceChecker.asArray(existing);
        if (eArray != null) {
            return IdempotenceChecker.checkArrayEquivalence(eArray, Objects.requireNonNull(IdempotenceChecker.asArray(fresh)), existing);
        }
        if (existing instanceof ResultWithLog) {
            return IdempotenceChecker.whichIsField("result", existing, fresh, IdempotenceChecker.checkValueEquivalence(((ResultWithLog)existing).getResult(), ((ResultWithLog)fresh).getResult()));
        }
        if (existing instanceof CachedValueBase.Data) {
            return IdempotenceChecker.checkCachedValueData((CachedValueBase.Data)existing, (CachedValueBase.Data)fresh);
        }
        if (existing instanceof List || IdempotenceChecker.isOrderedSet(existing)) {
            return IdempotenceChecker.checkCollectionElements((Collection)existing, (Collection)fresh);
        }
        if (IdempotenceChecker.isOrderedMap(existing)) {
            return IdempotenceChecker.checkCollectionElements(((Map)existing).entrySet(), ((Map)fresh).entrySet());
        }
        if (existing instanceof Set) {
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Set)existing).size(), ((Set)fresh).size()));
        }
        if (existing instanceof Map) {
            if (existing instanceof ConcurrentMap) {
                return null;
            }
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Map)existing).size(), ((Map)fresh).size()));
        }
        if (IdempotenceChecker.isExpectedToHaveSaneEquals(existing) && !existing.equals(fresh)) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        if (existing instanceof PsiNamedElement) {
            return IdempotenceChecker.checkPsiEquivalence((PsiElement)existing, (PsiElement)fresh);
        }
        if (existing instanceof ResolveResult) {
            PsiElement freshPsi;
            PsiElement existingPsi = ((ResolveResult)existing).getElement();
            if (existingPsi != (freshPsi = ((ResolveResult)fresh).getElement())) {
                String s = IdempotenceChecker.checkClassEquivalence(existingPsi, freshPsi);
                if (s == null) {
                    s = IdempotenceChecker.checkPsiEquivalence(existingPsi, freshPsi);
                }
                return IdempotenceChecker.whichIsField("element", existing, fresh, s);
            }
            return null;
        }
        return null;
    }

    private static boolean isOrderedMap(@NotNull Object o) {
        if (o == null) {
            IdempotenceChecker.$$$reportNull$$$0(7);
        }
        return o instanceof LinkedHashMap || o instanceof SortedMap;
    }

    private static boolean isOrderedSet(@NotNull Object o) {
        if (o == null) {
            IdempotenceChecker.$$$reportNull$$$0(8);
        }
        return o instanceof LinkedHashSet || o instanceof SortedSet;
    }

    private static String whichIsField(@NotNull @NonNls String field, @NotNull Object existing, @NotNull Object fresh, @Nullable String msg) {
        if (field == null) {
            IdempotenceChecker.$$$reportNull$$$0(9);
        }
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(10);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(11);
        }
        return msg == null ? null : IdempotenceChecker.appendDetail(msg, "which is `." + field + "` of " + existing + " and " + fresh);
    }

    private static Object @Nullable [] asArray(@NotNull Object o) {
        if (o == null) {
            IdempotenceChecker.$$$reportNull$$$0(12);
        }
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        if (o instanceof Map.Entry) {
            return new Object[]{((Map.Entry)o).getKey(), ((Map.Entry)o).getValue()};
        }
        if (o instanceof Pair) {
            return new Object[]{((Pair)o).first, ((Pair)o).second};
        }
        if (o instanceof Trinity) {
            return new Object[]{((Trinity)o).first, ((Trinity)o).second, ((Trinity)o).third};
        }
        return null;
    }

    private static String checkCachedValueData(@NotNull CachedValueBase.Data<?> existing, @NotNull CachedValueBase.Data<?> fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(13);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(14);
        }
        Object[] deps1 = existing.getDependencies();
        Object[] deps2 = fresh.getDependencies();
        Object eValue = existing.get();
        Object fValue = fresh.get();
        if (deps1.length != deps2.length) {
            String msg = IdempotenceChecker.reportProblem(deps1.length, deps2.length);
            msg = IdempotenceChecker.appendDetail(msg, "which is length of CachedValue dependencies: " + Arrays.toString(deps1) + " and " + Arrays.toString(deps2));
            msg = IdempotenceChecker.appendDetail(msg, "where values are  " + IdempotenceChecker.objAndClass(eValue) + " and " + IdempotenceChecker.objAndClass(fValue));
            return msg;
        }
        return IdempotenceChecker.checkValueEquivalence(eValue, fValue);
    }

    private static boolean isExpectedToHaveSaneEquals(@NotNull Object existing) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(15);
        }
        return existing instanceof Comparable || existing instanceof Symbol;
    }

    @Contract(value="null,_->!null;_,null->!null")
    private static String checkClassEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        Class<?> c2;
        if (existing == null || fresh == null) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        Class<?> c1 = existing.getClass();
        if (c1 != (c2 = fresh.getClass()) && !IdempotenceChecker.objectsOfDifferentClassesCanStillBeEquivalent(existing, fresh)) {
            return IdempotenceChecker.whichIsField("class", existing, fresh, IdempotenceChecker.reportProblem(c1, c2));
        }
        return null;
    }

    private static boolean objectsOfDifferentClassesCanStillBeEquivalent(@NotNull Object existing, @NotNull Object fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(16);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(17);
        }
        if (existing instanceof Map && fresh instanceof Map && IdempotenceChecker.isOrderedMap(existing) == IdempotenceChecker.isOrderedMap(fresh)) {
            return true;
        }
        if (existing instanceof Set && fresh instanceof Set && IdempotenceChecker.isOrderedSet(existing) == IdempotenceChecker.isOrderedSet(fresh)) {
            return true;
        }
        if (existing instanceof List && fresh instanceof List) {
            return true;
        }
        if (existing instanceof PsiNamedElement && fresh instanceof PsiNamedElement) {
            return true;
        }
        return ContainerUtil.intersects((Collection)allSupersWithEquals.get(existing.getClass()), (Collection)allSupersWithEquals.get(fresh.getClass()));
    }

    private static String checkPsiEquivalence(@NotNull PsiElement existing, @NotNull PsiElement fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(18);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(19);
        }
        if (!(existing.equals(fresh) || existing.isEquivalentTo(fresh) || fresh.isEquivalentTo(existing) || !IdempotenceChecker.seemsToBeResolveTarget(existing) && !IdempotenceChecker.seemsToBeResolveTarget(fresh))) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        return null;
    }

    private static boolean seemsToBeResolveTarget(@NotNull PsiElement psi) {
        if (psi == null) {
            IdempotenceChecker.$$$reportNull$$$0(20);
        }
        if (psi.isPhysical()) {
            return true;
        }
        PsiElement nav = psi.getNavigationElement();
        return nav != null && nav.isPhysical();
    }

    private static String checkCollectionElements(@NotNull Collection<?> existing, @NotNull Collection<?> fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(21);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(22);
        }
        if (fresh.isEmpty()) {
            return null;
        }
        return IdempotenceChecker.checkArrayEquivalence(existing.toArray(), fresh.toArray(), existing);
    }

    private static String checkCollectionSizes(int size1, int size2) {
        if (size2 == 0) {
            return null;
        }
        if (size1 != size2) {
            return IdempotenceChecker.reportProblem(size1, size2);
        }
        return null;
    }

    private static String checkArrayEquivalence(Object @NotNull [] a1, Object @NotNull [] a2, @NotNull Object original1) {
        int len2;
        int len1;
        if (original1 == null) {
            IdempotenceChecker.$$$reportNull$$$0(23);
        }
        if (a1 == null) {
            IdempotenceChecker.$$$reportNull$$$0(24);
        }
        if (a2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(25);
        }
        if ((len1 = a1.length) != (len2 = a2.length)) {
            return IdempotenceChecker.appendDetail(IdempotenceChecker.reportProblem(len1, len2), "which is length of " + Arrays.toString(a1) + " and " + Arrays.toString(a2));
        }
        for (int i = 0; i < len1; ++i) {
            String msg = IdempotenceChecker.checkValueEquivalence(a1[i], a2[i]);
            if (msg == null) continue;
            return IdempotenceChecker.whichIsField(original1 instanceof Map.Entry ? (i == 0 ? "key" : "value") : i + "th element", Arrays.toString(a1), Arrays.toString(a2), msg);
        }
        return null;
    }

    @NotNull
    private static String reportProblem(@Nullable Object o1, @Nullable Object o2) {
        return IdempotenceChecker.appendDetail("Non-idempotent computation: it returns different results when invoked multiple times or on different threads:", IdempotenceChecker.objAndClass(o1) + " != " + IdempotenceChecker.objAndClass(o2));
    }

    @Contract(pure=true)
    @NotNull
    private static String appendDetail(@NotNull @NonNls String message2, @NotNull @NonNls String detail) {
        if (message2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(26);
        }
        if (detail == null) {
            IdempotenceChecker.$$$reportNull$$$0(27);
        }
        String string = message2 + "\n  " + StringUtil.trimLog(detail, 10000);
        if (string == null) {
            IdempotenceChecker.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static boolean areRandomChecksEnabled() {
        return ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void applyForRandomCheck(@NotNull T data, @NotNull Object provider, @NotNull Computable<? extends T> recomputeValue) {
        if (data == null) {
            IdempotenceChecker.$$$reportNull$$$0(30);
        }
        if (provider == null) {
            IdempotenceChecker.$$$reportNull$$$0(31);
        }
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(32);
        }
        if (IdempotenceChecker.areRandomChecksEnabled() && IdempotenceChecker.shouldPerformRandomCheck()) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            AtomicInteger prevNesting = ourRandomCheckNesting.get();
            prevNesting.incrementAndGet();
            try {
                T fresh = recomputeValue.compute();
                if (stamp.mayCacheNow()) {
                    IdempotenceChecker.checkEquivalence(data, fresh, provider.getClass(), recomputeValue);
                }
            }
            finally {
                prevNesting.decrementAndGet();
            }
        }
    }

    private static boolean shouldPerformRandomCheck() {
        int rate = rateCheckProperty.get().asInteger();
        return rate > 0 && ThreadLocalRandom.current().nextInt(rate) == 0 && !ApplicationManagerEx.isInStressTest();
    }

    public static boolean isLoggingEnabled() {
        return ourLog.get() != null;
    }

    public static void logTrace(@NotNull @NonNls String message2) {
        List<String> log2;
        if (message2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(33);
        }
        if ((log2 = ourLog.get()) != null) {
            log2.add(message2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 3: 
            case 5: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recomputeValue";
                break;
            }
            case 4: 
            case 6: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/IdempotenceChecker";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fresh";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/IdempotenceChecker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "recomputeWithLogging";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithLogging";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "appendDetail";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkEquivalence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportFailure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recomputeWithLogging";
                break;
            }
            case 4: 
            case 6: 
            case 28: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeWithLogging";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOrderedMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOrderedSet";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "whichIsField";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "asArray";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValueData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedToHaveSaneEquals";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "objectsOfDifferentClassesCanStillBeEquivalent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiEquivalence";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "seemsToBeResolveTarget";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkCollectionElements";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayEquivalence";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendDetail";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "disableRandomChecksUntil";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyForRandomCheck";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "logTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ResultWithLog<T> {
        private final T result;
        private final List<String> log;

        private ResultWithLog(T result2, List<String> log2) {
            this.result = result2;
            this.log = log2;
        }

        public T getResult() {
            return this.result;
        }

        String printLog() {
            return StringUtil.join(this.log, s -> "  " + s, "\n");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResultWithLog)) {
                return false;
            }
            ResultWithLog log2 = (ResultWithLog)o;
            return Arrays.deepEquals(new Object[]{this.result}, new Object[]{log2.result});
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }

        public String toString() {
            return "ResultWithLog{" + this.result + (this.log.isEmpty() ? "" : ", log='\n" + this.printLog() + '\'') + '}';
        }
    }
}

