/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;

@ApiStatus.Internal
public final class PlatformUtils {
    private static final Set<String> COMMERCIAL_EDITIONS = new HashSet<String>(Arrays.asList("idea", "AppCode", "CLion", "Python", "DataSpell", "Ruby", "PhpStorm", "WebStorm", "DataGrip", "Rider", "GoLand", "RustRover", "Aqua"));

    @NotNull
    public static String getPlatformPrefix() {
        String string = PlatformUtils.getPlatformPrefix("idea");
        if (string == null) {
            PlatformUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getPlatformPrefix(@Nullable String defaultPrefix) {
        return System.getProperty("idea.platform.prefix", defaultPrefix);
    }

    public static boolean isJetBrainsClient() {
        return PlatformUtils.is("JetBrainsClient");
    }

    public static boolean isQodana() {
        return SystemProperties.getBooleanProperty("qodana.application", false);
    }

    private static boolean is(String idePrefix) {
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/PlatformUtils", "getPlatformPrefix"));
    }
}

