/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.SingletonIterator;
import org.jetbrains.kotlin.com.intellij.util.indexing.ValueContainer;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.ChangeBufferingList;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.IntIdsIterator;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexDebugProperties;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.UpdatableValueContainer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

@ApiStatus.Internal
public class ValueContainerImpl<Value>
extends UpdatableValueContainer<Value>
implements Cloneable {
    protected static final Logger LOG = Logger.getInstance(ValueContainerImpl.class);
    private static final boolean DO_EXPENSIVE_CHECKS = (IndexDebugProperties.IS_UNIT_TEST_MODE || IndexDebugProperties.EXTRA_SANITY_CHECKS) && !IndexDebugProperties.IS_IN_STRESS_TESTS;
    private static final boolean USE_SYNCHRONIZED_VALUE_CONTAINER = SystemProperties.getBooleanProperty("idea.use.synchronized.value.container", false);
    private Object myInputIdMapping;
    private Object myInputIdMappingValue;
    public static final IntIdsIterator EMPTY_ITERATOR = new IntIdsIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return this;
        }
    };

    protected ValueContainerImpl() {
    }

    @Nullable
    protected ValueToInputMap<Value> asMapping() {
        return this.myInputIdMapping instanceof ValueToInputMap ? (ValueToInputMap)this.myInputIdMapping : null;
    }

    private Value asValue() {
        return (Value)this.myInputIdMapping;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach((id, value2) -> {
            sb.append(id).append(" <-> '").append(value2).append("'\n");
            return true;
        });
        return sb.toString();
    }

    @NotNull
    protected static <Value> Value wrapValue(Value value2) {
        Object object = value2 == null ? ObjectUtils.NULL : value2;
        if (object == null) {
            ValueContainerImpl.$$$reportNull$$$0(2);
        }
        return (Value)object;
    }

    static <Value> Value unwrap(Value value2) {
        return value2 == ObjectUtils.NULL ? null : (Value)value2;
    }

    @Override
    @NotNull
    public InvertedIndexValueIterator<Value> getValueIterator() {
        Iterator iterator2;
        if (this.myInputIdMapping == null) {
            EmptyValueIterator emptyValueIterator = EmptyValueIterator.INSTANCE;
            if (emptyValueIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(3);
            }
            return emptyValueIterator;
        }
        ValueToInputMap<Value> mapping = this.asMapping();
        if (mapping == null) {
            AbstractMap.SimpleImmutableEntry<Value, Object> entry = new AbstractMap.SimpleImmutableEntry<Value, Object>(ValueContainerImpl.wrapValue(this.asValue()), this.myInputIdMappingValue);
            iterator2 = new SingletonIterator<AbstractMap.SimpleImmutableEntry<Value, Object>>(entry);
        } else {
            iterator2 = mapping.entrySet().iterator();
        }
        return new InvertedIndexValueIterator<Value>(){
            private Value currentValue;
            private Object currentFileSet;

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Value next() {
                Map.Entry entry = (Map.Entry)iterator2.next();
                Object next = this.currentValue = entry.getKey();
                this.currentFileSet = entry.getValue();
                return ValueContainerImpl.unwrap(next);
            }

            @Override
            @NotNull
            public ValueContainer.IntIterator getInputIdsIterator() {
                ValueContainer.IntIterator intIterator = ValueContainerImpl.getIntIteratorOutOfFileSetObject(this.getFileSetObject());
                if (intIterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return intIterator;
            }

            public Object getFileSetObject() {
                if (this.currentValue == null) {
                    throw new IllegalStateException();
                }
                return this.currentFileSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/ValueContainerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputIdsIterator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueAssociationPredicate";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static ValueContainer.IntIterator getIntIteratorOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            IntIdsIterator intIdsIterator = EMPTY_ITERATOR;
            if (intIdsIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(7);
            }
            return intIdsIterator;
        }
        if (input instanceof Integer) {
            return new SingleValueIterator((Integer)input);
        }
        IntIdsIterator intIdsIterator = ((ChangeBufferingList)input).intIterator();
        if (intIdsIterator == null) {
            ValueContainerImpl.$$$reportNull$$$0(8);
        }
        return intIdsIterator;
    }

    public ValueContainerImpl<Value> clone() {
        try {
            ValueContainerImpl clone = (ValueContainerImpl)super.clone();
            ValueToInputMap<Value> mapping = this.asMapping();
            if (mapping != null) {
                Object2ObjectOpenHashMap cloned = mapping.clone();
                cloned.forEach((arg_0, arg_1) -> ValueContainerImpl.lambda$clone$3((ValueToInputMap)cloned, arg_0, arg_1));
                clone.myInputIdMapping = cloned;
            } else if (this.myInputIdMappingValue instanceof ChangeBufferingList) {
                clone.myInputIdMappingValue = ((ChangeBufferingList)this.myInputIdMappingValue).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$clone$3(ValueToInputMap cloned, Object key, Object val) {
        if (val instanceof ChangeBufferingList) {
            cloned.put(key, ((ChangeBufferingList)val).clone());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/ValueContainerImpl";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSetObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/ValueContainerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueIterator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredicateOutOfFileSetObject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntIteratorOutOfFileSetObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetFileSetForValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "storeFileSet";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class ValueToInputMap<Value>
    extends Object2ObjectOpenHashMap<Value, Object> {
        @Override
        public ValueToInputMap<Value> clone() {
            return (ValueToInputMap)super.clone();
        }
    }

    private static final class EmptyValueIterator<Value>
    implements InvertedIndexValueIterator<Value> {
        private static final EmptyValueIterator<Object> INSTANCE = new EmptyValueIterator();

        private EmptyValueIterator() {
        }

        @Override
        @NotNull
        public ValueContainer.IntIterator getInputIdsIterator() {
            throw new IllegalStateException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Value next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static final class SingleValueIterator
    implements IntIdsIterator {
        private final int myValue;
        private boolean myValueRead;

        private SingleValueIterator(int value2) {
            this.myValue = value2;
        }

        @Override
        public boolean hasNext() {
            return !this.myValueRead;
        }

        @Override
        public int next() {
            this.myValueRead = true;
            return this.myValue;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new SingleValueIterator(this.myValue);
        }
    }
}

