/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUMap;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.kotlin.com.intellij.util.io.ResourceHandle;

public abstract class FileAccessorCache<K, T>
implements EqualityPolicy<K> {
    private static final int SEGMENTS_COUNT = Math.max(Runtime.getRuntime().availableProcessors() / 8, 1);
    private final SLRUMap<K, Handle<T>> cache;
    private final List<Handle<T>> handlersToBeDisposed = new ArrayList<Handle<T>>();
    private final ReentrantLock cacheLock = new ReentrantLock();
    private final ReentrantLock[] resourceAllocationLocks = new ReentrantLock[SEGMENTS_COUNT];

    public FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
        this.cache = new SLRUMap<K, Handle<T>>(protectedQueueSize, probationalQueueSize, this){

            @Override
            protected void onDropFromCache(K key, @NotNull Handle<T> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                value2.release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/io/FileAccessorCache$1", "onDropFromCache"));
            }
        };
        for (int i = 0; i < this.resourceAllocationLocks.length; ++i) {
            this.resourceAllocationLocks[i] = new ReentrantLock();
        }
    }

    @NotNull
    protected abstract T createAccessor(K var1) throws IOException;

    protected abstract void disposeAccessor(@NotNull T var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Handle<T> get(K key) {
        Handle<T> cached = this.getIfCached(key);
        if (cached != null) {
            Handle<T> handle = cached;
            if (handle == null) {
                FileAccessorCache.$$$reportNull$$$0(0);
            }
            return handle;
        }
        Handle handle = this.withUpdateLock(key, () -> {
            Handle<T> _cached = this.getIfCached(key);
            if (_cached != null) {
                return _cached;
            }
            return this.createHandle(key);
        });
        Handle handle2 = handle;
        if (handle2 == null) {
            FileAccessorCache.$$$reportNull$$$0(1);
        }
        return handle2;
        finally {
            this.runPostponedDisposals();
        }
    }

    private Handle<T> createHandle(K key) {
        try {
            Handle newHandle = new Handle(key, this.createAccessor(key), this);
            newHandle.allocate();
            this.cacheLock.lock();
            try {
                this.cache.put(key, newHandle);
            }
            finally {
                this.cacheLock.unlock();
            }
            return newHandle;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void runPostponedDisposals() {
        ArrayList<Handle<T>> handlesToBeDisposed;
        this.cacheLock.lock();
        try {
            if (this.handlersToBeDisposed.isEmpty()) {
                return;
            }
            handlesToBeDisposed = new ArrayList<Handle<T>>(this.handlersToBeDisposed);
            this.handlersToBeDisposed.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
        IOException disposeException = null;
        for (Handle handle : handlesToBeDisposed) {
            try {
                this.withUpdateLock(handle.key, () -> {
                    this.disposeAccessor(handleToDispose.resource);
                    return null;
                });
            }
            catch (IOException ex) {
                if (disposeException == null) {
                    disposeException = ex;
                    continue;
                }
                disposeException.addSuppressed(ex);
            }
        }
        if (disposeException != null) {
            throw new UncheckedIOException(disposeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, E extends Exception> R withUpdateLock(@NotNull K key, @NotNull ThrowableComputable<R, E> lambda) throws E {
        if (key == null) {
            FileAccessorCache.$$$reportNull$$$0(2);
        }
        if (lambda == null) {
            FileAccessorCache.$$$reportNull$$$0(3);
        }
        int hash = this.getHashCode(key);
        int segmentNo = Math.abs(hash) % this.resourceAllocationLocks.length;
        ReentrantLock lock2 = this.resourceAllocationLocks[segmentNo];
        lock2.lock();
        try {
            R r = lambda.compute();
            return r;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle<T> getIfCached(K key) {
        this.cacheLock.lock();
        try {
            Handle<T> value2 = this.cache.get(key);
            if (value2 != null) {
                value2.allocate();
            }
            Handle<T> handle = value2;
            return handle;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public boolean remove(K key) {
        try {
            this.cacheLock.lock();
            try {
                boolean bl = this.cache.remove(key);
                this.cacheLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.cacheLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.runPostponedDisposals();
        }
    }

    public void clear() {
        try {
            this.cacheLock.lock();
            try {
                this.cache.clear();
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        finally {
            this.runPostponedDisposals();
        }
    }

    @Override
    public int getHashCode(K value2) {
        return value2.hashCode();
    }

    @Override
    public boolean isEqual(K val1, K val2) {
        return val1.equals(val2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/FileAccessorCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/FileAccessorCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withUpdateLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Handle<T>
    extends ResourceHandle<T> {
        private final Object key;
        private final FileAccessorCache<?, T> owner;
        @NotNull
        private final T resource;
        private final AtomicInteger refCount;

        private <K> Handle(@NotNull K key, @NotNull T fileAccessor, @NotNull FileAccessorCache<K, T> owner) {
            if (key == null) {
                Handle.$$$reportNull$$$0(0);
            }
            if (fileAccessor == null) {
                Handle.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                Handle.$$$reportNull$$$0(2);
            }
            this.refCount = new AtomicInteger(1);
            this.key = key;
            this.resource = fileAccessor;
            this.owner = owner;
        }

        public void allocate() {
            this.refCount.incrementAndGet();
        }

        public void release() {
            if (this.refCount.decrementAndGet() == 0) {
                ((FileAccessorCache)this.owner).cacheLock.lock();
                try {
                    ((FileAccessorCache)this.owner).handlersToBeDisposed.add(this);
                }
                finally {
                    ((FileAccessorCache)this.owner).cacheLock.unlock();
                }
            }
        }

        @Override
        public void close() {
            this.release();
        }

        @Override
        @NotNull
        public T get() {
            T t = this.resource;
            if (t == null) {
                Handle.$$$reportNull$$$0(3);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAccessor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/FileAccessorCache$Handle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/FileAccessorCache$Handle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

