/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.ScannableDataEnumeratorEx;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator
implements ScannableDataEnumeratorEx<String>,
Closeable {
    private static final Logger LOG = Logger.getInstance(SimpleStringPersistentEnumerator.class);
    @NotNull
    private final Path file;
    private final Charset charset;
    @NotNull
    private volatile Object2IntMap<String> valueToId;
    private volatile String @NotNull [] idToValue;
    private volatile boolean closed;

    public SimpleStringPersistentEnumerator(@NotNull Path file) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this(file, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleStringPersistentEnumerator(@NotNull Path file, @NotNull Charset charset) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(2);
        }
        this.closed = false;
        this.file = file;
        this.charset = charset;
        try {
            Pair<Object2IntMap<String>, String[]> pair;
            if (Files.notExists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            try {
                pair = SimpleStringPersistentEnumerator.readStorageFromDisk(file, charset, Charset.defaultCharset());
            }
            catch (IOException e) {
                LOG.warnWithDebug("Can't read [" + file.toAbsolutePath() + "] content", e);
                Files.write(file, ArrayUtilRt.EMPTY_BYTE_ARRAY, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                pair = SimpleStringPersistentEnumerator.readStorageFromDisk(file, charset, Charset.defaultCharset());
            }
            SimpleStringPersistentEnumerator simpleStringPersistentEnumerator = this;
            synchronized (simpleStringPersistentEnumerator) {
                this.valueToId = pair.getFirst();
                this.idToValue = pair.getSecond();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't create file [" + file + "]", e);
        }
    }

    @NotNull
    public Path getFile() {
        Path path = this.file;
        if (path == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(3);
        }
        return path;
    }

    @Override
    public int enumerate(@Nullable String value2) {
        this.checkNotClosed();
        Object2IntMap<String> valueToIdLocal = this.valueToId;
        int id = valueToIdLocal.getInt(value2);
        if (id != valueToIdLocal.defaultReturnValue()) {
            return id;
        }
        return this.insertNewValue(value2);
    }

    private synchronized int insertNewValue(@Nullable String value2) {
        if (value2 != null && StringUtil.containsLineBreak(value2)) {
            throw new IllegalArgumentException("SimpleStringPersistentEnumerator doesn't support multi-line strings: [" + value2 + "]");
        }
        int id = this.valueToId.getInt(value2);
        if (id != this.valueToId.defaultReturnValue()) {
            return id;
        }
        int newId = this.idToValue.length + 1;
        String[] newIdToName = Arrays.copyOf(this.idToValue, this.idToValue.length + 1);
        newIdToName[newId - 1] = value2;
        this.idToValue = newIdToName;
        Object2IntOpenHashMap<String> newValueToId = new Object2IntOpenHashMap<String>(this.valueToId);
        newValueToId.put(value2, newId);
        this.valueToId = newValueToId;
        this.forceDiskSync();
        return newId;
    }

    @NotNull
    public Map<String, Integer> getInvertedState() {
        this.checkNotClosed();
        return new HashMap<String, Integer>(this.valueToId);
    }

    @Override
    @Nullable
    public String valueOf(int id) {
        this.checkNotClosed();
        String[] idToNameLocal = this.idToValue;
        if (id <= 0 || id > idToNameLocal.length) {
            return null;
        }
        return idToNameLocal[id - 1];
    }

    public synchronized void forceDiskSync() {
        this.checkNotClosed();
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.idToValue, this.file, this.charset);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Storage already closed");
        }
    }

    @NotNull
    private static Pair<Object2IntMap<String>, String[]> readStorageFromDisk(@NotNull Path file, @NotNull Charset charset, @NotNull Charset charsetToFallback) throws IOException {
        List<String> lines;
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(6);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(7);
        }
        if (charsetToFallback == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(8);
        }
        try {
            lines = Files.readAllLines(file, charset);
        }
        catch (IOException exMainCharset) {
            try {
                lines = Files.readAllLines(file, charsetToFallback);
            }
            catch (IOException exFallbackCharset) {
                exFallbackCharset.addSuppressed(exMainCharset);
                throw exFallbackCharset;
            }
        }
        Object2IntOpenHashMap<String> nameToIdRegistry = new Object2IntOpenHashMap<String>(lines.size());
        String[] idToNameRegistry = lines.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            String name2 = lines.get(i);
            int id = i + 1;
            nameToIdRegistry.put(name2, id);
            idToNameRegistry[i] = name2;
        }
        Pair<Object2IntMap<String>, String[]> pair = Pair.create(nameToIdRegistry, idToNameRegistry);
        if (pair == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static void writeStorageToDisk(String[] idToName, @NotNull Path file, @NotNull Charset charset) {
        if (file == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(10);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(11);
        }
        try {
            Files.write(file, Arrays.asList(idToName), charset, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            if (Files.notExists(file, new LinkOption[0])) {
                throw new UncheckedIOException("Can't store enumerator to " + file + " -- file is removed?", e);
            }
            throw new UncheckedIOException("Can't store enumerator to " + file, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsetToFallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpToString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readStorageFromDisk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readStorageFromDisk";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeStorageToDisk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

