/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayInputStream;
import org.jetbrains.kotlin.com.intellij.util.io.zip.JBZipExtraField;
import org.jetbrains.kotlin.com.intellij.util.io.zip.JBZipFile;
import org.jetbrains.kotlin.com.intellij.util.io.zip.UnrecognizedExtraField;
import org.jetbrains.kotlin.com.intellij.util.io.zip.Zip64ExtraField;
import org.jetbrains.kotlin.com.intellij.util.io.zip.ZipShort;
import org.jetbrains.kotlin.com.intellij.util.io.zip.ZipUInt64;

public class JBZipEntry {
    private volatile long time = -1L;
    private volatile long crc = -1L;
    private volatile long size = -1L;
    private volatile long csize = -1L;
    private volatile int method = -1;
    private volatile List<JBZipExtraField> extra = new SmartList<JBZipExtraField>();
    private volatile String comment;
    private volatile int internalAttributes = 0;
    private volatile int platform = 0;
    private volatile long externalAttributes = 0L;
    private volatile String name;
    private volatile long headerOffset = -1L;
    private final JBZipFile myFile;

    protected JBZipEntry(String name2, JBZipFile file) {
        this.name = name2;
        this.myFile = file;
    }

    protected JBZipEntry(JBZipFile file) {
        this.name = "";
        this.myFile = file;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value2) {
        this.internalAttributes = value2;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value2) {
        this.externalAttributes = value2;
    }

    public long getHeaderOffset() {
        return this.headerOffset;
    }

    public void setHeaderOffset(long headerOffset) {
        this.headerOffset = headerOffset;
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void addExtra(@NotNull JBZipExtraField field) {
        JBZipExtraField current;
        if (field == null) {
            JBZipEntry.$$$reportNull$$$0(1);
        }
        if ((current = ContainerUtil.find(this.extra, f -> f.getHeaderId().equals(field.getHeaderId()))) != null) {
            this.extra.remove(current);
        }
        this.extra.add(field);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setSize(long size) {
        if (size < 0L || size > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long csize) {
        this.csize = csize;
    }

    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("invalid compression method: " + method);
        }
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String name2) {
        this.name = name2;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @ApiStatus.Internal
    public InputStream getInputStream() throws IOException {
        this.myFile.ensureFlushed(this.getHeaderOffset() + 26L + 4L);
        long start = this.calcDataOffset();
        long size = this.getCompressedSize();
        this.myFile.ensureFlushed(start + size);
        if (this.myFile.getSize() < start + size) {
            throw new EOFException();
        }
        BoundedInputStream bis = new BoundedInputStream(start, size);
        switch (this.getMethod()) {
            case 0: {
                return bis;
            }
            case 8: {
                bis.addDummy();
                int bufferSize = this.size <= 0L ? 8192 : (int)Math.min(this.size, 8192L);
                return new InflaterInputStream(bis, new Inflater(true), bufferSize);
            }
        }
        throw new ZipException("Found unsupported compression method " + this.getMethod());
    }

    byte @NotNull [] getCentralDirectoryExtraBytes() throws IOException {
        byte[] byArray;
        BufferExposingByteArrayOutputStream stream;
        block6: {
            stream = new BufferExposingByteArrayOutputStream();
            for (JBZipExtraField field : this.extra) {
                stream.write(field.getHeaderId().getBytes());
                stream.write(field.getCentralDirectoryLength().getBytes());
                stream.write(field.getCentralDirectoryData());
            }
            byte[] bytes = stream.toByteArray();
            JBZipEntry.assertValidExtraFieldSize(bytes);
            byArray = bytes;
            if (byArray != null) break block6;
            JBZipEntry.$$$reportNull$$$0(3);
        }
        return byArray;
        finally {
            stream.close();
        }
    }

    byte @NotNull [] getLocalFileHeaderDataExtra() throws IOException {
        byte[] byArray;
        BufferExposingByteArrayOutputStream stream;
        block6: {
            stream = new BufferExposingByteArrayOutputStream();
            for (JBZipExtraField field : this.extra) {
                stream.write(field.getHeaderId().getBytes());
                stream.write(field.getLocalFileDataLength().getBytes());
                stream.write(field.getLocalFileDataData());
            }
            byte[] bytes = stream.toByteArray();
            JBZipEntry.assertValidExtraFieldSize(bytes);
            byArray = bytes;
            if (byArray != null) break block6;
            JBZipEntry.$$$reportNull$$$0(4);
        }
        return byArray;
        finally {
            stream.close();
        }
    }

    private static void assertValidExtraFieldSize(byte @NotNull [] bytes) {
        if (bytes == null) {
            JBZipEntry.$$$reportNull$$$0(5);
        }
        if (bytes.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
    }

    void readExtraFromCentralDirectoryBytes(byte @NotNull [] extraBytes) throws IOException {
        if (extraBytes == null) {
            JBZipEntry.$$$reportNull$$$0(6);
        }
        UnsyncByteArrayInputStream stream = new UnsyncByteArrayInputStream(extraBytes);
        while (stream.available() > 0) {
            ZipUInt64 offset;
            ZipUInt64 size;
            ZipShort headerId = new ZipShort(stream.readShortLittleEndian());
            JBZipExtraField field = headerId.equals(Zip64ExtraField.HEADER_ID) ? new Zip64ExtraField() : new UnrecognizedExtraField(headerId);
            int length = stream.readShortLittleEndian();
            field.parseFromCentralDirectoryData(JBZipEntry.readNBytes(stream, length), 0, length);
            this.addExtra(field);
            if (!(field instanceof Zip64ExtraField)) continue;
            Zip64ExtraField zip64ExtraField = (Zip64ExtraField)field;
            ZipUInt64 compressedSize = zip64ExtraField.getCompressedSize();
            if (compressedSize != null) {
                this.setCompressedSize(compressedSize.getLongValue());
            }
            if ((size = zip64ExtraField.getSize()) != null) {
                this.setSize(size.getLongValue());
            }
            if ((offset = zip64ExtraField.getHeaderOffset()) == null) continue;
            this.setHeaderOffset(offset.getLongValue());
        }
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 21845 && JBZipEntry.getUTF8Length(comment) > 65535) {
            throw new IllegalArgumentException("invalid entry comment length");
        }
        this.comment = comment;
    }

    private static int getUTF8Length(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public String getComment() {
        return this.comment;
    }

    public long calcDataOffset() throws IOException {
        long offset = this.getHeaderOffset();
        byte[] b = new byte[4];
        this.myFile.readFullyFromPosition(b, offset + 26L);
        int fileNameLen = ZipShort.getValue(b, 0);
        int extraFieldLen = ZipShort.getValue(b, 2);
        return offset + 26L + 4L + (long)fileNameLen + (long)extraFieldLen;
    }

    private static byte[] readNBytes(@NotNull InputStream is, int length) throws IOException {
        int count;
        if (is == null) {
            JBZipEntry.$$$reportNull$$$0(9);
        }
        byte[] bytes = ArrayUtil.newByteArray(length);
        int off = 0;
        for (int n = 0; n < length; n += count) {
            count = is.read(bytes, off + n, length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return bytes;
    }

    public String toString() {
        return this.name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/zip/JBZipEntry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraBytes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/zip/JBZipEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtra";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCentralDirectoryExtraBytes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileHeaderDataExtra";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setExtra";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExtra";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertValidExtraFieldSize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExtraFromCentralDirectoryBytes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDataFromStream";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDataFromPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readNBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.loc = start;
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            int ret;
            if (b == null) {
                BoundedInputStream.$$$reportNull$$$0(0);
            }
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            if ((ret = JBZipEntry.this.myFile.readFromPosition(b, off, len, this.loc)) > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            SeekableByteChannel archive = ((JBZipEntry)JBZipEntry.this).myFile.myArchive;
            archive.position(this.loc++);
            return JBZipEntry.this.myFile.readByte();
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/com/intellij/util/io/zip/JBZipEntry$BoundedInputStream", "read"));
        }
    }
}

