/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.zip;

import java.math.BigInteger;

public final class ZipUInt64 {
    private final BigInteger value;

    public ZipUInt64(long value2) {
        this(BigInteger.valueOf(value2));
    }

    public ZipUInt64(BigInteger value2) {
        this.value = value2;
    }

    public ZipUInt64(byte[] bytes, int offset) {
        this.value = ZipUInt64.getValue(bytes, offset);
    }

    public byte[] getBytes() {
        return ZipUInt64.getBytes(this.value);
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static byte[] getBytes(long value2) {
        return ZipUInt64.getBytes(BigInteger.valueOf(value2));
    }

    public static byte[] getBytes(BigInteger value2) {
        byte[] result2 = new byte[8];
        long val = value2.longValue();
        result2[0] = (byte)(val & 0xFFL);
        result2[1] = (byte)((val & 0xFF00L) >> 8);
        result2[2] = (byte)((val & 0xFF0000L) >> 16);
        result2[3] = (byte)((val & 0xFF000000L) >> 24);
        result2[4] = (byte)((val & 0xFF00000000L) >> 32);
        result2[5] = (byte)((val & 0xFF0000000000L) >> 40);
        result2[6] = (byte)((val & 0xFF000000000000L) >> 48);
        result2[7] = (byte)((val & 0x7F00000000000000L) >> 56);
        if (value2.testBit(63)) {
            result2[7] = (byte)(result2[7] | 0xFFFFFF80);
        }
        return result2;
    }

    public static long getLongValue(byte[] bytes, int offset) {
        return ZipUInt64.getValue(bytes, offset).longValue();
    }

    public static BigInteger getValue(byte[] bytes, int offset) {
        long value2 = (long)bytes[offset + 7] << 56 & 0x7F00000000000000L;
        value2 += (long)bytes[offset + 6] << 48 & 0xFF000000000000L;
        value2 += (long)bytes[offset + 5] << 40 & 0xFF0000000000L;
        value2 += (long)bytes[offset + 4] << 32 & 0xFF00000000L;
        value2 += (long)bytes[offset + 3] << 24 & 0xFF000000L;
        value2 += (long)bytes[offset + 2] << 16 & 0xFF0000L;
        value2 += (long)bytes[offset + 1] << 8 & 0xFF00L;
        BigInteger val = BigInteger.valueOf(value2 += (long)bytes[offset] & 0xFFL);
        return (bytes[offset + 7] & 0xFFFFFF80) == -128 ? val.setBit(63) : val;
    }

    public static long getLongValue(byte[] bytes) {
        return ZipUInt64.getLongValue(bytes, 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipUInt64)) {
            return false;
        }
        return this.value.equals(((ZipUInt64)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ZipInt64: " + this.value;
    }
}

