/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.lang.Access;
import org.jetbrains.kotlin.com.intellij.util.lang.CharSequenceAccess;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;
import org.jetbrains.kotlin.com.intellij.util.lang.StrippedLongSet;
import org.jetbrains.kotlin.com.intellij.util.lang.StrippedLongToObjectMap;
import org.jetbrains.kotlin.com.intellij.util.lang.Xxh3Impl;

@ApiStatus.Internal
public final class ClasspathCache {
    private static final IntFunction<Loader[][]> ARRAY_FACTORY = size -> new Loader[size][];
    private StrippedLongToObjectMap<Loader[]> classPackageCache;
    private StrippedLongToObjectMap<Loader[]> resourcePackageCache;
    private static final LongFunction<Loader[]> NULL = value2 -> null;
    private volatile LongFunction<Loader[]> classPackageCacheGetter;
    private volatile LongFunction<Loader[]> resourcePackageCacheGetter;

    void applyLoaderData(@NotNull IndexRegistrar registrar2, @NotNull Loader loader) {
        if (registrar2 == null) {
            ClasspathCache.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            ClasspathCache.$$$reportNull$$$0(1);
        }
        if (registrar2.classPackageCount() != 0) {
            StrippedLongToObjectMap<Loader[]> newClassMap = this.classPackageCache == null ? new StrippedLongToObjectMap<Loader[]>(ARRAY_FACTORY, registrar2.classPackageCount()) : new StrippedLongToObjectMap<Loader[]>(this.classPackageCache);
            ClasspathCache.addPackages(registrar2.classPackages(), newClassMap, loader, registrar2.getKeyFilter(true));
            this.classPackageCache = newClassMap;
            this.classPackageCacheGetter = newClassMap;
        }
        if (registrar2.resourcePackageCount() != 0) {
            StrippedLongToObjectMap<Loader[]> newResourceMap = this.resourcePackageCache == null ? new StrippedLongToObjectMap<Loader[]>(ARRAY_FACTORY, registrar2.resourcePackageCount()) : new StrippedLongToObjectMap<Loader[]>(this.resourcePackageCache);
            ClasspathCache.addPackages(registrar2.resourcePackages(), newResourceMap, loader, registrar2.getKeyFilter(false));
            this.resourcePackageCache = newResourceMap;
            this.resourcePackageCacheGetter = newResourceMap;
        }
    }

    Loader @Nullable [] getLoadersByName(@NotNull String path) {
        if (path == null) {
            ClasspathCache.$$$reportNull$$$0(2);
        }
        return (path.endsWith(".class") ? this.classPackageCacheGetter : this.resourcePackageCacheGetter).apply(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
    }

    Loader @Nullable [] getClassLoadersByPackageNameHash(long packageNameHash) {
        return this.classPackageCacheGetter.apply(packageNameHash);
    }

    public static long getPackageNameHash(@NotNull String resourcePath, int endIndex) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(4);
        }
        return endIndex <= 0 ? 0L : Xxh3Impl.hash((Object)resourcePath, (Access)CharSequenceAccess.INSTANCE, (int)0, (int)(endIndex * 2), (long)0L);
    }

    private static void addPackages(long[] hashes, StrippedLongToObjectMap<Loader[]> map, Loader loader, @Nullable LongPredicate hashFilter) {
        Loader[] singleArray = null;
        for (long hash : hashes) {
            if (hashFilter != null && !hashFilter.test(hash)) continue;
            int index = map.index(hash);
            if (index < 0) {
                if (singleArray == null) {
                    singleArray = new Loader[]{loader};
                }
                map.addByIndex(index, hash, singleArray);
                continue;
            }
            Loader[] loaders = map.getByIndex(index);
            Loader[] newList = new Loader[loaders.length + 1];
            System.arraycopy(loaders, 0, newList, 0, loaders.length);
            newList[loaders.length] = loader;
            map.replaceByIndex(index, hash, newList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/ClasspathCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyLoaderData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoadersByName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoadersByResourcePackageDir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface IndexRegistrar {
        default public Predicate<String> getNameFilter() {
            return null;
        }

        public int classPackageCount();

        public int resourcePackageCount();

        public long[] classPackages();

        public long[] resourcePackages();

        @Nullable
        default public LongPredicate getKeyFilter(boolean forClasses) {
            return null;
        }
    }

    @ApiStatus.Internal
    public static final class LoaderDataBuilder
    implements IndexRegistrar {
        final StrippedLongSet classPackageHashes = new StrippedLongSet();
        final StrippedLongSet resourcePackageHashes = new StrippedLongSet();

        @Override
        public int classPackageCount() {
            return this.classPackageHashes.size();
        }

        @Override
        public int resourcePackageCount() {
            return this.resourcePackageHashes.size();
        }

        @Override
        public long[] classPackages() {
            return this.classPackageHashes.keys;
        }

        @Override
        public long[] resourcePackages() {
            return this.resourcePackageHashes.keys;
        }

        @Override
        public LongPredicate getKeyFilter(final boolean forClasses) {
            return new LongPredicate(){
                boolean addZero;
                {
                    this.addZero = forClasses ? classPackageHashes.hasNull() : resourcePackageHashes.hasNull();
                }

                @Override
                public boolean test(long it) {
                    if (it == 0L) {
                        if (!this.addZero) {
                            return false;
                        }
                        this.addZero = false;
                    }
                    return true;
                }
            };
        }

        void addResourcePackage(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(0);
            }
            this.resourcePackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        void addClassPackage(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(2);
            }
            this.classPackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "path";
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/ClasspathCache$LoaderDataBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addResourcePackage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPackageFromName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addClassPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

