/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Cancellation;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.ListenerDescriptor;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusOwner;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.CompositeMessageBusKt;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusEx;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessagePublisher;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.ToDirectChildrenMessagePublisher;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.ToParentMessagePublisher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\bJ \u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0001J\u0015\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u001eJ/\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J#\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0000\u00a2\u0006\u0004\b*\u0010+J1\u0010,\u001a\u00020\u00142\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u000e\u0010-\u001a\n\u0012\u0006\b\u0000\u0012\u00020)0\n2\u0006\u0010.\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b/J\u001c\u0010.\u001a\u00020\u0014\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0002J\u0019\u00100\u001a\u00020\u00142\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0000\u00a2\u0006\u0002\b1J\u001d\u00102\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0004\b4\u00105J\u001d\u00106\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0004\b7\u00108J\u0006\u00109\u001a\u00020\u0014J\u0006\u0010:\u001a\u00020\u0014J\u001c\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ\u0018\u0010?\u001a\u00020\u00142\u0010\u0010@\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030B0AJ\b\u0010C\u001a\u00020\u0014H\u0007J\r\u0010D\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bER<\u0010\t\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u00010\r\u00a2\u0006\u0002\b\f0\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/CompositeMessageBus;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusEx;", "owner", "Lorg/jetbrains/kotlin/com/intellij/util/messages/MessageBusOwner;", "parentBus", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "childBuses", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "Ljava/util/List;", "topicClassToListenerDescriptor", "", "", "Lorg/jetbrains/kotlin/com/intellij/util/messages/ListenerDescriptor;", "setLazyListeners", "", "map", "Ljava/util/concurrent/ConcurrentMap;", "hasChildren", "", "hasChildren$intellij_platform_core", "addChild", "bus", "onChildBusDisposed", "childBus", "onChildBusDisposed$intellij_platform_core", "createPublisher", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessagePublisher;", "L", "topic", "Lorg/jetbrains/kotlin/com/intellij/util/messages/Topic;", "direction", "Lorg/jetbrains/kotlin/com/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "computeSubscribers", "", "", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "doComputeSubscribers", "result", "subscribeLazyListeners", "doComputeSubscribers$intellij_platform_core", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "notifyConnectionTerminated", "topicAndHandlerPairs", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "clearSubscriberCache", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "removeEmptyConnectionsRecursively", "clearPublisherCache", "unsubscribeLazyListeners", "module", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "clearAllSubscriberCache", "disposeChildren", "disposeChildren$intellij_platform_core", "intellij.platform.core"})
@VisibleForTesting
@ApiStatus.Internal
public class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    @NotNull
    private final List<MessageBusImpl> childBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor;

    public CompositeMessageBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    @Override
    public final void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            this.topicClassToListenerDescriptor = map;
        } else {
            topicClassToListenerDescriptor.putAll((Map<String, List<ListenerDescriptor>>)map);
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public final boolean hasChildren$intellij_platform_core() {
        return !((Collection)this.childBuses).isEmpty();
    }

    public final void onChildBusDisposed$intellij_platform_core(@NotNull MessageBusImpl childBus) {
        Intrinsics.checkNotNullParameter((Object)childBus, (String)"childBus");
        boolean removed = this.childBuses.remove(childBus);
        CompositeMessageBusKt.access$childrenListChanged(this);
        MessageBusImpl.LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public final <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                if (!(this.parentBus == null)) {
                    boolean bl = false;
                    String string = "Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT";
                    throw new IllegalArgumentException(string.toString());
                }
                messagePublisher = new ToDirectChildrenMessagePublisher<L>(topic, this, this.childBuses);
                break;
            }
            default: {
                messagePublisher = new MessagePublisher(topic, this);
            }
        }
        return messagePublisher;
    }

    @Override
    @NotNull
    public final Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        if (this.owner.isDisposed()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = super.computeSubscribers$intellij_platform_core(topic);
        }
        return objectArray;
    }

    @Override
    public final void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result2, boolean subscribeLazyListeners) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (subscribeLazyListeners) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers$intellij_platform_core(topic, result2, subscribeLazyListeners);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers$intellij_platform_core(topic, result2, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private final <L> void subscribeLazyListeners(Topic<L> topic) {
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            return;
        }
        Cancellation.computeInNonCancelableSection(() -> CompositeMessageBus.subscribeLazyListeners$lambda$4(topicClassToListenerDescriptor, topic, this));
    }

    @Override
    public final void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    @Override
    public final boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        boolean isChildClearingNeeded = super.notifyConnectionTerminated$intellij_platform_core(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
        this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$6(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$5(topicAndHandlerPairs, arg_0), arg_0));
        return false;
    }

    @Override
    public final void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        super.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
    }

    @Override
    public final void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        for (MessageBusImpl bus : this.childBuses) {
            bus.removeEmptyConnectionsRecursively();
        }
    }

    @Override
    public final void disposeChildren$intellij_platform_core() {
        for (MessageBusImpl childBus : this.childBuses) {
            Disposer.dispose(childBus);
        }
    }

    private static final List subscribeLazyListeners$lambda$4$lambda$1(PluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List subscribeLazyListeners$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void subscribeLazyListeners$lambda$4$lambda$3(CompositeMessageBus this$0, Topic $topic, PluginDescriptor key, List listeners) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        this$0.subscribers.add(new DescriptorBasedMessageBusConnection(key, $topic, listeners));
    }

    private static final Unit subscribeLazyListeners$lambda$4(Map $topicClassToListenerDescriptor, Topic $topic, CompositeMessageBus this$0) {
        List list = (List)$topicClassToListenerDescriptor.remove($topic.getListenerClass().getName());
        if (list == null) {
            return Unit.INSTANCE;
        }
        List listenerDescriptors = list;
        LinkedHashMap<Object, List> listenerMap = new LinkedHashMap<Object, List>();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                Object object = this$0.owner.createListener(listenerDescriptor);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createListener(...)");
                listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor, arg_0 -> CompositeMessageBus.subscribeLazyListeners$lambda$4$lambda$2(CompositeMessageBus::subscribeLazyListeners$lambda$4$lambda$1, arg_0)).add(object);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                MessageBusImpl.LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((arg_0, arg_1) -> CompositeMessageBus.subscribeLazyListeners$lambda$4$lambda$3(this$0, $topic, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final boolean notifyConnectionTerminated$lambda$5(Object[] $topicAndHandlerPairs, Message it) {
        Intrinsics.checkNotNull((Object)it);
        return CompositeMessageBusKt.access$nullizeHandlersFromMessage(it, $topicAndHandlerPairs);
    }

    private static final boolean notifyConnectionTerminated$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

