/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.pico;

import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.kotlin.com.intellij.util.pico.PicoIntrospectionException;

public final class AmbiguousComponentResolutionException
extends PicoIntrospectionException {
    private Class<?> component;
    private final Class<?> ambiguousDependency;
    private final Object[] ambiguousComponentKeys;

    public AmbiguousComponentResolutionException(Class ambiguousDependency, Object[] componentKeys) {
        super("");
        this.ambiguousDependency = ambiguousDependency;
        this.ambiguousComponentKeys = (Object[])componentKeys.clone();
    }

    @Override
    @NonNls
    public String getMessage() {
        return this.component + " has ambiguous dependency on " + this.ambiguousDependency + ", resolves to multiple classes: " + Arrays.asList(this.getAmbiguousComponentKeys());
    }

    public Object[] getAmbiguousComponentKeys() {
        return this.ambiguousComponentKeys;
    }

    public void setComponent(Class component2) {
        this.component = component2;
    }
}

