/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.KtBooleanExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalReturnsDeclaration;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtHoldsInEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirErrorContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeContractMayNotHaveLabel;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeContractDescriptionError;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002/0B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0017J5\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001bJ5\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001eH\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\u00020\u001d*\u00020\u0002H\u0002J-\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001aH\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010#J5\u0010$\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010'J-\u0010(\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001aH\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010#J9\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "EMPTY_CONTRACT_MESSAGE", "", "DUPLICATE_CALLS_IN_PLACE_MESSAGE", "INVALID_CONTRACT_BLOCK", "CALLS_IN_PLACE_ON_CONTEXT_PARAMETER", "CONDITIONAL_RETURNS_EXPRESSION_NOT_SUPPORTED", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkAnnotationsNotAllowed", "contractCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkUnresolvedEffects", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkContractNotAllowed", "", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;)Z", "isContractOnOperatorForbidden", "checkDuplicateCallsInPlace", "description", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;)V", "checkCallsInPlaceOnContextParameter", "valueParametersCount", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;I)V", "checkComplexArgumentConditions", "checkDiagnosticsFromFirBuilder", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/KtSourceElement;)V", "DiagnosticExtractor", "ErasedCastChecker", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n81#2,7:428\n76#2,2:435\n57#2:437\n78#2:438\n57#3:439\n1#4:440\n1#4:457\n1#4:471\n13#5,2:441\n38#5:443\n39#5:444\n39#5:445\n1642#6,10:446\n1915#6:456\n1916#6:458\n1652#6:459\n1642#6,10:460\n1915#6:470\n1916#6:472\n1652#6:473\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n82#1:428,7\n82#1:435,2\n82#1:437\n82#1:438\n92#1:439\n208#1:457\n239#1:471\n161#1:441,2\n161#1:443\n164#1:444\n167#1:445\n208#1:446,10\n208#1:456\n208#1:458\n208#1:459\n239#1:460,10\n239#1:470\n239#1:472\n239#1:473\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();

    private FirContractChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        FirContractDescription firContractDescription;
        FirFunctionCall contractCall;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(declaration instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription2 = ((FirContractDescriptionOwner)((Object)declaration)).getContractDescription();
        if (firContractDescription2 == null) {
            return;
        }
        FirContractDescription contractDescription2 = firContractDescription2;
        boolean reportedNotAllowed = this.checkContractNotAllowed(context2, reporter, declaration, contractDescription2);
        if (reportedNotAllowed) {
            return;
        }
        Object object = ((FirContractDescriptionOwner)((Object)declaration)).getBody();
        FirStatement firStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.firstOrNull((List)object) : null;
        FirContractCallBlock firContractCallBlock = firStatement instanceof FirContractCallBlock ? (FirContractCallBlock)firStatement : null;
        FirFunctionCall firFunctionCall = contractCall = firContractCallBlock != null ? firContractCallBlock.getCall() : null;
        if (contractCall != null) {
            this.checkAnnotationsNotAllowed(context2, reporter, contractCall);
        }
        if ((firContractDescription = contractDescription2) instanceof FirResolvedContractDescription) {
            this.checkUnresolvedEffects(context2, reporter, (FirResolvedContractDescription)contractDescription2, declaration);
            this.checkDuplicateCallsInPlace(context2, reporter, (FirResolvedContractDescription)contractDescription2);
            this.checkComplexArgumentConditions(context2, reporter, (FirResolvedContractDescription)contractDescription2);
            if (!((Collection)declaration.getContextParameters()).isEmpty()) {
                this.checkCallsInPlaceOnContextParameter(context2, reporter, (FirResolvedContractDescription)contractDescription2, ((FirContractDescriptionOwner)((Object)declaration)).getValueParameters().size());
            }
            if (((FirResolvedContractDescription)contractDescription2).getEffects().isEmpty() && ((FirResolvedContractDescription)contractDescription2).getUnresolvedEffects().isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirResolvedContractDescription)contractDescription2).getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)"Empty contract block is not allowed", null, 16, null);
            }
            this.checkDiagnosticsFromFirBuilder(context2, reporter, ((FirResolvedContractDescription)contractDescription2).getDiagnostic(), ((FirResolvedContractDescription)contractDescription2).getSource());
        } else if (firContractDescription instanceof FirErrorContractDescription) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirErrorContractDescription)contractDescription2).getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)"Contract block could not be resolved", null, 16, null);
            this.checkDiagnosticsFromFirBuilder(context2, reporter, ((FirErrorContractDescription)contractDescription2).getDiagnostic(), ((FirErrorContractDescription)contractDescription2).getSource());
        } else {
            if (firContractDescription instanceof FirRawContractDescription || firContractDescription instanceof FirLegacyRawContractDescription) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                void $this$buildAttachment$iv$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                void cause$iv$iv;
                void message$iv$iv;
                String message$iv = "Unexpected contract description kind: " + Reflection.getOrCreateKotlinClass(contractDescription2.getClass()).getSimpleName();
                Object cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                String string = message$iv;
                Object var13_13 = cause$iv;
                String attachmentName$iv$iv = attachmentName$iv;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv$iv;
                String name$iv$iv$iv = attachmentName$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = name$iv$iv$iv;
                void var23_23 = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "declaration", declaration);
                var23_23.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void checkAnnotationsNotAllowed(CheckerContext context2, DiagnosticReporter reporter, FirFunctionCall contractCall) {
        FirCall $this$arguments$iv = contractCall;
        boolean $i$f$getArguments = false;
        Object object = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = object instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)object : null;
        if (firAnonymousFunctionExpression == null) {
            return;
        }
        FirAnonymousFunctionExpression argument = firAnonymousFunctionExpression;
        if (!argument.getAnonymousFunction().isLambda()) {
            return;
        }
        FirBlock firBlock = argument.getAnonymousFunction().getBody();
        if (firBlock == null) {
            return;
        }
        FirBlock lambdaBody = firBlock;
        lambdaBody.acceptChildren(new FirVisitorVoid(context2, reporter){
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$context = $context;
                this.$reporter = $reporter;
            }

            public void visitElement(FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren(this);
            }

            public void visitAnnotation(FirAnnotation annotation) {
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_IN_CONTRACT_ERROR(), null, 8, null);
            }

            public void visitAnnotationCall(FirAnnotationCall annotationCall) {
                Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)annotationCall.getSource(), FirErrors.INSTANCE.getANNOTATION_IN_CONTRACT_ERROR(), null, 8, null);
            }
        });
    }

    private final void checkUnresolvedEffects(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription contractDescription2, FirFunction declaration) {
        ConeDiagnostic diagnostic;
        ErasedCastChecker erasedCastChecker = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowCheckForErasedTypesInContracts) ? null : new ErasedCastChecker(declaration, context2);
        for (FirContractElementDeclaration unresolvedEffect : contractDescription2.getUnresolvedEffects()) {
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null);
            if (coneDiagnostic == null) {
                ConeDiagnostic coneDiagnostic2;
                if (erasedCastChecker != null) {
                    ErasedCastChecker it;
                    boolean bl = false;
                    coneDiagnostic2 = (ConeDiagnostic)unresolvedEffect.getEffect().accept(it, null);
                } else {
                    coneDiagnostic2 = coneDiagnostic = null;
                }
                if (coneDiagnostic2 == null) continue;
            }
            diagnostic = coneDiagnostic;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), null, 16, null);
        }
        if (erasedCastChecker != null) {
            for (FirEffectDeclaration resolvedEffect : contractDescription2.getEffects()) {
                if ((ConeDiagnostic)((KtEffectDeclaration)resolvedEffect.getEffect()).accept(erasedCastChecker, null) == null) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)resolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), null, 16, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean checkContractNotAllowed(CheckerContext context2, DiagnosticReporter reporter, FirFunction declaration, FirContractDescription contractDescription2) {
        boolean $i$f$isOperator;
        FirMemberDeclaration $this$isOperator$iv;
        boolean allowedOnSomeOperators;
        KtSourceElement source;
        block11: {
            block10: {
                KtSourceElement ktSourceElement = source = contractDescription2.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                    return false;
                }
                boolean allowedOnAccessors = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowContractsOnPropertyAccessors);
                allowedOnSomeOperators = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowContractsOnSomeOperators);
                if (!allowedOnAccessors && (declaration instanceof FirPropertyAccessor || declaration instanceof FirAnonymousFunction)) {
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are only allowed for functions.");
                    return true;
                }
                if (allowedOnAccessors && declaration instanceof FirAnonymousFunction) {
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for anonymous functions.");
                    return true;
                }
                FirMemberDeclaration $this$isAbstract$iv = declaration;
                boolean $i$f$isAbstract = false;
                if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block10;
                FirMemberDeclaration $this$isOpen$iv = declaration;
                boolean $i$f$isOpen = false;
                if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block10;
                FirMemberDeclaration $this$isOverride$iv = declaration;
                boolean $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block11;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for open or override functions.");
            return true;
        }
        if (!allowedOnSomeOperators) {
            $this$isOperator$iv = declaration;
            $i$f$isOperator = false;
            if ($this$isOperator$iv.getStatus().isOperator()) {
                FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for operator functions.");
                return true;
            }
        }
        if (allowedOnSomeOperators) {
            $this$isOperator$iv = declaration;
            $i$f$isOperator = false;
            if ($this$isOperator$iv.getStatus().isOperator() && this.isContractOnOperatorForbidden(declaration)) {
                FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for operator " + FirDeclarationUtilKt.getNameOrSpecialName(declaration) + '.');
                return true;
            }
        }
        if (!declaration.getSymbol().isLocal()) return false;
        FirContractChecker.checkContractNotAllowed$contractNotAllowed(context2, reporter, source, "Contracts are not allowed for local functions.");
        return true;
    }

    private final boolean isContractOnOperatorForbidden(FirFunction $this$isContractOnOperatorForbidden) {
        Name name2 = FirDeclarationUtilKt.getNameOrSpecialName($this$isContractOnOperatorForbidden);
        return Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.COMPARE_TO) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET_VALUE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PROVIDE_DELEGATE) ? true : Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.GET) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.SET) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PLUS) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.MINUS) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TIMES) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.DIV) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.REM) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.PLUS_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.MINUS_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TIMES_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.DIV_ASSIGN) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.REM_ASSIGN);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDuplicateCallsInPlace(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription description) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = description.getEffects();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtCallsEffectDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirEffectDeclaration it = (FirEffectDeclaration)element$iv$iv;
            boolean bl2 = false;
            KtContractDescriptionElement ktContractDescriptionElement = it.getEffect();
            if ((ktContractDescriptionElement instanceof KtCallsEffectDeclaration ? (KtCallsEffectDeclaration)ktContractDescriptionElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List callsInPlaceEffects = (List)destination$iv$iv;
        Set seenParameterIndices = new LinkedHashSet();
        for (KtCallsEffectDeclaration effect : callsInPlaceEffects) {
            int parameterIndex = effect.getValueParameterReference().getParameterIndex();
            if (seenParameterIndices.contains(parameterIndex)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)description.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)"A value parameter may not be annotated with callsInPlace twice", null, 16, null);
                continue;
            }
            seenParameterIndices.add(parameterIndex);
        }
    }

    private final void checkCallsInPlaceOnContextParameter(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription description, int valueParametersCount) {
        for (FirEffectDeclaration effectDeclaration : description.getEffects()) {
            KtContractDescriptionElement effect = effectDeclaration.getEffect();
            if (!(effect instanceof KtCallsEffectDeclaration) || ((KtCallsEffectDeclaration)effect).getValueParameterReference().getParameterIndex() < valueParametersCount) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)description.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)"callsInPlace contract cannot be applied to context parameter because context arguments can never be lambdas.", null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkComplexArgumentConditions(CheckerContext context2, DiagnosticReporter reporter, FirResolvedContractDescription description) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = description.getEffects();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtConditionalReturnsDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirEffectDeclaration it = (FirEffectDeclaration)element$iv$iv;
            boolean bl2 = false;
            KtContractDescriptionElement ktContractDescriptionElement = it.getEffect();
            if ((ktContractDescriptionElement instanceof KtConditionalReturnsDeclaration ? (KtConditionalReturnsDeclaration)ktContractDescriptionElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List conditionalReturns = (List)destination$iv$iv;
        for (KtConditionalReturnsDeclaration conditionalReturn : conditionalReturns) {
            if (!FirContractChecker.checkComplexArgumentConditions$containsUnsupportedElements(conditionalReturn.getArgumentsCondition())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)description.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)"Arbitrary expressions are not supported in this contract, only 'null'` and 'is' checks are supported", null, 16, null);
        }
    }

    private final void checkDiagnosticsFromFirBuilder(CheckerContext context2, DiagnosticReporter reporter, ConeDiagnostic diagnostic, KtSourceElement source) {
        if (Intrinsics.areEqual((Object)diagnostic, (Object)ConeContractMayNotHaveLabel.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)ConeContractMayNotHaveLabel.INSTANCE.getReason(), null, 16, null);
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement source, String message2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message2, null, 16, null);
    }

    private static final boolean checkComplexArgumentConditions$containsUnsupportedElements(KtBooleanExpression<ConeKotlinType, ConeDiagnostic> $this$checkComplexArgumentConditions_u24containsUnsupportedElements) {
        KtBooleanExpression<ConeKotlinType, ConeDiagnostic> ktBooleanExpression = $this$checkComplexArgumentConditions_u24containsUnsupportedElements;
        return ktBooleanExpression instanceof KtLogicalNot ? FirContractChecker.checkComplexArgumentConditions$containsUnsupportedElements(((KtLogicalNot)$this$checkComplexArgumentConditions_u24containsUnsupportedElements).getArg()) : ktBooleanExpression instanceof KtBinaryLogicExpression || ktBooleanExpression instanceof KtBooleanValueParameterReference || ktBooleanExpression instanceof KtBooleanConstantReference;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\tj\u0002`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\f\u001a\u0004\u0018\u00010\u00022\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000ej\u0002`\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0017j\u0002`\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001bj\u0002`\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u001d\u001a\u00020\u00022\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020!j\u0002`\"2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010#\u001a\u0004\u0018\u00010\u00022\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020%j\u0002`&2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010'\u001a\u0004\u0018\u00010\u00022\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020)j\u0002`*2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010+\u001a\u00020\u00022\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020,2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010-\u001a\u0004\u0018\u00010\u00022\u0016\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020/j\u0002`02\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00101\u001a\u00020\u00022\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00104\u001a\u00020\u00022\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00107\u001a\u00020\u00022\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002092\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "()V", "visitContractDescriptionElement", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitConditionalReturnsDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalReturnsDeclaration;", "visitHoldsInEffectDeclaration", "holdsInEffect", "Lorg/jetbrains/kotlin/contracts/description/KtHoldsInEffectDeclaration;", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "visitErroneousCallsEffectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitErroneousIsInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitErroneousConstantReference", "erroneousConstantReference", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousConstantReference;", "visitErroneousValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousValueParameterReference;", "visitErroneousElement", "element", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "checkers"})
    private static final class DiagnosticExtractor
    extends KtContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitConditionalReturnsDeclaration(@NotNull KtConditionalReturnsDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getArgumentsCondition().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getReturnsEffect().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitHoldsInEffectDeclaration(@NotNull KtHoldsInEffectDeclaration<ConeKotlinType, ConeDiagnostic> holdsInEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(holdsInEffect, (String)"holdsInEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)holdsInEffect.getArgumentsCondition().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)holdsInEffect.getValueParameterReference().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(returnsEffect, (String)"returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull KtErroneousIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull KtErroneousConstantReference<ConeKotlinType, ConeDiagnostic> erroneousConstantReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(erroneousConstantReference, (String)"erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull KtErroneousValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return element.getDiagnostic();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020 2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010!\u001a\u0004\u0018\u00010\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020#2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitContractDescriptionElement", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "visitConditionalReturnsDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalReturnsDeclaration;", "visitHoldsInEffectDeclaration", "holdsInEffect", "Lorg/jetbrains/kotlin/contracts/description/KtHoldsInEffectDeclaration;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "getParameterType", "index", "", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,427:1\n294#2:428\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker\n*L\n397#1:428\n*E\n"})
    private static final class ErasedCastChecker
    extends KtContractDescriptionVisitor {
        @NotNull
        private final FirFunction declaration;
        @NotNull
        private final CheckerContext context;

        public ErasedCastChecker(@NotNull FirFunction declaration, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.declaration = declaration;
            this.context = context2;
        }

        @NotNull
        public final FirFunction getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            return (ConeDiagnostic)conditionalEffect.getCondition().accept(this, data);
        }

        @Nullable
        public ConeDiagnostic visitConditionalReturnsDeclaration(@NotNull KtConditionalReturnsDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            return (ConeDiagnostic)conditionalEffect.getArgumentsCondition().accept(this, data);
        }

        @Nullable
        public ConeDiagnostic visitHoldsInEffectDeclaration(@NotNull KtHoldsInEffectDeclaration<ConeKotlinType, ConeDiagnostic> holdsInEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(holdsInEffect, (String)"holdsInEffect");
            return (ConeDiagnostic)holdsInEffect.getArgumentsCondition().accept(this, data);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            ConeContractDescriptionError.ErasedIsCheck erasedIsCheck;
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            ConeKotlinType parameterType = this.getParameterType(isInstancePredicate.getArg().getParameterIndex());
            CheckerContext $this$visitIsInstancePredicate_u24lambda_u240 = this.context;
            boolean bl = false;
            boolean $this$ifTrue$iv = FirCastDiagnosticsHelpersKt.isCastErased($this$visitIsInstancePredicate_u24lambda_u240, parameterType, isInstancePredicate.getType());
            boolean $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                boolean bl2 = false;
                erasedIsCheck = ConeContractDescriptionError.ErasedIsCheck.INSTANCE;
            } else {
                erasedIsCheck = null;
            }
            return erasedIsCheck;
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, data);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, data);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, data);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final ConeKotlinType getParameterType(int index) {
            ConeKotlinType coneKotlinType;
            FirCallableSymbol declarationSymbolForReceiverParameter = this.declaration instanceof FirPropertyAccessor ? (FirCallableSymbol)((FirPropertyAccessor)this.declaration).getPropertySymbol() : this.declaration.getSymbol();
            int n = index;
            if (n == -1) {
                coneKotlinType = declarationSymbolForReceiverParameter.getResolvedReceiverType();
                if (coneKotlinType != null) return coneKotlinType;
                ConeSimpleKotlinType coneSimpleKotlinType = this.declaration.getSymbol().getDispatchReceiverType();
                if (coneSimpleKotlinType == null) throw new IllegalStateException("Contract references non-existent receiver".toString());
                coneKotlinType = coneSimpleKotlinType;
                return coneKotlinType;
            }
            coneKotlinType = (0 <= n ? n < ((Collection)this.declaration.getValueParameters()).size() : false) ? FirTypeUtilsKt.getConeType(this.declaration.getValueParameters().get(index).getReturnTypeRef()) : declarationSymbolForReceiverParameter.getContextParameterSymbols().get(index - this.declaration.getValueParameters().size()).getResolvedReturnType();
            return coneKotlinType;
        }
    }
}

