/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "objectRefVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker$Data;", "Data", "checkers"})
public final class FirObjectConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirObjectConstructorChecker INSTANCE = new FirObjectConstructorChecker();
    @NotNull
    private static final FirVisitor<Unit, Data> objectRefVisitor = new FirVisitor<Unit, Data>(){

        public void visitElement(FirElement element, Data data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element.acceptChildren(this, data);
        }

        public void visitThisReceiverExpression(FirThisReceiverExpression thisReceiverExpression, Data data) {
            Intrinsics.checkNotNullParameter((Object)thisReceiverExpression, (String)"thisReceiverExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (Intrinsics.areEqual(thisReceiverExpression.getCalleeReference().getBoundSymbol(), (Object)data.getObjectSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(data.getReporter(), (AbstractKtSourceElement)thisReceiverExpression.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data.getContext(), null, 8, null);
            }
        }

        public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier, Data data) {
            Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (Intrinsics.areEqual(resolvedQualifier.getSymbol(), (Object)data.getObjectSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(data.getReporter(), (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data.getContext(), null, 8, null);
            } else if (resolvedQualifier.getResolvedToCompanionObject()) {
                FirRegularClassSymbol companionSymbol;
                FirRegularClassSymbol firRegularClassSymbol = resolvedQualifier.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol != null && (firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, data.getContext().getSession())) != null ? firRegularClassSymbol.getResolvedCompanionObjectSymbol() : (companionSymbol = null);
                if (Intrinsics.areEqual((Object)companionSymbol, (Object)data.getObjectSymbol())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(data.getReporter(), (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data.getContext(), null, 8, null);
                }
            }
        }

        public void visitAnonymousObjectExpression(FirAnonymousObjectExpression anonymousObjectExpression, Data data) {
            Intrinsics.checkNotNullParameter((Object)anonymousObjectExpression, (String)"anonymousObjectExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        public void visitGetClassCall(FirGetClassCall getClassCall, Data data) {
            Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess, Data data) {
            Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }
    };

    private FirObjectConstructorChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        block2: {
            FirDelegatedConstructorCall firDelegatedConstructorCall;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (declaration.getClassKind() != ClassKind.OBJECT) {
                return;
            }
            FirRegularClassSymbol objectSymbol = declaration.getSymbol();
            FirRegularClassSymbol it = SupertypeUtilsKt.getSuperClassSymbolOrAny(objectSymbol, context2.getSession());
            boolean bl = false;
            if (it == null || !Intrinsics.areEqual((Object)it, ContainingClassUtilsKt.getContainingClassSymbol(objectSymbol))) {
                return;
            }
            FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(objectSymbol, context2.getSession());
            if (firConstructorSymbol == null || (firDelegatedConstructorCall = firConstructorSymbol.getResolvedDelegatedConstructorCall()) == null) break block2;
            firDelegatedConstructorCall.accept(objectRefVisitor, new Data(objectSymbol, context2, reporter));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker$Data;", "", "objectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getObjectSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    private static final class Data {
        @NotNull
        private final FirRegularClassSymbol objectSymbol;
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public Data(@NotNull FirRegularClassSymbol objectSymbol, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)objectSymbol, (String)"objectSymbol");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.objectSymbol = objectSymbol;
            this.context = context2;
            this.reporter = reporter;
        }

        @NotNull
        public final FirRegularClassSymbol getObjectSymbol() {
            return this.objectSymbol;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }
    }
}

