/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirSyntheticFunctionInterfaceProviderBase;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ5\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTooLargeFunctionImportChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "checkAndReportArityOf", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers"})
public final class FirTooLargeFunctionImportChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirTooLargeFunctionImportChecker INSTANCE = new FirTooLargeFunctionImportChecker();

    private FirTooLargeFunctionImportChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        for (FirImport firImport : declaration.getImports()) {
            Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
            if (object == null || (object = ((FirResolvedImport)object).getImportedName()) == null) continue;
            Object name2 = object;
            ClassId classId = new ClassId(((FirResolvedImport)firImport).getPackageFqName(), (Name)name2);
            this.checkAndReportArityOf(context2, reporter, classId, ((FirResolvedImport)firImport).getSource());
        }
    }

    public final void checkAndReportArityOf(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull ClassId classId, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind(classId, context2.getSession());
        if (functionTypeKind == null) {
            return;
        }
        FunctionTypeKind functionKind = functionTypeKind;
        Integer declaredArity = FirSyntheticFunctionInterfaceProviderBase.Companion.getArityIfAllowedOrNull(classId, functionKind);
        if (declaredArity == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getFUNCTION_TYPE_OF_TOO_LARGE_ARITY(), (Object)classId, (Object)functionKind.getMaxArity(), null, 32, null);
        } else if (Intrinsics.areEqual((Object)functionKind, (Object)FunctionTypeKind.KSuspendFunction.INSTANCE) && declaredArity > 21) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getK_SUSPEND_FUNCTION_TYPE_OF_DANGEROUSLY_LARGE_ARITY(), (Object)classId, (Object)21, null, 32, null);
        }
    }
}

