/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCollectionLiteral;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ5\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u0013H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u0010*\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\u0010H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u0010*\u0004\u0018\u00010\u001aH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCollectionLiteralChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;)V", "reportUnsupported", "forceError", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;Z)V", "containingCallKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker$ContainingCallKind;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker$ContainingCallKind;", "isInDefinitelyFailingPosition", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;)Z", "isInsideAnnotationConstructor", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isAnnotationClass", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "ContainingCallKind", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedArrayLiteralChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,119:1\n97#2,3:120\n102#2:124\n97#3:123\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n*L\n111#1:120,3\n111#1:124\n111#1:123\n*E\n"})
public final class FirUnsupportedArrayLiteralChecker
extends FirExpressionChecker<FirCollectionLiteral> {
    @NotNull
    public static final FirUnsupportedArrayLiteralChecker INSTANCE = new FirUnsupportedArrayLiteralChecker();

    private FirUnsupportedArrayLiteralChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCollectionLiteral expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.CollectionLiterals)) {
            return;
        }
        if (this.isInsideAnnotationConstructor(context2)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.containingCallKind(context2).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.reportUnsupported(context2, reporter, expression2, this.isInDefinitelyFailingPosition(context2, expression2));
                break;
            }
            case 3: {
                this.reportUnsupported(context2, reporter, expression2, true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void reportUnsupported(CheckerContext context2, DiagnosticReporter reporter, FirCollectionLiteral expression2, boolean forceError) {
        if (forceError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), (KtDiagnosticFactory0)FirErrors.INSTANCE.getUNSUPPORTED_ARRAY_LITERAL_OUTSIDE_OF_ANNOTATION().getErrorFactory(), null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_ARRAY_LITERAL_OUTSIDE_OF_ANNOTATION(), null, 8, null);
        }
    }

    private final ContainingCallKind containingCallKind(CheckerContext context2) {
        ContainingCallKind functionCallFound = ContainingCallKind.NotFound;
        for (FirStatement call : CollectionsKt.asReversed(context2.getCallsOrAssignments())) {
            FirStatement firStatement = call;
            if (firStatement instanceof FirAnnotationCall) {
                return ContainingCallKind.Annotation;
            }
            if (!(firStatement instanceof FirFunctionCall) || !this.isAnnotationClass(context2, FirTypeUtilsKt.getResolvedType((FirExpression)call))) continue;
            functionCallFound = ContainingCallKind.FunctionReturningAnnotation;
        }
        return functionCallFound;
    }

    private final boolean isInDefinitelyFailingPosition(CheckerContext context2, FirCollectionLiteral $this$isInDefinitelyFailingPosition) {
        FirElement firElement = FirHelpersKt.getSecondToLastContainer(context2);
        FirBlock firBlock = firElement instanceof FirBlock ? (FirBlock)firElement : null;
        if (firBlock == null) {
            return false;
        }
        FirBlock containingBlock = firBlock;
        return FirHelpersKt.nthLastContainer(context2, 3) instanceof FirAnonymousFunction ? containingBlock.isUnitCoerced() || UtilsKt.getLastExpression(containingBlock) != $this$isInDefinitelyFailingPosition : !(containingBlock instanceof FirSingleExpressionBlock);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInsideAnnotationConstructor(CheckerContext context2) {
        FirBasedSymbol firBasedSymbol;
        FirUnsupportedArrayLiteralChecker firUnsupportedArrayLiteralChecker;
        CheckerContext checkerContext;
        block3: {
            void $this$findClosest_u24default$iv;
            CheckerContext checkerContext2 = context2;
            checkerContext = context2;
            firUnsupportedArrayLiteralChecker = this;
            boolean $i$f$findClosest = false;
            for (FirBasedSymbol it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirBasedSymbol firBasedSymbol2;
                FirBasedSymbol firBasedSymbol3 = it$iv;
                if (!(firBasedSymbol3 instanceof FirConstructorSymbol)) {
                    firBasedSymbol3 = null;
                }
                if ((firBasedSymbol = (FirBasedSymbol)((FirConstructorSymbol)firBasedSymbol3)) == null) continue;
                FirBasedSymbol firBasedSymbol4 = firBasedSymbol2 = firBasedSymbol;
                boolean bl = false;
                FirBasedSymbol it = firBasedSymbol4;
                firBasedSymbol = true ? firBasedSymbol2 : null;
                if (firBasedSymbol == null) {
                    continue;
                }
                break block3;
            }
            firBasedSymbol = null;
        }
        FirBasedSymbol firBasedSymbol5 = firBasedSymbol;
        FirConstructorSymbol firConstructorSymbol = (FirConstructorSymbol)firBasedSymbol5;
        return firUnsupportedArrayLiteralChecker.isAnnotationClass(checkerContext, firConstructorSymbol != null ? firConstructorSymbol.getResolvedReturnType() : null);
    }

    private final boolean isAnnotationClass(CheckerContext context2, ConeKotlinType $this$isAnnotationClass) {
        FirRegularClassSymbol firRegularClassSymbol;
        return ($this$isAnnotationClass != null && (firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, $this$isAnnotationClass)) != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker$ContainingCallKind;", "", "<init>", "(Ljava/lang/String;I)V", "NotFound", "FunctionReturningAnnotation", "Annotation", "checkers"})
    private static final class ContainingCallKind
    extends Enum<ContainingCallKind> {
        public static final /* enum */ ContainingCallKind NotFound = new ContainingCallKind();
        public static final /* enum */ ContainingCallKind FunctionReturningAnnotation = new ContainingCallKind();
        public static final /* enum */ ContainingCallKind Annotation = new ContainingCallKind();
        private static final /* synthetic */ ContainingCallKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ContainingCallKind[] values() {
            return (ContainingCallKind[])$VALUES.clone();
        }

        public static ContainingCallKind valueOf(String value2) {
            return Enum.valueOf(ContainingCallKind.class, value2);
        }

        @NotNull
        public static EnumEntries<ContainingCallKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = containingCallKindArray = new ContainingCallKind[]{ContainingCallKind.NotFound, ContainingCallKind.FunctionReturningAnnotation, ContainingCallKind.Annotation};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContainingCallKind.values().length];
            try {
                nArray[ContainingCallKind.Annotation.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainingCallKind.FunctionReturningAnnotation.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainingCallKind.NotFound.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

