/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirFunctionalTypeParameterSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002R\u00020\bR\u00020\u0006j\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002R\u00020\bR\u00020\u0006j\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002R\u00020\bR\u00020\u0006j\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirFunctionalTypeParameterSyntaxChecker;", "<init>", "()V", "checkPsiOrLightTree", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "element", "Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkValOrVarKeyword", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkModifiers", "", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkAnnotations", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedModifiersInFunctionTypeParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n986#2,4:89\n992#2,6:93\n992#2,6:105\n777#3:99\n873#3,2:100\n1586#3:102\n1661#3,2:103\n1663#3:111\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n*L\n38#1:89,4\n41#1:93,6\n72#1:105,6\n72#1:99\n72#1:100,2\n72#1:102\n72#1:103,2\n72#1:111\n*E\n"})
public final class FirUnsupportedModifiersInFunctionTypeParameterChecker
extends FirFunctionalTypeParameterSyntaxChecker {
    @NotNull
    public static final FirUnsupportedModifiersInFunctionTypeParameterChecker INSTANCE = new FirUnsupportedModifiersInFunctionTypeParameterChecker();

    private FirUnsupportedModifiersInFunctionTypeParameterChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionTypeParameter element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.checkModifiers(reporter, context2, source);
        this.checkAnnotations(reporter, context2, source);
        this.checkValOrVarKeyword(reporter, context2, source);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkValOrVarKeyword(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source) {
        KtSourceElement ktSourceElement;
        KtSourceElement ktSourceElement2 = source;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement psiElement = ((KtPsiSourceElement)source).getPsi();
            PsiElement psiElement2 = psiElement instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement : null;
            if (psiElement2 != null && (psiElement2 = psiElement2.getValOrVarKeyword()) != null) {
                PsiElement psiElement3 = psiElement2;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement(psiElement3);
                } else {
                    if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement = new KtFakePsiSourceElement(psiElement3, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement = null;
            }
            ktSourceElement = ktPsiSourceElement;
        } else {
            KtLightSourceElement ktLightSourceElement;
            if (!(ktSourceElement2 instanceof KtLightSourceElement)) throw new NoWhenBranchMatchedException();
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword(((KtLightSourceElement)source).getTreeStructure(), ((KtLightSourceElement)source).getLighterASTNode());
            if (lighterASTNode != null) {
                void $this$toKtLightSourceElement_u24default$iv;
                LighterASTNode lighterASTNode2 = lighterASTNode;
                FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = ((KtLightSourceElement)source).getTreeStructure();
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, flyweightCapableTreeStructure, kind$iv);
            } else {
                ktLightSourceElement = null;
            }
            ktSourceElement = ktLightSourceElement;
        }
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement keyword = ktSourceElement;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)keyword, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Function type parameters cannot be 'val' or 'var'.", null, 16, null);
    }

    private final boolean checkModifiers(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList modifiersList = firModifierList;
        for (FirModifier<?> modifier : modifiersList.getModifiers()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Function type parameters cannot have modifiers.", null, 16, null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkAnnotations(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source) {
        List list;
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList commonModifiersList = firModifierList;
        FirModifierList firModifierList2 = commonModifiersList;
        if (firModifierList2 instanceof FirModifierList.FirLightModifierList) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LighterASTNode it;
            void $this$filterTo$iv$iv;
            FlyweightCapableTreeStructure<LighterASTNode> tree = ((FirModifierList.FirLightModifierList)commonModifiersList).getTree();
            List<LighterASTNode> children = LightTreeUtilsKt.getChildren(((FirModifierList.FirLightModifierList)commonModifiersList).getModifierList(), tree);
            Iterable $this$filter$iv = children;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.ANNOTATION_ENTRY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$toKtLightSourceElement_u24default$iv;
                it = (LighterASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LighterASTNode lighterASTNode = it;
                FlyweightCapableTreeStructure<LighterASTNode> tree$iv = tree;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                collection.add(new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv));
            }
            list = (List)destination$iv$iv;
        } else if (firModifierList2 instanceof FirModifierList.FirPsiModifierList) {
            ASTNode aSTNode = ((FirModifierList.FirPsiModifierList)commonModifiersList).getModifierList().getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            Sequence<ASTNode> children = PsiUtilsKt.children(aSTNode);
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(children, FirUnsupportedModifiersInFunctionTypeParameterChecker::checkAnnotations$lambda$2), FirUnsupportedModifiersInFunctionTypeParameterChecker::checkAnnotations$lambda$3));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List annotationsSource = list;
        for (KtSourceElement ann : annotationsSource) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)ann, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Function type parameters cannot have annotations.", null, 16, null);
        }
        return false;
    }

    private static final boolean checkAnnotations$lambda$2(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)KtNodeTypes.ANNOTATION_ENTRY);
    }

    private static final KtRealPsiSourceElement checkAnnotations$lambda$3(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        return new KtRealPsiSourceElement(psiElement);
    }
}

