/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeContextParameterWithDefaultValue;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirErrorSuperReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0010H\u0002J\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\rH\u0002J\u000e\u0010+\u001a\u00020\u0012*\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00102\u001a\u00020\t2\u0006\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00105\u001a\u00020\t2\u0006\u00106\u001a\u0002072\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u00108\u001a\u00020\u0012*\u000209H\u0002J\u0018\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020<2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020?2\u0006\u0010\f\u001a\u00020\rH\u0016J:\u0010@\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010*\u001a\u00020\r2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010B2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010EH\u0002\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitErrorLoop", "", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "isLambdaReturnTypeRefThatDoesntNeedReporting", "", "hasExpandedTypeAliasDeclarationSiteError", "hasDiagnostic", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitErrorAnnotationCall", "errorAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitResolvedErrorReference", "resolvedErrorReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedErrorReference;", "visitErrorSuperReference", "errorSuperReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorSuperReference;", "processErrorReference", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "context", "cannotBeResolved", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorProperty", "errorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorProperty;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "hasErrorOrParentWithError", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "visitThisReference", "thisReference", "Lorg/jetbrains/kotlin/fir/references/FirThisReference;", "reportFirDiagnostic", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "callOrAssignmentSource", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Companion", "checkers"})
@SourceDebugExtension(value={"SMAP\nErrorNodeDiagnosticCollectorComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorNodeDiagnosticCollectorComponent.kt\norg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1807#2,3:243\n1807#2,3:246\n1#3:249\n*S KotlinDebug\n*F\n+ 1 ErrorNodeDiagnosticCollectorComponent.kt\norg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent\n*L\n59#1:243,3\n60#1:246,3\n*E\n"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        super(session, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorLoop, (String)"errorLoop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorLoop.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, data, null, null, 24, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.isLambdaReturnTypeRefThatDoesntNeedReporting(errorTypeRef, data)) {
            return;
        }
        if (this.hasExpandedTypeAliasDeclarationSiteError(errorTypeRef)) {
            return;
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), errorTypeRef.getSource(), data, null, (object = CollectionsKt.getOrNull(data.getContainingElements(), (int)(CollectionsKt.getLastIndex(data.getContainingElements()) - 1))) instanceof FirValueParameter ? (FirValueParameter)object : null, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLambdaReturnTypeRefThatDoesntNeedReporting(FirErrorTypeRef $this$isLambdaReturnTypeRefThatDoesntNeedReporting, CheckerContext data) {
        boolean bl;
        boolean bl2;
        KtSourceElement ktSourceElement = $this$isLambdaReturnTypeRefThatDoesntNeedReporting.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitFunctionReturnType.INSTANCE)) {
            return false;
        }
        FirBasedSymbol containingDeclaration = (FirBasedSymbol)CollectionsKt.lastOrNull(data.getContainingDeclarations());
        if (!(containingDeclaration instanceof FirAnonymousFunctionSymbol)) return false;
        if (!Intrinsics.areEqual((Object)((FirAnonymousFunctionSymbol)containingDeclaration).getResolvedReturnTypeRef(), (Object)$this$isLambdaReturnTypeRefThatDoesntNeedReporting)) {
            return false;
        }
        Iterable $this$any$iv = FirHelpersKt.getReturnedExpressions((FirAnonymousFunctionSymbol)containingDeclaration);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FirExpression firExpression = (FirExpression)element$iv;
                boolean bl3 = false;
                if (!this.hasDiagnostic(firExpression, $this$isLambdaReturnTypeRefThatDoesntNeedReporting.getDiagnostic())) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = data.getCallsOrAssignments();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            FirStatement firStatement = (FirStatement)element$iv;
            boolean bl4 = false;
            if (firStatement instanceof FirExpression && this.hasDiagnostic((FirExpression)firStatement, $this$isLambdaReturnTypeRefThatDoesntNeedReporting.getDiagnostic())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean hasExpandedTypeAliasDeclarationSiteError(FirErrorTypeRef $this$hasExpandedTypeAliasDeclarationSiteError) {
        ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible($this$hasExpandedTypeAliasDeclarationSiteError.getConeType());
        ConeErrorType coneErrorType = coneRigidType instanceof ConeErrorType ? (ConeErrorType)coneRigidType : null;
        if (coneErrorType == null) {
            return false;
        }
        ConeErrorType lowerBound = coneErrorType;
        if (!Intrinsics.areEqual((Object)lowerBound.getDiagnostic(), (Object)$this$hasExpandedTypeAliasDeclarationSiteError.getDiagnostic())) {
            return false;
        }
        return AbbreviatedTypeAttributeKt.getAbbreviatedType(lowerBound) != null;
    }

    private final boolean hasDiagnostic(FirExpression $this$hasDiagnostic, ConeDiagnostic diagnostic) {
        Object object = FirTypeUtilsKt.getResolvedType($this$hasDiagnostic);
        ConeErrorType coneErrorType = object instanceof ConeErrorType ? (ConeErrorType)object : null;
        if (Intrinsics.areEqual((Object)(coneErrorType != null ? coneErrorType.getDiagnostic() : null), (Object)diagnostic)) {
            return true;
        }
        object = ReferenceUtilsKt.toReference($this$hasDiagnostic, this.getSession());
        FirDiagnosticHolder firDiagnosticHolder = object instanceof FirDiagnosticHolder ? (FirDiagnosticHolder)object : null;
        return Intrinsics.areEqual((Object)(firDiagnosticHolder != null ? firDiagnosticHolder.getDiagnostic() : null), (Object)diagnostic);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean bl2 = bl = !(resolvedTypeRef.getConeType() instanceof ConeErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Instead use FirErrorTypeRef for " + ConeTypeUtilsKt.renderForDebugging(resolvedTypeRef.getConeType());
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public void visitErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorAnnotationCall, (String)"errorAnnotationCall");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorAnnotationCall.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorAnnotationCall.getDiagnostic(), source, data, null, null, 24, null);
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorNamedReference, (String)"errorNamedReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.processErrorReference(errorNamedReference, errorNamedReference.getDiagnostic(), data);
    }

    @Override
    public void visitResolvedErrorReference(@NotNull FirResolvedErrorReference resolvedErrorReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)resolvedErrorReference, (String)"resolvedErrorReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.processErrorReference(resolvedErrorReference, resolvedErrorReference.getDiagnostic(), data);
    }

    @Override
    public void visitErrorSuperReference(@NotNull FirErrorSuperReference errorSuperReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorSuperReference, (String)"errorSuperReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.processErrorReference(errorSuperReference, errorSuperReference.getDiagnostic(), data);
    }

    private final void processErrorReference(FirReference reference2, ConeDiagnostic diagnostic, CheckerContext context2) {
        FirStatement firStatement;
        KtSourceElement source = null;
        source = reference2.getSource();
        FirStatement firStatement2 = (FirStatement)CollectionsKt.lastOrNull(context2.getCallsOrAssignments());
        if (firStatement2 != null) {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            firStatement = Intrinsics.areEqual((Object)ReferenceUtilsKt.toReference(it, this.getSession()), (Object)reference2) ? firStatement3 : null;
        } else {
            firStatement = null;
        }
        FirStatement callOrAssignment = firStatement;
        KtSourceElement ktSourceElement = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.ANNOTATION_ENTRY) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        KtSourceElement ktSourceElement2 = source;
        if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        if (callOrAssignment instanceof FirQualifiedAccessExpression && (this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExplicitReceiver()))) {
            return;
        }
        CheckerContext $this$processErrorReference_u24lambda_u241 = context2;
        boolean bl = false;
        KtSourceElement ktSourceElement3 = source;
        source = ktSourceElement3 != null ? SourceHelpersKt.delegatedPropertySourceOrThis($this$processErrorReference_u24lambda_u241, ktSourceElement3) : null;
        FirStatement firStatement4 = callOrAssignment;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, context2, firStatement4 != null ? firStatement4.getSource() : null, null, 16, null);
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        ConeDiagnostic diagnostic;
        Object object = $this$cannotBeResolved;
        ConeRigidType coneRigidType = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)object) : null;
        ConeErrorType coneErrorType = coneRigidType instanceof ConeErrorType ? (ConeErrorType)coneRigidType : null;
        ConeDiagnostic coneDiagnostic = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        return diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeInstanceAccessBeforeSuperCall || diagnostic instanceof ConeAmbiguousSuper ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.AmbiguousLabel : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ConeDiagnostic diagnostic = errorExpression.getDiagnostic();
        if (diagnostic instanceof ConeSyntaxDiagnostic) {
            return;
        }
        if (Intrinsics.areEqual((Object)diagnostic, (Object)ConeContextParameterWithDefaultValue.INSTANCE)) {
            List<FirBasedSymbol<?>> it = data.getContainingDeclarations();
            boolean bl = false;
            if (FirHelpersKt.isPrimaryConstructor((FirBasedSymbol)CollectionsKt.getOrNull(it, (int)(CollectionsKt.getLastIndex(it) - 1)))) {
                return;
            }
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, errorExpression.getSource(), data, null, null, 24, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorFunction, (String)"errorFunction");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorFunction.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, data, null, null, 24, null);
    }

    @Override
    public void visitErrorProperty(@NotNull FirErrorProperty errorProperty, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorProperty, (String)"errorProperty");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtSourceElement source = errorProperty.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorProperty.getDiagnostic(), source, data, null, null, 24, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirResolvedQualifier firResolvedQualifier = errorResolvedQualifier.getExplicitParent();
        boolean bl = firResolvedQualifier != null ? this.hasErrorOrParentWithError(firResolvedQualifier) : false;
        if (bl) {
            return;
        }
        KtSourceElement source = errorResolvedQualifier.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, data, null, null, 24, null);
    }

    private final boolean hasErrorOrParentWithError(FirResolvedQualifier $this$hasErrorOrParentWithError) {
        if ($this$hasErrorOrParentWithError instanceof FirErrorResolvedQualifier) {
            return true;
        }
        FirResolvedQualifier firResolvedQualifier = $this$hasErrorOrParentWithError.getExplicitParent();
        return firResolvedQualifier != null ? this.hasErrorOrParentWithError(firResolvedQualifier) : false;
    }

    @Override
    public void visitErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)errorPrimaryConstructor, (String)"errorPrimaryConstructor");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorPrimaryConstructor.getDiagnostic(), errorPrimaryConstructor.getSource(), data, null, null, 24, null);
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)thisReference, (String)"thisReference");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ConeDiagnostic coneDiagnostic = thisReference.getDiagnostic();
        if (coneDiagnostic == null) {
            return;
        }
        ConeDiagnostic diagnostic = coneDiagnostic;
        KtSourceElement ktSourceElement = thisReference.getSource();
        if (ktSourceElement == null) {
            FirElement firElement = (FirElement)CollectionsKt.getOrNull(data.getContainingElements(), (int)1);
            ktSourceElement = firElement != null ? firElement.getSource() : null;
        }
        KtSourceElement source = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data, null, null, 24, null);
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, KtSourceElement source, CheckerContext context2, KtSourceElement callOrAssignmentSource, FirValueParameter valueParameter2) {
        Companion.reportFirDiagnostic$checkers(diagnostic, source, context2, this.getSession(), this.getReporter(), callOrAssignmentSource, valueParameter2);
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtSourceElement ktSourceElement2, FirValueParameter firValueParameter, int n, Object object) {
        if ((n & 8) != 0) {
            ktSourceElement2 = null;
        }
        if ((n & 0x10) != 0) {
            firValueParameter = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, ktSourceElement, checkerContext, ktSourceElement2, firValueParameter);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JQ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent$Companion;", "", "<init>", "()V", "reportFirDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "callOrAssignmentSource", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "reportFirDiagnostic$checkers", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        public final void reportFirDiagnostic$checkers(@NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull CheckerContext context2, @NotNull FirSession session, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement callOrAssignmentSource, @Nullable FirValueParameter valueParameter2) {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    KtSourceElement ktSourceElement = source;
                    if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) && !Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.DesugaredNameBasedDestructuring.INSTANCE)) {
                        return;
                    }
                    KtSourceElement ktSourceElement2 = source;
                    if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableWrongReceiver || diagnostic instanceof ConeInapplicableCandidateError)) {
                        return;
                    }
                    KtSourceElement ktSourceElement3 = source;
                    if (Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) break block8;
                    KtSourceElement ktSourceElement4 = source;
                    if (!Intrinsics.areEqual((Object)(ktSourceElement4 != null ? ktSourceElement4.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) break block9;
                }
                return;
            }
            KtSourceElement ktSourceElement = source;
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredPrefixSecondGetReference) {
                return;
            }
            KtSourceElement ktSourceElement5 = source;
            if ((ktSourceElement5 != null ? ktSourceElement5.getKind() : null) instanceof KtFakeSourceElementKind.UnresolvedWhenConditionSubject) {
                return;
            }
            for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, session, source, callOrAssignmentSource, valueParameter2)) {
                reporter.report(coneDiagnostic, context2);
            }
        }

        public static /* synthetic */ void reportFirDiagnostic$checkers$default(Companion companion, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, FirSession firSession, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement2, FirValueParameter firValueParameter, int n, Object object) {
            if ((n & 8) != 0) {
                firSession = checkerContext.getSession();
            }
            if ((n & 0x20) != 0) {
                ktSourceElement2 = null;
            }
            if ((n & 0x40) != 0) {
                firValueParameter = null;
            }
            companion.reportFirDiagnostic$checkers(coneDiagnostic, ktSourceElement, checkerContext, firSession, diagnosticReporter, ktSourceElement2, firValueParameter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

