/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.backend.common.IrSpecialAnnotationsProvider;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltinSymbolsContainer;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrImplicitCastInserter;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrDataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.utils.ConversionTypeOrigin;
import org.jetbrains.kotlin.fir.backend.utils.IrElementsCreationUtilsKt;
import org.jetbrains.kotlin.fir.backend.utils.OffsetUtilsKt;
import org.jetbrains.kotlin.fir.backend.utils.VariousUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSamConversionExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.stages.FirFakeArgumentForCallableReference;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.IrProvider;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J/\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\nH\u0002JD\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J0\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u001c\u00100\u001a\u000201*\u0002022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002JD\u00103\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J\u0019\u00105\u001a\u00020\u0016*\u00020\u00162\u0006\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\b8J(\u00109\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020\nH\u0002J\u0016\u0010>\u001a\u0004\u0018\u00010;*\u00020;2\u0006\u0010?\u001a\u00020@H\u0002J\u000e\u0010>\u001a\u0004\u0018\u00010A*\u00020AH\u0002J\u001a\u0010B\u001a\u00020;*\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J\u0017\u0010G\u001a\u0004\u0018\u00010;2\u0006\u0010H\u001a\u00020;H\u0000\u00a2\u0006\u0002\bIJ!\u0010J\u001a\u00020\u0016*\u00020\u00162\u0006\u00106\u001a\u0002072\u0006\u0010K\u001a\u00020;H\u0000\u00a2\u0006\u0002\bLJ\u001a\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020;H\u0002J8\u0010R\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010S\u001a\u00020+2\u0006\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020NH\u0002J(\u0010V\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010U\u001a\u00020NH\u0002J\"\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\f2\n\u0010Y\u001a\u0006\u0012\u0002\b\u00030Z2\u0006\u0010[\u001a\u00020+J\u0014\u0010\\\u001a\u00020+*\u00020\u000e2\u0006\u0010]\u001a\u00020 H\u0002J,\u0010^\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\n\u0010Y\u001a\u0006\u0012\u0002\b\u00030Z2\u0006\u0010[\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010_\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR\u0012\u0010b\u001a\u00020cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u0012\u0010f\u001a\u00020gX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bh\u0010iR\u0012\u0010j\u001a\u00020kX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR\u0012\u0010n\u001a\u00020oX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u0012\u0010r\u001a\u00020sX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bt\u0010uR\u0012\u0010v\u001a\u00020wX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bx\u0010yR\u0012\u0010z\u001a\u00020{X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b|\u0010}R\u0014\u0010~\u001a\u00020\u007fX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0016\u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0016\u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R\u0016\u0010\u008a\u0001\u001a\u00030\u008b\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001R\u0016\u0010\u008e\u0001\u001a\u00030\u008f\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001R\u001e\u0010\u0092\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u0093\u0001\u0018\u00010EX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0016\u0010\u0096\u0001\u001a\u00030\u0097\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u0099\u0001R\u0016\u0010\u009a\u0001\u001a\u00030\u009b\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009c\u0001\u0010\u009d\u0001R\u0016\u0010\u009e\u0001\u001a\u00030\u009f\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a0\u0001\u0010\u00a1\u0001R\u001d\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a4\u00010\u00a3\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a5\u0001\u0010\u00a6\u0001R\u0016\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a9\u0001\u0010\u00aa\u0001R\u0016\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00ad\u0001\u0010\u00ae\u0001R\u0016\u0010\u00af\u0001\u001a\u00030\u00b0\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b1\u0001\u0010\u00b2\u0001R\u0016\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b5\u0001\u0010\u00b6\u0001R\u0016\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b9\u0001\u0010\u00ba\u0001R\u0018\u0010\u00bb\u0001\u001a\u0005\u0018\u00010\u00bc\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00bd\u0001\u0010\u00be\u0001R\u0016\u0010\u00bf\u0001\u001a\u00030\u00c0\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c1\u0001\u0010\u00c2\u0001R\u0016\u0010\u00c3\u0001\u001a\u00030\u00c4\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c5\u0001\u0010\u00c6\u0001R\u0016\u0010\u00c7\u0001\u001a\u00030\u00c8\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c9\u0001\u0010\u00ca\u0001\u00a8\u0006\u00cb\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "c", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "samResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "needToGenerateAdaptedCallableReference", "", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "type", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "needToGenerateAdaptedCallableReference$fir2ir", "needSuspendConversion", "needCoercionToUnit", "hasVarargOrDefaultArguments", "generateAdaptedCallableReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "explicitReceiverExpression", "adapteeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "generateAdaptedCallableReference$fir2ir", "findBoundReceiver", "isDispatch", "createAdapterFunctionForCallableReference", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "startOffset", "", "endOffset", "firAdaptee", "boundDispatchReceiver", "boundExtensionReceiver", "createAdapterParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "adapterFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "kind", "Lorg/jetbrains/kotlin/ir/declarations/IrParameterKind;", "toIrGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createAdapteeCallForCallableReference", "adaptedType", "applySamConversionIfNeeded", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "applySamConversionIfNeeded$fir2ir", "castArgumentToFunctionalInterfaceForSamType", "argumentConeType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "samType", "usesFunctionalTypeConversion", "removeExternalProjections", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "Lorg/jetbrains/kotlin/fir/types/ConeRigidType;", "starProjectionTypeRepresentation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "containingParameterSet", "", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "getFunctionTypeForPossibleSamType", "parameterType", "getFunctionTypeForPossibleSamType$fir2ir", "applySuspendConversionIfNeeded", "expectedType", "applySuspendConversionIfNeeded$fir2ir", "findInvokeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "expectedFunctionalType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "argumentType", "createAdapterFunctionForArgument", "adapterParameterType", "argumentIsNullable", "invokeSymbol", "createAdapteeCallForArgument", "generateFunInterfaceConstructorReference", "callableReference", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "irReferenceType", "getArgumentTypeAt", "index", "generateFunInterfaceConstructorAdapter", "adapterGenerator", "getAdapterGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtins", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "getBuiltins", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "dataClassMembersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "getDataClassMembersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "filesBeingCompiled", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesBeingCompiled", "()Ljava/util/Set;", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "getFirProvider", "()Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "implicitCastInserter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrImplicitCastInserter;", "getImplicitCastInserter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrImplicitCastInserter;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "getIrMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lazyFakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "getLazyFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "specialAnnotationsProvider", "Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "getSpecialAnnotationsProvider", "()Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "getSymbolsMappingForLazyClasses", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nAdapterGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdapterGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TypeUtils.kt\norg/jetbrains/kotlin/fir/types/TypeUtilsKt\n+ 7 ConeTypes.kt\norg/jetbrains/kotlin/fir/types/ConeTypesKt\n+ 8 OffsetUtils.kt\norg/jetbrains/kotlin/fir/backend/utils/OffsetUtilsKt\n+ 9 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,800:1\n54#2:801\n41#2:809\n54#2:810\n39#2:811\n40#2:812\n37#2:889\n193#3,3:802\n1586#4:805\n1661#4,3:806\n1629#4,4:813\n1586#4:876\n1661#4,3:877\n1629#4,4:880\n1586#4:884\n1661#4,3:885\n1924#4,3:890\n1#5:817\n1#5:826\n317#6,8:818\n325#6,24:827\n74#7:851\n44#8,7:852\n85#8,17:859\n53#9:888\n*S KotlinDebug\n*F\n+ 1 AdapterGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator\n*L\n90#1:801\n209#1:809\n215#1:810\n216#1:811\n217#1:812\n318#1:889\n120#1:802,3\n197#1:805\n197#1:806,3\n236#1:813,4\n621#1:876\n621#1:877,3\n648#1:880,4\n153#1:884\n153#1:885,3\n337#1:890,3\n473#1:826\n473#1:818,8\n473#1:827,24\n495#1:851\n570#1:852,7\n570#1:859,17\n317#1:888\n*E\n"})
public final class AdapterGenerator
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents c;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final FirSamResolver samResolver;

    public AdapterGenerator(@NotNull Fir2IrComponents c, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.c = c;
        this.conversionScope = conversionScope;
        this.samResolver = new FirSamResolver(this.getSession(), this.getScopeSession(), null, 4, null);
    }

    public final boolean needToGenerateAdaptedCallableReference$fir2ir(@NotNull FirCallableReferenceAccess callableReferenceAccess, @NotNull IrSimpleType type, @NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.needSuspendConversion(type, function2) || this.needCoercionToUnit(type, function2) || this.hasVarargOrDefaultArguments(callableReferenceAccess);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needSuspendConversion(IrSimpleType type, FirFunction function2) {
        if (!IrTypeUtilsKt.isSuspendFunction(type)) return false;
        FirMemberDeclaration $this$isSuspend$iv = function2;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) return false;
        return true;
    }

    private final boolean needCoercionToUnit(IrSimpleType type, FirFunction function2) {
        IrType expectedReturnType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.last(type.getArguments()));
        ConeKotlinType actualReturnType = FirTypeUtilsKt.getConeType(function2.getReturnTypeRef());
        IrType irType = expectedReturnType;
        return (irType != null ? IrTypePredicatesKt.isUnit(irType) : false) && !ConeBuiltinTypeUtilsKt.isUnit(actualReturnType) && !(ToSymbolUtilsKt.toSymbol((SessionHolder)this, actualReturnType) instanceof FirTypeParameterSymbol);
    }

    private final boolean hasVarargOrDefaultArguments(FirCallableReferenceAccess callableReferenceAccess) {
        boolean bl;
        block4: {
            FirNamedReference firNamedReference = callableReferenceAccess.getCalleeReference();
            FirResolvedCallableReference firResolvedCallableReference = firNamedReference instanceof FirResolvedCallableReference ? (FirResolvedCallableReference)firNamedReference : null;
            if (firResolvedCallableReference == null) {
                return false;
            }
            FirResolvedCallableReference calleeReference = firResolvedCallableReference;
            Map<FirValueParameter, ResolvedCallArgument<FirExpression>> $this$any$iv = calleeReference.getMappedArguments();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<FirValueParameter, ResolvedCallArgument<FirExpression>>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<FirValueParameter, ResolvedCallArgument<FirExpression>> element$iv;
                    Map.Entry<FirValueParameter, ResolvedCallArgument<FirExpression>> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    ResolvedCallArgument<FirExpression> value2 = entry.getValue();
                    if (!(value2 instanceof ResolvedCallArgument.VarargArgument || value2 instanceof ResolvedCallArgument.DefaultArgument)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final IrExpression generateAdaptedCallableReference$fir2ir(@NotNull FirCallableReferenceAccess callableReferenceAccess, @Nullable IrExpression explicitReceiverExpression, @NotNull IrFunctionSymbol adapteeSymbol, @NotNull IrSimpleType type) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
        Intrinsics.checkNotNullParameter((Object)adapteeSymbol, (String)"adapteeSymbol");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = ReferenceUtilsKt.toResolvedCallableReference(callableReferenceAccess);
        Object var6_5 = object != null && (object = ((FirResolvedNamedReference)object).getResolvedSymbol()) != null ? ((FirBasedSymbol)object).getFir() : null;
        FirFunction firAdaptee = var6_5 instanceof FirFunction ? (FirFunction)var6_5 : null;
        IrType expectedReturnType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.last(type.getArguments()));
        return (IrExpression)OffsetUtilsKt.convertWithOffsets(callableReferenceAccess, (arg_0, arg_1) -> AdapterGenerator.generateAdaptedCallableReference$lambda$0(this, callableReferenceAccess, explicitReceiverExpression, firAdaptee, type, adapteeSymbol, expectedReturnType, arg_0, arg_1));
    }

    private final IrExpression findBoundReceiver(FirCallableReferenceAccess $this$findBoundReceiver, IrExpression explicitReceiverExpression, boolean isDispatch) {
        FirExpression firReceiver;
        FirExpression firExpression = firReceiver = isDispatch ? $this$findBoundReceiver.getDispatchReceiver() : $this$findBoundReceiver.getExtensionReceiver();
        if (firReceiver == null) {
            return null;
        }
        CallAndReferenceGenerator $this$findBoundReceiver_u24lambda_u240 = this.getCallGenerator();
        boolean bl = false;
        return $this$findBoundReceiver_u24lambda_u240.findIrReceiver$fir2ir($this$findBoundReceiver, explicitReceiverExpression, isDispatch);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createAdapterFunctionForCallableReference(FirCallableReferenceAccess callableReferenceAccess, int startOffset, int endOffset, FirFunction firAdaptee, IrSimpleType type, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        void $this$mapIndexedTo$iv;
        Iterable iterable;
        void $this$createAdapterFunctionForCallableReference_u24lambda_u241_u240;
        IrExpression boundReceiver;
        Object object;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.last(type.getArguments()));
        Intrinsics.checkNotNull((Object)irType);
        IrType returnType = irType;
        Iterable $this$map$iv = CollectionsKt.dropLast(type.getArguments(), (int)1);
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            object = (IrTypeArgument)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
            Intrinsics.checkNotNull((Object)irType2);
            collection.add(irType2);
        }
        List parameterTypes = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)firAdaptee, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration firMemberAdaptee = firAdaptee;
        Name name2 = firAdaptee instanceof FirConstructor ? SpecialNames.INIT : ((FirFunctionSymbol)firAdaptee.getSymbol()).getName();
        IrFactory irFactory = IrFactoryImpl.INSTANCE;
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE();
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        FirMemberDeclaration $this$isInline$iv = firMemberAdaptee;
        boolean $i$f$isInline = false;
        FirMemberDeclaration $this$isSuspend$iv = firMemberAdaptee;
        boolean $i$f$isSuspend = false;
        FirMemberDeclaration $this$isOperator$iv = firMemberAdaptee;
        boolean $i$f$isOperator = false;
        FirMemberDeclaration $this$isInfix$iv = firMemberAdaptee;
        boolean $i$f$isInfix = false;
        Object irAdapterFunction = object2 = IrFactory.createSimpleFunction$default(irFactory, startOffset, endOffset, irDeclarationOrigin, name2, descriptorVisibility, $this$isInline$iv.getStatus().isInline(), false, returnType, Modality.FINAL, new IrSimpleFunctionSymbolImpl(null, null, 3, null), false, $this$isSuspend$iv.getStatus().isSuspend() || IrTypeUtilsKt.isSuspendFunction(type), $this$isOperator$iv.getStatus().isOperator(), $this$isInfix$iv.getStatus().isInfix(), false, null, false, 98304, null);
        boolean bl = false;
        List list = CollectionsKt.createListBuilder();
        item$iv$iv2 = list;
        object = irAdapterFunction;
        boolean bl2 = false;
        IrExpression irExpression = boundDispatchReceiver;
        if (irExpression == null) {
            irExpression = boundExtensionReceiver;
        }
        if ((boundReceiver = irExpression) != null) {
            if (boundDispatchReceiver != null && boundExtensionReceiver != null) {
                throw new IllegalStateException(("Bound callable references can't have both receivers: " + UtilsKt.render(callableReferenceAccess)).toString());
            }
            iterable = (Collection)$this$createAdapterFunctionForCallableReference_u24lambda_u241_u240;
            IrFunction irFunction = (IrFunction)irAdapterFunction;
            Name name3 = Name.identifier("receiver");
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            iterable.add(this.createAdapterParameter(irFunction, name3, boundReceiver.getType(), IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE(), IrParameterKind.ExtensionReceiver));
        }
        iterable = parameterTypes;
        Collection destination$iv = (Collection)$this$createAdapterFunctionForCallableReference_u24lambda_u241_u240;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            void parameterType;
            void index;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrType irType3 = (IrType)item$iv;
            int n2 = n;
            Collection collection = destination$iv;
            boolean bl3 = false;
            IrFunction irFunction = (IrFunction)irAdapterFunction;
            Name name4 = Name.identifier("" + 'p' + (int)index);
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            collection.add(this.createAdapterParameter(irFunction, name4, (IrType)parameterType, IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE(), IrParameterKind.Regular));
        }
        ((IrFunction)object).setParameters(CollectionsKt.build((List)list));
        IrDeclarationParent irDeclarationParent = this.conversionScope.parent();
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        ((IrDeclarationBase)irAdapterFunction).setParent(irDeclarationParent);
        return object2;
    }

    private final IrValueParameter createAdapterParameter(IrFunction adapterFunction, Name name2, IrType type, IrDeclarationOrigin origin, IrParameterKind kind) {
        Object object = IrFactoryImpl.INSTANCE;
        int n = adapterFunction.getStartOffset();
        int n2 = adapterFunction.getEndOffset();
        IrValueParameterSymbolImpl irValueParameterSymbolImpl = new IrValueParameterSymbolImpl(null, null, 3, null);
        Object irAdapterValueParameter = object = ((IrFactory)object).createValueParameter(n, n2, origin, kind, name2, type, false, irValueParameterSymbolImpl, null, false, false, false);
        boolean bl = false;
        ((IrDeclarationBase)irAdapterValueParameter).setParent(adapterFunction);
        return object;
    }

    private final IrGetValue toIrGetValue(IrValueDeclaration $this$toIrGetValue, int startOffset, int endOffset) {
        return BuildersKt.IrGetValueImpl$default(startOffset, endOffset, $this$toIrGetValue.getType(), $this$toIrGetValue.getSymbol(), null, 16, null);
    }

    private final IrExpression createAdapteeCallForCallableReference(FirCallableReferenceAccess callableReferenceAccess, FirFunction firAdaptee, IrFunctionSymbol adapteeSymbol, IrFunction adapterFunction, IrSimpleType adaptedType, IrExpression boundDispatchReceiver, IrExpression boundExtensionReceiver) {
        return (IrExpression)OffsetUtilsKt.convertWithOffsets(callableReferenceAccess, (arg_0, arg_1) -> AdapterGenerator.createAdapteeCallForCallableReference$lambda$0(callableReferenceAccess, this, firAdaptee, adapteeSymbol, boundDispatchReceiver, boundExtensionReceiver, adapterFunction, adaptedType, arg_0, arg_1));
    }

    @NotNull
    public final IrExpression applySamConversionIfNeeded$fir2ir(@NotNull IrExpression $this$applySamConversionIfNeeded, @NotNull FirExpression argument) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$applySamConversionIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        if (!(argument instanceof FirSamConversionExpression)) {
            return $this$applySamConversionIfNeeded;
        }
        ConeKotlinType it = FirTypeUtilsKt.getResolvedType(argument);
        boolean bl = false;
        ConeKotlinType coneKotlinType = this.removeExternalProjections(it, TypeComponentsKt.getTypeContext(this.getSession()));
        if (coneKotlinType == null) {
            coneKotlinType = it;
        }
        ConeKotlinType samFirType = coneKotlinType;
        IrType samType = Fir2IrTypeConverterKt.toIrType((Fir2IrComponents)this, samFirType, ConversionTypeOrigin.DEFAULT);
        if ($this$applySamConversionIfNeeded instanceof IrBlock && (Intrinsics.areEqual((Object)((IrBlock)$this$applySamConversionIfNeeded).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE()) || Intrinsics.areEqual((Object)((IrBlock)$this$applySamConversionIfNeeded).getOrigin(), (Object)IrStatementOrigin.Companion.getSUSPEND_CONVERSION()))) {
            int lastIndex = CollectionsKt.getLastIndex(((IrBlock)$this$applySamConversionIfNeeded).getStatements());
            IrStatement irStatement = ((IrBlock)$this$applySamConversionIfNeeded).getStatements().get(lastIndex);
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            IrTypeOperatorCallImpl samConversion = AdapterGenerator.applySamConversionIfNeeded$generateSamConversion((IrExpression)irStatement, this, samType, (FirSamConversionExpression)argument, samFirType);
            ((IrBlock)$this$applySamConversionIfNeeded).getStatements().set(lastIndex, samConversion);
            $this$applySamConversionIfNeeded.setType(samConversion.getType());
            irExpression = $this$applySamConversionIfNeeded;
        } else {
            irExpression = AdapterGenerator.applySamConversionIfNeeded$generateSamConversion($this$applySamConversionIfNeeded, this, samType, (FirSamConversionExpression)argument, samFirType);
        }
        return irExpression;
    }

    private final IrExpression castArgumentToFunctionalInterfaceForSamType(IrExpression argument, ConeKotlinType argumentConeType, ConeKotlinType samType, boolean usesFunctionalTypeConversion) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = this.getFunctionTypeForPossibleSamType$fir2ir(samType);
        if (coneKotlinType2 == null || (coneKotlinType = Fir2IrTypeConverterKt.approximateForIrOrSelf(this, coneKotlinType2)) == null) {
            return argument;
        }
        ConeKotlinType approximatedConeKotlinFunctionType = coneKotlinType;
        ConeKotlinType approximateArgumentConeType = Fir2IrTypeConverterKt.approximateForIrOrSelf(this, argumentConeType);
        if (usesFunctionalTypeConversion) {
            approximatedConeKotlinFunctionType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(approximatedConeKotlinFunctionType, this.getSession());
        }
        if (TypeUtilsKt.isSubtypeOf$default(approximateArgumentConeType, approximatedConeKotlinFunctionType, this.getSession(), false, 4, null)) {
            return argument;
        }
        IrType irFunctionType = Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, approximatedConeKotlinFunctionType, null, 2, null);
        return IrExpressionsKt.implicitCastTo(argument, irFunctionType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ConeKotlinType removeExternalProjections(ConeKotlinType $this$removeExternalProjections, ConeInferenceContext typeContext2) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$removeExternalProjections;
        if (coneKotlinType2 instanceof ConeRigidType) {
            coneKotlinType = this.removeExternalProjections((ConeRigidType)$this$removeExternalProjections);
            return coneKotlinType;
        } else {
            void $this$mapTypesOrNull_u24default$iv;
            if (!(coneKotlinType2 instanceof ConeFlexibleType)) throw new NoWhenBranchMatchedException();
            ConeFlexibleType coneFlexibleType = (ConeFlexibleType)$this$removeExternalProjections;
            ConeTypeContext typeContext$iv = typeContext2;
            boolean dropIdentity$iv = false;
            boolean $i$f$mapTypesOrNull = false;
            if ($this$mapTypesOrNull_u24default$iv.isTrivial()) {
                ConeKotlinType coneKotlinType3;
                ConeRigidType it = $this$mapTypesOrNull_u24default$iv.getLowerBound();
                boolean bl = false;
                ConeKotlinType it$iv = coneKotlinType3 = (ConeKotlinType)this.removeExternalProjections(it);
                boolean bl2 = false;
                ConeKotlinType mappedLowerBound$iv = coneKotlinType3;
                if (mappedLowerBound$iv == null) {
                    return null;
                }
                if (mappedLowerBound$iv instanceof ConeRigidType) {
                    coneKotlinType = TypeUtilsKt.coneFlexibleOrSimpleType(typeContext$iv, mappedLowerBound$iv, TypeUtilsKt.withNullability$default(mappedLowerBound$iv, true, typeContext$iv, null, true, 4, null), true);
                    return coneKotlinType;
                } else {
                    if (!(mappedLowerBound$iv instanceof ConeFlexibleType)) throw new NoWhenBranchMatchedException();
                    coneKotlinType = mappedLowerBound$iv;
                }
                return coneKotlinType;
            } else {
                ConeKotlinType coneKotlinType4;
                ConeKotlinType coneKotlinType5;
                ConeRigidType it = $this$mapTypesOrNull_u24default$iv.getLowerBound();
                boolean bl = false;
                ConeKotlinType it$iv = coneKotlinType5 = (ConeKotlinType)this.removeExternalProjections(it);
                boolean bl3 = false;
                ConeKotlinType mappedLowerBound$iv = coneKotlinType5;
                it = $this$mapTypesOrNull_u24default$iv.getUpperBound();
                bl = false;
                ConeKotlinType it$iv2 = coneKotlinType4 = (ConeKotlinType)this.removeExternalProjections(it);
                boolean bl4 = false;
                ConeKotlinType mappedUpperBound$iv = coneKotlinType4;
                if (mappedLowerBound$iv == null && mappedUpperBound$iv == null) {
                    return null;
                }
                if (!($this$mapTypesOrNull_u24default$iv instanceof ConeRawType)) {
                    ConeKotlinType coneKotlinType6;
                    ConeKotlinType coneKotlinType7 = mappedLowerBound$iv;
                    if (coneKotlinType7 == null) {
                        coneKotlinType7 = $this$mapTypesOrNull_u24default$iv.getLowerBound();
                    }
                    if ((coneKotlinType6 = mappedUpperBound$iv) == null) {
                        coneKotlinType6 = $this$mapTypesOrNull_u24default$iv.getUpperBound();
                    }
                    coneKotlinType = TypeUtilsKt.coneFlexibleOrSimpleType(typeContext$iv, coneKotlinType7, coneKotlinType6, false);
                    return coneKotlinType;
                } else {
                    ConeKotlinType coneKotlinType8;
                    ConeKotlinType coneKotlinType9 = mappedLowerBound$iv;
                    if (coneKotlinType9 == null || (coneKotlinType9 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType9)) == null) {
                        coneKotlinType9 = $this$mapTypesOrNull_u24default$iv.getLowerBound();
                    }
                    if ((coneKotlinType8 = mappedUpperBound$iv) == null || (coneKotlinType8 = ConeTypeUtilsKt.upperBoundIfFlexible(coneKotlinType8)) == null) {
                        coneKotlinType8 = $this$mapTypesOrNull_u24default$iv.getUpperBound();
                    }
                    coneKotlinType = ConeRawType.Companion.create((ConeRigidType)coneKotlinType9, (ConeRigidType)coneKotlinType8);
                }
            }
        }
        return coneKotlinType;
    }

    private final ConeRigidType removeExternalProjections(ConeRigidType $this$removeExternalProjections) {
        if (!($this$removeExternalProjections instanceof ConeClassLikeType)) {
            return $this$removeExternalProjections;
        }
        ConeInferenceContext $this$removeExternalProjections_u24lambda_u241 = TypeComponentsKt.getTypeContext(this.getSession());
        boolean bl = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$removeExternalProjections.getTypeArguments();
        if (coneTypeProjectionArray.length == 0) {
            boolean bl2 = false;
            return $this$removeExternalProjections;
        }
        ConeTypeProjection[] arguments = coneTypeProjectionArray;
        List<ConeTypeParameterLookupTag> parameters = $this$removeExternalProjections_u24lambda_u241.getParameters(((ConeClassLikeType)$this$removeExternalProjections).getLookupTag());
        Set parameterSet = CollectionsKt.toSet((Iterable)parameters);
        int n = arguments.length;
        ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[n];
        for (int i = 0; i < n; ++i) {
            ConeKotlinType coneKotlinType;
            block11: {
                ConeTypeParameterLookupTag parameter;
                ConeTypeProjection argument;
                block8: {
                    KotlinTypeMarker kotlinTypeMarker;
                    block10: {
                        block9: {
                            int n2 = i;
                            argument = arguments[n2];
                            if ((ConeTypeParameterLookupTag)CollectionsKt.getOrNull(parameters, (int)n2) == null) {
                                return null;
                            }
                            if (argument.getKind() != ProjectionKind.IN || !this.c.getConfiguration().getCarefulApproximationOfContravariantProjectionForSam()) break block8;
                            kotlinTypeMarker = (KotlinTypeMarker)CollectionsKt.singleOrNull($this$removeExternalProjections_u24lambda_u241.getUpperBounds(parameter));
                            if (kotlinTypeMarker == null || (kotlinTypeMarker = $this$removeExternalProjections_u24lambda_u241.upperBoundIfFlexible(kotlinTypeMarker)) == null) break block9;
                            KotlinTypeMarker $this$asCone$iv = kotlinTypeMarker;
                            boolean $i$f$asCone = false;
                            kotlinTypeMarker = (ConeRigidType)$this$asCone$iv;
                            if (kotlinTypeMarker != null) break block10;
                        }
                        return null;
                    }
                    KotlinTypeMarker upperBound = kotlinTypeMarker;
                    if (!ConeBuiltinTypeUtilsKt.isNullableAny((ConeKotlinType)upperBound)) {
                        return null;
                    }
                    coneKotlinType = (ConeKotlinType)upperBound;
                    break block11;
                }
                coneKotlinType = argument instanceof ConeKotlinTypeProjection ? ((ConeKotlinTypeProjection)argument).getType() : this.starProjectionTypeRepresentation(parameter.getTypeParameterSymbol(), parameterSet);
            }
            coneKotlinTypeArray[n2] = coneKotlinType;
        }
        ConeKotlinType[] newArguments2 = coneKotlinTypeArray;
        return ConeTypeUtilsKt.withArguments((ConeClassLikeType)$this$removeExternalProjections, newArguments2);
    }

    private final ConeKotlinType starProjectionTypeRepresentation(FirTypeParameterSymbol $this$starProjectionTypeRepresentation, Set<ConeTypeParameterLookupTag> containingParameterSet) {
        ConeInferenceContext coneInferenceContext = TypeComponentsKt.getTypeContext(this.getSession());
        AbstractConeSubstitutor substitutor2 = new AbstractConeSubstitutor(containingParameterSet, coneInferenceContext){
            final /* synthetic */ Set<ConeTypeParameterLookupTag> $containingParameterSet;
            {
                this.$containingParameterSet = $containingParameterSet;
                super($super_call_param$1);
            }

            public ConeKotlinType substituteType(ConeKotlinType type) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return null;
            }

            public ConeTypeProjection substituteArgument(ConeTypeProjection projection, int index) {
                Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
                if (projection instanceof ConeTypeParameterType && this.$containingParameterSet.contains(((ConeTypeParameterType)projection).getLookupTag())) {
                    return ConeStarProjection.INSTANCE;
                }
                return super.substituteArgument(projection, index);
            }
        };
        return substitutor2.substituteOrSelf(((FirResolvedTypeRef)CollectionsKt.first($this$starProjectionTypeRepresentation.getResolvedBounds())).getConeType());
    }

    @Nullable
    public final ConeKotlinType getFunctionTypeForPossibleSamType$fir2ir(@NotNull ConeKotlinType parameterType) {
        Intrinsics.checkNotNullParameter((Object)parameterType, (String)"parameterType");
        FirSamResolver.SamConversionInfo samConversionInfo = this.samResolver.getSamInfoForPossibleSamType(parameterType);
        return samConversionInfo != null ? samConversionInfo.getFunctionalType() : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final IrExpression applySuspendConversionIfNeeded$fir2ir(@NotNull IrExpression $this$applySuspendConversionIfNeeded, @NotNull FirExpression argument, @NotNull ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$applySuspendConversionIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        if ($this$applySuspendConversionIfNeeded instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)$this$applySuspendConversionIfNeeded).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE())) {
            return $this$applySuspendConversionIfNeeded;
        }
        v0 = this.getFunctionTypeForPossibleSamType$fir2ir(expectedType);
        if (v0 == null) {
            v0 = expectedType;
        }
        if (!FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(unwrappedExpectedType = v0, this.getSession())) {
            return $this$applySuspendConversionIfNeeded;
        }
        v1 = this;
        v2 /* !! */  = argument instanceof FirSamConversionExpression != false ? (FirSamConversionExpression)argument : null;
        if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getExpression()) == null) {
            v2 /* !! */  = argument;
        }
        if (TypeUtilsKt.isSubtypeOf$default(argumentTypeWithoutSamConversion = TypeExpansionUtilsKt.fullyExpandedType(v1, FirTypeUtilsKt.getResolvedType(v2 /* !! */ )), expectedType, this.getSession(), false, 4, null)) {
            return $this$applySuspendConversionIfNeeded;
        }
        expectedFunctionalType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(unwrappedExpectedType, this.getSession());
        v3 = this.findInvokeSymbol(expectedFunctionalType, argumentTypeWithoutSamConversion);
        if (v3 == null) {
            return $this$applySuspendConversionIfNeeded;
        }
        invokeSymbol = v3;
        v4 = Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, unwrappedExpectedType, null, 2, null);
        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        suspendConvertedType = (IrSimpleType)v4;
        $this$convertWithOffsets$iv = argument;
        $i$f$convertWithOffsets = false;
        var11_11 = $this$convertWithOffsets$iv;
        tokenSet$iv = var11_11 instanceof FirNamedFunction != false ? OffsetUtilsKt.access$getFUNCTION_KEYWORD_TOKENS$p() : (var11_11 instanceof FirConstructor != false ? OffsetUtilsKt.access$getCONSTRUCTOR_KEYWORD_TOKENS$p() : (var11_11 instanceof FirVariable != false ? KtTokens.VAL_VAR : null));
        var11_11 = $this$convertWithOffsets$iv.getSource();
        keywordTokens$iv$iv = tokenSet$iv;
        $i$f$convertWithOffsets = false;
        startOffset$iv$iv = 0;
        endOffset$iv$iv = 0;
        if (OffsetUtilsKt.access$isCompiledElement(KtSourceElementKt.getPsi((AbstractKtSourceElement)$this$convertWithOffsets$iv$iv))) ** GOTO lbl-1000
        v5 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v5 != null ? v5.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) ** GOTO lbl-1000
        v6 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v6 != null ? v6.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitThisReceiverExpression.INSTANCE)) ** GOTO lbl-1000
        v7 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v7 != null ? v7.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitContextParameterArgument.INSTANCE)) lbl-1000:
        // 4 sources

        {
            startOffset$iv$iv = -1;
            endOffset$iv$iv = -1;
        } else {
            v8 = $this$convertWithOffsets$iv$iv;
            if (v8 != null && (v8 = OffsetUtilsKt.startOffsetSkippingComments((AbstractKtSourceElement)v8, keywordTokens$iv$iv)) != null) {
                v9 = v8;
            } else {
                v10 = $this$convertWithOffsets$iv$iv;
                v9 = v10 != null ? v10.getStartOffset() : -1;
            }
            startOffset$iv$iv = v9;
            v11 = $this$convertWithOffsets$iv$iv;
            endOffset$iv$iv = v11 != null ? v11.getEndOffset() : -1;
        }
        var17_17 = endOffset$iv$iv;
        startOffset = startOffset$iv$iv;
        $i$a$-convertWithOffsets-AdapterGenerator$applySuspendConversionIfNeeded$1 = false;
        irAdapterFunction = this.createAdapterFunctionForArgument(startOffset, (int)endOffset, suspendConvertedType, Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, expectedFunctionalType, null, 2, null), ConeTypeUtilsKt.isMarkedNullable(argumentTypeWithoutSamConversion), invokeSymbol);
        irAdapterRef = BuildersKt.IrFunctionReferenceImpl(startOffset, (int)endOffset, suspendConvertedType, irAdapterFunction.getSymbol(), irAdapterFunction.getTypeParameters().size(), null, IrStatementOrigin.Companion.getSUSPEND_CONVERSION());
        $this$applySuspendConversionIfNeeded_u24lambda_u240_u240 = var22_22 = BuildersKt.IrBlockImpl(startOffset, (int)endOffset, suspendConvertedType, IrStatementOrigin.Companion.getSUSPEND_CONVERSION());
        $i$a$-apply-AdapterGenerator$applySuspendConversionIfNeeded$1$1 = false;
        $this$applySuspendConversionIfNeeded_u24lambda_u240_u240.getStatements().add(irAdapterFunction);
        var26_26 = var25_25 = irAdapterRef;
        var27_27 = $this$applySuspendConversionIfNeeded_u24lambda_u240_u240.getStatements();
        $i$a$-apply-AdapterGenerator$applySuspendConversionIfNeeded$1$1$1 = false;
        $this$applySuspendConversionIfNeeded_u24lambda_u240_u240_u240.getArguments().set(0, $this$applySuspendConversionIfNeeded);
        var27_27.add(var25_25);
        return (IrExpression)((IrElement)var22_22);
    }

    private final IrSimpleFunctionSymbol findInvokeSymbol(ConeClassLikeType expectedFunctionalType, ConeKotlinType argumentType) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        FirFunctionSymbol<?> firFunctionSymbol;
        if (FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionType(argumentType, this.getSession(), expectedFunctionalType) == null) {
            return null;
        }
        FirFunctionSymbol<?> firFunctionSymbol2 = firFunctionSymbol = FunctionalTypeUtilsKt.isSomeFunctionType(expectedFunctionalType, this.getSession()) ? (FirFunctionSymbol<?>)FunctionalTypeUtilsKt.findBaseInvokeSymbol(this, expectedFunctionalType) : FunctionalTypeUtilsKt.findContributedInvokeSymbol(this, expectedFunctionalType, expectedFunctionalType, true);
        if (firFunctionSymbol != null) {
            FirFunctionSymbol<?> it = firFunctionSymbol;
            boolean bl = false;
            IrFunctionSymbol irFunctionSymbol = Fir2IrDeclarationStorage.getIrFunctionSymbol$default(this.getDeclarationStorage(), it, null, false, 6, null);
            irSimpleFunctionSymbol = irFunctionSymbol instanceof IrSimpleFunctionSymbol ? (IrSimpleFunctionSymbol)irFunctionSymbol : null;
        } else {
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createAdapterFunctionForArgument(int startOffset, int endOffset, IrSimpleType type, IrType adapterParameterType, boolean argumentIsNullable, IrSimpleFunctionSymbol invokeSymbol) {
        void $this$mapIndexedTo$iv;
        void $this$createAdapterFunctionForArgument_u24lambda_u241_u240;
        List list;
        IrSimpleFunction irSimpleFunction;
        Iterable it;
        void $this$mapTo$iv$iv;
        IrType returnType = IrTypesKt.getTypeOrFail((IrTypeArgument)CollectionsKt.last(type.getArguments()));
        Iterable $this$map$iv = CollectionsKt.dropLast(type.getArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IrTypesKt.getTypeOrFail((IrTypeArgument)((Object)it)));
        }
        List parameterTypes = (List)destination$iv$iv;
        IrFactory irFactory = IrFactoryImpl.INSTANCE;
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getADAPTER_FOR_SUSPEND_CONVERSION();
        Name name2 = Name.identifier(Scope.inventNameForTemporary$default(this.conversionScope.scope(), "suspendConversion", null, 2, null));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        IrSimpleFunction irAdapterFunction = irSimpleFunction = IrFactory.createSimpleFunction$default(irFactory, startOffset, endOffset, irDeclarationOrigin, name2, descriptorVisibility, false, false, returnType, Modality.FINAL, new IrSimpleFunctionSymbolImpl(null, null, 3, null), false, true, false, false, false, null, false, 98304, null);
        boolean bl = false;
        List $i$f$mapTo22 = list = CollectionsKt.createListBuilder();
        IrSimpleFunction irSimpleFunction2 = irAdapterFunction;
        boolean bl2 = false;
        it = (Collection)$this$createAdapterFunctionForArgument_u24lambda_u241_u240;
        IrFunction irFunction = irAdapterFunction;
        Name name3 = Name.identifier("$callee");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        it.add(this.createAdapterParameter(irFunction, name3, adapterParameterType, IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_SUSPEND_CONVERSION(), IrParameterKind.ExtensionReceiver));
        it = parameterTypes;
        Collection destination$iv = (Collection)$this$createAdapterFunctionForArgument_u24lambda_u241_u240;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            void parameterType;
            void index;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrType irType = (IrType)item$iv;
            int n2 = n;
            Collection collection = destination$iv;
            boolean bl3 = false;
            IrFunction irFunction2 = irAdapterFunction;
            Name name4 = Name.identifier("" + 'p' + (int)index);
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            collection.add(this.createAdapterParameter(irFunction2, name4, (IrType)parameterType, IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_SUSPEND_CONVERSION(), IrParameterKind.Regular));
        }
        irSimpleFunction2.setParameters(CollectionsKt.build((List)list));
        irAdapterFunction.setBody(IrFactoryHelpersKt.createBlockBody((IrFactory)IrFactoryImpl.INSTANCE, startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> AdapterGenerator.createAdapterFunctionForArgument$lambda$1$1(this, startOffset, endOffset, irAdapterFunction, invokeSymbol, argumentIsNullable, returnType, arg_0))));
        IrDeclarationParent irDeclarationParent = this.conversionScope.parent();
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        irAdapterFunction.setParent(irDeclarationParent);
        return irSimpleFunction;
    }

    private final IrExpression createAdapteeCallForArgument(int startOffset, int endOffset, IrFunction adapterFunction, IrSimpleFunctionSymbol invokeSymbol) {
        IrCallImpl irCall = BuildersKt.IrCallImpl$default(startOffset, endOffset, adapterFunction.getReturnType(), invokeSymbol, 0, null, null, 96, null);
        Iterator iterator2 = ((Iterable)adapterFunction.getParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IrValueParameter parameter = (IrValueParameter)iterator2.next();
            irCall.getArguments().set(i, this.toIrGetValue(parameter, startOffset, endOffset));
        }
        return irCall;
    }

    @NotNull
    public final IrExpression generateFunInterfaceConstructorReference(@NotNull FirCallableReferenceAccess callableReference, @NotNull FirFunctionSymbol<?> callableSymbol, @NotNull IrType irReferenceType) {
        Intrinsics.checkNotNullParameter((Object)callableReference, (String)"callableReference");
        Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
        Intrinsics.checkNotNullParameter((Object)irReferenceType, (String)"irReferenceType");
        return (IrExpression)OffsetUtilsKt.convertWithOffsets(callableReference, (arg_0, arg_1) -> AdapterGenerator.generateFunInterfaceConstructorReference$lambda$0(this, callableSymbol, irReferenceType, arg_0, arg_1));
    }

    private final IrType getArgumentTypeAt(IrSimpleType $this$getArgumentTypeAt, int index) {
        IrTypeArgument irTypeArgument = $this$getArgumentTypeAt.getArguments().get(index);
        IrTypeProjection irTypeProjection = irTypeArgument instanceof IrTypeProjection ? (IrTypeProjection)irTypeArgument : null;
        if (irTypeProjection == null) {
            throw new AssertionError((Object)("Type projection expected at argument " + index + ": " + RenderIrElementKt.render$default($this$getArgumentTypeAt, null, 1, null)));
        }
        IrTypeProjection irTypeArgument2 = irTypeProjection;
        return irTypeArgument2.getType();
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateFunInterfaceConstructorAdapter(int startOffset, int endOffset, FirFunctionSymbol<?> callableSymbol, IrType irReferenceType) {
        void $this$generateFunInterfaceConstructorAdapter_u24lambda_u240_u240;
        IrCallImpl irCallImpl;
        IrSimpleFunction irSimpleFunction;
        IrSimpleType irSimpleType = irReferenceType instanceof IrSimpleType ? (IrSimpleType)irReferenceType : null;
        if (irSimpleType == null) {
            throw new AssertionError((Object)("Class type expected: " + RenderIrElementKt.render$default(irReferenceType, null, 1, null)));
        }
        IrSimpleType irSimpleReferenceType = irSimpleType;
        IrType irSamType = this.getArgumentTypeAt(irSimpleReferenceType, 1);
        IrType irFunctionType = this.getArgumentTypeAt(irSimpleReferenceType, 0);
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.singleOrNull(callableSymbol.getValueParameterSymbols());
        if (firValueParameterSymbol == null) {
            throw new AssertionError((Object)("Single value parameter expected: " + callableSymbol.getValueParameterSymbols()));
        }
        FirValueParameterSymbol functionParameter = firValueParameterSymbol;
        IrFactory irFactory = IrFactoryImpl.INSTANCE;
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getADAPTER_FOR_FUN_INTERFACE_CONSTRUCTOR();
        Name name2 = callableSymbol.getName();
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        IrSimpleFunction irAdapterFunction = irSimpleFunction = IrFactory.createSimpleFunction$default(irFactory, startOffset, endOffset, irDeclarationOrigin, name2, descriptorVisibility, false, false, irSamType, Modality.FINAL, new IrSimpleFunctionSymbolImpl(null, null, 3, null), false, false, false, false, false, null, false, 98304, null);
        boolean bl = false;
        IrValueParameter irFunctionParameter = this.createAdapterParameter(irAdapterFunction, functionParameter.getName(), irFunctionType, IrDeclarationOrigin.Companion.getADAPTER_PARAMETER_FOR_CALLABLE_REFERENCE(), IrParameterKind.Regular);
        irAdapterFunction.setParameters(CollectionsKt.listOf((Object)irFunctionParameter));
        IrCallImpl irCallImpl2 = irCallImpl = BuildersKt.IrCallImplWithShape$default(startOffset, endOffset, irFunctionType, this.getBuiltins().getCheckNotNullSymbol(), 1, 1, 0, false, false, IrStatementOrigin.Companion.getEXCLEXCL(), null, 1024, null);
        IrType irType = irSamType;
        IrTypeOperator irTypeOperator = IrTypeOperator.SAM_CONVERSION;
        IrType irType2 = irSamType;
        int n = endOffset;
        int n2 = startOffset;
        IrReturnTargetSymbol irReturnTargetSymbol = irAdapterFunction.getSymbol();
        IrType irType3 = this.c.getBuiltins().getNothingType();
        int n3 = endOffset;
        int n4 = startOffset;
        int n5 = endOffset;
        int n6 = startOffset;
        IrFactory irFactory2 = IrFactoryImpl.INSTANCE;
        IrSimpleFunction irSimpleFunction2 = irAdapterFunction;
        boolean bl2 = false;
        $this$generateFunInterfaceConstructorAdapter_u24lambda_u240_u240.getTypeArguments().set(0, irFunctionType);
        $this$generateFunInterfaceConstructorAdapter_u24lambda_u240_u240.getArguments().set(0, BuildersKt.IrGetValueImpl$default(startOffset, endOffset, irFunctionParameter.getSymbol(), null, 8, null));
        Unit unit = Unit.INSTANCE;
        IrExpression irExpression = BuildersKt.IrTypeOperatorCallImpl(n2, n, irType2, irTypeOperator, irType, irCallImpl);
        IrReturnTargetSymbol irReturnTargetSymbol2 = irReturnTargetSymbol;
        IrType irType4 = irType3;
        int n7 = n3;
        int n8 = n4;
        irSimpleFunction2.setBody(IrFactoryHelpersKt.createBlockBody(irFactory2, n6, n5, CollectionsKt.listOf((Object)new IrReturnImpl(n8, n7, irType4, irReturnTargetSymbol2, irExpression))));
        IrDeclarationParent irDeclarationParent = this.conversionScope.parent();
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        irAdapterFunction.setParent(irDeclarationParent);
        return irSimpleFunction;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.c.getSession();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.c.getScopeSession();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.c.getFirProvider();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.c.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrBuiltinSymbolsContainer getBuiltins() {
        return this.c.getBuiltins();
    }

    @Override
    @Nullable
    public IrSpecialAnnotationsProvider getSpecialAnnotationsProvider() {
        return this.c.getSpecialAnnotationsProvider();
    }

    @Override
    @NotNull
    public KotlinMangler.IrMangler getIrMangler() {
        return this.c.getIrMangler();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.c.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.c.getLock();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.c.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.c.getDeclarationStorage();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.c.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.c.getVisibilityConverter();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.c.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.c.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.c.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public Fir2IrDataClassMembersGenerator getDataClassMembersGenerator() {
        return this.c.getDataClassMembersGenerator();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.c.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.c.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyFakeOverrideGenerator getLazyFakeOverrideGenerator() {
        return this.c.getLazyFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.c.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.c.getExtensions();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.c.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.c.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public AdapterGenerator getAdapterGenerator() {
        return this.c.getAdapterGenerator();
    }

    @Override
    @NotNull
    public Fir2IrImplicitCastInserter getImplicitCastInserter() {
        return this.c.getImplicitCastInserter();
    }

    @Override
    @Nullable
    public Set<FirFile> getFilesBeingCompiled() {
        return this.c.getFilesBeingCompiled();
    }

    private static final Unit generateAdaptedCallableReference$lambda$0$0(IrType $expectedReturnType, AdapterGenerator this$0, IrExpression $irCall, int $startOffset, int $endOffset, IrSimpleFunction $irAdapterFunction, IrBlockBody $this$createBlockBody) {
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        IrType irType = $expectedReturnType;
        boolean bl = (irType != null ? IrTypePredicatesKt.isUnit(irType) : false) ? $this$createBlockBody.getStatements().add(Fir2IrImplicitCastInserter.Companion.coerceToUnitIfNeeded$fir2ir(this$0, $irCall)) : $this$createBlockBody.getStatements().add(new IrReturnImpl($startOffset, $endOffset, this$0.getBuiltins().getNothingType(), $irAdapterFunction.getSymbol(), $irCall));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrBlockImpl generateAdaptedCallableReference$lambda$0(AdapterGenerator this$0, FirCallableReferenceAccess $callableReferenceAccess, IrExpression $explicitReceiverExpression, FirFunction $firAdaptee, IrSimpleType $type, IrFunctionSymbol $adapteeSymbol, IrType $expectedReturnType, int startOffset, int endOffset) {
        IrExpression boundDispatchReceiver = this$0.findBoundReceiver($callableReferenceAccess, $explicitReceiverExpression, true);
        IrExpression boundExtensionReceiver = this$0.findBoundReceiver($callableReferenceAccess, $explicitReceiverExpression, false);
        FirFunction firFunction = $firAdaptee;
        Intrinsics.checkNotNull((Object)firFunction);
        IrSimpleFunction irAdapterFunction = this$0.createAdapterFunctionForCallableReference($callableReferenceAccess, startOffset, endOffset, firFunction, $type, boundDispatchReceiver, boundExtensionReceiver);
        IrExpression irCall = this$0.createAdapteeCallForCallableReference($callableReferenceAccess, $firAdaptee, $adapteeSymbol, irAdapterFunction, $type, boundDispatchReceiver, boundExtensionReceiver);
        irAdapterFunction.setBody(IrFactoryHelpersKt.createBlockBody((IrFactory)IrFactoryImpl.INSTANCE, startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> AdapterGenerator.generateAdaptedCallableReference$lambda$0$0($expectedReturnType, this$0, irCall, startOffset, endOffset, irAdapterFunction, arg_0))));
        if (!irAdapterFunction.getTypeParameters().isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Iterable iterable = irAdapterFunction.getTypeParameters();
            StringBuilder stringBuilder = new StringBuilder().append("Internal error: function adapter ").append(irAdapterFunction.getSymbol()).append(" has unexpected type parameters: ");
            boolean $i$f$map = false;
            void var18_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSymbol());
            }
            String string = stringBuilder.append((List)destination$iv$iv).append("\nThey should already be used to determine exact return type and value parameters types").toString();
            throw new IllegalArgumentException(string.toString());
        }
        IrExpression irExpression = BuildersKt.IrFunctionReferenceImpl(startOffset, endOffset, $type, irAdapterFunction.getSymbol(), 0, null, IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE());
        IrFunctionReferenceImpl $this$generateAdaptedCallableReference_u24lambda_u240_u242 = irExpression;
        boolean bl = false;
        IrExpression irExpression2 = boundDispatchReceiver;
        if (irExpression2 == null) {
            irExpression2 = boundExtensionReceiver;
        }
        if (irExpression2 != null) {
            IrExpression it = irExpression2;
            boolean bl3 = false;
            $this$generateAdaptedCallableReference_u24lambda_u240_u242.getArguments().set(0, it);
        }
        $this$generateAdaptedCallableReference_u24lambda_u240_u242.setReflectionTarget($adapteeSymbol);
        IrFunctionReferenceImpl irAdapterRef = irExpression;
        IrExpression $this$generateAdaptedCallableReference_u24lambda_u240_u243 = irExpression = BuildersKt.IrBlockImpl(startOffset, endOffset, $type, IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE());
        boolean bl4 = false;
        ((IrBlockImpl)$this$generateAdaptedCallableReference_u24lambda_u240_u243).getStatements().add(irAdapterFunction);
        ((IrBlockImpl)$this$generateAdaptedCallableReference_u24lambda_u240_u243).getStatements().add(irAdapterRef);
        return irExpression;
    }

    private static final IrGetValue createAdapteeCallForCallableReference$lambda$0$buildIrGetValueArgument(Ref.IntRef adapterParameterIndex, AdapterGenerator this$0, IrFunction $adapterFunction, Ref.IntRef parameterShift, int $startOffset, int $endOffset, FirExpression argument) {
        FirFakeArgumentForCallableReference firFakeArgumentForCallableReference = argument instanceof FirFakeArgumentForCallableReference ? (FirFakeArgumentForCallableReference)argument : null;
        int parameterIndex = firFakeArgumentForCallableReference != null ? firFakeArgumentForCallableReference.getIndex() : adapterParameterIndex.element;
        int n = adapterParameterIndex.element;
        adapterParameterIndex.element = n + 1;
        return this$0.toIrGetValue($adapterFunction.getParameters().get(parameterIndex + parameterShift.element), $startOffset, $endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrExpression createAdapteeCallForCallableReference$lambda$0(FirCallableReferenceAccess $callableReferenceAccess, AdapterGenerator this$0, FirFunction $firAdaptee, IrFunctionSymbol $adapteeSymbol, IrExpression $boundDispatchReceiver, IrExpression $boundExtensionReceiver, IrFunction $adapterFunction, IrSimpleType $adaptedType, int startOffset, int endOffset) {
        Ref.IntRef parameterShift;
        Ref.IntRef adapterParameterIndex;
        IrFunctionAccessExpression irCall;
        ConeSubstitutor substitutor2;
        block25: {
            boolean bl;
            block26: {
                boolean bl2;
                Object receiverValue;
                Object receiverParameter;
                block24: {
                    IrFunctionAccessExpression irFunctionAccessExpression;
                    ConeSubstitutor coneSubstitutor = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default($callableReferenceAccess, this$0.getSession(), false, 2, null);
                    if (coneSubstitutor == null) {
                        coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
                    }
                    substitutor2 = coneSubstitutor;
                    IrType type = Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this$0, substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType($firAdaptee.getReturnTypeRef())), null, 2, null);
                    IrFunctionSymbol irFunctionSymbol = $adapteeSymbol;
                    if (irFunctionSymbol instanceof IrConstructorSymbol) {
                        irFunctionAccessExpression = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, startOffset, endOffset, type, (IrConstructorSymbol)$adapteeSymbol, null, 16, null);
                    } else if (irFunctionSymbol instanceof IrSimpleFunctionSymbol) {
                        irFunctionAccessExpression = BuildersKt.IrCallImpl(startOffset, endOffset, type, (IrSimpleFunctionSymbol)$adapteeSymbol, $callableReferenceAccess.getTypeArguments().size(), null, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    irCall = irFunctionAccessExpression;
                    adapterParameterIndex = new Ref.IntRef();
                    parameterShift = new Ref.IntRef();
                    if ($boundDispatchReceiver == null && $boundExtensionReceiver == null) break block24;
                    receiverParameter = $adapterFunction.getParameters().get(0);
                    receiverValue = BuildersKt.IrGetValueImpl(startOffset, endOffset, receiverParameter.getType(), ((IrValueParameter)receiverParameter).getSymbol(), IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE());
                    irCall.getArguments().set(0, receiverValue);
                    parameterShift.element = 1;
                    break block25;
                }
                if (!($callableReferenceAccess.getExplicitReceiver() instanceof FirResolvedQualifier)) break block25;
                if (!($firAdaptee instanceof FirConstructor)) break block26;
                receiverParameter = ClassMembersKt.containingClassLookupTag($firAdaptee);
                if (receiverParameter != null && (receiverValue = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)this$0, (ConeClassLikeLookupTag)receiverParameter)) != null) {
                    FirClassLikeSymbol $this$isInner$iv = (FirClassLikeSymbol)receiverValue;
                    boolean $i$f$isInner = false;
                    bl2 = $this$isInner$iv.getRawStatus().isInner();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block25;
            }
            FirMemberDeclaration firMemberDeclaration = $firAdaptee instanceof FirMemberDeclaration ? (FirMemberDeclaration)$firAdaptee : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isStatic$iv = firMemberDeclaration;
                boolean $i$f$isStatic = false;
                bl = $this$isStatic$iv.getStatus().isStatic();
            } else {
                bl = false;
            }
            if (!bl) {
                IrValueParameter adaptedReceiverParameter = $adapterFunction.getParameters().get(0);
                IrGetValueImpl adaptedReceiverValue = BuildersKt.IrGetValueImpl$default(startOffset, endOffset, adaptedReceiverParameter.getType(), adaptedReceiverParameter.getSymbol(), null, 16, null);
                irCall.getArguments().set(0, adaptedReceiverValue);
                parameterShift.element = 1;
            }
        }
        FirNamedReference $i$f$isStatic = $callableReferenceAccess.getCalleeReference();
        FirResolvedCallableReference firResolvedCallableReference = $i$f$isStatic instanceof FirResolvedCallableReference ? (FirResolvedCallableReference)$i$f$isStatic : null;
        Map<FirValueParameter, ResolvedCallArgument<FirExpression>> mappedArguments = firResolvedCallableReference != null ? firResolvedCallableReference.getMappedArguments() : null;
        Iterable $this$forEachIndexed$iv = $firAdaptee.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ResolvedCallArgument<FirExpression> mappedArgument;
            void valueParameter2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index = n;
            boolean bl = false;
            ConeKotlinType coneKotlinType = VariousUtilsKt.getVarargElementType((FirValueParameter)valueParameter2);
            IrType varargElementType = coneKotlinType != null ? Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this$0, coneKotlinType, null, 2, null) : null;
            IrType parameterType = Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this$0, substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef())), null, 2, null);
            Map<FirValueParameter, ResolvedCallArgument<FirExpression>> map = mappedArguments;
            ResolvedCallArgument<FirExpression> resolvedCallArgument = mappedArgument = map != null ? map.get(valueParameter2) : null;
            if (mappedArgument instanceof ResolvedCallArgument.VarargArgument) {
                IrVarargImpl irVarargImpl;
                if (((ResolvedCallArgument.VarargArgument)mappedArgument).getArguments().isEmpty()) {
                    irVarargImpl = null;
                } else {
                    IrType reifiedVarargElementType = null;
                    IrType reifiedVarargType = null;
                    IrType irType = varargElementType;
                    boolean bl3 = irType != null ? IrTypeUtilsKt.isTypeParameter(irType) : false;
                    if (bl3 && parameterType instanceof IrSimpleType && !IrTypeUtilsKt.isPrimitiveArray(parameterType)) {
                        reifiedVarargElementType = this$0.getArgumentTypeAt($adaptedType, index);
                        reifiedVarargType = IrSimpleTypeImplKt.IrSimpleTypeImpl$default(((IrSimpleType)parameterType).getClassifier(), ((IrSimpleType)parameterType).getNullability(), CollectionsKt.listOf((Object)IrSimpleTypeImplKt.makeTypeProjection(reifiedVarargElementType, Variance.OUT_VARIANCE)), parameterType.getAnnotations(), null, 16, null);
                    } else {
                        IrType irType2 = varargElementType;
                        Intrinsics.checkNotNull((Object)irType2);
                        reifiedVarargElementType = irType2;
                        reifiedVarargType = parameterType;
                    }
                    IrVarargImpl adaptedValueArgument = BuildersKt.IrVarargImpl(startOffset, endOffset, reifiedVarargType, reifiedVarargElementType);
                    for (FirExpression argument : ((ResolvedCallArgument.VarargArgument)mappedArgument).getArguments()) {
                        IrGetValue irValueArgument = AdapterGenerator.createAdapteeCallForCallableReference$lambda$0$buildIrGetValueArgument(adapterParameterIndex, this$0, $adapterFunction, parameterShift, startOffset, endOffset, argument);
                        IrExpressionsKt.addElement(adaptedValueArgument, irValueArgument);
                    }
                    irVarargImpl = adaptedValueArgument;
                }
                IrVarargImpl valueArgument = irVarargImpl;
                irCall.getArguments().set(index + parameterShift.element, valueArgument);
                continue;
            }
            if (Intrinsics.areEqual(mappedArgument, (Object)ResolvedCallArgument.DefaultArgument.INSTANCE)) {
                irCall.getArguments().set(index + parameterShift.element, null);
                continue;
            }
            if (mappedArgument instanceof ResolvedCallArgument.SimpleArgument) {
                IrGetValue irValueArgument = AdapterGenerator.createAdapteeCallForCallableReference$lambda$0$buildIrGetValueArgument(adapterParameterIndex, this$0, $adapterFunction, parameterShift, startOffset, endOffset, (FirExpression)((ResolvedCallArgument.SimpleArgument)mappedArgument).getCallArgument());
                if (valueParameter2.isVararg()) {
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = irCall.getArguments();
                    int n2 = index + parameterShift.element;
                    IrType irType = varargElementType;
                    Intrinsics.checkNotNull((Object)irType);
                    valueArgumentsList.set(n2, BuildersKt.IrVarargImpl(startOffset, endOffset, parameterType, irType, CollectionsKt.listOf((Object)BuildersKt.IrSpreadElementImpl(startOffset, endOffset, irValueArgument))));
                    continue;
                }
                irCall.getArguments().set(index + parameterShift.element, irValueArgument);
                continue;
            }
            if (mappedArgument == null) continue;
            throw new NoWhenBranchMatchedException();
        }
        CallAndReferenceGenerator $this$createAdapteeCallForCallableReference_u24lambda_u240_u241 = this$0.getCallGenerator();
        boolean bl = false;
        return $this$createAdapteeCallForCallableReference_u24lambda_u240_u241.applyTypeArguments$fir2ir(irCall, $callableReferenceAccess);
    }

    private static final IrTypeOperatorCallImpl applySamConversionIfNeeded$generateSamConversion(IrExpression $this$applySamConversionIfNeeded_u24generateSamConversion, AdapterGenerator this$0, IrType samType, FirSamConversionExpression firSamConversion, ConeKotlinType samFirType) {
        return BuildersKt.IrTypeOperatorCallImpl($this$applySamConversionIfNeeded_u24generateSamConversion.getStartOffset(), $this$applySamConversionIfNeeded_u24generateSamConversion.getEndOffset(), samType, IrTypeOperator.SAM_CONVERSION, samType, this$0.castArgumentToFunctionalInterfaceForSamType($this$applySamConversionIfNeeded_u24generateSamConversion, FirTypeUtilsKt.getResolvedType(firSamConversion.getExpression()), samFirType, firSamConversion.getUsesFunctionKindConversion()));
    }

    private static final Unit createAdapterFunctionForArgument$lambda$1$1(AdapterGenerator this$0, int $startOffset, int $endOffset, IrSimpleFunction $irAdapterFunction, IrSimpleFunctionSymbol $invokeSymbol, boolean $argumentIsNullable, IrType $returnType, IrBlockBody $this$createBlockBody) {
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        IrExpression irCall = this$0.createAdapteeCallForArgument($startOffset, $endOffset, $irAdapterFunction, $invokeSymbol);
        if ($argumentIsNullable) {
            irCall = IrElementsCreationUtilsKt.createWhenForSafeFall(this$0, irCall.getType(), $irAdapterFunction.getParameters().get(0).getSymbol(), irCall);
        }
        boolean bl = IrTypePredicatesKt.isUnit($returnType) ? $this$createBlockBody.getStatements().add(irCall) : $this$createBlockBody.getStatements().add(new IrReturnImpl($startOffset, $endOffset, this$0.getBuiltins().getNothingType(), $irAdapterFunction.getSymbol(), irCall));
        return Unit.INSTANCE;
    }

    private static final IrBlockImpl generateFunInterfaceConstructorReference$lambda$0(AdapterGenerator this$0, FirFunctionSymbol $callableSymbol, IrType $irReferenceType, int startOffset, int endOffset) {
        IrSimpleFunction irAdapterFun = this$0.generateFunInterfaceConstructorAdapter(startOffset, endOffset, $callableSymbol, $irReferenceType);
        IrFunctionReferenceImpl irAdapterRef = BuildersKt.IrFunctionReferenceImpl(startOffset, endOffset, $irReferenceType, irAdapterFun.getSymbol(), irAdapterFun.getTypeParameters().size(), irAdapterFun.getSymbol(), IrStatementOrigin.Companion.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE());
        Object[] objectArray = new IrElement[]{irAdapterFun, irAdapterRef};
        return BuildersKt.IrBlockImpl(startOffset, endOffset, $irReferenceType, IrStatementOrigin.Companion.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE(), CollectionsKt.listOf((Object[])objectArray));
    }
}

