/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirCollectionLiteral;
import org.jetbrains.kotlin.fir.expressions.FirDesugaredAssignmentValueReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.TransformData;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00f8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aE\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u0001H\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\u001a\u0018\u00100\u001a\u0002012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u00102\u001a\u000203\u001a$\u00104\u001a\u0002052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u00102\u001a\u0002032\n\b\u0002\u00106\u001a\u0004\u0018\u000107\u001a8\u00108\u001a\u000209\"\u0004\b\u0000\u0010:*\u0002092\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H:0<2\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020?\u0012\n\u0012\b\u0012\u0004\u0012\u0002H:0@0>\u001a-\u0010A\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020B*\u0002092\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020B0>\u00a2\u0006\u0002\u0010D\u001a\n\u0010E\u001a\u00020\n*\u00020\n\u001a\n\u0010F\u001a\u00020\n*\u00020\n\u001a\u0018\u0010G\u001a\b\u0012\u0004\u0012\u00020\n0\u0019*\u00020\n2\u0006\u0010H\u001a\u00020'\u001a\"\u0010I\u001a\u00020J*\u00020\n2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\n0L2\u0006\u0010H\u001a\u00020'H\u0002\u001a\f\u0010X\u001a\u0004\u0018\u00010Y*\u00020N\u001a\n\u0010Z\u001a\u00020\n*\u00020\n\u001a\n\u0010^\u001a\u00020\n*\u00020\n\u001a\n\u0010_\u001a\u00020\n*\u00020\n\u001a*\u0010n\u001a\u00020J*\u00020(2\u0018\u0010o\u001a\u0014\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u00020r\u0012\u0004\u0012\u00020J0pH\u0086\b\u00f8\u0001\u0000\u001a\u000f\u0010s\u001a\u0004\u0018\u00010t*\u00020\nH\u0086\u0010\"\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0016\u0010\u001d\u001a\u00020\n*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0018\u0010 \u001a\u0004\u0018\u00010!*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u001e\u0010$\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0019*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001c\"\u0016\u0010&\u001a\u00020'*\u00020(8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b&\u0010)\"6\u0010*\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020,\u0018\u00010+j\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020,\u0018\u0001`-*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0017\u0010M\u001a\u0004\u0018\u00010\n*\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\"\u0017\u0010Q\u001a\u0004\u0018\u00010\n*\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010P\"\u0017\u0010S\u001a\u0004\u0018\u00010\n*\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010P\"\u001b\u0010U\u001a\b\u0012\u0004\u0012\u00020\n0\u0019*\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010W\"\u0015\u0010[\u001a\u00020'*\u00020\\8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010]\"\u0017\u0010`\u001a\u0004\u0018\u00010a*\u00020b8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010d\"\u0017\u0010e\u001a\u0004\u0018\u00010\n*\u00020b8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010g\"\u0015\u0010h\u001a\u00020'*\u00020i8F\u00a2\u0006\u0006\u001a\u0004\bh\u0010j\"\u001b\u0010k\u001a\b\u0012\u0004\u0012\u00020\n0\u0019*\u00020Y8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010m\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006u"}, d2={"unexpandedConeClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "getUnexpandedConeClassLikeType", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "unexpandedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "getUnexpandedClassId", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Lorg/jetbrains/kotlin/name/ClassId;", "buildConstOrErrorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "T", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "kind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "literalType", "", "literalValue", "", "diagnosticKind", "Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;", "(Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/types/ConstantValueKind;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "arguments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "getArguments", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Ljava/util/List;", "argument", "getArgument", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "dynamicVararg", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "getDynamicVararg", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "dynamicVarargArguments", "getDynamicVarargArguments", "isCalleeDynamic", "", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "resolvedArgumentMapping", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "getResolvedArgumentMapping", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Ljava/util/LinkedHashMap;", "buildErrorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "buildErrorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "transformStatementsIndexed", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "D", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "dataProducer", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/visitors/TransformData;", "replaceFirstStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "factory", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "unwrapErrorExpression", "unwrapArgument", "unwrapAndFlattenArgument", "flattenArrays", "unwrapAndFlattenArgumentTo", "", "list", "", "explicitReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "getExplicitReceiver", "(Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "dispatchReceiver", "getDispatchReceiver", "extensionReceiver", "getExtensionReceiver", "contextArguments", "getContextArguments", "(Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)Ljava/util/List;", "unwrapLValue", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "unwrapExpression", "isImplicitWhenSubjectVariable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "(Lorg/jetbrains/kotlin/fir/declarations/FirVariable;)Z", "unwrapSmartcastExpression", "unwrapDesugaredAssignmentValueRef", "whenSubjectVariable", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenSubjectExpression;", "getWhenSubjectVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenSubjectExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "whenSubject", "getWhenSubject", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenSubjectExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isBound", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "(Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;)Z", "allReceiverExpressions", "getAllReceiverExpressions", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Ljava/util/List;", "forAllReifiedTypeParameters", "block", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjectionWithVariance;", "unwrapAnonymousFunctionExpression", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "tree"})
@SourceDebugExtension(value={"SMAP\nFirExpressionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 2 FirErrorExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirErrorExpressionBuilderKt\n+ 3 FirErrorLoopBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirErrorLoopBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirTransformerUtil.kt\norg/jetbrains/kotlin/fir/visitors/FirTransformerUtilKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,214:1\n36#1:215\n57#1:217\n62#1:218\n57#1:219\n57#1:237\n59#1:242\n58#2:216\n58#2:221\n47#3:220\n1#4:222\n37#5,14:223\n1915#6,2:238\n1915#6,2:240\n28#7:243\n*S KotlinDebug\n*F\n+ 1 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n39#1:215\n62#1:217\n65#1:218\n65#1:219\n129#1:237\n157#1:242\n51#1:216\n90#1:221\n77#1:220\n100#1:223,14\n129#1:238,2\n134#1:240,2\n190#1:243\n*E\n"})
public final class FirExpressionUtilKt {
    @Nullable
    public static final ConeClassLikeType getUnexpandedConeClassLikeType(@NotNull FirAnnotation $this$unexpandedConeClassLikeType) {
        Intrinsics.checkNotNullParameter((Object)$this$unexpandedConeClassLikeType, (String)"<this>");
        boolean $i$f$getUnexpandedConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        return coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
    }

    @Nullable
    public static final ClassId getUnexpandedClassId(@NotNull FirAnnotation $this$unexpandedClassId) {
        Intrinsics.checkNotNullParameter((Object)$this$unexpandedClassId, (String)"<this>");
        boolean $i$f$getUnexpandedClassId = false;
        FirAnnotation $this$unexpandedConeClassLikeType$iv = $this$unexpandedClassId;
        boolean $i$f$getUnexpandedConeClassLikeType = false;
        FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType$iv.getAnnotationTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        Object object = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        return object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final <T> FirExpression buildConstOrErrorExpression(@Nullable KtSourceElement source, @NotNull ConstantValueKind kind, @Nullable T value2, @NotNull String literalType, @NotNull Object literalValue, @NotNull DiagnosticKind diagnosticKind) {
        FirErrorExpressionBuilder firErrorExpressionBuilder;
        FirExpression firExpression;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)literalType, (String)"literalType");
        Intrinsics.checkNotNullParameter((Object)literalValue, (String)"literalValue");
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticKind), (String)"diagnosticKind");
        Object object = value2;
        if (object != null) {
            T it = object;
            boolean bl = false;
            FirLiteralExpression firLiteralExpression = FirConstExpressionBuilderKt.buildLiteralExpression$default(source, kind, it, null, false, null, 40, null);
            object = firLiteralExpression;
            if (firLiteralExpression != null) {
                firExpression = (FirExpression)object;
                return firExpression;
            }
        }
        boolean $i$f$buildErrorExpression = false;
        FirErrorExpressionBuilder $this$buildConstOrErrorExpression_u24lambda_u241 = firErrorExpressionBuilder = new FirErrorExpressionBuilder();
        boolean bl = false;
        $this$buildConstOrErrorExpression_u24lambda_u241.setSource(source);
        $this$buildConstOrErrorExpression_u24lambda_u241.setDiagnostic(new ConeSimpleDiagnostic("Incorrect " + literalType + ": " + literalValue, diagnosticKind));
        firExpression = firErrorExpressionBuilder.build();
        return firExpression;
    }

    @NotNull
    public static final List<FirExpression> getArguments(@NotNull FirCall $this$arguments) {
        Intrinsics.checkNotNullParameter((Object)$this$arguments, (String)"<this>");
        boolean $i$f$getArguments = false;
        return $this$arguments.getArgumentList().getArguments();
    }

    @NotNull
    public static final FirExpression getArgument(@NotNull FirCall $this$argument) {
        Intrinsics.checkNotNullParameter((Object)$this$argument, (String)"<this>");
        boolean $i$f$getArgument = false;
        return (FirExpression)kotlin.collections.CollectionsKt.first($this$argument.getArgumentList().getArguments());
    }

    @Nullable
    public static final FirVarargArgumentsExpression getDynamicVararg(@NotNull FirCall $this$dynamicVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$dynamicVararg, (String)"<this>");
        boolean $i$f$getDynamicVararg = false;
        FirCall $this$arguments$iv = $this$dynamicVararg;
        boolean $i$f$getArguments = false;
        Object object = kotlin.collections.CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        return object instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)object : null;
    }

    @Nullable
    public static final List<FirExpression> getDynamicVarargArguments(@NotNull FirCall $this$dynamicVarargArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$dynamicVarargArguments, (String)"<this>");
        boolean $i$f$getDynamicVarargArguments = false;
        FirCall $this$dynamicVararg$iv = $this$dynamicVarargArguments;
        boolean $i$f$getDynamicVararg = false;
        FirCall $this$arguments$iv$iv = $this$dynamicVararg$iv;
        boolean $i$f$getArguments = false;
        Object object = kotlin.collections.CollectionsKt.firstOrNull($this$arguments$iv$iv.getArgumentList().getArguments());
        FirVarargArgumentsExpression firVarargArgumentsExpression = object instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)object : null;
        return firVarargArgumentsExpression != null ? firVarargArgumentsExpression.getArguments() : null;
    }

    public static final boolean isCalleeDynamic(@NotNull FirFunctionCall $this$isCalleeDynamic) {
        Intrinsics.checkNotNullParameter((Object)$this$isCalleeDynamic, (String)"<this>");
        boolean $i$f$isCalleeDynamic = false;
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$isCalleeDynamic.getCalleeReference(), false, 1, null);
        return Intrinsics.areEqual((Object)(firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getOrigin() : null), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE);
    }

    @Nullable
    public static final LinkedHashMap<FirExpression, FirValueParameter> getResolvedArgumentMapping(@NotNull FirCall $this$resolvedArgumentMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvedArgumentMapping, (String)"<this>");
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList = $this$resolvedArgumentMapping.getArgumentList();
        return argumentList instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList).getMapping() : null;
    }

    @NotNull
    public static final FirErrorLoop buildErrorLoop(@Nullable KtSourceElement source, @NotNull ConeDiagnostic diagnostic) {
        FirErrorLoop firErrorLoop;
        FirErrorLoopBuilder firErrorLoopBuilder;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        boolean $i$f$buildErrorLoop = false;
        FirErrorLoopBuilder $this$buildErrorLoop_u24lambda_u240 = firErrorLoopBuilder = new FirErrorLoopBuilder();
        boolean bl = false;
        $this$buildErrorLoop_u24lambda_u240.setSource(source);
        $this$buildErrorLoop_u24lambda_u240.setDiagnostic(diagnostic);
        FirErrorLoop it = firErrorLoop = firErrorLoopBuilder.build();
        boolean bl2 = false;
        it.getBlock().replaceConeTypeOrNull(new ConeErrorType(diagnostic, false, null, null, null, null, null, 126, null));
        return firErrorLoop;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirErrorExpression buildErrorExpression(@Nullable KtSourceElement source, @NotNull ConeDiagnostic diagnostic, @Nullable FirElement element) {
        void it;
        FirElement firElement;
        FirErrorExpressionBuilder firErrorExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        boolean $i$f$buildErrorExpression = false;
        FirErrorExpressionBuilder $this$buildErrorExpression_u24lambda_u240 = firErrorExpressionBuilder = new FirErrorExpressionBuilder();
        boolean bl = false;
        $this$buildErrorExpression_u24lambda_u240.setSource(source);
        $this$buildErrorExpression_u24lambda_u240.setDiagnostic(diagnostic);
        $this$buildErrorExpression_u24lambda_u240.setExpression(element instanceof FirExpression ? (FirExpression)element : null);
        FirElement firElement2 = firElement = element;
        FirErrorExpressionBuilder firErrorExpressionBuilder2 = $this$buildErrorExpression_u24lambda_u240;
        boolean bl2 = false;
        firErrorExpressionBuilder2.setNonExpressionElement(Boolean.valueOf(it instanceof FirExpression) == false ? firElement : null);
        return firErrorExpressionBuilder.build();
    }

    public static /* synthetic */ FirErrorExpression buildErrorExpression$default(KtSourceElement ktSourceElement, ConeDiagnostic coneDiagnostic, FirElement firElement, int n, Object object) {
        if ((n & 4) != 0) {
            firElement = null;
        }
        return FirExpressionUtilKt.buildErrorExpression(ktSourceElement, coneDiagnostic, firElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D> FirBlock transformStatementsIndexed(@NotNull FirBlock $this$transformStatementsIndexed, @NotNull FirTransformer<? super D> transformer2, @NotNull Function1<? super Integer, ? extends TransformData<? extends D>> dataProducer) {
        block4: {
            FirBlock firBlock;
            block3: {
                void $this$transformInplace$iv;
                Intrinsics.checkNotNullParameter((Object)$this$transformStatementsIndexed, (String)"<this>");
                Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
                Intrinsics.checkNotNullParameter(dataProducer, (String)"dataProducer");
                firBlock = $this$transformStatementsIndexed;
                if (!(firBlock instanceof FirBlockImpl)) break block3;
                List<FirStatement> list = ((FirBlockImpl)$this$transformStatementsIndexed).getStatements();
                FirTransformer<? super D> transformer$iv = transformer2;
                boolean $i$f$transformInplace = false;
                ListIterator iterator$iv = $this$transformInplace$iv.listIterator();
                int index$iv = 0;
                while (iterator$iv.hasNext()) {
                    Object e = iterator$iv.next();
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirPureAbstractElement");
                    FirPureAbstractElement next$iv = (FirPureAbstractElement)e;
                    TransformData data$iv = (TransformData)dataProducer.invoke((Object)index$iv++);
                    if (!(data$iv instanceof TransformData.Data)) {
                        if (Intrinsics.areEqual((Object)data$iv, (Object)TransformData.Nothing.INSTANCE)) continue;
                        throw new NoWhenBranchMatchedException();
                    }
                    Object data$iv2 = ((TransformData.Data)data$iv).getValue();
                    Object result$iv = next$iv.transform(transformer$iv, data$iv2);
                    if (result$iv == next$iv) continue;
                    iterator$iv.set(result$iv);
                }
                break block4;
            }
            if (!(firBlock instanceof FirSingleExpressionBlock)) break block4;
            Object object = dataProducer.invoke((Object)0);
            TransformData.Data data = object instanceof TransformData.Data ? (TransformData.Data)object : null;
            if (data != null && (data = data.getValue()) != null) {
                TransformData.Data it = data;
                boolean bl = false;
                ((FirSingleExpressionBlock)$this$transformStatementsIndexed).transformStatements(transformer2, it);
            }
        }
        return $this$transformStatementsIndexed;
    }

    @NotNull
    public static final <T extends FirStatement> T replaceFirstStatement(@NotNull FirBlock $this$replaceFirstStatement, @NotNull Function1<? super T, ? extends FirStatement> factory) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceFirstStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        if (!($this$replaceFirstStatement instanceof FirBlockImpl)) {
            boolean bl = false;
            String string = "replaceFirstStatement should not be called for " + Reflection.getOrCreateKotlinClass($this$replaceFirstStatement.getClass()).getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        FirStatement firStatement = ((FirBlockImpl)$this$replaceFirstStatement).getStatements().get(0);
        Intrinsics.checkNotNull((Object)firStatement, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt.replaceFirstStatement");
        FirStatement existing = firStatement;
        ((FirBlockImpl)$this$replaceFirstStatement).getStatements().set(0, (FirStatement)factory.invoke((Object)existing));
        return (T)existing;
    }

    @NotNull
    public static final FirExpression unwrapErrorExpression(@NotNull FirExpression $this$unwrapErrorExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapErrorExpression, (String)"<this>");
        FirExpression firExpression = $this$unwrapErrorExpression instanceof FirErrorExpression ? (FirErrorExpression)$this$unwrapErrorExpression : null;
        if (firExpression == null || (firExpression = firExpression.getExpression()) == null || (firExpression = FirExpressionUtilKt.unwrapErrorExpression(firExpression)) == null) {
            firExpression = $this$unwrapErrorExpression;
        }
        return firExpression;
    }

    @NotNull
    public static final FirExpression unwrapArgument(@NotNull FirExpression $this$unwrapArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapArgument, (String)"<this>");
        FirExpression firExpression = $this$unwrapArgument instanceof FirWrappedArgumentExpression ? (FirWrappedArgumentExpression)$this$unwrapArgument : null;
        if (firExpression == null || (firExpression = firExpression.getExpression()) == null) {
            firExpression = $this$unwrapArgument;
        }
        return firExpression;
    }

    @NotNull
    public static final List<FirExpression> unwrapAndFlattenArgument(@NotNull FirExpression $this$unwrapAndFlattenArgument, boolean flattenArrays) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapAndFlattenArgument, (String)"<this>");
        List $this$unwrapAndFlattenArgument_u24lambda_u240 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        FirExpressionUtilKt.unwrapAndFlattenArgumentTo($this$unwrapAndFlattenArgument, $this$unwrapAndFlattenArgument_u24lambda_u240, flattenArrays);
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final void unwrapAndFlattenArgumentTo(FirExpression $this$unwrapAndFlattenArgumentTo, List<FirExpression> list, boolean flattenArrays) {
        FirExpression unwrapped = FirExpressionUtilKt.unwrapArgument($this$unwrapAndFlattenArgumentTo);
        if (unwrapped instanceof FirCollectionLiteral || unwrapped instanceof FirFunctionCall) {
            if (flattenArrays) {
                void $this$forEach$iv;
                Object $this$arguments$iv = (FirCall)((Object)unwrapped);
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl = false;
                    FirExpressionUtilKt.unwrapAndFlattenArgumentTo(it, list, flattenArrays);
                }
            } else {
                list.add(unwrapped);
            }
        } else if (unwrapped instanceof FirVarargArgumentsExpression) {
            Iterable $this$forEach$iv = ((FirVarargArgumentsExpression)unwrapped).getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                FirExpressionUtilKt.unwrapAndFlattenArgumentTo(it, list, flattenArrays);
            }
        } else {
            list.add(unwrapped);
        }
    }

    @Nullable
    public static final FirExpression getExplicitReceiver(@NotNull FirVariableAssignment $this$explicitReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$explicitReceiver, (String)"<this>");
        FirQualifiedAccessExpression firQualifiedAccessExpression = FirExpressionUtilKt.unwrapLValue($this$explicitReceiver);
        return firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getExplicitReceiver() : null;
    }

    @Nullable
    public static final FirExpression getDispatchReceiver(@NotNull FirVariableAssignment $this$dispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$dispatchReceiver, (String)"<this>");
        FirQualifiedAccessExpression firQualifiedAccessExpression = FirExpressionUtilKt.unwrapLValue($this$dispatchReceiver);
        return firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getDispatchReceiver() : null;
    }

    @Nullable
    public static final FirExpression getExtensionReceiver(@NotNull FirVariableAssignment $this$extensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$extensionReceiver, (String)"<this>");
        FirQualifiedAccessExpression firQualifiedAccessExpression = FirExpressionUtilKt.unwrapLValue($this$extensionReceiver);
        return firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getExtensionReceiver() : null;
    }

    @NotNull
    public static final List<FirExpression> getContextArguments(@NotNull FirVariableAssignment $this$contextArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$contextArguments, (String)"<this>");
        Object object = FirExpressionUtilKt.unwrapLValue($this$contextArguments);
        if (object == null || (object = ((FirQualifiedAccessExpression)object).getContextArguments()) == null) {
            object = kotlin.collections.CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final FirQualifiedAccessExpression unwrapLValue(@NotNull FirVariableAssignment $this$unwrapLValue) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapLValue, (String)"<this>");
        FirExpression lValue = $this$unwrapLValue.getLValue();
        FirQualifiedAccessExpression firQualifiedAccessExpression = lValue instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)lValue : null;
        if (firQualifiedAccessExpression == null) {
            Object object = lValue instanceof FirDesugaredAssignmentValueReferenceExpression ? (FirDesugaredAssignmentValueReferenceExpression)lValue : null;
            Object var2_2 = object != null && (object = ((FirDesugaredAssignmentValueReferenceExpression)object).getExpressionRef()) != null ? ((FirExpressionRef)object).getValue() : null;
            firQualifiedAccessExpression = var2_2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)var2_2 : null;
        }
        return firQualifiedAccessExpression;
    }

    @NotNull
    public static final FirExpression unwrapExpression(@NotNull FirExpression $this$unwrapExpression) {
        FirExpression firExpression;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapExpression, (String)"<this>");
        FirExpression firExpression2 = $this$unwrapExpression;
        if (firExpression2 instanceof FirSmartCastExpression) {
            firExpression = FirExpressionUtilKt.unwrapExpression(((FirSmartCastExpression)$this$unwrapExpression).getOriginalExpression());
        } else if (firExpression2 instanceof FirCheckedSafeCallSubject) {
            firExpression = FirExpressionUtilKt.unwrapExpression(((FirCheckedSafeCallSubject)$this$unwrapExpression).getOriginalReceiverRef().getValue());
        } else if (firExpression2 instanceof FirCheckNotNullCall) {
            FirCall $this$argument$iv = (FirCall)((Object)$this$unwrapExpression);
            boolean $i$f$getArgument = false;
            firExpression = FirExpressionUtilKt.unwrapExpression((FirExpression)kotlin.collections.CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
        } else {
            firExpression = firExpression2 instanceof FirDesugaredAssignmentValueReferenceExpression ? FirExpressionUtilKt.unwrapExpression(((FirDesugaredAssignmentValueReferenceExpression)$this$unwrapExpression).getExpressionRef().getValue()) : $this$unwrapExpression;
        }
        return firExpression;
    }

    public static final boolean isImplicitWhenSubjectVariable(@NotNull FirVariable $this$isImplicitWhenSubjectVariable) {
        Intrinsics.checkNotNullParameter((Object)$this$isImplicitWhenSubjectVariable, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isImplicitWhenSubjectVariable.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.ImplicitWhenSubject.INSTANCE);
    }

    @NotNull
    public static final FirExpression unwrapSmartcastExpression(@NotNull FirExpression $this$unwrapSmartcastExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapSmartcastExpression, (String)"<this>");
        return $this$unwrapSmartcastExpression instanceof FirSmartCastExpression ? ((FirSmartCastExpression)$this$unwrapSmartcastExpression).getOriginalExpression() : $this$unwrapSmartcastExpression;
    }

    @NotNull
    public static final FirExpression unwrapDesugaredAssignmentValueRef(@NotNull FirExpression $this$unwrapDesugaredAssignmentValueRef) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapDesugaredAssignmentValueRef, (String)"<this>");
        return $this$unwrapDesugaredAssignmentValueRef instanceof FirDesugaredAssignmentValueReferenceExpression ? ((FirDesugaredAssignmentValueReferenceExpression)$this$unwrapDesugaredAssignmentValueRef).getExpressionRef().getValue() : $this$unwrapDesugaredAssignmentValueRef;
    }

    @Nullable
    public static final FirProperty getWhenSubjectVariable(@NotNull FirWhenSubjectExpression $this$whenSubjectVariable) {
        Intrinsics.checkNotNullParameter((Object)$this$whenSubjectVariable, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = FirReferenceUtilsKt.getSymbol($this$whenSubjectVariable.getCalleeReference());
        FirPropertySymbol firPropertySymbol = firBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null;
        return firPropertySymbol != null ? (FirProperty)firPropertySymbol.getFir() : null;
    }

    @Nullable
    public static final FirExpression getWhenSubject(@NotNull FirWhenSubjectExpression $this$whenSubject) {
        Intrinsics.checkNotNullParameter((Object)$this$whenSubject, (String)"<this>");
        FirProperty firProperty = FirExpressionUtilKt.getWhenSubjectVariable($this$whenSubject);
        return firProperty != null ? firProperty.getInitializer() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBound(@NotNull FirCallableReferenceAccess $this$isBound) {
        Intrinsics.checkNotNullParameter((Object)$this$isBound, (String)"<this>");
        if ($this$isBound.getDispatchReceiver() == null) {
            if ($this$isBound.getExtensionReceiver() == null) return false;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default($this$isBound.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) return true;
        FirCallableSymbol $this$isStatic$iv = firCallableSymbol;
        boolean $i$f$isStatic = false;
        if (!$this$isStatic$iv.getRawStatus().isStatic()) return true;
        return false;
    }

    @NotNull
    public static final List<FirExpression> getAllReceiverExpressions(@NotNull FirQualifiedAccessExpression $this$allReceiverExpressions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$allReceiverExpressions, (String)"<this>");
        List $this$_get_allReceiverExpressions__u24lambda_u240 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionsKt.addIfNotNull($this$_get_allReceiverExpressions__u24lambda_u240, $this$allReceiverExpressions.getDispatchReceiver());
        CollectionsKt.addIfNotNull($this$_get_allReceiverExpressions__u24lambda_u240, $this$allReceiverExpressions.getExtensionReceiver());
        $this$_get_allReceiverExpressions__u24lambda_u240.addAll((Collection)$this$allReceiverExpressions.getContextArguments());
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    public static final void forAllReifiedTypeParameters(@NotNull FirFunctionCall $this$forAllReifiedTypeParameters, @NotNull Function2<? super ConeKotlinType, ? super FirTypeProjectionWithVariance, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$forAllReifiedTypeParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forAllReifiedTypeParameters = false;
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$forAllReifiedTypeParameters.getCalleeReference(), false, 1, null);
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol functionSymbol2 = firNamedFunctionSymbol;
        for (Pair pair : kotlin.collections.CollectionsKt.zip((Iterable)functionSymbol2.getTypeParameterSymbols(), (Iterable)$this$forAllReifiedTypeParameters.getTypeArguments())) {
            ConeKotlinType type;
            FirTypeParameterSymbol typeParameterSymbol = (FirTypeParameterSymbol)pair.component1();
            FirTypeProjection typeArgument = (FirTypeProjection)pair.component2();
            if (!typeParameterSymbol.isReified() || !(typeArgument instanceof FirTypeProjectionWithVariance) || FirTypeUtilsKt.getConeTypeOrNull(((FirTypeProjectionWithVariance)typeArgument).getTypeRef()) == null) continue;
            block.invoke((Object)type, (Object)typeArgument);
        }
    }

    @Nullable
    public static final FirAnonymousFunction unwrapAnonymousFunctionExpression(@NotNull FirExpression $this$unwrapAnonymousFunctionExpression) {
        FirAnonymousFunction firAnonymousFunction;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$unwrapAnonymousFunctionExpression, (String)"<this>");
            while (true) {
                FirExpression firExpression;
                if ((firExpression = $this$unwrapAnonymousFunctionExpression) instanceof FirAnonymousFunctionExpression) {
                    firAnonymousFunction = ((FirAnonymousFunctionExpression)$this$unwrapAnonymousFunctionExpression).getAnonymousFunction();
                    break block2;
                }
                if (!(firExpression instanceof FirWrappedArgumentExpression)) break;
                $this$unwrapAnonymousFunctionExpression = ((FirWrappedArgumentExpression)$this$unwrapAnonymousFunctionExpression).getExpression();
            }
            firAnonymousFunction = null;
        }
        return firAnonymousFunction;
    }
}

