/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferTypeParameterType;
import org.jetbrains.kotlin.fir.resolve.calls.TypeVariableReplacement;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnknownLambdaParameterTypeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/TypeVariableTypeRemovingSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "replacement", "Lorg/jetbrains/kotlin/fir/resolve/calls/TypeVariableReplacement;", "skippedOuterTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;Lorg/jetbrains/kotlin/fir/resolve/calls/TypeVariableReplacement;Ljava/util/Set;)V", "substituteType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "convertTypeVariableType", "Lorg/jetbrains/kotlin/fir/types/ConeTypeVariableType;", "toString", "", "semantics"})
final class TypeVariableTypeRemovingSubstitutor
extends AbstractConeSubstitutor {
    @NotNull
    private final TypeVariableReplacement replacement;
    @Nullable
    private final Set<TypeConstructorMarker> skippedOuterTypeVariables;

    public TypeVariableTypeRemovingSubstitutor(@NotNull ConeTypeContext typeContext2, @NotNull TypeVariableReplacement replacement, @Nullable Set<? extends TypeConstructorMarker> skippedOuterTypeVariables) {
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        Intrinsics.checkNotNullParameter((Object)((Object)replacement), (String)"replacement");
        super(typeContext2);
        this.replacement = replacement;
        this.skippedOuterTypeVariables = skippedOuterTypeVariables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(type instanceof ConeTypeVariableType)) return null;
        Set<TypeConstructorMarker> set = this.skippedOuterTypeVariables;
        if (set != null) {
            if (set.contains(((ConeTypeVariableType)type).getTypeConstructor())) {
                return null;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return null;
        ConeKotlinType coneKotlinType = this.convertTypeVariableType((ConeTypeVariableType)type);
        return coneKotlinType;
    }

    private final ConeKotlinType convertTypeVariableType(ConeTypeVariableType type) {
        TypeParameterMarker originalTypeParameter = type.getTypeConstructor().getOriginalTypeParameter();
        if (originalTypeParameter != null) {
            if (!(originalTypeParameter instanceof ConeTypeParameterLookupTag)) {
                throw new IllegalStateException("Check failed.");
            }
            ConeTypeParameterTypeImpl typeParameterType = new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)originalTypeParameter, type.isMarkedNullable(), type.getAttributes());
            return this.replacement == TypeVariableReplacement.ErrorType ? (ConeKotlinType)new ConeErrorType(new ConeCannotInferTypeParameterType(((ConeTypeParameterLookupTag)originalTypeParameter).getTypeParameterSymbol(), null, 2, null), true, typeParameterType, null, null, null, null, 120, null) : (ConeKotlinType)typeParameterType;
        }
        return new ConeErrorType(new ConeUnknownLambdaParameterTypeDiagnostic(Intrinsics.areEqual((Object)type.getTypeConstructor().getDebugName(), (Object)"_R")), false, null, null, null, null, null, 126, null);
    }

    @NotNull
    public String toString() {
        return "{<Type variable> -> <Error type>}";
    }
}

