/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtomWithSingleChild;
import org.jetbrains.kotlin.fir.resolve.calls.ManyLambdaExpressionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameForAmbiguousParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ForbiddenNamedArgumentsTarget;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001SB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001503J\u0018\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u000bH\u0002J\u0018\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u000bH\u0002J\u0018\u00109\u001a\u0002012\u0006\u00105\u001a\u00020:2\u0006\u00108\u001a\u00020;H\u0002J\u000e\u0010<\u001a\u0002012\u0006\u0010=\u001a\u00020\u0015J\u0014\u0010>\u001a\u0002012\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001503J\u0006\u0010@\u001a\u000201J\b\u0010A\u001a\u000201H\u0002J\u0010\u0010B\u001a\u0002012\u0006\u00108\u001a\u00020\u0015H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00192\u0006\u0010D\u001a\u00020\u0018H\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010\u00192\u0006\u00108\u001a\u00020;H\u0002J\u0010\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR.\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00142\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R9\u0010$\u001a*\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150&0%j\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150&`'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010*\u001a\u0004\u0018\u00010+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b,\u0010-R\u0018\u0010H\u001a\u00020\u000b*\u00020I8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010JR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0019038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010#R\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001903X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010N\u001a\b\u0012\u0004\u0012\u00020O03*\u0006\u0012\u0002\b\u00030P8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor;", "", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "isIndexedSetOperator", "", "lookInContextParameters", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;ZZ)V", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "currentPositionedParameterIndex", "", "varargArguments", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "namedDynamicArgumentsNamesImpl", "", "namedDynamicArgumentsNames", "getNamedDynamicArgumentsNames", "()Ljava/util/Set;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "result", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "forbiddenNamedArgumentsTarget", "Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "getForbiddenNamedArgumentsTarget", "()Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget$delegate", "Lkotlin/Lazy;", "processNonLambdaArguments", "", "arguments", "", "processNonLambdaArgument", "atom", "isLastArgument", "processPositionArgument", "argument", "processNamedArgument", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtomWithSingleChild;", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "processExternalArgument", "externalArgument", "processExcessLambdaArguments", "excessLambdaArguments", "processDefaultsAndRunChecks", "completeVarargPositionArguments", "addVarargArgument", "getParameterByName", "name", "findParameterByName", "addDiagnostic", "diagnostic", "isSpread", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "valueParameters", "getValueParameters", "valueAndContextParametersIfRequired", "valueAndContextParameterSymbolsIfRequired", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "getValueAndContextParameterSymbolsIfRequired", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Ljava/util/List;", "State", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,472:1\n1#2:473\n1915#3,2:474\n349#3,8:487\n363#3,7:495\n81#4,7:476\n76#4,2:483\n57#4:485\n78#4:486\n*S KotlinDebug\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor\n*L\n281#1:474,2\n435#1:487,8\n408#1:495,7\n288#1:476,7\n288#1:483,2\n288#1:485\n288#1:486\n*E\n"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final FirFunction function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    private final boolean isIndexedSetOperator;
    private final boolean lookInContextParameters;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<ConeResolutionAtom> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private Set<Name> namedDynamicArgumentsNamesImpl;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> result;
    @NotNull
    private final Lazy forbiddenNamedArgumentsTarget$delegate;
    @NotNull
    private final List<FirValueParameter> valueAndContextParametersIfRequired;

    public FirCallArgumentsProcessor(@NotNull FirSession useSiteSession, @NotNull FirFunction function2, @NotNull BodyResolveComponents bodyResolveComponents, @Nullable FirScope originScope, boolean isIndexedSetOperator, boolean lookInContextParameters) {
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.useSiteSession = useSiteSession;
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents;
        this.originScope = originScope;
        this.isIndexedSetOperator = isIndexedSetOperator;
        this.lookInContextParameters = lookInContextParameters;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
        this.forbiddenNamedArgumentsTarget$delegate = LazyKt.lazy(() -> FirCallArgumentsProcessor.forbiddenNamedArgumentsTarget_delegate$lambda$0(this));
        this.valueAndContextParametersIfRequired = this.lookInContextParameters ? CollectionsKt.plus((Collection)this.getValueParameters(), (Iterable)this.function.getContextParameters()) : this.getValueParameters();
    }

    private final Set<Name> getNamedDynamicArgumentsNames() {
        Set set = this.namedDynamicArgumentsNamesImpl;
        if (set == null) {
            Set set2;
            Set it = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            this.namedDynamicArgumentsNamesImpl = it;
            set = set2;
        }
        return set;
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> getResult() {
        return this.result;
    }

    @Nullable
    public final ForbiddenNamedArgumentsTarget getForbiddenNamedArgumentsTarget() {
        Lazy lazy = this.forbiddenNamedArgumentsTarget$delegate;
        return (ForbiddenNamedArgumentsTarget)((Object)lazy.getValue());
    }

    public final void processNonLambdaArguments(@NotNull List<? extends ConeResolutionAtom> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Iterator iterator2 = ((Iterable)arguments).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int argumentIndex = n++;
            ConeResolutionAtom argument = (ConeResolutionAtom)iterator2.next();
            this.processNonLambdaArgument(argument, argumentIndex == CollectionsKt.getLastIndex(arguments));
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final void processNonLambdaArgument(ConeResolutionAtom atom, boolean isLastArgument) {
        FirExpression argument = atom.getExpression();
        if (!(argument instanceof FirNamedArgumentExpression)) {
            if (this.state == State.VARARG_POSITION && this.isIndexedSetOperator && isLastArgument) {
                this.completeVarargPositionArguments();
            }
            this.processPositionArgument(atom, isLastArgument);
            return;
        }
        if (!(atom instanceof ConeResolutionAtomWithSingleChild)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((ConeResolutionAtomWithSingleChild)atom).getSubAtom() == null) {
            boolean bl = false;
            String string = "SubAtom of named argument is null";
            throw new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            this.processPositionArgument(((ConeResolutionAtomWithSingleChild)atom).getSubAtom(), isLastArgument);
            if (!this.getNamedDynamicArgumentsNames().add(((FirNamedArgumentExpression)argument).getName())) {
                this.addDiagnostic(new ArgumentPassedTwice((FirNamedArgumentExpression)argument));
            }
        } else {
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument((ConeResolutionAtomWithSingleChild)atom, (FirNamedArgumentExpression)argument);
        }
    }

    private final void processPositionArgument(ConeResolutionAtom argument, boolean isLastArgument) {
        int n;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument.getExpression()));
            return;
        }
        if (this.isIndexedSetOperator) {
            int lastParameterIndex = CollectionsKt.getLastIndex(this.getValueParameters());
            n = isLastArgument ? lastParameterIndex : (this.currentPositionedParameterIndex >= lastParameterIndex ? -1 : this.currentPositionedParameterIndex);
        } else {
            n = this.currentPositionedParameterIndex;
        }
        int assignedParameterIndex = n;
        FirValueParameter parameter = (FirValueParameter)CollectionsKt.getOrNull(this.getValueParameters(), (int)assignedParameterIndex);
        if (parameter == null) {
            this.addDiagnostic(new TooManyArguments(argument.getExpression(), this.function));
            return;
        }
        if (!parameter.isVararg()) {
            int n2 = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n2 + 1;
            ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(argument));
            this.state = State.POSITION_ARGUMENTS;
        } else {
            this.addVarargArgument(argument);
            this.state = State.VARARG_POSITION;
        }
    }

    private final void processNamedArgument(ConeResolutionAtomWithSingleChild atom, FirNamedArgumentExpression argument) {
        ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget = this.getForbiddenNamedArgumentsTarget();
        if (forbiddenNamedArgumentsTarget != null) {
            ForbiddenNamedArgumentsTarget it = forbiddenNamedArgumentsTarget;
            boolean bl = false;
            this.addDiagnostic(new NamedArgumentNotAllowed(atom.getExpression(), this.function, it));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        FirValueParameter firValueParameter = this.findParameterByName(argument);
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter parameter = firValueParameter;
        ResolvedCallArgument<ConeResolutionAtom> resolvedCallArgument = this.result.get(parameter);
        if (resolvedCallArgument != null) {
            ResolvedCallArgument<ConeResolutionAtom> it = resolvedCallArgument;
            boolean bl = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument));
            return;
        }
        ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtomWithSingleChild>(atom));
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)CollectionsKt.getOrNull(this.getValueParameters(), (int)this.currentPositionedParameterIndex), (Object)parameter)) {
            this.state = State.POSITION_ARGUMENTS;
            int n = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull ConeResolutionAtom externalArgument) {
        Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
        FirExpression argumentExpression = externalArgument.getExpression();
        FirValueParameter lastParameter = (FirValueParameter)CollectionsKt.lastOrNull(this.getValueParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(argumentExpression, this.function));
            return;
        }
        if (!Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            if (lastParameter.isVararg()) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(argumentExpression, lastParameter));
                return;
            }
            ResolvedCallArgument<ConeResolutionAtom> previousOccurrence = this.result.get(lastParameter);
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(argumentExpression, this.function));
                return;
            }
            ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(externalArgument));
        } else {
            ResolvedCallArgument<ConeResolutionAtom> existing = this.result.get(lastParameter);
            if (existing == null) {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(externalArgument));
            } else {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.plus((Collection)existing.getArguments(), (Object)externalArgument)));
            }
        }
    }

    public final void processExcessLambdaArguments(@NotNull List<? extends ConeResolutionAtom> excessLambdaArguments) {
        Intrinsics.checkNotNullParameter(excessLambdaArguments, (String)"excessLambdaArguments");
        Iterable $this$forEach$iv = excessLambdaArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeResolutionAtom arg = (ConeResolutionAtom)element$iv;
            boolean bl = false;
            this.addDiagnostic(new ManyLambdaExpressionArguments(arg.getExpression()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processDefaultsAndRunChecks() {
        for (Map.Entry entry : ((Map)this.result).entrySet()) {
            FirValueParameter parameter = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            if (parameter.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                void $this$buildAttachment$iv$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                void cause$iv$iv;
                void message$iv$iv;
                String message$iv = "Incorrect resolved argument for parameter " + parameter.getClass() + ": " + resolvedArgument.getClass();
                Object cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                String string = message$iv;
                Object var10_12 = cause$iv;
                String attachmentName$iv$iv = attachmentName$iv;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv$iv;
                String name$iv$iv$iv = attachmentName$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = name$iv$iv$iv;
                void var20_22 = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$processDefaultsAndRunChecks_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$processDefaultsAndRunChecks_u24lambda_u240, "parameter", parameter);
                $this$processDefaultsAndRunChecks_u24lambda_u240.withEntryGroup("arguments", (Function1<? super ExceptionAttachmentBuilder, Unit>)((Function1)arg_0 -> FirCallArgumentsProcessor.processDefaultsAndRunChecks$lambda$0$0(resolvedArgument, arg_0)));
                var20_22.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            if (!this.isSpread(((ConeResolutionAtom)((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()).getExpression())) continue;
            this.addDiagnostic(new NonVarargSpread(((ConeResolutionAtom)((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()).getExpression()));
        }
        Iterator iterator2 = ((Iterable)this.getValueParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Map.Entry entry = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
            FirValueParameter parameter = (FirValueParameter)((Object)entry);
            if (this.result.containsKey(parameter)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(this.useSiteSession, this.bodyResolveComponents.getScopeSession(), this.function, this.originScope, index)) {
                ((Map)this.result).put(parameter, ResolvedCallArgument.DefaultArgument.INSTANCE);
                continue;
            }
            if (parameter.isVararg()) {
                ((Map)this.result).put(parameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl;
        boolean bl2 = bl = this.state == State.VARARG_POSITION;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Incorrect state: " + (Object)((Object)this.state);
            throw new AssertionError((Object)string);
        }
        FirValueParameter parameter = this.getValueParameters().get(this.currentPositionedParameterIndex);
        Map map = this.result;
        List<ConeResolutionAtom> list = this.varargArguments;
        Intrinsics.checkNotNull(list);
        map.put(parameter, new ResolvedCallArgument.VarargArgument<ConeResolutionAtom>(list));
    }

    private final void addVarargArgument(ConeResolutionAtom argument) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<ConeResolutionAtom> list = this.varargArguments;
        Intrinsics.checkNotNull(list);
        list.add(argument);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name2) {
        if (this.nameToParameter == null) {
            if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden(this.function) && this.getForbiddenNamedArgumentsTarget() == null) {
                FirNamedFunctionSymbol symbol;
                FirCallableSymbol firCallableSymbol = this.function.getSymbol();
                FirNamedFunctionSymbol firNamedFunctionSymbol = symbol = firCallableSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firCallableSymbol : null;
                if (symbol != null) {
                    FirScope firScope = this.originScope;
                    FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                    if (firTypeScope != null) {
                        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.getParameterByName$lambda$0(this, arg_0)));
                    }
                }
                if (this.nameToParameter == null) {
                    this.nameToParameter = MapsKt.emptyMap();
                }
            } else {
                LinkedHashMap linkedHashMap;
                LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
                FirCallArgumentsProcessor firCallArgumentsProcessor = this;
                boolean bl = false;
                for (FirValueParameter parameter : this.valueAndContextParametersIfRequired) {
                    void $this$getParameterByName_u24lambda_u241;
                    Object name3;
                    Object object = FirTypeUtilsKt.getConeTypeOrNull(parameter.getReturnTypeRef());
                    if (object == null || (object = FunctionalTypeUtilsKt.valueParameterName((ConeKotlinType)object, this.useSiteSession)) == null) {
                        object = parameter.getName();
                    }
                    if (((Name)(name3 = object)).isSpecial()) continue;
                    ((Map)$this$getParameterByName_u24lambda_u241).put(name3, parameter);
                }
                firCallArgumentsProcessor.nameToParameter = linkedHashMap;
            }
        }
        Map<Name, ? extends FirValueParameter> map = this.nameToParameter;
        Intrinsics.checkNotNull(map);
        return map.get(name2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter findParameterByName(FirNamedArgumentExpression argument) {
        Ref.ObjectRef parameter;
        block9: {
            int n;
            int n2;
            Ref.IntRef matchedIndex;
            FirNamedFunctionSymbol symbol;
            block7: {
                void $this$indexOfFirst$iv;
                block8: {
                    parameter = new Ref.ObjectRef();
                    parameter.element = this.getParameterByName(argument.getName());
                    FirCallableSymbol firCallableSymbol = this.function.getSymbol();
                    symbol = firCallableSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firCallableSymbol : null;
                    matchedIndex = new Ref.IntRef();
                    matchedIndex.element = -1;
                    if (parameter.element != null) break block8;
                    if (symbol != null && (ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) || DeclarationUtilsKt.isJavaOrEnhancement(this.function))) {
                        Ref.ObjectRef allowedParameters = new Ref.ObjectRef();
                        FirScope firScope = this.originScope;
                        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                        if (firTypeScope != null) {
                            FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$0(this, matchedIndex, parameter, allowedParameters, argument, arg_0)));
                        }
                    }
                    if (parameter.element != null) break block9;
                    this.addDiagnostic(new NameNotFound(argument, this.function));
                    break block9;
                }
                if (symbol == null || !ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) && !DeclarationUtilsKt.isJavaOrEnhancement(this.function)) break block9;
                Map<Name, ? extends FirValueParameter> map = this.nameToParameter;
                Intrinsics.checkNotNull(map);
                Iterable allowedParameters = map.entrySet();
                Ref.IntRef intRef = matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Map.Entry it = (Map.Entry)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getKey(), (Object)argument.getName())) {
                        n2 = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if (matchedIndex.element != -1) {
                FirScope firScope = this.originScope;
                FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                if (firTypeScope != null) {
                    FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$2(this, matchedIndex, argument, arg_0)));
                }
            }
        }
        return (FirValueParameter)parameter.element;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list = this.diagnostics;
        Intrinsics.checkNotNull(list);
        list.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirWrappedArgumentExpression ? ((FirWrappedArgumentExpression)$this$isSpread).isSpread() : false;
    }

    private final List<FirValueParameter> getValueParameters() {
        return this.function.getValueParameters();
    }

    private final List<FirValueParameterSymbol> getValueAndContextParameterSymbolsIfRequired(FirFunctionSymbol<?> $this$valueAndContextParameterSymbolsIfRequired) {
        return this.lookInContextParameters ? CollectionsKt.plus((Collection)$this$valueAndContextParameterSymbolsIfRequired.getValueParameterSymbols(), (Iterable)$this$valueAndContextParameterSymbolsIfRequired.getContextParameterSymbols()) : $this$valueAndContextParameterSymbolsIfRequired.getValueParameterSymbols();
    }

    private static final ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget_delegate$lambda$0(FirCallArgumentsProcessor this$0) {
        FirScope firScope = this$0.originScope;
        return ResolveUtilsKt.forbiddenNamedArgumentsTargetOrNull(this$0.function, firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null);
    }

    private static final Unit processDefaultsAndRunChecks$lambda$0$0(ResolvedCallArgument $resolvedArgument, ExceptionAttachmentBuilder $this$withEntryGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$withEntryGroup, (String)"$this$withEntryGroup");
        Iterator iterator2 = ((Iterable)$resolvedArgument.getArguments()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            ConeResolutionAtom argument = (ConeResolutionAtom)iterator2.next();
            FirExceptionUtilsKt.withFirEntry($this$withEntryGroup, "argument" + index, argument.getExpression());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction getParameterByName$lambda$0(FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol overrideSymbol) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)overrideSymbol, (String)"overrideSymbol");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)overrideSymbol.getFir())) {
            return ProcessorAction.NEXT;
        }
        LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
        FirCallArgumentsProcessor firCallArgumentsProcessor = this$0;
        boolean bl = false;
        Iterator iterator2 = ((Iterable)this$0.valueAndContextParametersIfRequired).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$getParameterByName_u24lambda_u240_u240;
            int i = n++;
            Object t = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            FirValueParameter p = (FirValueParameter)t;
            Name name2 = this$0.getValueAndContextParameterSymbolsIfRequired(overrideSymbol).get(i).getName();
            if (name2.isSpecial()) continue;
            ((Map)$this$getParameterByName_u24lambda_u240_u240).put(name2, p);
        }
        firCallArgumentsProcessor.nameToParameter = linkedHashMap;
        return ProcessorAction.STOP;
    }

    private static final ProcessorAction findParameterByName$findAndReportValueParameterWithDifferentName(List<FirValueParameterSymbol> $this$findParameterByName_u24findAndReportValueParameterWithDifferentName, Ref.IntRef matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0) {
        Name someName;
        Object object = (FirValueParameterSymbol)CollectionsKt.getOrNull($this$findParameterByName_u24findAndReportValueParameterWithDifferentName, (int)matchedIndex.element);
        Name name2 = object != null && (object = (FirValueParameter)((FirBasedSymbol)object).getFir()) != null ? ((FirValueParameter)object).getName() : (someName = null);
        if (someName != null && !someName.isSpecial() && !Intrinsics.areEqual((Object)someName, (Object)$argument.getName())) {
            this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction findParameterByName$lambda$0(FirCallArgumentsProcessor this$0, Ref.IntRef $matchedIndex, Ref.ObjectRef $parameter, Ref.ObjectRef $allowedParameters, FirNamedArgumentExpression $argument, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        List<FirValueParameterSymbol> someParameterSymbols = this$0.getValueAndContextParameterSymbolsIfRequired(it);
        if ($matchedIndex.element != -1) {
            processorAction = FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(someParameterSymbols, $matchedIndex, $argument, this$0);
        } else {
            int n;
            int n2;
            block9: {
                void $this$indexOfFirst$iv;
                List<FirValueParameterSymbol> list = someParameterSymbols;
                Ref.IntRef intRef = $matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FirValueParameterSymbol originalParameter = (FirValueParameterSymbol)item$iv;
                    boolean bl = false;
                    if (!originalParameter.getName().isSpecial() && Intrinsics.areEqual((Object)originalParameter.getName(), (Object)$argument.getName())) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if ($matchedIndex.element != -1) {
                FirValueParameter someParameter;
                $parameter.element = this$0.valueAndContextParametersIfRequired.get($matchedIndex.element);
                Object object = (List)$allowedParameters.element;
                FirValueParameter firValueParameter = object != null && (object = (FirValueParameterSymbol)CollectionsKt.getOrNull((List)object, (int)$matchedIndex.element)) != null ? (FirValueParameter)((FirBasedSymbol)object).getFir() : (someParameter = null);
                if (someParameter != null) {
                    this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
            } else {
                $allowedParameters.element = someParameterSymbols;
                processorAction = ProcessorAction.NEXT;
            }
        }
        return processorAction;
    }

    private static final ProcessorAction findParameterByName$lambda$2(FirCallArgumentsProcessor this$0, Ref.IntRef $matchedIndex, FirNamedArgumentExpression $argument, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        return FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(this$0.getValueAndContextParameterSymbolsIfRequired(it), $matchedIndex, $argument, this$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "", "<init>", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

