/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProvider;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "generatedDeclarationProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "generateAndUpdateCompanion", "", "generateCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCompanionGenerationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompanionGenerationProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 FirScope.kt\norg/jetbrains/kotlin/fir/scopes/FirScopeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,109:1\n249#2,4:110\n124#3,2:114\n1#4:116\n81#5,7:117\n76#5,2:124\n57#5:126\n78#5:127\n81#5,7:128\n76#5,2:135\n57#5:137\n78#5:138\n*S KotlinDebug\n*F\n+ 1 FirCompanionGenerationProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer\n*L\n50#1:110,4\n71#1:114,2\n87#1:117,7\n87#1:124,2\n87#1:126\n87#1:127\n96#1:128,7\n96#1:135,2\n96#1:137\n96#1:138\n*E\n"})
public final class FirCompanionGenerationTransformer
extends FirTransformer {
    @NotNull
    private final FirSession session;
    @Nullable
    private final FirSwitchableExtensionDeclarationsSymbolProvider generatedDeclarationProvider;

    public FirCompanionGenerationTransformer(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.generatedDeclarationProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.session);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @NotNull
    public FirFile transformFile(@NotNull FirFile file, @Nullable Void data) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.generatedDeclarationProvider == null) {
            return file;
        }
        FirFile file$iv = file;
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            firFile = file.transformDeclarations(this, data);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file$iv.getModuleData().getSession()).handleExceptionOnFileAnalysis(file$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firFile;
    }

    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        this.generateAndUpdateCompanion(regularClass);
        return regularClass.transformDeclarations((FirTransformer)this, data);
    }

    public final void generateAndUpdateCompanion(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirRegularClassSymbol companionSymbol = this.generateCompanion(regularClass);
        if (companionSymbol != null) {
            regularClass.replaceCompanionObjectSymbol(companionSymbol);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirRegularClassSymbol generateCompanion(FirRegularClass regularClass) {
        String attachmentName$iv;
        Throwable cause$iv;
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> generatedCompanion;
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        FirClassLikeSymbol<?> $this$processClassifiersByName$iv;
        if (this.generatedDeclarationProvider == null) {
            return null;
        }
        if (regularClass.isLocal()) {
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.session, regularClass);
            if (firNestedClassifierScope != null) {
                void name$iv;
                FirScope firScope = firNestedClassifierScope;
                Name name2 = SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT;
                Function1 processor$iv = arg_0 -> FirCompanionGenerationTransformer.generateCompanion$lambda$0(result2, arg_0);
                boolean $i$f$processClassifiersByName = false;
                ((FirScope)((Object)$this$processClassifiersByName$iv)).processClassifiersByNameWithSubstitution((Name)name$iv, (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
                    final /* synthetic */ Function1 $processor;
                    {
                        this.$processor = $processor;
                    }

                    public final void invoke(FirClassifierSymbol<?> symbol, ConeSubstitutor coneSubstitutor) {
                        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                        Intrinsics.checkNotNullParameter((Object)coneSubstitutor, (String)"<unused var>");
                        this.$processor.invoke(symbol);
                    }
                });
            }
            firClassLikeSymbol = (FirClassLikeSymbol<?>)result2.element;
        } else {
            ClassId companionClassId = FirDeclarationUtilKt.getClassId(regularClass).createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            FirClassLikeSymbol<?> firClassLikeSymbol2 = this.generatedDeclarationProvider.getClassLikeSymbolByClassId(companionClassId);
            if (firClassLikeSymbol2 != null) {
                FirClassLikeSymbol<?> it = $this$processClassifiersByName$iv = firClassLikeSymbol2;
                boolean bl = false;
                firClassLikeSymbol = it.getOrigin().getGenerated() ? $this$processClassifiersByName$iv : null;
            } else {
                firClassLikeSymbol = null;
            }
        }
        FirClassLikeSymbol<?> firClassLikeSymbol3 = generatedCompanion = firClassLikeSymbol;
        if (firClassLikeSymbol3 == null) {
            firRegularClassSymbol = null;
        } else if (firClassLikeSymbol3 instanceof FirRegularClassSymbol) {
            if (regularClass.getCompanionObjectSymbol() != null) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                void $this$buildAttachment$iv$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                void cause$iv$iv;
                void message$iv$iv;
                String message$iv = "Plugin generated duplicated companion object: " + Reflection.getOrCreateKotlinClass(((FirRegularClassSymbol)generatedCompanion).getOrigin().getClass()).getSimpleName();
                cause$iv = null;
                attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                String $i$f$processClassifiersByName = message$iv;
                Throwable throwable = cause$iv;
                String attachmentName$iv$iv = attachmentName$iv;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv$iv;
                String name$iv$iv$iv = attachmentName$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string = name$iv$iv$iv;
                void var19_35 = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$generateCompanion_u24lambda_u242 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                $this$generateCompanion_u24lambda_u242.withEntry("origin", ((FirRegularClassSymbol)generatedCompanion).getOrigin().toString());
                FirExceptionUtilsKt.withFirSymbolEntry((ExceptionAttachmentBuilder)$this$generateCompanion_u24lambda_u242, "generatedCompanion", (FirBasedSymbol)generatedCompanion);
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$generateCompanion_u24lambda_u242, "regularClass", regularClass);
                var19_35.withAttachment(string, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            firRegularClassSymbol = (FirRegularClassSymbol)generatedCompanion;
        } else {
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Plugin generated non regular class as companion object: " + Reflection.getOrCreateKotlinClass(generatedCompanion.getOrigin().getClass()).getSimpleName();
            cause$iv = null;
            attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            String message$iv$iv = message$iv;
            Throwable cause$iv$iv = cause$iv;
            String attachmentName$iv$iv = attachmentName$iv;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv$iv, cause$iv$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            String name$iv$iv$iv = attachmentName$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder $this$buildErrorWithAttachment_u24lambda_u240$iv$iv = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string = name$iv$iv$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            ExceptionAttachmentBuilder $this$generateCompanion_u24lambda_u243 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl3 = false;
            $this$generateCompanion_u24lambda_u243.withEntry("origin", generatedCompanion.getOrigin().toString());
            FirExceptionUtilsKt.withFirSymbolEntry($this$generateCompanion_u24lambda_u243, "generatedCompanion", (FirBasedSymbol)generatedCompanion);
            FirExceptionUtilsKt.withFirEntry($this$generateCompanion_u24lambda_u243, "regularClass", regularClass);
            kotlinExceptionWithAttachments.withAttachment(string, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return firRegularClassSymbol;
    }

    private static final Unit generateCompanion$lambda$0(Ref.ObjectRef $result, FirClassifierSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof FirClassLikeSymbol && ((FirClassLikeSymbol)it).getOrigin().getGenerated()) {
            $result.element = it;
        }
        return Unit.INSTANCE;
    }
}

