/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0003H\u0004J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u00132\u0006\u0010\u001a\u001a\u00020\u0003H$R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u0010j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "rootProjectDir", "Ljava/io/File;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "getModulesInfo", "()Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "possibleParentsToBuildDirs", "", "Ljava/nio/file/Path;", "getPossibleParentsToBuildDirs", "()Ljava/util/Set;", "dirToHistoryFileCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "historyFilesForChangedFiles", "Lorg/jetbrains/kotlin/incremental/util/Either;", "changedFiles", "getBuildHistoryForDir", "file", "isInProjectBuildDir", "", "getBuildHistoryFilesForJar", "jar", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nModulesApiHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,257:1\n1512#2:258\n1538#2,3:259\n1541#2,3:269\n1807#2,3:279\n383#3,7:262\n383#3,7:272\n*S KotlinDebug\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase\n*L\n75#1:258\n75#1:259,3\n75#1:269,3\n116#1:279,3\n75#1:262,7\n94#1:272,7\n*E\n"})
public abstract class ModulesApiHistoryBase
implements ModulesApiHistory {
    @NotNull
    private final IncrementalModuleInfo modulesInfo;
    @NotNull
    private final Set<Path> possibleParentsToBuildDirs;
    @NotNull
    private final HashMap<File, Set<File>> dirToHistoryFileCache;

    public ModulesApiHistoryBase(@NotNull File rootProjectDir, @NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter((Object)rootProjectDir, (String)"rootProjectDir");
        Intrinsics.checkNotNullParameter((Object)modulesInfo, (String)"modulesInfo");
        this.modulesInfo = modulesInfo;
        Object[] objectArray = new Path[]{Paths.get(this.modulesInfo.getRootProjectBuildDir().getParentFile().getAbsolutePath(), new String[0]), Paths.get(rootProjectDir.getAbsolutePath(), new String[0])};
        this.possibleParentsToBuildDirs = SetsKt.setOf((Object[])objectArray);
        this.dirToHistoryFileCache = new HashMap();
    }

    @NotNull
    protected final IncrementalModuleInfo getModulesInfo() {
        return this.modulesInfo;
    }

    @NotNull
    protected final Set<Path> getPossibleParentsToBuildDirs() {
        return this.possibleParentsToBuildDirs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Either<Set<File>> historyFilesForChangedFiles(@NotNull Set<? extends File> changedFiles) {
        Either<Set<File>> historyEither;
        void $this$groupByTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
        HashSet result2 = new HashSet();
        ArrayList<File> jarFiles = new ArrayList<File>();
        ArrayList<File> classFiles = new ArrayList<File>();
        ArrayList<File> manifestFiles = new ArrayList<File>();
        for (File iterator5 : changedFiles) {
            String extension = FilesKt.getExtension((File)iterator5);
            if (StringsKt.equals((String)extension, (String)"class", (boolean)true)) {
                classFiles.add(iterator5);
                continue;
            }
            if (StringsKt.equals((String)extension, (String)"jar", (boolean)true)) {
                jarFiles.add(iterator5);
                continue;
            }
            if (StringsKt.equals((String)extension, (String)"klib", (boolean)true)) {
                jarFiles.add(iterator5);
                continue;
            }
            if (!Intrinsics.areEqual((Object)iterator5.getName(), (Object)"manifest")) continue;
            manifestFiles.add(iterator5);
        }
        Iterator iterator2 = jarFiles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<File> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            File file;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            Either<Set<File>> historyEither2 = this.getBuildHistoryFilesForJar(file);
            object = historyEither2;
            if (object instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither2).getValue());
                continue;
            }
            if (object instanceof Either.Error) {
                return historyEither2;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterable iterable = classFiles;
        boolean $i$f$groupBy = false;
        object = iterable;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            File it = (File)element$iv$iv;
            boolean bl = false;
            File key$iv$iv = it.getParentFile();
            Map map = destination$iv$iv;
            File key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map classFileDirs = destination$iv$iv;
        for (File dir2 : classFileDirs.keySet()) {
            Intrinsics.checkNotNull((Object)dir2);
            historyEither = this.getBuildHistoryForDir(dir2);
            if (historyEither instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (historyEither instanceof Either.Error) {
                return historyEither;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterator iterator4 = manifestFiles.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        Iterator iterator5 = iterator4;
        while (iterator5.hasNext()) {
            Object e = iterator5.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            File manifest = (File)e;
            File file = manifest.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            historyEither = this.getBuildHistoryForDir(file);
            if (historyEither instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (historyEither instanceof Either.Error) {
                return historyEither;
            }
            throw new NoWhenBranchMatchedException();
        }
        return new Either.Success(result2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map map = this.dirToHistoryFileCache;
        File key$iv = file;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Set set;
            boolean bl = false;
            IncrementalModuleEntry module2 = this.modulesInfo.getDirToModule().get(file);
            File parent2 = file.getParentFile();
            if (module2 != null) {
                set = SetsKt.setOf((Object)module2.getBuildHistoryFile());
            } else {
                if (parent2 == null || !this.isInProjectBuildDir(parent2)) return new Either.Error("Unable to get build history for " + file);
                Either<Set<File>> parentHistory = this.getBuildHistoryForDir(parent2);
                Either<Set<File>> either = parentHistory;
                if (either instanceof Either.Success) {
                    set = (Set)((Either.Success)parentHistory).getValue();
                } else {
                    if (!(either instanceof Either.Error)) throw new NoWhenBranchMatchedException();
                    return parentHistory;
                }
            }
            Set answer$iv = set;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Set history = (Set)object;
        return new Either.Success<Set>(history);
    }

    protected final boolean isInProjectBuildDir(@NotNull File file) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$any$iv = this.possibleParentsToBuildDirs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (!ModulesApiHistoryKt.access$isParentOf(it, file)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    protected abstract Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File var1);
}

