/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.kotlin.io.vavr.Tuple2;
import org.jetbrains.kotlin.io.vavr.collection.Collections;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.LinkedHashMap;
import org.jetbrains.kotlin.io.vavr.collection.Map;
import org.jetbrains.kotlin.io.vavr.collection.Set;

public final class LinkedHashSet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LinkedHashSet<?> EMPTY = new LinkedHashSet(LinkedHashMap.empty());
    private final LinkedHashMap<T, Object> map;

    private LinkedHashSet(LinkedHashMap<T, Object> map) {
        this.map = map;
    }

    public static <T> LinkedHashSet<T> empty() {
        return EMPTY;
    }

    static <T> LinkedHashSet<T> wrap(LinkedHashMap<T, Object> map) {
        return new LinkedHashSet<T>(map);
    }

    public static <T> LinkedHashSet<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof LinkedHashSet) {
            return (LinkedHashSet)elements;
        }
        LinkedHashMap<T, Object> mao = LinkedHashSet.addAll(LinkedHashMap.empty(), elements);
        return mao.isEmpty() ? LinkedHashSet.empty() : new LinkedHashSet<T>(mao);
    }

    @Override
    public LinkedHashSet<T> add(T element) {
        return this.contains(element) ? this : new LinkedHashSet<T>(this.map.put((Object)element, (Object)element));
    }

    @Override
    public boolean contains(T element) {
        return this.map.get(element).isDefined();
    }

    @Override
    public LinkedHashSet<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinkedHashSet<T> filtered = LinkedHashSet.ofAll(this.iterator().filter(predicate));
        return filtered.length() == this.length() ? this : filtered;
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.map.isEmpty()) {
            throw new NoSuchElementException("head of empty set");
        }
        return (T)this.iterator().next();
    }

    @Override
    public LinkedHashSet<T> intersect(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty() || elements.isEmpty()) {
            return LinkedHashSet.empty();
        }
        return this.retainAll(elements);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.iterator().map((? super T t) -> t._1);
    }

    @Override
    public T last() {
        return (T)((Tuple2)this.map.last())._1;
    }

    @Override
    public int length() {
        return this.map.size();
    }

    @Override
    public <U> LinkedHashSet<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return LinkedHashSet.empty();
        }
        LinkedHashMap that = this.foldLeft(LinkedHashMap.empty(), (tree, t) -> {
            Object u = mapper.apply(t);
            return tree.put(u, u);
        });
        return new LinkedHashSet<T>(that);
    }

    @Override
    public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return this.iterator().mkString(prefix, delimiter, suffix);
    }

    public LinkedHashSet<T> remove(T element) {
        Map newMap2 = this.map.remove((Object)element);
        return newMap2 == this.map ? this : new LinkedHashSet<T>(newMap2);
    }

    public LinkedHashSet<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public LinkedHashSet<T> tail() {
        if (this.map.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty set");
        }
        return this.remove(this.head());
    }

    @Override
    public java.util.LinkedHashSet<T> toJavaSet() {
        return this.toJavaSet(java.util.LinkedHashSet::new);
    }

    public boolean equals(Object o) {
        return Collections.equals(this, o);
    }

    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> LinkedHashMap<T, Object> addAll(LinkedHashMap<T, Object> initial, Iterable<? extends T> additional) {
        Map<Object, Object> that = initial;
        for (T t : additional) {
            that = that.put((Object)t, (Object)t);
        }
        return that;
    }

    private Object writeReplace() {
        return new SerializationProxy<T>(this.map);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient LinkedHashMap<T, Object> map;

        SerializationProxy(LinkedHashMap<T, Object> map) {
            this.map = map;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.map.size());
            for (Tuple2 tuple2 : this.map) {
                s.writeObject(tuple2._1);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            Map temp = LinkedHashMap.empty();
            for (int i = 0; i < size; ++i) {
                Object element = s.readObject();
                temp = temp.put(element, element);
            }
            this.map = temp;
        }

        private Object readResolve() {
            return this.map.isEmpty() ? LinkedHashSet.empty() : new LinkedHashSet(this.map);
        }
    }
}

