/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.kotlin.io.vavr.Tuple;
import org.jetbrains.kotlin.io.vavr.Tuple2;
import org.jetbrains.kotlin.io.vavr.collection.Collections;
import org.jetbrains.kotlin.io.vavr.collection.JavaConverters;
import org.jetbrains.kotlin.io.vavr.collection.LinearSeq;

public interface List<T>
extends LinearSeq<T> {
    public static final long serialVersionUID = 1L;

    public static <T> Collector<T, ArrayList<T>, List<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, List> finisher = List::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> List<T> empty() {
        return Nil.instance();
    }

    @Override
    default public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty();

    @Override
    default public boolean isLazy() {
        return false;
    }

    public static <T> List<T> of(T element) {
        return new Cons(element, Nil.instance());
    }

    public static <T> List<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof List) {
            return (List)elements;
        }
        if (elements instanceof JavaConverters.ListView && ((JavaConverters.ListView)elements).getDelegate() instanceof List) {
            return (List)((JavaConverters.ListView)elements).getDelegate();
        }
        if (elements instanceof java.util.List) {
            List result2 = Nil.instance();
            java.util.List list = (java.util.List)elements;
            ListIterator iterator2 = list.listIterator(list.size());
            while (iterator2.hasPrevious()) {
                result2 = result2.prepend(iterator2.previous());
            }
            return result2;
        }
        if (elements instanceof NavigableSet) {
            List result3 = Nil.instance();
            Iterator iterator3 = ((NavigableSet)elements).descendingIterator();
            while (iterator3.hasNext()) {
                result3 = result3.prepend(iterator3.next());
            }
            return result3;
        }
        List<T> result4 = Nil.instance();
        for (T element : elements) {
            result4 = result4.prepend(element);
        }
        return result4.reverse();
    }

    @Override
    default public List<T> append(T element) {
        return this.foldRight(List.of(element), (x, xs) -> xs.prepend(x));
    }

    @Override
    default public List<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return List.ofAll(elements).prependAll(this);
    }

    default public <U> List<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(keyExtractor.apply(t)));
    }

    default public List<T> dropRight(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.length()) {
            return List.empty();
        }
        return List.ofAll(this.iterator().dropRight(n));
    }

    @Override
    default public List<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return this;
        }
        List filtered = this.foldLeft(List.empty(), (xs, x) -> predicate.test(x) ? xs.prepend(x) : xs);
        if (filtered.isEmpty()) {
            return List.empty();
        }
        if (filtered.length() == this.length()) {
            return this;
        }
        return filtered.reverse();
    }

    @Override
    default public T get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index + ") on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("get(" + index + ")");
        }
        LinearSeq<T> list = this;
        for (int i = index - 1; i >= 0; --i) {
            if (!(list = list.tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException("get(" + index + ") on List of length " + (index - i));
        }
        return list.head();
    }

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    default public int indexOf(T element, int from2) {
        int index = 0;
        LinearSeq<T> list = this;
        while (!list.isEmpty()) {
            if (index >= from2 && Objects.equals(list.head(), element)) {
                return index;
            }
            list = list.tail();
            ++index;
        }
        return -1;
    }

    default public List<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty list");
        }
        return this.dropRight(1);
    }

    @Override
    public int length();

    @Override
    default public List<T> insert(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e)");
        }
        List preceding = Nil.instance();
        LinearSeq<T> tail = this;
        int i = index;
        while (i > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("insert(" + index + ", e) on List of length " + this.length());
            }
            preceding = preceding.prepend(tail.head());
            --i;
            tail = tail.tail();
        }
        List result2 = tail.prepend(element);
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    @Override
    default public List<T> insertAll(int index, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements)");
        }
        List preceding = Nil.instance();
        LinearSeq<T> tail = this;
        int i = index;
        while (i > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("insertAll(" + index + ", elements) on List of length " + this.length());
            }
            preceding = preceding.prepend(tail.head());
            --i;
            tail = tail.tail();
        }
        List result2 = tail.prependAll(elements);
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public T last() {
        return Collections.last(this);
    }

    @Override
    default public int lastIndexOf(T element, int end) {
        int result2 = -1;
        LinearSeq<T> list = this;
        for (int index = 0; index <= end && !list.isEmpty(); ++index) {
            if (Objects.equals(list.head(), element)) {
                result2 = index;
            }
            list = list.tail();
        }
        return result2;
    }

    @Override
    default public <U> List<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        List<U> list = List.empty();
        for (Object t : this) {
            list = list.prepend(mapper.apply(t));
        }
        return list.reverse();
    }

    default public Tuple2<T, List<T>> pop2() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("pop2 of empty list");
        }
        return Tuple.of(this.head(), this.tail());
    }

    default public List<T> prepend(T element) {
        return new Cons(element, this);
    }

    default public List<T> prependAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.isEmpty() ? List.ofAll(elements) : List.ofAll(elements).reverse().foldLeft(this, List::prepend);
    }

    default public List<T> push(T element) {
        return new Cons(element, this);
    }

    default public List<T> pushAll(Iterable<T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        List<T> result2 = this;
        for (T element : elements) {
            result2 = result2.prepend(element);
        }
        return result2;
    }

    @Override
    default public List<T> remove(T element) {
        ArrayDeque preceding = new ArrayDeque(this.size());
        LinearSeq<Object> result2 = this;
        boolean found = false;
        while (!found && !result2.isEmpty()) {
            Object head = result2.head();
            if (Objects.equals(head, element)) {
                found = true;
            } else {
                preceding.addFirst(head);
            }
            result2 = result2.tail();
        }
        if (!found) {
            return this;
        }
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    default public List<T> removeFirst(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        List<Object> init = List.empty();
        LinearSeq<T> tail = this;
        while (!tail.isEmpty() && !predicate.test(tail.head())) {
            init = init.prepend(tail.head());
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            return this;
        }
        return init.foldLeft(tail.tail(), List::prepend);
    }

    @Override
    default public List<T> removeAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ")");
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ") on Nil");
        }
        List init = Nil.instance();
        LinearSeq<T> tail = this;
        while (index > 0 && !tail.isEmpty()) {
            init = init.prepend(tail.head());
            tail = tail.tail();
            --index;
        }
        if (index > 0) {
            throw new IndexOutOfBoundsException("removeAt() on Nil");
        }
        return init.reverse().appendAll((Iterable)tail.tail());
    }

    @Override
    default public List<T> removeAll(Iterable<? extends T> elements) {
        return Collections.removeAll(this, elements);
    }

    default public List<T> replace(T currentElement, T newElement) {
        List preceding = Nil.instance();
        LinearSeq<T> tail = this;
        while (!tail.isEmpty() && !Objects.equals(tail.head(), currentElement)) {
            preceding = preceding.prepend(tail.head());
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            return this;
        }
        List result2 = tail.tail().prepend(newElement);
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    @Override
    default public List<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    default public List<T> reverse() {
        return this.length() <= 1 ? this : this.foldLeft(List.empty(), List::prepend);
    }

    @Override
    default public List<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(List.collector());
    }

    @Override
    default public String stringPrefix() {
        return "List";
    }

    @Override
    default public List<T> subSequence(int beginIndex, int endIndex) {
        Collections.subSequenceRangeCheck(beginIndex, endIndex, this.length());
        if (beginIndex == endIndex) {
            return List.empty();
        }
        if (beginIndex == 0 && endIndex == this.length()) {
            return this;
        }
        List result2 = Nil.instance();
        LinearSeq<T> list = this;
        int i = 0;
        while (i < endIndex) {
            if (i >= beginIndex) {
                result2 = result2.prepend(list.head());
            }
            ++i;
            list = list.tail();
        }
        return result2.reverse();
    }

    @Override
    public List<T> tail();

    @Override
    default public List<T> take(int n) {
        if (n <= 0) {
            return List.empty();
        }
        if (n >= this.length()) {
            return this;
        }
        List result2 = Nil.instance();
        LinearSeq<T> list = this;
        int i = 0;
        while (i < n) {
            result2 = result2.prepend(list.head());
            ++i;
            list = list.tail();
        }
        return result2.reverse();
    }

    default public List<T> takeRight(int n) {
        if (n <= 0) {
            return List.empty();
        }
        if (n >= this.length()) {
            return this;
        }
        return this.reverse().take(n).reverse();
    }

    @Override
    default public List<T> update(int index, T element) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index + ", e) on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("update(" + index + ", e)");
        }
        List preceding = Nil.instance();
        LinearSeq<T> tail = this;
        int i = index;
        while (i > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("update(" + index + ", e) on List of length " + this.length());
            }
            preceding = preceding.prepend(tail.head());
            --i;
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index + ", e) on List of length " + this.length());
        }
        List result2 = tail.tail().prepend(element);
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    public static final class Cons<T>
    implements List<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T head;
        private final List<T> tail;
        private final int length;

        private Cons(T head, List<T> tail) {
            this.head = head;
            this.tail = tail;
            this.length = 1 + tail.length();
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public List<T> tail() {
            return this.tail;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean equals(Object o) {
            return Collections.equals(this, o);
        }

        public int hashCode() {
            return Collections.hashOrdered(this);
        }

        @Override
        public String toString() {
            return this.mkString(this.stringPrefix() + "(", ", ", ")");
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static final class SerializationProxy<T>
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient Cons<T> list;

            SerializationProxy(Cons<T> list) {
                this.list = list;
            }

            private void writeObject(ObjectOutputStream s) throws IOException {
                s.defaultWriteObject();
                s.writeInt(this.list.length());
                LinearSeq<T> l = this.list;
                while (!l.isEmpty()) {
                    s.writeObject(l.head());
                    l = l.tail();
                }
            }

            private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
                s.defaultReadObject();
                int size = s.readInt();
                if (size <= 0) {
                    throw new InvalidObjectException("No elements");
                }
                List<Object> temp = Nil.instance();
                for (int i = 0; i < size; ++i) {
                    Object element = s.readObject();
                    temp = temp.prepend(element);
                }
                this.list = (Cons)temp.reverse();
            }

            private Object readResolve() {
                return this.list;
            }
        }
    }

    public static final class Nil<T>
    implements List<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Nil<?> INSTANCE = new Nil();

        private Nil() {
        }

        public static <T> Nil<T> instance() {
            return INSTANCE;
        }

        @Override
        public T head() {
            throw new NoSuchElementException("head of empty list");
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public List<T> tail() {
            throw new UnsupportedOperationException("tail of empty list");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object o) {
            return Collections.equals(this, o);
        }

        public int hashCode() {
            return Collections.hashOrdered(this);
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

