/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/RemoveInitializersForLazyProperties;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "calculateFileFieldsPureness", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPropertyLazyInitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyLazyInitLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/RemoveInitializersForLazyProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class RemoveInitializersForLazyProperties
implements DeclarationTransformer {
    @NotNull
    private final JsCommonBackendContext context;

    public RemoveInitializersForLazyProperties(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        block7: {
            IrElement irElement;
            IrElement irElement2;
            boolean allFieldsInFilePure;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (!this.context.getPropertyLazyInitialization().getEnabled()) {
                return null;
            }
            if (!(declaration instanceof IrField)) {
                return null;
            }
            if (!PropertyLazyInitLoweringKt.access$isCompatibleDeclaration(declaration, this.context)) {
                return null;
            }
            IrElement irElement3 = ((IrField)declaration).getParent();
            IrFile irFile = irElement3 instanceof IrFile ? (IrFile)irElement3 : null;
            if (irFile == null) {
                return null;
            }
            IrFile file = irFile;
            if (Intrinsics.areEqual((Object)PropertyLazyInitLoweringKt.access$isPureForInitialization(file), (Object)true)) {
                return null;
            }
            Boolean bl = PropertyLazyInitLoweringKt.access$isPureForInitialization(file);
            boolean bl2 = allFieldsInFilePure = bl != null ? bl.booleanValue() : this.calculateFileFieldsPureness(file);
            if (allFieldsInFilePure) {
                return null;
            }
            irElement3 = PropertyLazyInitLoweringKt.access$getCorrespondingProperty(declaration);
            if (irElement3 == null) break block7;
            IrElement it = irElement2 = irElement3;
            boolean bl3 = false;
            IrElement irElement4 = irElement = PropertyLazyInitLoweringKt.access$isForLazyInit((IrProperty)it) ? irElement2 : null;
            if (irElement != null && (irElement2 = ((IrProperty)irElement).getBackingField()) != null) {
                IrElement it2 = irElement2;
                boolean bl4 = false;
                ((IrField)it2).setInitializer(null);
            }
        }
        return null;
    }

    private final boolean calculateFileFieldsPureness(IrFile file) {
        List declarations2 = CollectionsKt.toList((Iterable)file.getDeclarations());
        Collection expressions = PropertyLazyInitLoweringKt.access$calculateFieldToExpression(declarations2, this.context).values();
        boolean allFieldsInFilePure = PropertyLazyInitLoweringKt.access$allFieldsInFilePure(expressions);
        PropertyLazyInitLoweringKt.access$setPureForInitialization(file, allFieldsInFilePure);
        return allFieldsInFilePure;
    }
}

