/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/ExceptionHelperCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "helperMapping", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "call", "doNotIntrinsify", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExceptionHelperCallsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHelperCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/ExceptionHelperCallsTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class ExceptionHelperCallsTransformer
implements CallsTransformer {
    @NotNull
    private final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> helperMapping;

    public ExceptionHelperCallsTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)context2.getIrBuiltIns().getCheckNotNullSymbol(), (Object)context2.getSymbols().getJsEnsureNonNull()), TuplesKt.to((Object)context2.getIrBuiltIns().getThrowCceSymbol(), (Object)context2.getSymbols().getThrowTypeCastException()), TuplesKt.to((Object)context2.getIrBuiltIns().getThrowIseSymbol(), (Object)context2.getSymbols().getThrowISE()), TuplesKt.to((Object)context2.getIrBuiltIns().getIllegalArgumentExceptionSymbol(), (Object)context2.getSymbols().getThrowIAE()), TuplesKt.to((Object)context2.getIrBuiltIns().getNoWhenBranchMatchedExceptionSymbol(), (Object)context2.getSymbols().getNoWhenBranchMatchedException()), TuplesKt.to((Object)context2.getIrBuiltIns().getLinkageErrorSymbol(), (Object)context2.getSymbols().getLinkageErrorSymbol())};
        this.helperMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IrFunctionAccessExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call, boolean doNotIntrinsify) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Object object = this.helperMapping.get(call.getSymbol());
        if (object != null) {
            IrSimpleFunctionSymbol it = object;
            boolean bl = false;
            IrCall irCall = IrUtilsKt.irCall$default(call, it, null, null, 12, null);
            object = irCall;
            if (irCall != null) {
                irFunctionAccessExpression = (IrFunctionAccessExpression)object;
                return irFunctionAccessExpression;
            }
        }
        irFunctionAccessExpression = call;
        return irFunctionAccessExpression;
    }
}

