/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.tsexport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.ExportUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedAttribute;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a#\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0015*\u0002H\u00142\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0003*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0018\u0010\t\u001a\u00020\u0003*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0018"}, d2={"magicPropertyName", "", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "isStaticMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isStaticProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "isExportedImplicitlyOrExplicitly", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "toExportedVisibility", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "withAttributesFor", "T", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedDeclaration;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/tsexport/ExportModelGeneratorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,941:1\n1#2:942\n*E\n"})
public final class ExportModelGeneratorKt {
    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass != null ? IrUtilsKt.isInterface(irClass) : false;
    }

    private static final boolean isStaticMethod(IrFunction $this$isStaticMethod) {
        return ES6ConstructorLoweringKt.isEs6ConstructorReplacement($this$isStaticMethod) || IrDeclarationsKt.isStaticMethodOfClass($this$isStaticMethod);
    }

    private static final boolean isStaticProperty(IrProperty $this$isStaticProperty) {
        IrSimpleFunction irSimpleFunction = $this$isStaticProperty.getGetter();
        if (irSimpleFunction == null) {
            irSimpleFunction = $this$isStaticProperty.getSetter();
        }
        return irSimpleFunction != null ? IrDeclarationsKt.isStaticMethodOfClass(irSimpleFunction) : false;
    }

    private static final boolean isExportedImplicitlyOrExplicitly(IrDeclaration $this$isExportedImplicitlyOrExplicitly, JsIrBackendContext context2) {
        IrDeclarationWithName irDeclarationWithName = ExportUtilsKt.getExportCandidate($this$isExportedImplicitlyOrExplicitly);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportUtilsKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, context2, $this$isExportedImplicitlyOrExplicitly);
    }

    @NotNull
    public static final ExportedVisibility toExportedVisibility(@NotNull DescriptorVisibility $this$toExportedVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$toExportedVisibility, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$toExportedVisibility, (Object)DescriptorVisibilities.PROTECTED) ? ExportedVisibility.PROTECTED : ExportedVisibility.DEFAULT;
    }

    private static final <T extends ExportedDeclaration> T withAttributesFor(T $this$withAttributesFor, IrDeclaration declaration) {
        String string = AnnotationUtilsKt.getDeprecated(declaration);
        if (string != null) {
            String it = string;
            boolean bl = false;
            $this$withAttributesFor.getAttributes().add(new ExportedAttribute.DeprecatedAttribute(it));
        }
        if (AnnotationUtilsKt.isJsExportDefault(declaration)) {
            $this$withAttributesFor.getAttributes().add(ExportedAttribute.DefaultExport.INSTANCE);
        }
        return $this$withAttributesFor;
    }

    public static final /* synthetic */ ExportedDeclaration access$withAttributesFor(ExportedDeclaration $receiver, IrDeclaration declaration) {
        return ExportModelGeneratorKt.withAttributesFor($receiver, declaration);
    }

    public static final /* synthetic */ boolean access$isStaticMethod(IrFunction $receiver) {
        return ExportModelGeneratorKt.isStaticMethod($receiver);
    }

    public static final /* synthetic */ boolean access$isStaticProperty(IrProperty $receiver) {
        return ExportModelGeneratorKt.isStaticProperty($receiver);
    }

    public static final /* synthetic */ boolean access$isExportedImplicitlyOrExplicitly(IrDeclaration $receiver, JsIrBackendContext context2) {
        return ExportModelGeneratorKt.isExportedImplicitlyOrExplicitly($receiver, context2);
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return ExportModelGeneratorKt.isInterface($receiver);
    }
}

