/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\b\u0010!\u001a\u00020\u000bH&R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsIterableLoop;", "Lorg/jetbrains/kotlin/js/backend/ast/SourceInfoAwareJsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLoop;", "bindingVarVariant", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$Variant;", "bindingVarName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "bindingExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "iterableExpression", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsVars$Variant;Lorg/jetbrains/kotlin/js/backend/ast/JsName;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "getBindingVarVariant", "()Lorg/jetbrains/kotlin/js/backend/ast/JsVars$Variant;", "getBindingVarName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "value", "getBindingExpression", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getIterableExpression", "getBody", "()Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "acceptChildren", "traverse", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContext;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "deepCopy", "js.ast"})
public abstract class JsIterableLoop
extends SourceInfoAwareJsNode
implements JsLoop {
    @Nullable
    private final JsVars.Variant bindingVarVariant;
    @Nullable
    private final JsName bindingVarName;
    @Nullable
    private JsExpression bindingExpression;
    @NotNull
    private JsExpression iterableExpression;
    @NotNull
    private JsStatement body;

    public JsIterableLoop(@Nullable JsVars.Variant bindingVarVariant, @Nullable JsName bindingVarName, @Nullable JsExpression bindingExpression, @NotNull JsExpression iterableExpression, @NotNull JsStatement body) {
        Intrinsics.checkNotNullParameter((Object)iterableExpression, (String)"iterableExpression");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.bindingVarVariant = bindingVarVariant;
        this.bindingVarName = bindingVarName;
        this.bindingExpression = bindingExpression;
        this.iterableExpression = iterableExpression;
        this.body = body;
    }

    @Nullable
    public final JsVars.Variant getBindingVarVariant() {
        return this.bindingVarVariant;
    }

    @Nullable
    public final JsName getBindingVarName() {
        return this.bindingVarName;
    }

    @Nullable
    public final JsExpression getBindingExpression() {
        return this.bindingExpression;
    }

    @NotNull
    public final JsExpression getIterableExpression() {
        return this.iterableExpression;
    }

    @NotNull
    public final JsStatement getBody() {
        return this.body;
    }

    @Override
    public abstract void accept(@NotNull JsVisitor var1);

    @Override
    public void acceptChildren(@NotNull JsVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        JsExpression jsExpression = this.bindingExpression;
        if (jsExpression != null) {
            JsExpression it = jsExpression;
            boolean bl = false;
            visitor2.acceptLvalue(it);
        }
        visitor2.accept((JsNode)this.iterableExpression);
        visitor2.accept((JsNode)this.body);
    }

    public void traverse(@NotNull JsVisitorWithContext visitor2, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (visitor2.visit(this, ctx)) {
            JsExpression jsExpression = this.bindingExpression;
            if (jsExpression != null) {
                JsExpression it = jsExpression;
                boolean bl = false;
                this.bindingExpression = visitor2.acceptLvalue(this.bindingExpression);
            }
            JsExpression jsExpression2 = visitor2.acceptLvalue(this.iterableExpression);
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"acceptLvalue(...)");
            this.iterableExpression = jsExpression2;
            JsStatement jsStatement = visitor2.acceptStatement(this.body);
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"acceptStatement(...)");
            this.body = jsStatement;
        }
        visitor2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public abstract JsStatement deepCopy();
}

