/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0002DEB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010'\u001a\u00020\bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010.\u001a\u00020)H\u0016J*\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u0001022\u000e\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J\u0010\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\bH\u0002J,\u00109\u001a\u00020)2\u0006\u00100\u001a\u00020\b2\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\u0010\b\u0002\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014JD\u0010;\u001a\u00020)2\u0006\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u0001022\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\b\u00105\u001a\u0004\u0018\u00010\bH\u0016JP\u0010;\u001a\u00020)2\u0006\u00100\u001a\u00020\b2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u00062\n\b\u0002\u00105\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\u0010\b\u0002\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J\b\u0010?\u001a\u00020)H\u0016J\u0010\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020\u0006H\u0002J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u0002HC0\u000f\"\u0004\b\u0000\u0010CH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0017j\b\u0012\u0004\u0012\u00020\u0006`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00106\u001a\u00020\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder;", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapMappingConsumer;", "generatedFile", "Ljava/io/File;", "getCurrentOutputColumn", "Lkotlin/Function0;", "", "pathPrefix", "", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sources", "Lorg/jetbrains/kotlin/it/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$SourceKey;", "orderedSources", "", "orderedSourceContentSuppliers", "Ljava/util/function/Supplier;", "Ljava/io/Reader;", "ignoredSources", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "names", "orderedNames", "previousNameIndex", "previousPreviousNameIndex", "previousGeneratedColumn", "previousSourceIndex", "previousSourceLine", "previousSourceColumn", "previousMappingOffset", "previousPreviousSourceIndex", "previousPreviousSourceLine", "previousPreviousSourceColumn", "currentMappingIsEmpty", "", "build", "appendSources", "", "json", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "appendIgnoredSources", "appendSourcesContent", "newLine", "getSourceIndex", "source", "fileIdentity", "", "contentSupplier", "getNameIndex", "name", "unixStylePath", "getUnixStylePath", "(Ljava/lang/String;)Ljava/lang/String;", "addIgnoredSource", "sourceContent", "addMapping", "sourceLine", "sourceColumn", "outputColumn", "addEmptyMapping", "startMapping", "column", "createOpenHashMap", "T", "Base64VLQ", "SourceKey", "js.sourcemap"})
@SourceDebugExtension(value={"SMAP\nSourceMap3Builder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap3Builder.kt\norg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1661#2,3:258\n1661#2,3:261\n1661#2,3:264\n1661#2,3:267\n1#3:270\n*S KotlinDebug\n*F\n+ 1 SourceMap3Builder.kt\norg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder\n*L\n51#1:258,3\n59#1:261,3\n64#1:264,3\n72#1:267,3\n*E\n"})
public final class SourceMap3Builder
implements SourceMapMappingConsumer {
    @Nullable
    private final File generatedFile;
    @NotNull
    private final Function0<Integer> getCurrentOutputColumn;
    @NotNull
    private final String pathPrefix;
    @NotNull
    private final StringBuilder out;
    @NotNull
    private final Object2IntOpenHashMap<SourceKey> sources;
    @NotNull
    private final List<String> orderedSources;
    @NotNull
    private final List<Supplier<Reader>> orderedSourceContentSuppliers;
    @NotNull
    private final LinkedHashSet<Integer> ignoredSources;
    @NotNull
    private final Object2IntOpenHashMap<String> names;
    @NotNull
    private final List<String> orderedNames;
    private int previousNameIndex;
    private int previousPreviousNameIndex;
    private int previousGeneratedColumn;
    private int previousSourceIndex;
    private int previousSourceLine;
    private int previousSourceColumn;
    private int previousMappingOffset;
    private int previousPreviousSourceIndex;
    private int previousPreviousSourceLine;
    private int previousPreviousSourceColumn;
    private boolean currentMappingIsEmpty;

    public SourceMap3Builder(@Nullable File generatedFile, @NotNull Function0<Integer> getCurrentOutputColumn, @NotNull String pathPrefix) {
        Intrinsics.checkNotNullParameter(getCurrentOutputColumn, (String)"getCurrentOutputColumn");
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        this.generatedFile = generatedFile;
        this.getCurrentOutputColumn = getCurrentOutputColumn;
        this.pathPrefix = pathPrefix;
        this.out = new StringBuilder(8192);
        this.sources = this.createOpenHashMap();
        this.orderedSources = new ArrayList();
        this.orderedSourceContentSuppliers = new ArrayList();
        this.ignoredSources = new LinkedHashSet();
        this.names = this.createOpenHashMap();
        this.orderedNames = new ArrayList();
        this.previousGeneratedColumn = -1;
        this.currentMappingIsEmpty = true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String build() {
        void destination$iv;
        void $this$mapTo$iv;
        Object object;
        String string;
        Map<String, JsonNode> map;
        JsonObject json = new JsonObject(new Pair[0]);
        json.getProperties().put("version", new JsonNumber(3.0));
        if (this.generatedFile != null) {
            map = json.getProperties();
            string = "file";
            String string2 = this.generatedFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            object = new JsonString(string2);
            map.put(string, (JsonNode)object);
        }
        this.appendSources(json);
        this.appendSourcesContent(json);
        this.appendIgnoredSources(json);
        map = json.getProperties();
        string = "names";
        object = this.orderedNames;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string3 = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(new JsonString((String)it));
        }
        List list = (List)destination$iv;
        object = new JsonArray(list);
        map.put(string, (JsonNode)object);
        map = json.getProperties();
        string = "mappings";
        String string4 = this.out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        object = new JsonString(string4);
        map.put(string, (JsonNode)object);
        return json.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendSources(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, JsonNode> map = json.getProperties();
        String string = "sources";
        Object object = this.orderedSources;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(new JsonString(this.pathPrefix + (String)it));
        }
        List list = (List)destination$iv;
        object = new JsonArray(list);
        map.put(string, (JsonNode)object);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendIgnoredSources(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = this.ignoredSources;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            int n = ((Number)item$iv).intValue();
            void var10_9 = destination$iv;
            boolean bl = false;
            var10_9.add(new JsonNumber((double)it));
        }
        List list = (List)destination$iv;
        JsonArray ignoreList = new JsonArray(list);
        json.getProperties().put("ignoreList", ignoreList);
        json.getProperties().put("x_google_ignoreList", ignoreList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void appendSourcesContent(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, JsonNode> map = json.getProperties();
        String string = "sourcesContent";
        Object object = this.orderedSourceContentSuppliers;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Object object2;
            Supplier supplier = (Supplier)item$iv;
            void var15_18 = destination$iv;
            boolean bl = false;
            try {
                JsonNode jsonNode;
                void it;
                object2 = (Closeable)it.get();
                Throwable throwable = null;
                try {
                    Reader reader = (Reader)object2;
                    boolean bl2 = false;
                    jsonNode = reader != null ? (JsonNode)new JsonString(TextStreamsKt.readText((Reader)reader)) : (JsonNode)JsonNull.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object2 = jsonNode;
            }
            catch (IOException e) {
                System.err.println("An exception occurred during embedding sources into source map");
                e.printStackTrace();
                object2 = JsonNull.INSTANCE;
            }
            var15_18.add(object2);
        }
        List list = (List)destination$iv;
        object = new JsonArray(list);
        map.put(string, (JsonNode)object);
    }

    @Override
    public void newLine() {
        this.out.append(';');
        this.previousGeneratedColumn = -1;
    }

    private final int getSourceIndex(String source, Object fileIdentity, Supplier<Reader> contentSupplier) {
        SourceKey key = new SourceKey(source, fileIdentity);
        int sourceIndex = this.sources.getInt(key);
        if (sourceIndex == -1) {
            sourceIndex = this.orderedSources.size();
            this.sources.put(key, sourceIndex);
            this.orderedSources.add(source);
            this.orderedSourceContentSuppliers.add(contentSupplier);
        }
        return sourceIndex;
    }

    private final int getNameIndex(String name2) {
        int nameIndex = this.names.getInt(name2);
        if (nameIndex == -1) {
            nameIndex = this.orderedNames.size();
            this.names.put(name2, nameIndex);
            this.orderedNames.add(name2);
        }
        return nameIndex;
    }

    private final String getUnixStylePath(String $this$unixStylePath) {
        return StringsKt.replace$default((String)$this$unixStylePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    public final void addIgnoredSource(@NotNull String source, @Nullable Object fileIdentity, @NotNull Supplier<Reader> sourceContent) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(sourceContent, (String)"sourceContent");
        this.ignoredSources.add(this.getSourceIndex(this.getUnixStylePath(source), fileIdentity, sourceContent));
    }

    public static /* synthetic */ void addIgnoredSource$default(SourceMap3Builder sourceMap3Builder, String string, Object object, Supplier supplier, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            supplier = SourceMap3Builder::addIgnoredSource$lambda$0;
        }
        sourceMap3Builder.addIgnoredSource(string, object, supplier);
    }

    @Override
    public void addMapping(@NotNull String source, @Nullable Object fileIdentity, @NotNull Supplier<Reader> sourceContent, int sourceLine, int sourceColumn, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(sourceContent, (String)"sourceContent");
        this.addMapping(source, sourceLine, sourceColumn, ((Number)this.getCurrentOutputColumn.invoke()).intValue(), name2, fileIdentity, sourceContent);
    }

    public final void addMapping(@NotNull String source, int sourceLine, int sourceColumn, int outputColumn, @Nullable String name2, @Nullable Object fileIdentity, @NotNull Supplier<Reader> sourceContent) {
        int nameIndex;
        int n;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(sourceContent, (String)"sourceContent");
        int sourceIndex = this.getSourceIndex(this.getUnixStylePath(source), fileIdentity, sourceContent);
        String string = name2;
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            n = this.getNameIndex(p0);
        } else {
            n = nameIndex = -1;
        }
        if (!this.currentMappingIsEmpty && this.previousSourceIndex == sourceIndex && this.previousSourceLine == sourceLine && this.previousSourceColumn == sourceColumn) {
            return;
        }
        this.startMapping(outputColumn);
        Base64VLQ.INSTANCE.encode(this.out, sourceIndex - this.previousSourceIndex);
        this.previousSourceIndex = sourceIndex;
        Base64VLQ.INSTANCE.encode(this.out, sourceLine - this.previousSourceLine);
        this.previousSourceLine = sourceLine;
        Base64VLQ.INSTANCE.encode(this.out, sourceColumn - this.previousSourceColumn);
        this.previousSourceColumn = sourceColumn;
        if (nameIndex >= 0) {
            Base64VLQ.INSTANCE.encode(this.out, nameIndex - this.previousNameIndex);
            this.previousNameIndex = nameIndex;
        }
        this.currentMappingIsEmpty = false;
    }

    public static /* synthetic */ void addMapping$default(SourceMap3Builder sourceMap3Builder, String string, int n, int n2, int n3, String string2, Object object, Supplier supplier, int n4, Object object2) {
        if ((n4 & 0x10) != 0) {
            string2 = null;
        }
        if ((n4 & 0x20) != 0) {
            object = null;
        }
        if ((n4 & 0x40) != 0) {
            supplier = SourceMap3Builder::addMapping$lambda$0;
        }
        sourceMap3Builder.addMapping(string, n, n2, n3, string2, object, supplier);
    }

    @Override
    public void addEmptyMapping() {
        if (!this.currentMappingIsEmpty) {
            this.startMapping(((Number)this.getCurrentOutputColumn.invoke()).intValue());
            this.currentMappingIsEmpty = true;
        }
    }

    private final void startMapping(int column) {
        boolean newGroupStarted;
        boolean bl = newGroupStarted = this.previousGeneratedColumn == -1;
        if (newGroupStarted) {
            this.previousGeneratedColumn = 0;
        }
        int columnDiff = column - this.previousGeneratedColumn;
        if (!newGroupStarted) {
            this.out.append(',');
        }
        if (columnDiff > 0 || newGroupStarted) {
            Base64VLQ.INSTANCE.encode(this.out, columnDiff);
            this.previousGeneratedColumn = column;
            this.previousMappingOffset = this.out.length();
            this.previousPreviousSourceIndex = this.previousSourceIndex;
            this.previousPreviousSourceLine = this.previousSourceLine;
            this.previousPreviousSourceColumn = this.previousSourceColumn;
            this.previousPreviousNameIndex = this.previousNameIndex;
        } else {
            this.out.setLength(this.previousMappingOffset);
            this.previousSourceIndex = this.previousPreviousSourceIndex;
            this.previousSourceLine = this.previousPreviousSourceLine;
            this.previousSourceColumn = this.previousPreviousSourceColumn;
            this.previousNameIndex = this.previousPreviousNameIndex;
        }
    }

    private final <T> Object2IntOpenHashMap<T> createOpenHashMap() {
        Object2IntOpenHashMap object2IntOpenHashMap;
        Object2IntOpenHashMap $this$createOpenHashMap_u24lambda_u240 = object2IntOpenHashMap = new Object2IntOpenHashMap();
        boolean bl = false;
        $this$createOpenHashMap_u24lambda_u240.defaultReturnValue(-1);
        return object2IntOpenHashMap;
    }

    private static final Reader addIgnoredSource$lambda$0() {
        return null;
    }

    private static final Reader addMapping$lambda$0() {
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$Base64VLQ;", "", "<init>", "()V", "VLQ_BASE_SHIFT", "", "VLQ_BASE", "VLQ_BASE_MASK", "VLQ_CONTINUATION_BIT", "BASE64_MAP", "", "getBASE64_MAP$annotations", "toVLQSigned", "value", "encode", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "js.sourcemap"})
    private static final class Base64VLQ {
        @NotNull
        public static final Base64VLQ INSTANCE = new Base64VLQ();
        @NotNull
        private static final char[] BASE64_MAP;

        private Base64VLQ() {
        }

        private final int toVLQSigned(int value2) {
            return value2 < 0 ? (-value2 << 1) + 1 : value2 << 1;
        }

        public final void encode(@NotNull StringBuilder out, int value2) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int value3 = this.toVLQSigned(value2);
            do {
                int digit = value3 & 0x1F;
                if ((value3 >>>= 5) > 0) {
                    digit |= 0x20;
                }
                out.append(BASE64_MAP[digit]);
            } while (value3 > 0);
        }

        static {
            char[] cArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            BASE64_MAP = cArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u001f\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$SourceKey;", "", "sourcePath", "", "fileIdentity", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "js.sourcemap"})
    private static final class SourceKey {
        @NotNull
        private final String sourcePath;
        @Nullable
        private final Object fileIdentity;

        public SourceKey(@NotNull String sourcePath, @Nullable Object fileIdentity) {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            this.sourcePath = sourcePath;
            this.fileIdentity = fileIdentity;
        }

        @NotNull
        public final SourceKey copy(@NotNull String sourcePath, @Nullable Object fileIdentity) {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            return new SourceKey(sourcePath, fileIdentity);
        }

        public static /* synthetic */ SourceKey copy$default(SourceKey sourceKey, String string, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string = sourceKey.sourcePath;
            }
            if ((n & 2) != 0) {
                object = sourceKey.fileIdentity;
            }
            return sourceKey.copy(string, object);
        }

        @NotNull
        public String toString() {
            return "SourceKey(sourcePath=" + this.sourcePath + ", fileIdentity=" + this.fileIdentity + ')';
        }

        public int hashCode() {
            int result2 = this.sourcePath.hashCode();
            result2 = result2 * 31 + (this.fileIdentity == null ? 0 : this.fileIdentity.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceKey)) {
                return false;
            }
            SourceKey sourceKey = (SourceKey)other;
            if (!Intrinsics.areEqual((Object)this.sourcePath, (Object)sourceKey.sourcePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fileIdentity, (Object)sourceKey.fileIdentity);
        }
    }
}

