/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.lexer;

import org.jetbrains.kotlin.com.intellij.lexer.FlexAdapter;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.lexer.MergeFunction;
import org.jetbrains.kotlin.com.intellij.lexer.MergingLexerAdapterBase;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.lexer._KDocLexer;

public class KDocLexer
extends MergingLexerAdapterBase {
    private final MergeFunction mergeFunction = new KDocLexerMergeFunction();

    public KDocLexer() {
        super(new FlexAdapter(new _KDocLexer(null)));
    }

    @Override
    public MergeFunction getMergeFunction() {
        return this.mergeFunction;
    }

    private static class KDocLexerMergeFunction
    implements MergeFunction {
        private KDocLexerMergeFunction() {
        }

        @Override
        public IElementType merge(IElementType type, Lexer originalLexer) {
            IElementType nextTokenType = originalLexer.getTokenType();
            String nextTokenText = originalLexer.getTokenText();
            if (type == KDocTokens.CODE_BLOCK_TEXT && nextTokenType == KDocTokens.TEXT && (nextTokenText.equals("```") || nextTokenText.equals("~~~"))) {
                originalLexer.advance();
                return KDocTokens.TEXT;
            }
            if (type == KDocTokens.CODE_BLOCK_TEXT || type == KDocTokens.TEXT || type == TokenType.WHITE_SPACE) {
                while (type == originalLexer.getTokenType()) {
                    originalLexer.advance();
                }
            }
            return type;
        }
    }
}

