/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u001a\b\u0002\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n\u0012\u0004\u0012\u00020\u00040\tH\u0080\b\u00f8\u0001\u0000\u001a\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\r\u001a3\u0010\u0011\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00040\tH\u0082\b\u001a\u001e\u0010\u0018\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u001b\u001a\n \u0002*\u0004\u0018\u00010\u00060\u0006*\u00020\rH\u0002\u001a&\u0010\u001c\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u0015\u001a&\u0010\u001c\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u0015\u001a)\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 *\u00020\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H 0\t\u00a2\u0006\u0002\u0010\"\u001a1\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 *\u00020\r2\u0006\u0010#\u001a\u00020\u00152\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H 0\t\u00a2\u0006\u0002\u0010$\u001a\u0012\u0010%\u001a\u00020\u0004*\u00020\r2\u0006\u0010&\u001a\u00020\r\u001a\u0016\u0010'\u001a\u00020\u000e*\u00020\r2\b\b\u0002\u0010#\u001a\u00020\u0015H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"DEFAULT_ZIP_ENTRY_TIME", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "zipDirAsInternal", "", "dirPath", "Ljava/nio/file/Path;", "zipFilePath", "shuffle", "Lkotlin/Function1;", "", "expandSymlinks", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "Ljava/nio/file/FileSystem;", "path", "", "newEntry", "Ljava/util/zip/ZipOutputStream;", "relativePath", "isDir", "", "block", "Ljava/util/zip/ZipEntry;", "recursiveCopyTo", "destination", "resetTimeAttributes", "toPath", "unzipTo", "destinationDirectory", "fromSubdirectory", "withZipFileSystem", "T", "action", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "create", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipDirAs", "zipFile", "zipFileSystem", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n+ 2 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n+ 3 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt$zipDirAsInternal$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt$newEntry$1\n*L\n1#1,200:1\n57#1,4:201\n61#1,5:208\n66#1,3:214\n69#1,14:218\n98#1,22:232\n83#1,2:254\n121#1,2:256\n86#1:258\n97#1,23:259\n121#1,2:283\n88#1,3:285\n91#1:289\n92#1:299\n93#1:309\n98#1,25:317\n97#1,23:342\n121#1,2:366\n98#1,25:394\n97#1,26:419\n219#2,3:205\n230#2,2:290\n222#2,7:292\n230#2,2:300\n222#2,7:302\n219#2,3:310\n219#2,3:313\n230#2,2:369\n222#2,7:371\n230#2,2:378\n222#2,7:380\n219#2,3:387\n219#2,3:390\n230#2,2:446\n222#2,7:448\n230#2,2:455\n222#2,7:457\n219#2,13:464\n57#3:213\n1869#4:217\n1870#4:288\n1869#4:316\n1870#4:368\n1869#4:393\n1870#4:445\n97#5:282\n97#5:365\n*S KotlinDebug\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n*L\n55#1:201,4\n55#1:208,5\n55#1:214,3\n55#1:218,14\n55#1:232,22\n55#1:254,2\n55#1:256,2\n55#1:258\n55#1:259,23\n55#1:283,2\n55#1:285,3\n55#1:289\n55#1:299\n55#1:309\n82#1:317,25\n86#1:342,23\n86#1:366,2\n82#1:394,25\n86#1:419,26\n55#1:205,3\n55#1:290,2\n55#1:292,7\n55#1:300,2\n55#1:302,7\n60#1:310,3\n61#1:313,3\n61#1:369,2\n61#1:371,7\n60#1:378,2\n60#1:380,7\n60#1:387,3\n61#1:390,3\n61#1:446,2\n61#1:448,7\n60#1:455,2\n60#1:457,7\n164#1:464,13\n55#1:213\n55#1:217\n55#1:288\n68#1:316\n68#1:368\n68#1:393\n68#1:445\n55#1:282\n86#1:365\n*E\n"})
public final class ZipUtilKt {
    private static final FileTime DEFAULT_ZIP_ENTRY_TIME = FileTime.fromMillis(0L);

    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean create2) {
        FileSystem fileSystem;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$zipFileSystem, (String)"<this>");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(create2))};
            HashMap attributes = MapsKt.hashMapOf((Pair[])pairArray);
            List<FileSystemProvider> list = FileSystemProvider.installedProviders();
            Intrinsics.checkNotNullExpressionValue(list, (String)"installedProviders()");
            for (FileSystemProvider fileSystemProvider : (Iterable)list) {
                FileSystem fileSystem2;
                FileSystem fileSystem3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)fileSystemProvider.getScheme(), (Object)"jar")) {
                    fileSystem3 = null;
                } else {
                    FileSystem fileSystem4;
                    try {
                        fileSystem4 = fileSystemProvider.newFileSystem(ZipUtilKt.toPath($this$zipFileSystem), (Map)attributes);
                    }
                    catch (Exception e) {
                        Exception exception = e;
                        if (!(exception instanceof UnsupportedOperationException ? true : exception instanceof IllegalArgumentException)) {
                            throw e;
                        }
                        fileSystem4 = null;
                    }
                    fileSystem3 = fileSystem4;
                }
                if ((fileSystem2 = fileSystem3) == null) continue;
                fileSystem = fileSystem2;
                break block7;
            }
            fileSystem = null;
        }
        if (fileSystem == null) {
            throw new ZipException("Cannot create a virtual file system to read KLIB archive file. Probably the file is a malformed archive or does not exist: " + $this$zipFileSystem);
        }
        return fileSystem;
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ZipUtilKt.zipFileSystem(file, bl);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = $this$file.getPath(file.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.getPath(file.path)");
        return new File(path);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = $this$file.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.getPath(path)");
        return new File(path2);
    }

    private static final Path toPath(File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void zipDirAs(@NotNull File $this$zipDirAs, @NotNull File zipFile) {
        void $this$use$iv$iv;
        void dirPath$iv;
        Intrinsics.checkNotNullParameter((Object)$this$zipDirAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Path path = $this$zipDirAs.getJavaPath$kotlin_util_io();
        Path zipFilePath$iv = zipFile.getJavaPath$kotlin_util_io();
        boolean $i$f$zipDirAsInternal = false;
        Path dirPathWithExpandedSymlinks$iv = ZipUtilKt.expandSymlinks((Path)dirPath$iv);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(zipFilePath$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        AutoCloseable autoCloseable = outputStream;
        boolean $i$f$use = false;
        boolean closed$iv$iv = false;
        try {
            OutputStream outputStream$iv = (OutputStream)$this$use$iv$iv;
            boolean bl = false;
            AutoCloseable $this$use$iv$iv2 = new ZipOutputStream(outputStream$iv);
            boolean $i$f$use2 = false;
            boolean closed$iv$iv2 = false;
            try {
                Unit paths$iv;
                ZipOutputStream zipOutputStream$iv = (ZipOutputStream)$this$use$iv$iv2;
                boolean bl2 = false;
                zipOutputStream$iv.setLevel(5);
                Unit unit = Files.walk(dirPathWithExpandedSymlinks$iv, new FileVisitOption[0]).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(unit, (String)"walk(dirPathWithExpanded\u2026lect(Collectors.toList())");
                Unit unit2 = paths$iv = unit;
                boolean bl3 = false;
                Unit it = unit2;
                CollectionsKt.sort(paths$iv);
                Iterable $this$forEach$iv$iv = (Iterable)paths$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    ZipOutputStream $this$newEntry$iv$iv;
                    boolean isDir$iv$iv;
                    Path path$iv = (Path)element$iv$iv;
                    boolean bl4 = false;
                    Path pathWithExpandedSymlinks$iv = ZipUtilKt.expandSymlinks(path$iv);
                    if (!pathWithExpandedSymlinks$iv.startsWith(dirPathWithExpandedSymlinks$iv)) {
                        throw new ZipException("An attempt to escape the source directory " + dirPath$iv + " in symlink " + path$iv);
                    }
                    if (Intrinsics.areEqual((Object)pathWithExpandedSymlinks$iv, (Object)dirPathWithExpandedSymlinks$iv)) continue;
                    String relativePath$iv = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path$iv, (Path)dirPathWithExpandedSymlinks$iv));
                    Object object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    BasicFileAttributes attributes$iv = Files.readAttributes(pathWithExpandedSymlinks$iv, BasicFileAttributes.class, object);
                    if (attributes$iv.isRegularFile()) {
                        ZipEntry zipEntry;
                        object = zipOutputStream$iv;
                        isDir$iv$iv = false;
                        boolean $i$f$newEntry = false;
                        ZipEntry it$iv$iv = zipEntry = new ZipEntry(relativePath$iv);
                        boolean bl5 = false;
                        it$iv$iv.setMethod(8);
                        ZipEntry entry$iv$iv = zipEntry;
                        entry$iv$iv.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv$iv.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv$iv.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv$iv.setExtra(null);
                        $this$newEntry$iv$iv.putNextEntry(entry$iv$iv);
                        ZipEntry it$iv = entry$iv$iv;
                        boolean bl6 = false;
                        Files.copy(pathWithExpandedSymlinks$iv, zipOutputStream$iv);
                        $this$newEntry$iv$iv.closeEntry();
                        continue;
                    }
                    if (attributes$iv.isDirectory()) {
                        void $this$newEntry_u24default$iv$iv;
                        ZipEntry zipEntry;
                        $this$newEntry$iv$iv = zipOutputStream$iv;
                        isDir$iv$iv = true;
                        boolean $i$f$newEntry = false;
                        ZipEntry it$iv$iv = zipEntry = new ZipEntry(relativePath$iv + '/');
                        boolean bl7 = false;
                        it$iv$iv.setMethod(0);
                        it$iv$iv.setSize(0L);
                        it$iv$iv.setCrc(0L);
                        ZipEntry entry$iv$iv = zipEntry;
                        entry$iv$iv.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv$iv.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv$iv.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv$iv.setExtra(null);
                        $this$newEntry_u24default$iv$iv.putNextEntry(entry$iv$iv);
                        ZipEntry bl6 = entry$iv$iv;
                        boolean bl8 = false;
                        ZipEntry it$iv = bl6;
                        $this$newEntry_u24default$iv$iv.closeEntry();
                        continue;
                    }
                    throw new IllegalStateException(("Unsupported file type encountered: " + path$iv).toString());
                }
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv$iv) {
                try {
                    closed$iv$iv2 = true;
                    try {
                        $this$use$iv$iv2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv$iv2) {
                        $this$use$iv$iv2.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv$iv2.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv$iv) {
            try {
                closed$iv$iv = true;
                try {
                    void v4 = $this$use$iv$iv;
                    if (v4 != null) {
                        v4.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv$iv) {
                    void v5 = $this$use$iv$iv;
                    if (v5 != null) {
                        v5.close();
                    }
                }
                throw throwable;
            }
        }
        void v3 = $this$use$iv$iv;
        if (v3 != null) {
            v3.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void zipDirAsInternal(@NotNull Path dirPath, @NotNull Path zipFilePath, @NotNull Function1<? super List<Path>, Unit> shuffle) {
        void $this$use$iv;
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter(shuffle, (String)"shuffle");
        boolean $i$f$zipDirAsInternal = false;
        Path dirPathWithExpandedSymlinks = ZipUtilKt.expandSymlinks(dirPath);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(zipFilePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        AutoCloseable autoCloseable = outputStream;
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            OutputStream outputStream2 = (OutputStream)$this$use$iv;
            boolean bl = false;
            AutoCloseable $this$use$iv2 = new ZipOutputStream(outputStream2);
            boolean $i$f$use2 = false;
            boolean closed$iv2 = false;
            try {
                ZipOutputStream zipOutputStream = (ZipOutputStream)$this$use$iv2;
                boolean bl2 = false;
                zipOutputStream.setLevel(5);
                List list = Files.walk(dirPathWithExpandedSymlinks, new FileVisitOption[0]).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"walk(dirPathWithExpanded\u2026lect(Collectors.toList())");
                List paths = list;
                shuffle.invoke(paths);
                CollectionsKt.sort(paths);
                Iterable $this$forEach$iv = paths;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipOutputStream $this$newEntry$iv;
                    boolean isDir$iv;
                    Path path = (Path)element$iv;
                    boolean bl3 = false;
                    Path pathWithExpandedSymlinks = ZipUtilKt.expandSymlinks(path);
                    if (!pathWithExpandedSymlinks.startsWith(dirPathWithExpandedSymlinks)) {
                        throw new ZipException("An attempt to escape the source directory " + dirPath + " in symlink " + path);
                    }
                    if (Intrinsics.areEqual((Object)pathWithExpandedSymlinks, (Object)dirPathWithExpandedSymlinks)) continue;
                    String relativePath = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path, (Path)dirPathWithExpandedSymlinks));
                    Object object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    BasicFileAttributes attributes = Files.readAttributes(pathWithExpandedSymlinks, BasicFileAttributes.class, object);
                    if (attributes.isRegularFile()) {
                        ZipEntry zipEntry;
                        object = zipOutputStream;
                        isDir$iv = false;
                        boolean $i$f$newEntry = false;
                        ZipEntry it$iv = zipEntry = new ZipEntry(relativePath);
                        boolean bl4 = false;
                        it$iv.setMethod(8);
                        ZipEntry entry$iv = zipEntry;
                        entry$iv.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setExtra(null);
                        $this$newEntry$iv.putNextEntry(entry$iv);
                        ZipEntry it = entry$iv;
                        boolean bl5 = false;
                        Files.copy(pathWithExpandedSymlinks, zipOutputStream);
                        $this$newEntry$iv.closeEntry();
                        continue;
                    }
                    if (attributes.isDirectory()) {
                        void $this$newEntry_u24default$iv;
                        ZipEntry zipEntry;
                        $this$newEntry$iv = zipOutputStream;
                        isDir$iv = true;
                        boolean $i$f$newEntry = false;
                        ZipEntry it$iv = zipEntry = new ZipEntry(relativePath + '/');
                        boolean bl6 = false;
                        it$iv.setMethod(0);
                        it$iv.setSize(0L);
                        it$iv.setCrc(0L);
                        ZipEntry entry$iv = zipEntry;
                        entry$iv.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setExtra(null);
                        $this$newEntry_u24default$iv.putNextEntry(entry$iv);
                        ZipEntry bl5 = entry$iv;
                        boolean bl7 = false;
                        ZipEntry it = bl5;
                        $this$newEntry_u24default$iv.closeEntry();
                        continue;
                    }
                    throw new IllegalStateException(("Unsupported file type encountered: " + path).toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv2 = true;
                    try {
                        $this$use$iv2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    InlineMarker.finallyStart((int)1);
                    if (!closed$iv2) {
                        $this$use$iv2.close();
                    }
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
            }
            InlineMarker.finallyStart((int)1);
            $this$use$iv2.close();
            InlineMarker.finallyEnd((int)1);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    void v4 = $this$use$iv;
                    if (v4 != null) {
                        v4.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed$iv) {
                    void v5 = $this$use$iv;
                    if (v5 != null) {
                        v5.close();
                    }
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        void v3 = $this$use$iv;
        if (v3 != null) {
            v3.close();
        }
        InlineMarker.finallyEnd((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static /* synthetic */ void zipDirAsInternal$default(Path dirPath, Path zipFilePath, Function1 shuffle, int n, Object object) {
        void $this$use$iv;
        if ((n & 4) != 0) {
            shuffle = zipDirAsInternal.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)shuffle, (String)"shuffle");
        boolean $i$f$zipDirAsInternal = false;
        Path dirPathWithExpandedSymlinks = ZipUtilKt.expandSymlinks(dirPath);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(zipFilePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        AutoCloseable autoCloseable = outputStream;
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            OutputStream outputStream2 = (OutputStream)$this$use$iv;
            boolean bl = false;
            AutoCloseable $this$use$iv2 = new ZipOutputStream(outputStream2);
            boolean $i$f$use2 = false;
            boolean closed$iv2 = false;
            try {
                ZipOutputStream zipOutputStream = (ZipOutputStream)$this$use$iv2;
                boolean bl2 = false;
                zipOutputStream.setLevel(5);
                List list = Files.walk(dirPathWithExpandedSymlinks, new FileVisitOption[0]).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"walk(dirPathWithExpanded\u2026lect(Collectors.toList())");
                List paths = list;
                shuffle.invoke(paths);
                CollectionsKt.sort(paths);
                Iterable $this$forEach$iv = paths;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipOutputStream $this$newEntry$iv;
                    boolean isDir$iv;
                    Path path = (Path)element$iv;
                    boolean bl3 = false;
                    Path pathWithExpandedSymlinks = ZipUtilKt.expandSymlinks(path);
                    if (!pathWithExpandedSymlinks.startsWith(dirPathWithExpandedSymlinks)) {
                        throw new ZipException("An attempt to escape the source directory " + dirPath + " in symlink " + path);
                    }
                    if (Intrinsics.areEqual((Object)pathWithExpandedSymlinks, (Object)dirPathWithExpandedSymlinks)) continue;
                    String relativePath = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path, (Path)dirPathWithExpandedSymlinks));
                    Object object2 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    BasicFileAttributes attributes = Files.readAttributes(pathWithExpandedSymlinks, BasicFileAttributes.class, object2);
                    if (attributes.isRegularFile()) {
                        ZipEntry zipEntry;
                        object2 = zipOutputStream;
                        isDir$iv = false;
                        boolean $i$f$newEntry = false;
                        ZipEntry it$iv = zipEntry = new ZipEntry(relativePath);
                        boolean bl4 = false;
                        it$iv.setMethod(8);
                        ZipEntry entry$iv = zipEntry;
                        entry$iv.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setExtra(null);
                        $this$newEntry$iv.putNextEntry(entry$iv);
                        ZipEntry it = entry$iv;
                        boolean bl5 = false;
                        Files.copy(pathWithExpandedSymlinks, zipOutputStream);
                        $this$newEntry$iv.closeEntry();
                        continue;
                    }
                    if (attributes.isDirectory()) {
                        void $this$newEntry_u24default$iv;
                        ZipEntry zipEntry;
                        $this$newEntry$iv = zipOutputStream;
                        isDir$iv = true;
                        boolean $i$f$newEntry = false;
                        ZipEntry it$iv = zipEntry = new ZipEntry(relativePath + '/');
                        boolean bl6 = false;
                        it$iv.setMethod(0);
                        it$iv.setSize(0L);
                        it$iv.setCrc(0L);
                        ZipEntry entry$iv = zipEntry;
                        entry$iv.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
                        entry$iv.setExtra(null);
                        $this$newEntry_u24default$iv.putNextEntry(entry$iv);
                        ZipEntry bl5 = entry$iv;
                        boolean bl7 = false;
                        ZipEntry it = bl5;
                        $this$newEntry_u24default$iv.closeEntry();
                        continue;
                    }
                    throw new IllegalStateException(("Unsupported file type encountered: " + path).toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv2 = true;
                    try {
                        $this$use$iv2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    InlineMarker.finallyStart((int)1);
                    if (!closed$iv2) {
                        $this$use$iv2.close();
                    }
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
            }
            InlineMarker.finallyStart((int)1);
            $this$use$iv2.close();
            InlineMarker.finallyEnd((int)1);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    void v4 = $this$use$iv;
                    if (v4 != null) {
                        v4.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed$iv) {
                    void v5 = $this$use$iv;
                    if (v5 != null) {
                        v5.close();
                    }
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        void v3 = $this$use$iv;
        if (v3 != null) {
            v3.close();
        }
        InlineMarker.finallyEnd((int)1);
    }

    private static final Path expandSymlinks(Path $this$expandSymlinks) {
        Path path;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Windows", (boolean)false, (int)2, null)) {
            String rawPath = ((Object)$this$expandSymlinks).toString();
            Path path2 = StringsKt.startsWith$default((String)rawPath, (String)"/", (boolean)false, (int)2, null) ? Paths.get(StringsKt.removePrefix((String)rawPath, (CharSequence)"/"), new String[0]) : $this$expandSymlinks;
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n        val rawPath = \u2026se\n            this\n    }");
        } else {
            path = $this$expandSymlinks;
        }
        Path correctedPath = path;
        Path path3 = correctedPath.toRealPath(new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"correctedPath.toRealPath()");
        return path3;
    }

    public static final void unzipTo(@NotNull File $this$unzipTo, @NotNull File destinationDirectory, @NotNull File fromSubdirectory, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)fromSubdirectory, (String)"fromSubdirectory");
        ZipUtilKt.withZipFileSystem($this$unzipTo, (Function1)new Function1<FileSystem, Unit>(fromSubdirectory, destinationDirectory, resetTimeAttributes){
            final /* synthetic */ File $fromSubdirectory;
            final /* synthetic */ File $destinationDirectory;
            final /* synthetic */ boolean $resetTimeAttributes;
            {
                this.$fromSubdirectory = $fromSubdirectory;
                this.$destinationDirectory = $destinationDirectory;
                this.$resetTimeAttributes = $resetTimeAttributes;
                super(1);
            }

            public final void invoke(FileSystem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ZipUtilKt.access$recursiveCopyTo(ZipUtilKt.file(it, this.$fromSubdirectory), this.$destinationDirectory, this.$resetTimeAttributes);
            }
        });
    }

    public static /* synthetic */ void unzipTo$default(File file, File file2, File file3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file3 = new File("/");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ZipUtilKt.unzipTo(file, file2, file3, bl);
    }

    public static final void unzipTo(@NotNull Path $this$unzipTo, @NotNull Path destinationDirectory, @NotNull Path fromSubdirectory, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)fromSubdirectory, (String)"fromSubdirectory");
        ZipUtilKt.unzipTo(new File($this$unzipTo), new File(destinationDirectory), new File(fromSubdirectory), resetTimeAttributes);
    }

    public static /* synthetic */ void unzipTo$default(Path path, Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            Path path4 = Paths.get("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(\"/\")");
            path3 = path4;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ZipUtilKt.unzipTo(path, path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean create2, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = ZipUtilKt.zipFileSystem($this$withZipFileSystem, create2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            object = action.invoke((Object)$this$use$iv);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)object;
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }

    private static final void recursiveCopyTo(File $this$recursiveCopyTo, File destination, boolean resetTimeAttributes) {
        Path sourcePath = $this$recursiveCopyTo.getJavaPath$kotlin_util_io();
        Path destPath = destination.getJavaPath$kotlin_util_io();
        FileSystem destFs = destPath.getFileSystem();
        Path normalizedDestPath = destPath.normalize();
        Files.walk(sourcePath, new FileVisitOption[0]).forEach(new Consumer(sourcePath, destFs, destPath, normalizedDestPath, destination, resetTimeAttributes){
            final /* synthetic */ Path $sourcePath;
            final /* synthetic */ FileSystem $destFs;
            final /* synthetic */ Path $destPath;
            final /* synthetic */ Path $normalizedDestPath;
            final /* synthetic */ File $destination;
            final /* synthetic */ boolean $resetTimeAttributes;
            {
                this.$sourcePath = $sourcePath;
                this.$destFs = $destFs;
                this.$destPath = $destPath;
                this.$normalizedDestPath = $normalizedDestPath;
                this.$destination = $destination;
                this.$resetTimeAttributes = $resetTimeAttributes;
            }

            public final void accept(Path oldPath) {
                Path relative = this.$sourcePath.relativize(oldPath);
                Object[] objectArray = new String[]{((Object)relative).toString()};
                Path newPath = this.$destFs.getPath(((Object)this.$destPath).toString(), (String[])objectArray);
                if (!newPath.normalize().startsWith(this.$normalizedDestPath)) {
                    throw new ZipException(relative + " attempted to escape the destination directory " + this.$destination);
                }
                if (Intrinsics.areEqual((Object)newPath, (Object)newPath.getRoot())) {
                    return;
                }
                if (Files.isDirectory(newPath, new LinkOption[0])) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(oldPath, newPath, (CopyOption[])objectArray);
                }
                if (this.$resetTimeAttributes) {
                    FileTime zero = FileTime.fromMillis(0L);
                    Files.getFileAttributeView(newPath, BasicFileAttributeView.class, new LinkOption[0]).setTimes(zero, zero, zero);
                }
            }
        });
    }

    public static final /* synthetic */ void access$recursiveCopyTo(File $receiver, File destination, boolean resetTimeAttributes) {
        ZipUtilKt.recursiveCopyTo($receiver, destination, resetTimeAttributes);
    }
}

