/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KlibAttributes;
import org.jetbrains.kotlin.library.KlibComponent;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.loader.KlibLoader;
import org.jetbrains.kotlin.library.loader.KlibLoaderSpec;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/ToolingSingleFileKlibResolveStrategy;", "Lorg/jetbrains/kotlin/library/SingleFileKlibResolveStrategy;", "()V", "fakeLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "libraryFile", "Lorg/jetbrains/kotlin/konan/file/File;", "resolve", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "tryResolve", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nToolingResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolingResolve.kt\norg/jetbrains/kotlin/library/ToolingSingleFileKlibResolveStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class ToolingSingleFileKlibResolveStrategy
implements SingleFileKlibResolveStrategy {
    @NotNull
    public static final ToolingSingleFileKlibResolveStrategy INSTANCE = new ToolingSingleFileKlibResolveStrategy();

    private ToolingSingleFileKlibResolveStrategy() {
    }

    @Override
    @NotNull
    public KotlinLibrary resolve(@NotNull File libraryFile, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        KotlinLibrary kotlinLibrary = this.tryResolve(libraryFile, logger);
        if (kotlinLibrary == null) {
            kotlinLibrary = this.fakeLibrary(libraryFile);
        }
        return kotlinLibrary;
    }

    @Nullable
    public final KotlinLibrary tryResolve(@NotNull File libraryFile, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        int n = 0;
        while (n < 0) {
            int it = n++;
            boolean bl = false;
            logger.log("Trying to resolve KLIB: " + libraryFile);
        }
        return (KotlinLibrary)CollectionsKt.singleOrNull(new KlibLoader((Function1<? super KlibLoaderSpec, Unit>)((Function1)new Function1<KlibLoaderSpec, Unit>(libraryFile){
            final /* synthetic */ File $libraryFile;
            {
                this.$libraryFile = $libraryFile;
                super(1);
            }

            public final void invoke(KlibLoaderSpec $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                String[] stringArray = new String[]{this.$libraryFile.getPath()};
                $this$$receiver.libraryPaths(stringArray);
            }
        })).load().getLibrariesStdlibFirst());
    }

    private final KotlinLibrary fakeLibrary(File libraryFile) {
        return new KotlinLibrary(libraryFile){
            private final File location;
            private final KlibAttributes attributes;
            private final KotlinLibraryVersioning versions;
            private final Properties manifestProperties;
            {
                this.location = $libraryFile;
                this.attributes = new KlibAttributes();
                this.versions = new KotlinLibraryVersioning(null, null, null, null, 8, null);
                this.manifestProperties = new Properties();
            }

            public String toString() {
                return "[non-existent library] " + this.getLocation();
            }

            public File getLocation() {
                return this.location;
            }

            public KlibAttributes getAttributes() {
                return this.attributes;
            }

            public KotlinLibraryVersioning getVersions() {
                return this.versions;
            }

            public Properties getManifestProperties() {
                return this.manifestProperties;
            }

            public <KC extends KlibComponent> KC getComponent(KlibComponent.Kind<KC, ?> kind) {
                Intrinsics.checkNotNullParameter(kind, (String)"kind");
                return null;
            }

            public String getLibraryName() {
                return this.getLocation().getPath();
            }

            public File getLibraryFile() {
                return this.getLocation();
            }
        };
    }
}

