/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.one.util.streamex;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.kotlin.one.util.streamex.CancellableCollector;

interface Internals {
    public static final Function<int[], Integer> UNBOX_INT = box -> box[0];
    public static final Function<long[], Long> UNBOX_LONG = box -> box[0];
    public static final Function<double[], Double> UNBOX_DOUBLE = box -> box[0];
    public static final Object NONE = new Object();
    public static final Set<Collector.Characteristics> NO_CHARACTERISTICS = EnumSet.noneOf(Collector.Characteristics.class);
    public static final Set<Collector.Characteristics> UNORDERED_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED);
    public static final Set<Collector.Characteristics> UNORDERED_ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    public static final Set<Collector.Characteristics> ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <A> Predicate<A> finished(Collector<?, A, ?> collector) {
        if (collector instanceof CancellableCollector) {
            return ((CancellableCollector)collector).finished();
        }
        return null;
    }

    public static abstract class CloneableSpliterator<T, S extends CloneableSpliterator<T, ?>>
    implements Cloneable,
    Spliterator<T> {
        S doClone() {
            try {
                return (S)((CloneableSpliterator)this.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    public static interface TailSpliterator<T>
    extends Spliterator<T> {
        public Spliterator<T> tryAdvanceOrTail(Consumer<? super T> var1);

        public Spliterator<T> forEachOrTail(Consumer<? super T> var1);

        public static <T> Spliterator<T> tryAdvanceWithTail(Spliterator<T> target, Consumer<? super T> action) {
            while (target instanceof TailSpliterator) {
                Spliterator<? super T> spltr = ((TailSpliterator)target).tryAdvanceOrTail(action);
                if (spltr == null || spltr == target) {
                    return spltr;
                }
                target = spltr;
            }
            return target.tryAdvance(action) ? target : null;
        }

        public static <T> void forEachWithTail(Spliterator<T> target, Consumer<? super T> action) {
            block2: {
                while (target instanceof TailSpliterator) {
                    Spliterator<? super T> spltr = ((TailSpliterator)target).forEachOrTail(action);
                    if (spltr != null) {
                        target = spltr;
                        continue;
                    }
                    break block2;
                }
                target.forEachRemaining(action);
            }
        }
    }

    public static class ArrayCollection
    extends AbstractCollection<Object> {
        private final Object[] arr;

        ArrayCollection(Object[] arr) {
            this.arr = arr;
        }

        @Override
        public Iterator<Object> iterator() {
            return Arrays.asList(this.arr).iterator();
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Object[] toArray() {
            return this.arr;
        }
    }

    public static class CancelException
    extends Error {
        CancelException() {
            super(null, null, false, false);
        }
    }

    public static final class PairBox<A, B>
    extends Box<A> {
        B b;

        PairBox(A a, B b) {
            super(a);
            this.b = b;
        }

        public int hashCode() {
            return this.b == null ? 0 : this.b.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == PairBox.class && Objects.equals(this.b, ((PairBox)obj).b);
        }
    }

    public static class Box<A>
    implements Consumer<A> {
        A a;

        Box(A obj) {
            this.a = obj;
        }

        @Override
        public void accept(A a) {
            this.a = a;
        }
    }

    public static final class CancellableCollectorImpl<T, A, R>
    extends CancellableCollector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Predicate<A> finished;
        private final Set<Collector.Characteristics> characteristics;

        CancellableCollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Predicate<A> finished, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.finished = finished;
            this.characteristics = characteristics;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }

        @Override
        Predicate<A> finished() {
            return this.finished;
        }
    }
}

