/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/PackagePartClassUtils;", "", "<init>", "()V", "PART_CLASS_NAME_SUFFIX", "", "getPackagePartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFilePartShortName", "psi-impl"})
public final class PackagePartClassUtils {
    @NotNull
    public static final PackagePartClassUtils INSTANCE = new PackagePartClassUtils();

    private PackagePartClassUtils() {
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String partClassName = PackagePartClassUtils.getFilePartShortName(file);
        Name name2 = Name.identifier(partClassName);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return packageFqName.child(name2);
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        String string2 = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
        String nameWithoutExtension = string2;
        if (file.isCompiled()) {
            return nameWithoutExtension;
        }
        return NameUtils.getPackagePartClassNamePrefix(nameWithoutExtension) + "Kt";
    }
}

