/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.calls.tower.LambdaContextInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(0);
        }
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@Nullable KtExpression condition, @NotNull ExpressionTypingContext context2) {
        if (context2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(1);
        }
        if (condition != null) {
            ExpressionTypingContext conditionContext = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(this.components.builtIns.getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinTypeInfo typeInfo = this.facade.getTypeInfo(condition, conditionContext);
            DataFlowInfo dataFlowInfo = this.components.dataFlowAnalyzer.checkType(typeInfo, condition, (ResolutionContext)conditionContext).getDataFlowInfo();
            if (dataFlowInfo == null) {
                ControlStructureTypingVisitor.$$$reportNull$$$0(2);
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (dataFlowInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(3);
        }
        return dataFlowInfo;
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression ifExpression, ExpressionTypingContext context2) {
        if (ifExpression == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(4);
        }
        KtExpression condition = ifExpression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(condition, context2);
        boolean loopBreakContinuePossibleInCondition = condition != null && this.containsJumpOutOfLoop(condition, context2);
        KtExpression elseBranch = ifExpression.getElse();
        KtExpression thenBranch = ifExpression.getThen();
        LexicalWritableScope thenScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.THEN, this.components.overloadChecker);
        LexicalWritableScope elseScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.ELSE, this.components.overloadChecker);
        DataFlowInfo thenInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context2).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context2).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                KotlinTypeInfo result2 = this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, context2, ifExpression);
                return result2.getJumpOutPossible() ? result2.replaceJumpOutPossible(true).replaceJumpFlowInfo(conditionDataFlowInfo) : result2;
            }
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getUnitType(), thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, context2, ifExpression);
        }
        KtPsiFactory psiFactory = new KtPsiFactory(ifExpression.getProject(), false);
        KtBlockExpression thenBlock = psiFactory.wrapInABlockWrapper(thenBranch);
        KtBlockExpression elseBlock = psiFactory.wrapInABlockWrapper(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression, ifExpression, Lists.newArrayList(thenBlock, elseBlock));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, conditionDataFlowInfo, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, ControlStructureTypingUtils.ResolveConstruct.IF, Lists.newArrayList("thenBranch", "elseBranch"), Lists.newArrayList(false, false), context2, dataFlowInfoForArguments);
        return this.processIfBranches(ifExpression, context2, conditionDataFlowInfo, loopBreakContinuePossibleInCondition, elseBranch, thenBranch, resolvedCall2);
    }

    @NotNull
    private KotlinTypeInfo processIfBranches(KtIfExpression ifExpression, ExpressionTypingContext context2, DataFlowInfo conditionDataFlowInfo, boolean loopBreakContinuePossibleInCondition, KtExpression elseBranch, KtExpression thenBranch, ResolvedCall<FunctionDescriptor> resolvedCall2) {
        DataFlowInfo resultDataFlowInfo;
        BindingContext bindingContext = context2.trace.getBindingContext();
        KotlinTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, bindingContext);
        KotlinTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, bindingContext);
        boolean isThenPostponed = ArgumentTypeResolver.isFunctionLiteralOrCallableReference(thenBranch, context2);
        boolean isElsePostponed = ArgumentTypeResolver.isFunctionLiteralOrCallableReference(thenBranch, context2);
        assert (thenTypeInfo != null || elseTypeInfo != null || isThenPostponed || isElsePostponed) : "Both branches of if expression were not processed: " + ifExpression.getText();
        if (thenTypeInfo == null && elseTypeInfo == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                ControlStructureTypingVisitor.$$$reportNull$$$0(5);
            }
            return kotlinTypeInfo;
        }
        KotlinType resultType = resolvedCall2.getResultingDescriptor().getReturnType();
        boolean loopBreakContinuePossible = loopBreakContinuePossibleInCondition;
        if (elseTypeInfo == null) {
            loopBreakContinuePossible |= thenTypeInfo.getJumpOutPossible();
            resultDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        } else if (thenTypeInfo == null) {
            loopBreakContinuePossible |= elseTypeInfo.getJumpOutPossible();
            resultDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        } else {
            boolean jumpInElse;
            KotlinType thenType = thenTypeInfo.getType();
            KotlinType elseType = elseTypeInfo.getType();
            DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
            DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
            if (resultType != null && thenType != null && elseType != null) {
                DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(ifExpression, resultType, context2);
                DataFlowValue thenValue = this.components.dataFlowValueFactory.createDataFlowValue(thenBranch, thenType, context2);
                thenDataFlowInfo = thenDataFlowInfo.assign(resultValue, thenValue, this.components.languageVersionSettings);
                DataFlowValue elseValue = this.components.dataFlowValueFactory.createDataFlowValue(elseBranch, elseType, context2);
                elseDataFlowInfo = elseDataFlowInfo.assign(resultValue, elseValue, this.components.languageVersionSettings);
            }
            loopBreakContinuePossible |= thenTypeInfo.getJumpOutPossible() || elseTypeInfo.getJumpOutPossible();
            boolean jumpInThen = thenType != null && KotlinBuiltIns.isNothing(thenType);
            boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.isNothing(elseType);
            resultDataFlowInfo = thenType == null && elseType == null ? thenDataFlowInfo.or(elseDataFlowInfo) : (thenType == null || jumpInThen && !jumpInElse ? elseDataFlowInfo : (elseType == null || jumpInElse && !jumpInThen ? thenDataFlowInfo : thenDataFlowInfo.or(elseDataFlowInfo)));
            if (thenType == null && jumpInElse || elseType == null && jumpInThen) {
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
                if (kotlinTypeInfo == null) {
                    ControlStructureTypingVisitor.$$$reportNull$$$0(6);
                }
                return kotlinTypeInfo;
            }
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(resultType, (KtExpression)ifExpression, (ResolutionContext)context2), resultDataFlowInfo, loopBreakContinuePossible, loopBreakContinuePossibleInCondition ? context2.dataFlowInfo : conditionDataFlowInfo);
        if (kotlinTypeInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(7);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull KtExpression presentBranch, @NotNull LexicalWritableScope presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context2, @NotNull KtIfExpression ifExpression) {
        if (presentBranch == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(8);
        }
        if (presentScope == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(9);
        }
        if (presentInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(10);
        }
        if (otherInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(12);
        }
        if (ifExpression == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(13);
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KotlinTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext);
        KotlinType type = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type != null && KotlinBuiltIns.isNothing(type) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)ifExpression, (ResolutionContext)context2).replaceDataFlowInfo(dataFlowInfo);
        if (kotlinTypeInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(14);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(15);
        }
        return this.visitWhileExpression(expression2, context2, false);
    }

    public KotlinTypeInfo visitWhileExpression(KtWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context2.dataFlowInfo, this.components.languageVersionSettings));
        KtExpression condition = expression2.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(condition, context2);
        KtExpression body = expression2.getBody();
        DataFlowInfo conditionInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context2).and(dataFlowInfo);
        if (body != null) {
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.WHILE_BODY, this.components.overloadChecker);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context2.replaceDataFlowInfo(conditionInfo));
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(conditionInfo);
        }
        if (!this.containsJumpOutOfLoop(expression2, context2)) {
            dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context2).and(dataFlowInfo);
        }
        if (body != null && KtPsiUtil.isTrueConstant(condition)) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo(), this.components.languageVersionSettings));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final @NotNull KtExpression expression2, final ExpressionTypingContext context2) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(16);
        }
        final boolean[] result2 = new boolean[]{false};
        expression2.accept(new KtTreeVisitor<List<KtLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull KtBreakExpression breakExpression, List<KtLoopExpression> outerLoops) {
                KtSimpleNameExpression targetLabel;
                PsiElement element;
                if (breakExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement psiElement = element = (targetLabel = breakExpression.getTargetLabel()) != null ? context2.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (outerLoops.isEmpty() || element == expression2 || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == expression2) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull KtContinueExpression expression22, List<KtLoopExpression> outerLoops) {
                PsiElement element;
                KtSimpleNameExpression targetLabel;
                if (expression22 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((targetLabel = expression22.getTargetLabel()) != null && (element = context2.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof KtLoopExpression && !outerLoops.contains(element)) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull KtLoopExpression loopExpression, List<KtLoopExpression> outerLoops) {
                if (loopExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                ArrayList<KtLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression);
                return (Void)super.visitLoopExpression(loopExpression, newOuterLoops);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "breakExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loopExpression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBreakExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitContinueExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLoopExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, expression2 instanceof KtLoopExpression ? Lists.newArrayList((KtLoopExpression)expression2) : Lists.newArrayList());
        return result2[0];
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(17);
        }
        return this.visitDoWhileExpression(expression2, context2, false);
    }

    public KotlinTypeInfo visitDoWhileExpression(KtDoWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression body = expression2.getBody();
        LexicalScope conditionScope = context2.scope;
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context2.dataFlowInfo, this.components.languageVersionSettings));
        if (body instanceof KtLambdaExpression) {
            bodyTypeInfo = this.facade.getTypeInfo(body, context2);
        } else if (body != null) {
            LexicalWritableScope writableScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.DO_WHILE_BODY, this.components.overloadChecker);
            conditionScope = writableScope;
            List<KtExpression> block = body instanceof KtBlockExpression ? ((KtBlockExpression)body).getStatements() : Collections.singletonList(body);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context2);
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KtExpression condition = expression2.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(condition, (ExpressionTypingContext)context2.replaceScope(conditionScope));
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression2, context2) ? this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context2).and(conditionDataFlowInfo) : context2.dataFlowInfo;
        if (body != null) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo(), this.components.languageVersionSettings));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(18);
        }
        return this.visitForExpression(expression2, context2, false);
    }

    public KotlinTypeInfo visitForExpression(KtForExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KtExpression body;
        KotlinTypeInfo loopRangeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context2.dataFlowInfo, this.components.languageVersionSettings));
        KtExpression loopRange = expression2.getLoopRange();
        KotlinType expectedParameterType = null;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, context2);
            loopRangeInfo = this.facade.getTypeInfo(loopRange, context2);
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context2);
            }
        } else {
            loopRangeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        }
        LexicalWritableScope loopScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.FOR, this.components.overloadChecker);
        KtParameter loopParameter = expression2.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context2);
            ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = this.components.modifiersChecker.withTrace(context2.trace);
            modifiersCheckingProcedure.checkModifiersForLocalDeclaration(loopParameter, variableDescriptor);
            this.components.identifierChecker.checkDeclaration(loopParameter, context2.trace);
            loopScope.addVariableDescriptor(variableDescriptor);
            KtDestructuringDeclaration multiParameter = loopParameter.getDestructuringDeclaration();
            if (multiParameter != null) {
                KotlinType elementType = expectedParameterType == null ? ErrorUtils.createErrorType(ErrorTypeKind.NO_TYPE_FOR_LOOP_RANGE, new String[0]) : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)loopScope, loopParameter.getModifierList(), context2.trace);
                this.components.destructuringDeclarationResolver.defineLocalVariablesFromDestructuringDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context2);
                modifiersCheckingProcedure.checkModifiersForDestructuringDeclaration(multiParameter);
                this.components.identifierChecker.checkDeclaration(multiParameter, context2.trace);
            }
        }
        KotlinTypeInfo bodyTypeInfo = (body = expression2.getBody()) != null ? this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context2.replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo())) : loopRangeInfo;
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo());
    }

    private VariableDescriptor createLoopParameterDescriptor(KtParameter loopParameter, KotlinType expectedParameterType, ExpressionTypingContext context2) {
        VariableDescriptor variableDescriptor;
        this.components.modifiersChecker.withTrace(context2.trace).checkParameterHasNoValOrVar(loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        KtTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context2.scope, loopParameter, context2.trace);
            KotlinType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context2.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType(ErrorTypeKind.NO_TYPE_FOR_LOOP_PARAMETER, new String[0]);
            }
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context2.trace, context2.scope);
        }
        ExpressionTypingUtils.checkVariableShadowing(context2.scope, context2.trace, variableDescriptor);
        return variableDescriptor;
    }

    @Override
    public KotlinTypeInfo visitTryExpression(@NotNull KtTryExpression expression2, ExpressionTypingContext typingContext) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(19);
        }
        expression2.getCatchClauses().forEach(catchClause -> {
            KtParameterList parameters = catchClause.getParameterList();
            if (parameters != null && parameters.getStub() == null) {
                TrailingCommaChecker.INSTANCE.check(parameters.getTrailingComma(), typingContext.trace, typingContext.languageVersionSettings);
            }
        });
        if (typingContext.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
            return this.resolveTryExpressionWithNewInference(expression2, typingContext);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        KtBlockExpression tryBlock = expression2.getTryBlock();
        List<KtCatchClause> catchClauses = expression2.getCatchClauses();
        KtFinallySection finallyBlock = expression2.getFinallyBlock();
        ArrayList<KotlinType> types2 = new ArrayList<KotlinType>();
        boolean nothingInAllCatchBranches = true;
        for (KtCatchClause catchClause2 : catchClauses) {
            KtParameter catchParameter = catchClause2.getCatchParameter();
            KtExpression catchBody = catchClause2.getCatchBody();
            boolean nothingInCatchBranch = false;
            if (catchParameter != null) {
                VariableDescriptor variableDescriptor = this.resolveAndCheckCatchParameter(catchParameter, context2);
                if (catchBody != null) {
                    LexicalWritableScope catchScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.CATCH, this.components.overloadChecker);
                    catchScope.addVariableDescriptor(variableDescriptor);
                    KotlinType type = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context2.replaceScope(catchScope)).getType();
                    if (type != null) {
                        types2.add(type);
                        if (KotlinBuiltIns.isNothing(type)) {
                            nothingInCatchBranch = true;
                        }
                    }
                }
            }
            if (nothingInCatchBranch) continue;
            nothingInAllCatchBranches = false;
        }
        KotlinTypeInfo tryResult = this.facade.getTypeInfo(tryBlock, context2);
        ExpressionTypingContext tryOutputContext = this.getCleanedContextFromTryWithAssignmentsToVar(expression2, nothingInAllCatchBranches, context2);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(tryOutputContext);
        if (finallyBlock != null) {
            result2 = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), tryOutputContext);
        } else if (nothingInAllCatchBranches) {
            result2 = tryResult;
        }
        KotlinType type = tryResult.getType();
        if (type != null) {
            types2.add(type);
        }
        if (types2.isEmpty()) {
            return result2.clearType();
        }
        return result2.replaceType(CommonSupertypes.commonSupertype(types2));
    }

    private KotlinTypeInfo resolveTryExpressionWithNewInference(@NotNull KtTryExpression tryExpression, ExpressionTypingContext tryInputContext) {
        if (tryExpression == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(20);
        }
        KtBlockExpression tryBlock = tryExpression.getTryBlock();
        List<KtCatchClause> catchClauses = tryExpression.getCatchClauses();
        KtFinallySection finallySection = tryExpression.getFinallyBlock();
        DataFlowInfo dataFlowInfoBeforeTry = tryInputContext.dataFlowInfo;
        PreliminaryLoopVisitor tryVisitor = PreliminaryLoopVisitor.visitTryBlock(tryExpression);
        ExpressionTypingContext tryOutputContext = (ExpressionTypingContext)tryInputContext.replaceDataFlowInfo(tryVisitor.clearDataFlowInfoForAssignedLocalVariables(dataFlowInfoBeforeTry, this.components.languageVersionSettings));
        DataFlowInfo dataFlowInfoAfterTry = tryOutputContext.dataFlowInfo;
        ArrayList<KtExpression> catchBlocks = Lists.newArrayList();
        ArrayList<kotlin.Pair<KtExpression, VariableDescriptor>> catchClausesBlocksAndParameters = Lists.newArrayList();
        for (KtCatchClause catchClause : catchClauses) {
            KtParameter catchParameter = catchClause.getCatchParameter();
            KtExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            VariableDescriptor variableDescriptor = this.resolveAndCheckCatchParameter(catchParameter, tryInputContext);
            if (catchBody == null) continue;
            catchBlocks.add(catchBody);
            catchClausesBlocksAndParameters.add(new kotlin.Pair((Object)catchBody, (Object)variableDescriptor));
        }
        KtBlockExpression finallyBlock = null;
        if (finallySection != null) {
            finallyBlock = finallySection.getFinalExpression();
        }
        ArrayList<KtExpression> arguments = Lists.newArrayList(tryBlock);
        arguments.addAll(catchBlocks);
        Call callForTry = ControlStructureTypingUtils.createCallForSpecialConstruction(tryExpression, tryExpression, arguments);
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsOfTryCall(callForTry, dataFlowInfoBeforeTry, dataFlowInfoBeforeTry);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveTryAsCall(callForTry, catchClausesBlocksAndParameters, tryInputContext, dataFlowInfoForArguments);
        KotlinType resultType = resolvedCall2.getResultingDescriptor().getReturnType();
        BindingContext bindingContext = tryInputContext.trace.getBindingContext();
        return this.processTryBranches(tryExpression, tryBlock, tryInputContext, catchBlocks, finallyBlock, bindingContext, resultType);
    }

    @NotNull
    private KotlinTypeInfo processTryBranches(@NotNull KtTryExpression tryExpression, KtBlockExpression tryBlock, ExpressionTypingContext context2, List<KtExpression> catchBlocks, KtBlockExpression finallyBlock, BindingContext bindingContext, KotlinType resultType) {
        KotlinTypeInfo tryInfo;
        if (tryExpression == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(21);
        }
        DataFlowInfo dataFlowInfoAfterTry = (tryInfo = BindingContextUtils.getRecordedTypeInfo(tryBlock, bindingContext)) != null ? tryInfo.getDataFlowInfo() : DataFlowInfo.Companion.getEMPTY();
        boolean nothingInAllCatchBranches = ControlStructureTypingVisitor.isCatchBranchesReturnsNothing(catchBlocks, bindingContext);
        ExpressionTypingContext tryOutputContext = (ExpressionTypingContext)((ExpressionTypingContext)this.getCleanedContextFromTryWithAssignmentsToVar(tryExpression, nothingInAllCatchBranches, context2).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.createTypeInfo(resultType, tryOutputContext);
        if (finallyBlock != null) {
            KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(finallyBlock, tryOutputContext).replaceType(resultType);
            if (kotlinTypeInfo == null) {
                ControlStructureTypingVisitor.$$$reportNull$$$0(22);
            }
            return kotlinTypeInfo;
        }
        if (!nothingInAllCatchBranches || tryInfo == null) {
            KotlinTypeInfo kotlinTypeInfo = result2;
            if (kotlinTypeInfo == null) {
                ControlStructureTypingVisitor.$$$reportNull$$$0(23);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(resultType, (KtExpression)tryExpression, (ResolutionContext)tryOutputContext), dataFlowInfoAfterTry);
        if (kotlinTypeInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(24);
        }
        return kotlinTypeInfo;
    }

    private static boolean isCatchBranchesReturnsNothing(List<KtExpression> catchBlocks, BindingContext bindingContext) {
        return CollectionsKt.all(ControlStructureTypingVisitor.whichCatchBranchesReturnNothing(catchBlocks, bindingContext), it -> it);
    }

    private static List<Boolean> whichCatchBranchesReturnNothing(List<KtExpression> catchBlocks, BindingContext bindingContext) {
        return catchBlocks.stream().map(catchBlock -> BindingContextUtils.getRecordedTypeInfo(catchBlock, bindingContext)).map(catchTypeInfo -> {
            if (catchTypeInfo == null) {
                return true;
            }
            KotlinType catchType = catchTypeInfo.getType();
            return catchType == null || KotlinBuiltIns.isNothing(catchType);
        }).collect(Collectors.toList());
    }

    private VariableDescriptor resolveAndCheckCatchParameter(@NotNull KtParameter catchParameter, ExpressionTypingContext context2) {
        if (catchParameter == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(25);
        }
        this.checkCatchParameterDeclaration(catchParameter, context2);
        VariableDescriptor variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context2.scope, catchParameter, context2.trace);
        KotlinType catchParameterType = variableDescriptor.getType();
        ControlStructureTypingVisitor.checkCatchParameterType(catchParameter, catchParameterType, context2);
        SimpleType throwableType = this.components.builtIns.getThrowable().getDefaultType();
        this.components.dataFlowAnalyzer.checkType(catchParameterType, (KtExpression)catchParameter, (ResolutionContext)context2.replaceExpectedType(throwableType));
        return variableDescriptor;
    }

    private ExpressionTypingContext getCleanedContextFromTryWithAssignmentsToVar(KtTryExpression tryExpression, boolean nothingInAllCatchBranches, ExpressionTypingContext context2) {
        context2 = (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (!nothingInAllCatchBranches && this.facade.getComponents().languageVersionSettings.supportsFeature(LanguageFeature.SoundSmartCastsAfterTry)) {
            PreliminaryLoopVisitor tryVisitor = PreliminaryLoopVisitor.visitTryBlock(tryExpression);
            context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(tryVisitor.clearDataFlowInfoForAssignedLocalVariables(context2.dataFlowInfo, this.components.languageVersionSettings));
        }
        return context2;
    }

    private static void checkCatchParameterType(KtParameter catchParameter, KotlinType catchParameterType, ExpressionTypingContext context2) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(catchParameterType);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                context2.trace.report(Errors.REIFIED_TYPE_IN_CATCH_CLAUSE.on(catchParameter));
            } else {
                context2.trace.report(Errors.TYPE_PARAMETER_IN_CATCH_CLAUSE.on(catchParameter));
            }
        }
    }

    private void checkCatchParameterDeclaration(KtParameter catchParameter, ExpressionTypingContext context2) {
        this.components.identifierChecker.checkDeclaration(catchParameter, context2.trace);
        ModifiersChecker.ModifiersCheckingProcedure modifiersChecking = this.components.modifiersChecker.withTrace(context2.trace);
        modifiersChecking.checkParameterHasNoValOrVar(catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
        ModifierCheckerCore.INSTANCE.check(catchParameter, context2.trace, null, this.components.languageVersionSettings);
        if (catchParameter.hasDefaultValue()) {
            context2.trace.report(Errors.CATCH_PARAMETER_WITH_DEFAULT_VALUE.on(catchParameter));
        }
    }

    @Override
    public KotlinTypeInfo visitThrowExpression(@NotNull KtThrowExpression expression2, ExpressionTypingContext context2) {
        KtExpression thrownExpression;
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(26);
        }
        if ((thrownExpression = expression2.getThrownExpression()) != null) {
            SimpleType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(throwableType)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context2, expression2);
    }

    @Override
    public KotlinTypeInfo visitReturnExpression(@NotNull KtReturnExpression expression2, ExpressionTypingContext context2) {
        SimpleFunctionDescriptor functionDescriptor;
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(27);
        }
        KtElement labelTargetElement = LabelResolver.INSTANCE.resolveControlLabel(expression2, context2);
        KtExpression returnedExpression = expression2.getReturnedExpression();
        KotlinResolutionCallbacksImpl.LambdaInfo newInferenceLambdaInfo = null;
        KotlinType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        SimpleType resultType = this.components.builtIns.getNothingType();
        KtDeclaration parentDeclaration = (KtDeclaration)context2.getContextParentOfType(expression2, KtDeclaration.class);
        if (parentDeclaration instanceof KtParameter) {
            context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
        }
        if (expression2.getTargetLabel() == null) {
            while (parentDeclaration instanceof KtDestructuringDeclaration) {
                parentDeclaration = (KtDeclaration)context2.getContextParentOfType(parentDeclaration, KtDeclaration.class);
            }
            DeclarationDescriptor declarationDescriptor = context2.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
            Pair<FunctionDescriptor, PsiElement> containingFunInfo = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(declarationDescriptor, false);
            FunctionDescriptor containingFunctionDescriptor = containingFunInfo.getFirst();
            if (containingFunctionDescriptor != null) {
                if (!InlineUtil.checkNonLocalReturnUsage(containingFunctionDescriptor, expression2, context2) || ControlStructureTypingVisitor.isClassInitializer(containingFunInfo)) {
                    context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                    resultType = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_NOT_ALLOWED, new String[0]);
                }
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (KtElement)containingFunInfo.getSecond(), context2);
                newInferenceLambdaInfo = ExpressionTypingServices.getNewInferenceLambdaInfo(context2, (KtElement)containingFunInfo.getSecond());
            } else {
                context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_NOT_ALLOWED, new String[0]);
            }
        } else if (labelTargetElement != null && (functionDescriptor = context2.trace.get(BindingContext.FUNCTION, labelTargetElement)) != null) {
            KtExpression callExpression;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement, context2);
            newInferenceLambdaInfo = ExpressionTypingServices.getNewInferenceLambdaInfo(context2, labelTargetElement);
            if (!InlineUtil.checkNonLocalReturnUsage(functionDescriptor, expression2, context2)) {
                context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_NOT_ALLOWED, new String[0]);
            } else if (labelTargetElement instanceof KtFunctionLiteral && Objects.equals(expression2.getLabelName(), "suspend") && (resolvedCall2 = CallUtilKt.getResolvedCall(callExpression = KtPsiUtil.getParentCallIfPresent((KtFunction)labelTargetElement), context2.trace.getBindingContext())) != null && !KtPsiUtil.isLabeledFunctionLiteral((KtFunctionLiteral)labelTargetElement) && Objects.equals(DescriptorUtilsKt.fqNameOrNull(resolvedCall2.getResultingDescriptor()), SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
                context2.trace.report(Errors.RETURN_FOR_BUILT_IN_SUSPEND.on(expression2));
            }
        }
        if (returnedExpression != null) {
            if (newInferenceLambdaInfo != null) {
                LambdaContextInfo contextInfo;
                KtExpression deparenthesizedReturnExpression = KtPsiUtil.deparenthesize(returnedExpression);
                if (deparenthesizedReturnExpression instanceof KtLambdaExpression || deparenthesizedReturnExpression instanceof KtCallableReferenceExpression) {
                    contextInfo = new LambdaContextInfo(new KotlinTypeInfo(TypeUtils.DONT_CARE, context2.dataFlowInfo), null, context2.scope, context2.trace);
                } else {
                    KotlinTypeInfo result2 = this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(newInferenceLambdaInfo.getExpectedType())).replaceContextDependency(newInferenceLambdaInfo.getContextDependency()));
                    contextInfo = new LambdaContextInfo(result2, null, context2.scope, context2.trace);
                }
                newInferenceLambdaInfo.getReturnStatements().add((kotlin.Pair<KtReturnExpression, LambdaContextInfo>)new kotlin.Pair((Object)expression2, (Object)contextInfo));
            } else {
                this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceContextDependency(ContextDependency.INDEPENDENT));
            }
        } else {
            if (!(TypeUtils.noExpectedType(expectedType) || KotlinBuiltIns.isUnit(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType))) {
                context2.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression2, expectedType));
            }
            if (newInferenceLambdaInfo != null) {
                newInferenceLambdaInfo.getReturnStatements().add((kotlin.Pair<KtReturnExpression, LambdaContextInfo>)new kotlin.Pair((Object)expression2, null));
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context2, expression2);
    }

    private static boolean isClassInitializer(@NotNull Pair<FunctionDescriptor, PsiElement> containingFunInfo) {
        if (containingFunInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(28);
        }
        return containingFunInfo.getFirst() instanceof ConstructorDescriptor && !(containingFunInfo.getSecond() instanceof KtSecondaryConstructor);
    }

    @Override
    public KotlinTypeInfo visitBreakExpression(@NotNull KtBreakExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(29);
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context2);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context2, expression2).replaceJumpOutPossible(true);
    }

    @Override
    public KotlinTypeInfo visitContinueExpression(@NotNull KtContinueExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(30);
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context2);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context2, expression2).replaceJumpOutPossible(true);
    }

    @NotNull
    private static KotlinType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor, @NotNull KtElement function2, @NotNull ExpressionTypingContext context2) {
        KotlinType expectedType;
        if (descriptor == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(31);
        }
        if (function2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(32);
        }
        if (context2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(33);
        }
        if (function2 instanceof KtSecondaryConstructor) {
            expectedType = DescriptorUtilsKt.getBuiltIns(descriptor).getUnitType();
        } else if (function2 instanceof KtFunction) {
            KtFunction ktFunction = (KtFunction)function2;
            expectedType = context2.trace.get(BindingContext.EXPECTED_RETURN_TYPE, ktFunction);
            if (expectedType == null && (ktFunction.getTypeReference() != null || ktFunction.hasBlockBody())) {
                expectedType = descriptor.getReturnType();
            }
        } else {
            expectedType = descriptor.getReturnType();
        }
        KotlinType kotlinType = expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
        if (kotlinType == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(34);
        }
        return kotlinType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: 
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentBranch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherInfo";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchParameter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFunInfo";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCondition";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processIfBranches";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfoWhenOnlyOneBranchIsPresent";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "processTryBranches";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionExpectedReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkCondition";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 34: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoWhenOnlyOneBranchIsPresent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsJumpOutOfLoop";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveTryExpressionWithNewInference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processTryBranches";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCheckCatchParameter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isClassInitializer";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExpectedReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

