/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020%J\u0015\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011\u00a2\u0006\u0004\b'\u0010\u0013J\u0015\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015\u00a2\u0006\u0004\b)\u0010\u0017J\u0015\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015\u00a2\u0006\u0004\b+\u0010\u0017J\u000e\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020%J\u0017\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b/\u0010\u0017J\u0017\u00100\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b1\u0010\u0017J\u0010\u00102\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/ByteWriter;", "", "os", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "writeByte", "", "v", "", "writeBytes", "", "writeUByte", "Lkotlin/UByte;", "writeUByte-7apg3OU", "(B)V", "writeUInt16", "Lkotlin/UShort;", "writeUInt16-xj2QHRw", "(S)V", "writeUInt32", "Lkotlin/UInt;", "writeUInt32-WZ4Q5Ns", "(I)V", "writeUInt64", "Lkotlin/ULong;", "writeUInt64-VKZWuLQ", "(J)V", "size", "", "writeUInt64-4PLdz1A", "(JI)V", "writeVarInt7", "writeVarInt32", "writeVarInt64", "", "writeVarUInt1", "", "writeVarUInt7", "writeVarUInt7-xj2QHRw", "writeVarUInt32", "writeVarUInt32-WZ4Q5Ns", "writeVarUInt32FixedSize", "writeVarUInt32FixedSize-WZ4Q5Ns", "writeBoolean", "value", "writeUnsignedLeb128Fixed", "writeUnsignedLeb128Fixed-WZ4Q5Ns", "writeUnsignedLeb128", "writeUnsignedLeb128-WZ4Q5Ns", "writeSignedLeb128", "wasm.ir"})
public class ByteWriter {
    @NotNull
    private final OutputStream os;

    public ByteWriter(@NotNull OutputStream os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        this.os = os;
    }

    public final void writeByte(byte v) {
        this.os.write(v);
    }

    public final void writeBytes(@NotNull byte[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.os.write(v);
    }

    public final void writeUByte-7apg3OU(byte v) {
        this.writeByte(v);
    }

    public final void writeUInt16-xj2QHRw(short v) {
        this.writeByte((byte)v);
        this.writeByte((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(v & 0xFFFF)) >>> 8)));
    }

    public final void writeUInt32-WZ4Q5Ns(int v) {
        this.writeByte((byte)v);
        this.writeByte((byte)UInt.constructor-impl((int)(v >>> 8)));
        this.writeByte((byte)UInt.constructor-impl((int)(v >>> 16)));
        this.writeByte((byte)UInt.constructor-impl((int)(v >>> 24)));
    }

    public final void writeUInt64-VKZWuLQ(long v) {
        this.writeByte((byte)v);
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 8)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 16)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 24)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 32)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 40)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 48)));
        this.writeByte((byte)ULong.constructor-impl((long)(v >>> 56)));
    }

    public final void writeUInt64-4PLdz1A(long v, int size) {
        switch (size) {
            case 1: {
                this.writeUByte-7apg3OU(UByte.constructor-impl((byte)((byte)v)));
                break;
            }
            case 2: {
                this.writeUInt16-xj2QHRw(UShort.constructor-impl((short)((short)v)));
                break;
            }
            case 4: {
                this.writeUInt32-WZ4Q5Ns(UInt.constructor-impl((int)((int)v)));
                break;
            }
            case 8: {
                this.writeUInt64-VKZWuLQ(v);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported size " + size).toString());
            }
        }
    }

    public final void writeVarInt7(byte v) {
        this.writeSignedLeb128(v);
    }

    public final void writeVarInt32(int v) {
        this.writeSignedLeb128(v);
    }

    public final void writeVarInt64(long v) {
        this.writeSignedLeb128(v);
    }

    public final void writeVarUInt1(boolean v) {
        this.writeUnsignedLeb128-WZ4Q5Ns(v ? 1 : 0);
    }

    public final void writeVarUInt7-xj2QHRw(short v) {
        this.writeUnsignedLeb128-WZ4Q5Ns(UInt.constructor-impl((int)(v & 0xFFFF)));
    }

    public final void writeVarUInt32-WZ4Q5Ns(int v) {
        this.writeUnsignedLeb128-WZ4Q5Ns(v);
    }

    public final void writeVarUInt32FixedSize-WZ4Q5Ns(int v) {
        this.writeUnsignedLeb128Fixed-WZ4Q5Ns(v);
    }

    public final void writeBoolean(boolean value2) {
        this.writeByte(value2 ? (byte)1 : 0);
    }

    private final void writeUnsignedLeb128Fixed-WZ4Q5Ns(int v) {
        int v2 = 0;
        v2 = v;
        int remaining = 0;
        remaining = UInt.constructor-impl((int)(v2 >>> 7));
        int n = 4;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            int n3 = UInt.constructor-impl((int)(UInt.constructor-impl((int)(v2 & 0x7F)) | 0x80));
            this.writeByte((byte)n3);
            v2 = remaining;
            remaining = UInt.constructor-impl((int)(remaining >>> 7));
        }
        int n4 = UInt.constructor-impl((int)(v2 & 0x7F));
        this.writeByte((byte)n4);
    }

    private final void writeUnsignedLeb128-WZ4Q5Ns(int v) {
        int n;
        int v2 = v;
        int remaining = UInt.constructor-impl((int)(v2 >>> 7));
        while (remaining != 0) {
            n = UInt.constructor-impl((int)(UInt.constructor-impl((int)(v2 & 0x7F)) | 0x80));
            this.writeByte((byte)n);
            v2 = remaining;
            remaining = UInt.constructor-impl((int)(remaining >>> 7));
        }
        n = UInt.constructor-impl((int)(v2 & 0x7F));
        this.writeByte((byte)n);
    }

    private final void writeSignedLeb128(long v) {
        long end;
        long v2 = v;
        long remaining = v2 >> 7;
        boolean hasMore = true;
        long l = end = (v2 & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (v2 >> 6 & 1L);
            int n = (int)(v2 & 0x7FL | (hasMore ? 128L : 0L));
            this.writeByte((byte)n);
            v2 = remaining;
            remaining >>= 7;
        }
    }
}

