/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.wasm.ir.DeclarationResolver;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.convertors.Function;
import org.jetbrains.kotlin.wasm.ir.convertors.FunctionHeapType;
import org.jetbrains.kotlin.wasm.ir.convertors.FunctionType;
import org.jetbrains.kotlin.wasm.ir.convertors.Global;
import org.jetbrains.kotlin.wasm.ir.convertors.Type;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/BinaryToIrResolver;", "Lorg/jetbrains/kotlin/wasm/ir/DeclarationResolver;", "<init>", "()V", "functions", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "getFunctions", "()Ljava/util/List;", "globalFields", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "getGlobalFields", "gcTypes", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "getGcTypes", "functionTypes", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "getFunctionTypes", "resolve", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType$Type;", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$TypeIdx;", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$GlobalIdx;", "function", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$FuncIdx;", "wasm.ir"})
final class BinaryToIrResolver
extends DeclarationResolver {
    @NotNull
    private final List<WasmFunction> functions = new ArrayList();
    @NotNull
    private final List<WasmGlobal> globalFields = new ArrayList();
    @NotNull
    private final List<WasmTypeDeclaration> gcTypes = new ArrayList();
    @NotNull
    private final List<WasmFunctionType> functionTypes = new ArrayList();

    @NotNull
    public final List<WasmFunction> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final List<WasmGlobal> getGlobalFields() {
        return this.globalFields;
    }

    @NotNull
    public final List<WasmTypeDeclaration> getGcTypes() {
        return this.gcTypes;
    }

    @NotNull
    public final List<WasmFunctionType> getFunctionTypes() {
        return this.functionTypes;
    }

    @Override
    @NotNull
    public WasmTypeDeclaration resolve(@NotNull WasmHeapType.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.functionTypes.get(((FunctionHeapType)type).getIndex());
    }

    @Override
    @NotNull
    public WasmTypeDeclaration resolve(@NotNull WasmImmediate.TypeIdx type) {
        WasmTypeDeclaration wasmTypeDeclaration;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmImmediate.TypeIdx typeIdx = type;
        if (typeIdx instanceof FunctionType) {
            wasmTypeDeclaration = this.functionTypes.get(((FunctionType)type).getIndex());
        } else if (typeIdx instanceof Type) {
            wasmTypeDeclaration = this.gcTypes.get(((Type)type).getIndex());
        } else {
            throw new IllegalStateException(("Unknown type:" + Reflection.getOrCreateKotlinClass(type.getClass()).getSimpleName()).toString());
        }
        return wasmTypeDeclaration;
    }

    @Override
    @NotNull
    public WasmGlobal resolve(@NotNull WasmImmediate.GlobalIdx global) {
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        return this.globalFields.get(((Global)global).getIndex());
    }

    @Override
    @NotNull
    public WasmFunction resolve(@NotNull WasmImmediate.FuncIdx function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.functions.get(((Function)function2).getIndex());
    }
}

