/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstructionKt;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.convertors.OptimizeFlow;
import org.jetbrains.kotlin.wasm.ir.convertors.OptimizeFlowBase;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/MergeSetAndGetIntoTee;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlowBase;", "output", "Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlow;", "<init>", "(Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlow;)V", "firstInstruction", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "push", "", "instruction", "flash", "wasm.ir"})
final class MergeSetAndGetIntoTee
extends OptimizeFlowBase {
    @Nullable
    private WasmInstr firstInstruction;

    public MergeSetAndGetIntoTee(@NotNull OptimizeFlow output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        super(output2);
    }

    @Override
    public void push(@NotNull WasmInstr instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (instruction.getOperator().getOpcode() == 65535) {
            this.flash();
            this.getOutput().push(instruction);
            return;
        }
        WasmInstr first = this.firstInstruction;
        if (first == null) {
            this.firstInstruction = instruction;
            return;
        }
        if (first.getOperator() == WasmOp.LOCAL_SET && instruction.getOperator() == WasmOp.LOCAL_GET) {
            if (!(first.getImmediatesCount() == 1 && instruction.getImmediatesCount() == 1)) {
                throw new IllegalStateException("Check failed.");
            }
            WasmImmediate firstImmediate = WasmInstructionKt.firstImmediateOrNull(first);
            WasmImmediate secondImmediate = WasmInstructionKt.firstImmediateOrNull(instruction);
            WasmImmediate.LocalIdx localIdx = firstImmediate instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)firstImmediate : null;
            Integer setNumber = localIdx != null ? Integer.valueOf(localIdx.getValue()) : null;
            WasmImmediate.LocalIdx localIdx2 = secondImmediate instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)secondImmediate : null;
            Integer getNumber = localIdx2 != null ? Integer.valueOf(localIdx2.getValue()) : null;
            if (!(setNumber != null && getNumber != null)) {
                throw new IllegalStateException("Check failed.");
            }
            if (Intrinsics.areEqual((Object)getNumber, (Object)setNumber)) {
                SourceLocation location = instruction.getLocation();
                this.firstInstruction = location != null ? WasmInstructionKt.wasmInstrWithLocation(WasmOp.LOCAL_TEE, location, firstImmediate) : WasmInstructionKt.wasmInstrWithoutLocation(WasmOp.LOCAL_TEE, firstImmediate);
                return;
            }
        }
        this.firstInstruction = instruction;
        this.getOutput().push(first);
    }

    @Override
    protected void flash() {
        block0: {
            WasmInstr wasmInstr = this.firstInstruction;
            if (wasmInstr == null) break block0;
            WasmInstr it = wasmInstr;
            boolean bl = false;
            this.getOutput().push(it);
            this.firstInstruction = null;
        }
    }
}

