/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstructionKt;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.convertors.InstructionsFlowOptimizersKt;
import org.jetbrains.kotlin.wasm.ir.convertors.OptimizeFlow;
import org.jetbrains.kotlin.wasm.ir.convertors.OptimizeFlowBase;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/RemoveInstructionPriorUnreachable;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlowBase;", "output", "Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlow;", "<init>", "(Lorg/jetbrains/kotlin/wasm/ir/convertors/OptimizeFlow;)V", "firstInstruction", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "push", "", "instruction", "flash", "wasm.ir"})
final class RemoveInstructionPriorUnreachable
extends OptimizeFlowBase {
    @Nullable
    private WasmInstr firstInstruction;

    public RemoveInstructionPriorUnreachable(@NotNull OptimizeFlow output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        super(output2);
    }

    @Override
    public void push(@NotNull WasmInstr instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (instruction.getOperator().getOpcode() == 65535) {
            this.flash();
            this.getOutput().push(instruction);
            return;
        }
        WasmInstr first = this.firstInstruction;
        this.firstInstruction = instruction;
        if (first == null) {
            return;
        }
        if (instruction.getOperator() == WasmOp.UNREACHABLE && (InstructionsFlowOptimizersKt.access$pureStacklessInstruction(first.getOperator()) || first.getOperator() == WasmOp.NOP)) {
            if (first.getOperator() != WasmOp.NOP) {
                SourceLocation.DefinedLocation firstLocation;
                SourceLocation sourceLocation = first.getLocation();
                SourceLocation.DefinedLocation definedLocation = firstLocation = sourceLocation instanceof SourceLocation.DefinedLocation ? (SourceLocation.DefinedLocation)sourceLocation : null;
                if (firstLocation != null) {
                    this.getOutput().push(WasmInstructionKt.wasmInstrWithLocation(WasmOp.NOP, firstLocation));
                }
            }
        } else {
            this.getOutput().push(first);
        }
    }

    @Override
    protected void flash() {
        block0: {
            WasmInstr wasmInstr = this.firstInstruction;
            if (wasmInstr == null) break block0;
            WasmInstr it = wasmInstr;
            boolean bl = false;
            this.push(it);
            this.firstInstruction = null;
        }
    }
}

