/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.DeclarationResolver;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmData;
import org.jetbrains.kotlin.wasm.ir.WasmDataMode;
import org.jetbrains.kotlin.wasm.ir.WasmElement;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmFuncRef;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstructionKt;
import org.jetbrains.kotlin.wasm.ir.WasmLimits;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmMemory;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.WasmNamedModuleField;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmTag;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;
import org.jetbrains.kotlin.wasm.ir.convertors.SExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToTextKt;
import org.jetbrains.kotlin.wasm.ir.debug.DebugData;
import org.jetbrains.kotlin.wasm.ir.debug.DebugInformationConsumer;
import org.jetbrains.kotlin.wasm.ir.debug.DebugInformationGenerator;
import org.jetbrains.kotlin.wasm.ir.debug.DebugSection;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocationMappingToText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014H\u0016J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0016\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010\"\u001a\u00020(H\u0002J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u00102\u0006\u0010*\u001a\u00020-J\u0016\u0010.\u001a\u00020\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0012H\u0002J\u0006\u00101\u001a\u00020\u0010J\u0010\u00102\u001a\u00020\u00102\u0006\u0010*\u001a\u000203H\u0002J!\u00104\u001a\u00020\u00102\b\u00105\u001a\u0004\u0018\u0001002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001007H\u0082\bJ\u0010\u00108\u001a\u00020\u00102\u0006\u0010*\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u00102\u0006\u0010*\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020>H\u0002J\f\u0010?\u001a\u00020\u0010*\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010=\u001a\u00020\fH\u0002J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020MH\u0002J\u0014\u0010N\u001a\u00020\u00102\n\u0010O\u001a\u0006\u0012\u0002\b\u00030PH\u0002J\u0010\u0010Q\u001a\u00020\u00102\u0006\u0010R\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020\u00102\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020\u00102\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020\u00102\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020\u00102\u0006\u0010^\u001a\u00020_H\u0002J\u000e\u0010`\u001a\u00020\u00102\u0006\u0010*\u001a\u00020aJ\u000e\u0010b\u001a\u00020\u00102\u0006\u0010*\u001a\u00020cJ\u000e\u0010d\u001a\u00020\u00102\u0006\u0010*\u001a\u00020cJ\u0010\u0010e\u001a\u00020\u00102\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020\u00102\u0006\u0010f\u001a\u00020gH\u0002J\u000e\u0010i\u001a\u00020\u00102\u0006\u0010^\u001a\u00020_J\u000e\u0010i\u001a\u00020\u00102\u0006\u0010^\u001a\u00020jJ\u000e\u0010k\u001a\u00020\u00102\u0006\u0010l\u001a\u00020jJ\u000e\u0010m\u001a\u00020\u00102\u0006\u0010n\u001a\u00020oJ\u0014\u0010p\u001a\u00020\u00102\f\u0010f\u001a\b\u0012\u0004\u0012\u00020r0qJ\u000e\u0010p\u001a\u00020\u00102\u0006\u0010f\u001a\u00020rJ\u0010\u0010s\u001a\u00020\u00102\u0006\u0010t\u001a\u00020%H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToText;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/SExpressionBuilder;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationConsumer;", "module", "Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "debugInformationGenerator", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationGenerator;", "<init>", "(Lorg/jetbrains/kotlin/wasm/ir/WasmModule;Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationGenerator;)V", "getModule", "()Lorg/jetbrains/kotlin/wasm/ir/WasmModule;", "currentFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Defined;", "resolver", "Lorg/jetbrains/kotlin/wasm/ir/DeclarationResolver;", "consumeDebugInformation", "", "debugInformation", "", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugSection;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformation;", "appendOffset", "value", "Lkotlin/UInt;", "appendOffset-WZ4Q5Ns", "(I)V", "appendAlign", "appendAlign-WZ4Q5Ns", "appendInstrList", "instr", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "appendInstr", "wasmInstr", "appendImmediate", "x", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "f32Str", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$ConstF32;", "f64Str", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$ConstF64;", "appendBlockType", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$BlockType;", "appendRefType", "Lorg/jetbrains/kotlin/wasm/ir/WasmRefType;", "appendWasmTypeList", "typeList", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "appendWasmModule", "appendFunctionTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "maybeSubType", "superType", "body", "Lkotlin/Function0;", "appendStructTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "appendArrayTypeDeclaration", "Lorg/jetbrains/kotlin/wasm/ir/WasmArrayDeclaration;", "appendImportedFunction", "function", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction$Imported;", "appendImportPair", "Lorg/jetbrains/kotlin/wasm/ir/WasmImportDescriptor;", "appendDefinedFunction", "appendTable", "table", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable;", "appendMemory", "memory", "Lorg/jetbrains/kotlin/wasm/ir/WasmMemory;", "appendLimits", "limits", "Lorg/jetbrains/kotlin/wasm/ir/WasmLimits;", "appendGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "appendExport", "export", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "appendWasmElement", "element", "Lorg/jetbrains/kotlin/wasm/ir/WasmElement;", "appendStartFunction", "startFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "appendData", "wasmData", "Lorg/jetbrains/kotlin/wasm/ir/WasmData;", "appendTag", "wasmTag", "Lorg/jetbrains/kotlin/wasm/ir/WasmTag;", "appendLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "appendHeapType", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "appendReferencedType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "appendType", "appendStructField", "field", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructFieldDeclaration;", "appendFieldType", "appendLocalReference", "", "appendIdxIfNotZero", "id", "appendCatch", "catch", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch;", "appendModuleFieldReference", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmNamedModuleField;", "appendWatString", "s", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmIrToText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmIrToText.kt\norg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 WasmIrToText.kt\norg/jetbrains/kotlin/wasm/ir/convertors/SExpressionBuilder\n*L\n1#1,720:1\n355#1,2:836\n357#1,2:840\n359#1:848\n361#1:851\n363#1:856\n1915#2,2:721\n1915#2,2:724\n1915#2,2:726\n1915#2,2:728\n1915#2,2:734\n1915#2,2:738\n1915#2,2:748\n1915#2,2:754\n1915#2,2:762\n1915#2:769\n1916#2:779\n1915#2,2:780\n1915#2,2:782\n1915#2,2:784\n1915#2,2:786\n1915#2,2:788\n1915#2,2:790\n1915#2,2:792\n1915#2,2:794\n1915#2,2:796\n1915#2,2:811\n1915#2,2:817\n1915#2,2:844\n1915#2,2:900\n1915#2,2:904\n1915#2,2:908\n1786#2,3:971\n1915#2,2:1015\n1915#2,2:1048\n1#3:723\n39#4,4:730\n39#4,2:736\n41#4,2:740\n39#4,4:742\n39#4,2:746\n41#4,2:750\n39#4,2:752\n41#4,2:756\n39#4,4:758\n32#4,3:764\n21#4,2:767\n32#4,3:770\n21#4,4:773\n35#4,2:777\n23#4,2:798\n35#4,2:800\n32#4,3:802\n21#4,2:805\n39#4,2:807\n39#4,2:809\n41#4,2:813\n39#4,2:815\n41#4,2:819\n41#4,2:821\n23#4,2:823\n35#4,2:825\n39#4,4:827\n32#4,3:831\n21#4,2:834\n39#4,2:838\n39#4,2:842\n41#4,2:846\n41#4,2:849\n39#4,4:852\n23#4,2:857\n35#4,2:859\n32#4,3:861\n21#4,2:864\n39#4,4:866\n23#4,2:870\n35#4,2:872\n32#4,3:874\n21#4,2:877\n39#4,4:879\n23#4,2:883\n35#4,2:885\n39#4,4:887\n32#4,3:891\n21#4,2:894\n39#4,4:896\n39#4,2:902\n41#4,2:906\n23#4,2:910\n35#4,2:912\n32#4,3:914\n21#4,4:917\n35#4,2:921\n32#4,3:923\n21#4,4:926\n35#4,2:930\n32#4,3:932\n21#4,2:935\n39#4,4:937\n23#4,2:941\n35#4,2:943\n32#4,3:945\n21#4,2:948\n39#4,4:950\n23#4,2:954\n35#4,2:956\n32#4,3:958\n21#4,2:961\n39#4,4:963\n39#4,4:967\n39#4,4:974\n23#4,2:978\n35#4,2:980\n32#4,3:982\n21#4,4:985\n35#4,2:989\n32#4,3:991\n21#4,2:994\n39#4,4:996\n39#4,4:1000\n23#4,2:1004\n35#4,2:1006\n32#4,3:1008\n21#4,2:1011\n39#4,2:1013\n41#4,2:1017\n23#4,2:1019\n35#4,2:1021\n32#4,3:1023\n21#4,4:1026\n35#4,2:1030\n39#4,4:1032\n39#4,4:1036\n39#4,4:1040\n39#4,4:1044\n*S KotlinDebug\n*F\n+ 1 WasmIrToText.kt\norg/jetbrains/kotlin/wasm/ir/convertors/WasmIrToText\n*L\n370#1:836,2\n370#1:840,2\n370#1:848\n370#1:851\n370#1:856\n63#1:721,2\n88#1:724,2\n121#1:726,2\n158#1:728,2\n195#1:734,2\n199#1:738,2\n274#1:748,2\n277#1:754,2\n291#1:762,2\n306#1:769\n306#1:779\n314#1:780,2\n324#1:782,2\n325#1:784,2\n326#1:786,2\n327#1:788,2\n328#1:790,2\n329#1:792,2\n331#1:794,2\n332#1:796,2\n343#1:811,2\n347#1:817,2\n372#1:844,2\n410#1:900,2\n413#1:904,2\n416#1:908,2\n485#1:971,3\n537#1:1015,2\n619#1:1048,2\n187#1:730,4\n199#1:736,2\n199#1:740,2\n267#1:742,4\n274#1:746,2\n274#1:750,2\n277#1:752,2\n277#1:756,2\n286#1:758,4\n305#1:764,3\n305#1:767,2\n308#1:770,3\n308#1:773,4\n308#1:777,2\n305#1:798,2\n305#1:800,2\n339#1:802,3\n339#1:805,2\n341#1:807,2\n342#1:809,2\n342#1:813,2\n346#1:815,2\n346#1:819,2\n341#1:821,2\n339#1:823,2\n339#1:825,2\n356#1:827,4\n367#1:831,3\n367#1:834,2\n370#1:838,2\n371#1:842,2\n371#1:846,2\n370#1:849,2\n371#1:852,4\n367#1:857,2\n367#1:859,2\n381#1:861,3\n381#1:864,2\n383#1:866,4\n381#1:870,2\n381#1:872,2\n391#1:874,3\n391#1:877,2\n394#1:879,4\n391#1:883,2\n391#1:885,2\n399#1:887,4\n406#1:891,3\n406#1:894,2\n409#1:896,4\n412#1:902,2\n412#1:906,2\n406#1:910,2\n406#1:912,2\n424#1:914,3\n424#1:917,4\n424#1:921,2\n433#1:923,3\n433#1:926,4\n433#1:930,2\n446#1:932,3\n446#1:935,2\n452#1:937,4\n446#1:941,2\n446#1:943,2\n461#1:945,3\n461#1:948,2\n463#1:950,4\n461#1:954,2\n461#1:956,2\n470#1:958,3\n470#1:961,2\n476#1:963,4\n478#1:967,4\n496#1:974,4\n470#1:978,2\n470#1:980,2\n505#1:982,3\n505#1:985,4\n505#1:989,2\n511#1:991,3\n511#1:994,2\n515#1:996,4\n517#1:1000,4\n511#1:1004,2\n511#1:1006,2\n530#1:1008,3\n530#1:1011,2\n536#1:1013,2\n536#1:1017,2\n530#1:1019,2\n530#1:1021,2\n544#1:1023,3\n544#1:1026,4\n544#1:1030,2\n574#1:1032,4\n579#1:1036,4\n592#1:1040,4\n599#1:1044,4\n*E\n"})
public final class WasmIrToText
extends SExpressionBuilder
implements DebugInformationConsumer {
    @NotNull
    private final WasmModule module;
    @Nullable
    private final DebugInformationGenerator debugInformationGenerator;
    @Nullable
    private WasmFunction.Defined currentFunction;
    @NotNull
    private final DeclarationResolver resolver;

    public WasmIrToText(@NotNull WasmModule module2, @Nullable DebugInformationGenerator debugInformationGenerator) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        this.debugInformationGenerator = debugInformationGenerator;
        this.resolver = this.module.getResolver();
    }

    public /* synthetic */ WasmIrToText(WasmModule wasmModule, DebugInformationGenerator debugInformationGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            debugInformationGenerator = null;
        }
        this(wasmModule, debugInformationGenerator);
    }

    @NotNull
    public final WasmModule getModule() {
        return this.module;
    }

    @Override
    public void consumeDebugInformation(@NotNull List<DebugSection> debugInformation) {
        Intrinsics.checkNotNullParameter(debugInformation, (String)"debugInformation");
        Iterable $this$forEach$iv = debugInformation;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugSection it = (DebugSection)element$iv;
            boolean bl = false;
            this.newLine();
            this.getStringBuilder().append("(; @custom ");
            this.getStringBuilder().append(it.getName());
            if (!(it.getData() instanceof DebugData.StringData)) {
                throw new IllegalStateException(("Unsupported debug data type " + Reflection.getOrCreateKotlinClass(it.getData().getClass())).toString());
            }
            this.getStringBuilder().append(" \"" + ((DebugData.StringData)it.getData()).unbox-impl() + '\"');
            this.getStringBuilder().append(" ;)");
        }
    }

    public final void appendOffset-WZ4Q5Ns(int value2) {
        if (value2 != 0) {
            this.appendElement("offset=" + UInt.toString-impl((int)value2));
        }
    }

    public final void appendAlign-WZ4Q5Ns(int value2) {
        long alignEffective = 0L;
        alignEffective = 1L;
        int n = value2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            alignEffective *= (long)2;
        }
        if (alignEffective != 0L) {
            this.appendElement("align=" + alignEffective);
        }
    }

    private final void appendInstrList(List<? extends WasmInstr> instr) {
        Iterable $this$forEach$iv = instr;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmInstr it = (WasmInstr)element$iv;
            boolean bl = false;
            this.appendInstr(it);
        }
    }

    private final void appendInstr(WasmInstr wasmInstr) {
        WasmOp[] wasmOpArray;
        int n;
        SourceLocation sourceLocation = wasmInstr.getLocation();
        if (sourceLocation != null) {
            SourceLocation it = sourceLocation;
            boolean bl = false;
            DebugInformationGenerator debugInformationGenerator = this.debugInformationGenerator;
            if (debugInformationGenerator != null) {
                debugInformationGenerator.addSourceLocation(new SourceLocationMappingToText(it, new SourceLocation.DefinedLocation("", this.getStringBuilder().getLineNumber(), this.getStringBuilder().getColumnNumber())));
            }
        }
        WasmOp op = wasmInstr.getOperator();
        if (op.getOpcode() == 65535) {
            switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
                case 1: {
                    String text = WasmIrToText.appendInstr$commentText(wasmInstr);
                    if (!(SequencesKt.count((Sequence)StringsKt.lineSequence((CharSequence)text)) < 2)) {
                        boolean $i$a$-require-WasmIrToText$appendInstr$32 = false;
                        String $i$a$-require-WasmIrToText$appendInstr$32 = "Comments for single instruction should be in one line";
                        throw new IllegalArgumentException($i$a$-require-WasmIrToText$appendInstr$32.toString());
                    }
                    this.getStringBuilder().append("  ;; ");
                    this.getStringBuilder().append(text);
                    break;
                }
                case 2: {
                    this.newLine();
                    Iterable $this$forEach$iv = StringsKt.lines((CharSequence)WasmIrToText.appendInstr$commentText(wasmInstr));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String line = (String)element$iv;
                        boolean bl = false;
                        this.newLine();
                        this.getStringBuilder().append(";; ");
                        this.getStringBuilder().append(line);
                    }
                    break;
                }
                case 3: {
                    this.newLine();
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unknown pseudo op " + (Object)((Object)op)).toString());
                }
            }
            return;
        }
        if (op == WasmOp.END || op == WasmOp.ELSE || op == WasmOp.CATCH || op == WasmOp.CATCH_ALL) {
            n = this.getIndent();
            this.setIndent(n + -1);
        }
        this.newLine();
        this.getStringBuilder().append(wasmInstr.getOperator().getMnemonic());
        if (op == WasmOp.BLOCK || op == WasmOp.LOOP || op == WasmOp.IF || op == WasmOp.ELSE || op == WasmOp.CATCH || op == WasmOp.CATCH_ALL || op == WasmOp.TRY || op == WasmOp.TRY_TABLE) {
            n = this.getIndent();
            this.setIndent(n + 1);
        }
        if (SetsKt.setOf((Object[])(wasmOpArray = new WasmOp[]{WasmOp.CALL_INDIRECT, WasmOp.TABLE_INIT})).contains((Object)wasmInstr.getOperator())) {
            List reversed = new ArrayList();
            wasmInstr.forEachImmediates((Function1<? super WasmImmediate, Unit>)((Function1)new Function1<WasmImmediate, Unit>((Object)reversed){

                public final void invoke(WasmImmediate p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }));
            CollectionsKt.reverse((List)reversed);
            Iterable $this$forEach$iv = reversed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WasmImmediate it = (WasmImmediate)element$iv;
                boolean bl = false;
                this.appendImmediate(it);
            }
            this.getStringBuilder().append(wasmInstr.getOperator().getTailMnemonic());
            return;
        }
        wasmInstr.forEachImmediates((Function1<? super WasmImmediate, Unit>)((Function1)arg_0 -> WasmIrToText.appendInstr$lambda$4(this, arg_0)));
        this.getStringBuilder().append(wasmInstr.getOperator().getTailMnemonic());
    }

    /*
     * WARNING - void declaration
     */
    private final void appendImmediate(WasmImmediate x) {
        WasmImmediate wasmImmediate = x;
        if (wasmImmediate instanceof WasmImmediate.ConstU8) {
            String string = UByte.toString-impl((byte)((WasmImmediate.ConstU8)x).getValue-w2LRezQ()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.appendElement(string);
        } else if (wasmImmediate instanceof WasmImmediate.ConstI32) {
            String string = String.valueOf(((WasmImmediate.ConstI32)x).getValue()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.appendElement(string);
        } else if (wasmImmediate instanceof WasmImmediate.ConstI64) {
            String string = String.valueOf(((WasmImmediate.ConstI64)x).getValue()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.appendElement(string);
        } else if (wasmImmediate instanceof WasmImmediate.ConstF32) {
            String string = this.f32Str((WasmImmediate.ConstF32)x).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.appendElement(string);
        } else if (wasmImmediate instanceof WasmImmediate.ConstF64) {
            String string = this.f64Str((WasmImmediate.ConstF64)x).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            this.appendElement(string);
        } else if (wasmImmediate instanceof WasmImmediate.SymbolI32) {
            this.appendElement(String.valueOf(((Number)((WasmImmediate.SymbolI32)x).getValue().getOwner()).intValue()));
        } else if (wasmImmediate instanceof WasmImmediate.MemArg) {
            this.appendOffset-WZ4Q5Ns(((WasmImmediate.MemArg)x).getOffset-pVg5ArA());
            this.appendAlign-WZ4Q5Ns(((WasmImmediate.MemArg)x).getAlign-pVg5ArA());
        } else if (wasmImmediate instanceof WasmImmediate.BlockType) {
            this.appendBlockType((WasmImmediate.BlockType)x);
        } else if (wasmImmediate instanceof WasmImmediate.FuncIdx) {
            this.appendModuleFieldReference(this.resolver.resolve((WasmImmediate.FuncIdx)x));
        } else if (wasmImmediate instanceof WasmImmediate.LocalIdx) {
            this.appendLocalReference(((WasmImmediate.LocalIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.GlobalIdx) {
            this.appendModuleFieldReference(this.resolver.resolve((WasmImmediate.GlobalIdx)x));
        } else if (wasmImmediate instanceof WasmImmediate.TypeIdx) {
            void this_$iv;
            SExpressionBuilder sExpressionBuilder = this;
            String name$iv = "type";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
            boolean bl = false;
            this.appendModuleFieldReference(this.resolver.resolve((WasmImmediate.TypeIdx)x));
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        } else if (wasmImmediate instanceof WasmImmediate.MemoryIdx) {
            this.appendIdxIfNotZero(((WasmImmediate.MemoryIdx)x).getValue());
        } else if (wasmImmediate instanceof WasmImmediate.DataIdx) {
            this.appendElement(((WasmImmediate.DataIdx)x).getValue().toString());
        } else if (wasmImmediate instanceof WasmImmediate.TableIdx) {
            this.appendElement(((WasmImmediate.TableIdx)x).getValue().toString());
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdx) {
            this.appendElement(String.valueOf(((WasmImmediate.LabelIdx)x).getValue()));
        } else if (wasmImmediate instanceof WasmImmediate.TagIdx) {
            this.appendElement(((WasmImmediate.TagIdx)x).getValue().toString());
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdxVector) {
            Iterable $this$forEach$iv = ((WasmImmediate.LabelIdxVector)x).getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                this.appendElement(String.valueOf(it));
            }
        } else if (wasmImmediate instanceof WasmImmediate.ElemIdx) {
            Integer n = ((WasmImmediate.ElemIdx)x).getValue().getId();
            Intrinsics.checkNotNull((Object)n);
            this.appendElement(String.valueOf(n));
        } else if (wasmImmediate instanceof WasmImmediate.ValTypeVector) {
            void this_$iv;
            SExpressionBuilder $this$forEach$iv = this;
            String name$iv = "result";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
            boolean bl = false;
            Iterable $this$forEach$iv2 = ((WasmImmediate.ValTypeVector)x).getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                WasmType it = (WasmType)element$iv;
                boolean bl2 = false;
                this.appendType(it);
            }
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        } else if (wasmImmediate instanceof WasmImmediate.StructFieldIdx) {
            this.appendElement(String.valueOf(((WasmImmediate.StructFieldIdx)x).getValue()));
        } else if (wasmImmediate instanceof WasmImmediate.HeapType) {
            this.appendHeapType(((WasmImmediate.HeapType)x).getValue());
        } else {
            if (wasmImmediate instanceof WasmImmediate.ConstString) {
                throw new IllegalStateException("Pseudo immediate".toString());
            }
            if (wasmImmediate instanceof WasmImmediate.Catch) {
                this.appendCatch((WasmImmediate.Catch)x);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final String f32Str(WasmImmediate.ConstF32 x) {
        String string;
        int bits = x.getRawBits-pVg5ArA();
        float v = Float.intBitsToFloat(bits);
        if (Float.isNaN(v)) {
            String sign;
            String string2 = sign = (bits & Integer.MIN_VALUE) == 0 ? "" : "-";
            if (bits != 2143289344) {
                int customPayload = bits & 0x7FFFFF;
                StringBuilder stringBuilder = new StringBuilder().append(sign).append("nan:0x");
                int n = customPayload;
                int n2 = 16;
                String string3 = Integer.toString(n, CharsKt.checkRadix((int)n2));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                string = stringBuilder.append(string3).toString();
            } else {
                string = sign + "nan";
            }
        } else {
            float f = v;
            string = f == Float.POSITIVE_INFINITY ? "inf" : (f == Float.NEGATIVE_INFINITY ? "-inf" : String.valueOf(v));
        }
        return string;
    }

    private final String f64Str(WasmImmediate.ConstF64 x) {
        String string;
        long bits = x.getRawBits-s-VKNKU();
        double v = Double.longBitsToDouble(bits);
        if (Double.isNaN(v)) {
            String sign;
            String string2 = sign = (bits & Long.MIN_VALUE) == 0L ? "" : "-";
            if (bits != 9221120237041090560L) {
                long customPayload = bits & 0xFFFFFFFFFFFFFL;
                StringBuilder stringBuilder = new StringBuilder().append(sign).append("nan:0x");
                long l = customPayload;
                int n = 16;
                String string3 = Long.toString(l, CharsKt.checkRadix((int)n));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                string = stringBuilder.append(string3).toString();
            } else {
                string = sign + "nan";
            }
        } else {
            double d = v;
            string = d == Double.POSITIVE_INFINITY ? "inf" : (d == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(v));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void appendBlockType(@NotNull WasmImmediate.BlockType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmImmediate.BlockType blockType = type;
        if (blockType instanceof WasmImmediate.BlockType.Value) {
            if (((WasmImmediate.BlockType.Value)type).getType() != null && !(((WasmImmediate.BlockType.Value)type).getType() instanceof WasmUnreachableType)) {
                void this_$iv;
                SExpressionBuilder sExpressionBuilder = this;
                String name$iv = "result";
                boolean $i$f$sameLineList2 = false;
                SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
                boolean bl = false;
                this.appendType(((WasmImmediate.BlockType.Value)type).getType());
                SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
            }
        } else if (blockType instanceof WasmImmediate.BlockType.Function) {
            WasmType it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            SExpressionBuilder this_$iv;
            boolean $i$f$sameLineList;
            String name$iv;
            List<WasmType> parameters = ((WasmImmediate.BlockType.Function)type).getType().getOwner().getParameterTypes();
            List<WasmType> results = ((WasmImmediate.BlockType.Function)type).getType().getOwner().getResultTypes();
            if (!((Collection)parameters).isEmpty()) {
                SExpressionBuilder $i$f$sameLineList2 = this;
                name$iv = "param";
                $i$f$sameLineList = false;
                SExpressionBuilder.access$getStringBuilder(this_$iv).append(" (" + name$iv);
                boolean bl = false;
                $this$forEach$iv = parameters;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (WasmType)element$iv;
                    boolean bl2 = false;
                    this.appendType(it);
                }
                SExpressionBuilder.access$getStringBuilder(this_$iv).append(")");
            }
            if (!((Collection)results).isEmpty()) {
                this_$iv = this;
                name$iv = "result";
                $i$f$sameLineList = false;
                SExpressionBuilder.access$getStringBuilder(this_$iv).append(" (" + name$iv);
                boolean bl = false;
                $this$forEach$iv = results;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (WasmType)element$iv;
                    boolean bl3 = false;
                    this.appendType(it);
                }
                SExpressionBuilder.access$getStringBuilder(this_$iv).append(")");
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendRefType(@NotNull WasmRefType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmHeapType wasmHeapType = type.getHeapType();
        if (wasmHeapType instanceof WasmHeapType.Simple) {
            this.appendElement(((WasmHeapType.Simple)type.getHeapType()).getName() + "ref");
        } else if (wasmHeapType instanceof WasmHeapType.Type) {
            void this_$iv;
            SExpressionBuilder sExpressionBuilder = this;
            String name$iv = "ref";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
            boolean bl = false;
            this.appendHeapType(type.getHeapType());
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void appendWasmTypeList(List<? extends WasmTypeDeclaration> typeList) {
        Iterable $this$forEach$iv = typeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmTypeDeclaration type = (WasmTypeDeclaration)element$iv;
            boolean bl = false;
            WasmTypeDeclaration wasmTypeDeclaration = type;
            if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
                this.appendStructTypeDeclaration((WasmStructDeclaration)type);
                continue;
            }
            if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
                this.appendArrayTypeDeclaration((WasmArrayDeclaration)type);
                continue;
            }
            if (wasmTypeDeclaration instanceof WasmFunctionType) {
                this.appendFunctionTypeDeclaration((WasmFunctionType)type);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendWasmModule() {
        Object it;
        Object it2;
        Object object;
        void this_$iv;
        WasmModule $this$appendWasmModule_u24lambda_u240 = this.module;
        boolean bl = false;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "module";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl2 = false;
        boolean bl3 = false;
        Iterable $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getRecGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List recGroup = (List)element$iv;
            boolean bl4 = false;
            if (recGroup.size() > 1) {
                void this_$iv2;
                object = this;
                String name$iv2 = "rec";
                boolean $i$f$newLineList2 = false;
                SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv2);
                SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append('(' + name$iv2);
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$indented2 = false;
                int n2 = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv2);
                SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv2, n2 + 1);
                $i$a$-indented-SExpressionBuilder$newLineList$1$iv = false;
                boolean bl5 = false;
                this.appendWasmTypeList(recGroup);
                n2 = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv2);
                SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv2, n2 + -1);
                SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
                continue;
            }
            this.appendWasmTypeList(recGroup);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getImportsInOrder();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmNamedModuleField)element$iv;
            boolean bl6 = false;
            object = it2;
            if (object instanceof WasmFunction.Imported) {
                this.appendImportedFunction((WasmFunction.Imported)it2);
                continue;
            }
            if (object instanceof WasmMemory) {
                this.appendMemory((WasmMemory)it2);
                continue;
            }
            if (object instanceof WasmTable) {
                this.appendTable((WasmTable)it2);
                continue;
            }
            if (object instanceof WasmGlobal) {
                this.appendGlobal((WasmGlobal)it2);
                continue;
            }
            if (object instanceof WasmTag) {
                this.appendTag((WasmTag)it2);
                continue;
            }
            throw new IllegalStateException(("Unknown import kind " + Reflection.getOrCreateKotlinClass(it2.getClass())).toString());
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getDefinedFunctions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmFunction.Defined)element$iv;
            boolean bl7 = false;
            this.appendDefinedFunction((WasmFunction.Defined)it2);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getTables();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmTable)element$iv;
            boolean bl8 = false;
            this.appendTable((WasmTable)it2);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getMemories();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmMemory)element$iv;
            boolean bl9 = false;
            this.appendMemory((WasmMemory)it2);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getGlobals();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmGlobal)element$iv;
            boolean bl10 = false;
            this.appendGlobal((WasmGlobal)it2);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getExports();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmExport)element$iv;
            boolean bl11 = false;
            this.appendExport((WasmExport<?>)it2);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getElements();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmElement)element$iv;
            boolean bl12 = false;
            this.appendWasmElement((WasmElement)it2);
        }
        WasmFunction wasmFunction = $this$appendWasmModule_u24lambda_u240.getStartFunction();
        if (wasmFunction != null) {
            it = wasmFunction;
            boolean bl13 = false;
            this.appendStartFunction((WasmFunction)it);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getData();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmData)element$iv;
            boolean bl14 = false;
            this.appendData((WasmData)it2);
        }
        $this$forEach$iv = $this$appendWasmModule_u24lambda_u240.getTags();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (WasmTag)element$iv;
            boolean bl15 = false;
            this.appendTag((WasmTag)it2);
        }
        DebugInformationGenerator debugInformationGenerator = this.debugInformationGenerator;
        if (debugInformationGenerator != null) {
            it = debugInformationGenerator;
            boolean bl16 = false;
            this.consumeDebugInformation(it.generateDebugInformation());
        }
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendFunctionTypeDeclaration(WasmFunctionType type) {
        WasmType it;
        SExpressionBuilder this_$iv;
        void this_$iv2;
        void this_$iv3;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "type";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv3);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv3).append('(' + name$iv);
        void this_$iv$iv = this_$iv3;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(type);
        SExpressionBuilder sExpressionBuilder2 = this;
        String name$iv2 = "func";
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(" (" + name$iv2);
        boolean bl3 = false;
        SExpressionBuilder sExpressionBuilder3 = this;
        String name$iv3 = "param";
        boolean $i$f$sameLineList2 = false;
        SExpressionBuilder.access$getStringBuilder(this_$iv).append(" (" + name$iv3);
        boolean bl4 = false;
        Iterable $this$forEach$iv = type.getParameterTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WasmType)element$iv;
            boolean bl5 = false;
            this.appendType(it);
        }
        SExpressionBuilder.access$getStringBuilder(this_$iv).append(")");
        if (!((Collection)type.getResultTypes()).isEmpty()) {
            this_$iv = this;
            name$iv3 = "result";
            $i$f$sameLineList2 = false;
            SExpressionBuilder.access$getStringBuilder(this_$iv).append(" (" + name$iv3);
            boolean bl6 = false;
            $this$forEach$iv = type.getResultTypes();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (WasmType)element$iv;
                boolean bl7 = false;
                this.appendType(it);
            }
            SExpressionBuilder.access$getStringBuilder(this_$iv).append(")");
        }
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv3).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendStructTypeDeclaration(WasmStructDeclaration type) {
        WasmTypeDeclaration wasmTypeDeclaration;
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "type";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(type);
        WasmHeapType.Type type2 = type.getSuperType();
        if (type2 != null) {
            WasmHeapType.Type it = type2;
            boolean bl3 = false;
            wasmTypeDeclaration = this.resolver.resolve(it);
        } else {
            wasmTypeDeclaration = null;
        }
        WasmTypeDeclaration superTypeOwner = wasmTypeDeclaration;
        WasmIrToText wasmIrToText = this;
        WasmTypeDeclaration superType$iv = superTypeOwner;
        boolean $i$f$maybeSubType = false;
        if (superType$iv != null) {
            void this_$iv2;
            void this_$iv$iv2;
            void this_$iv3;
            SExpressionBuilder bl3 = (SExpressionBuilder)this_$iv3;
            String name$iv$iv = "sub";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv$iv2).append(" (" + name$iv$iv);
            boolean bl4 = false;
            this_$iv3.appendModuleFieldReference(superType$iv);
            boolean bl5 = false;
            SExpressionBuilder sExpressionBuilder2 = this;
            String name$iv2 = "struct";
            boolean $i$f$sameLineList2 = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(" (" + name$iv2);
            boolean bl6 = false;
            Iterable $this$forEach$iv = type.getFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WasmStructFieldDeclaration it = (WasmStructFieldDeclaration)element$iv;
                boolean bl7 = false;
                this.appendStructField(it);
            }
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv$iv2).append(")");
        } else {
            boolean bl8 = false;
            SExpressionBuilder this_$iv2 = this;
            String name$iv3 = "struct";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder(this_$iv2).append(" (" + name$iv3);
            boolean bl9 = false;
            Iterable $this$forEach$iv = type.getFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WasmStructFieldDeclaration it = (WasmStructFieldDeclaration)element$iv;
                boolean bl10 = false;
                this.appendStructField(it);
            }
            SExpressionBuilder.access$getStringBuilder(this_$iv2).append(")");
        }
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendArrayTypeDeclaration(WasmArrayDeclaration type) {
        void this_$iv;
        void this_$iv2;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "type";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv2);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append('(' + name$iv);
        void this_$iv$iv = this_$iv2;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(type);
        SExpressionBuilder sExpressionBuilder2 = this;
        String name$iv2 = "array";
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv2);
        boolean bl3 = false;
        this.appendFieldType(type.getField());
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendImportedFunction(WasmFunction.Imported function2) {
        void this_$iv;
        void this_$iv2;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "func";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv2);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append('(' + name$iv);
        void this_$iv$iv = this_$iv2;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(function2);
        this.appendImportPair(function2.getImportPair());
        SExpressionBuilder sExpressionBuilder2 = this;
        String name$iv2 = "type";
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv2);
        boolean bl3 = false;
        this.appendModuleFieldReference(this.resolver.resolve(function2.getType()));
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendImportPair(WasmImportDescriptor $this$appendImportPair) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "import";
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
        boolean bl = false;
        this.appendWatString($this$appendImportPair.getModuleName());
        this.appendWatString($this$appendImportPair.getDeclarationName().getOwner());
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendDefinedFunction(WasmFunction.Defined function2) {
        WasmLocal it;
        void this_$iv;
        void this_$iv2;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "func";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv2);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append('(' + name$iv);
        void this_$iv$iv = this_$iv2;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(function2);
        WasmTypeDeclaration wasmTypeDeclaration = this.resolver.resolve(function2.getType());
        Intrinsics.checkNotNull((Object)wasmTypeDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.wasm.ir.WasmFunctionType");
        WasmFunctionType functionType = (WasmFunctionType)wasmTypeDeclaration;
        SExpressionBuilder sExpressionBuilder2 = this;
        String name$iv2 = "type";
        boolean $i$f$sameLineList22 = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv2);
        boolean bl3 = false;
        this.appendModuleFieldReference(functionType);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        Object $this$forEach$iv = function2.getLocals();
        boolean $i$f$forEach = false;
        Iterator $i$f$sameLineList22 = $this$forEach$iv.iterator();
        while ($i$f$sameLineList22.hasNext()) {
            Object element$iv = $i$f$sameLineList22.next();
            it = (WasmLocal)element$iv;
            boolean bl4 = false;
            if (!it.isParameter()) continue;
            this.appendLocal(it);
        }
        if (!((Collection)functionType.getResultTypes()).isEmpty()) {
            $this$forEach$iv = this;
            name$iv = "result";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
            boolean bl5 = false;
            Iterable $this$forEach$iv2 = functionType.getResultTypes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                WasmType it2 = (WasmType)element$iv;
                boolean bl6 = false;
                this.appendType(it2);
            }
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        }
        $this$forEach$iv = function2.getLocals();
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            it = (WasmLocal)element$iv;
            boolean bl7 = false;
            if (it.isParameter()) continue;
            this.appendLocal(it);
        }
        this.currentFunction = function2;
        this.appendInstrList(function2.getInstructions());
        this.currentFunction = null;
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendTable(WasmTable table) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "table";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(table);
        WasmImportDescriptor wasmImportDescriptor = table.getImportPair();
        if (wasmImportDescriptor != null) {
            this.appendImportPair(wasmImportDescriptor);
        }
        this.appendLimits(table.getLimits());
        this.appendType(table.getElementType());
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendMemory(WasmMemory memory) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "memory";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(memory);
        WasmImportDescriptor wasmImportDescriptor = memory.getImportPair();
        if (wasmImportDescriptor != null) {
            this.appendImportPair(wasmImportDescriptor);
        }
        this.appendLimits(memory.getLimits());
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    private final void appendLimits(WasmLimits limits) {
        block0: {
            this.appendElement(Integer.toUnsignedString(limits.getMinSize-pVg5ArA()));
            UInt uInt = limits.getMaxSize-0hXNFcg();
            if (uInt == null) break block0;
            int it = uInt.unbox-impl();
            boolean bl = false;
            this.appendElement(Integer.toUnsignedString(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendGlobal(WasmGlobal global) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "global";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(global);
        WasmImportDescriptor wasmImportDescriptor = global.getImportPair();
        if (wasmImportDescriptor != null) {
            this.appendImportPair(wasmImportDescriptor);
        }
        if (global.isMutable()) {
            void this_$iv2;
            SExpressionBuilder sExpressionBuilder2 = this;
            String name$iv2 = "mut";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(" (" + name$iv2);
            boolean bl3 = false;
            this.appendType(global.getType());
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
        } else {
            this.appendType(global.getType());
        }
        this.appendInstrList(global.getInit());
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendExport(WasmExport<?> export) {
        void this_$iv;
        void this_$iv2;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "export";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv2);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append('(' + name$iv);
        void this_$iv$iv = this_$iv2;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendWatString(export.getName());
        SExpressionBuilder sExpressionBuilder2 = this;
        String name$iv2 = export.getKeyword();
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv2);
        boolean bl3 = false;
        this.appendModuleFieldReference((WasmNamedModuleField)export.getField());
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendWasmElement(WasmElement element) {
        boolean allFunctions;
        int n;
        void this_$iv$iv;
        void this_$iv;
        block15: {
            boolean bl;
            SExpressionBuilder sExpressionBuilder = this;
            String name$iv = "elem";
            boolean $i$f$newLineList = false;
            SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
            this_$iv$iv = this_$iv;
            boolean $i$f$indented = false;
            n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
            SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
            boolean bl2 = false;
            boolean bl3 = false;
            WasmElement.Mode mode = element.getMode();
            if (!Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Passive.INSTANCE)) {
                if (mode instanceof WasmElement.Mode.Active) {
                    SExpressionBuilder this_$iv2;
                    boolean $i$f$sameLineList;
                    String name$iv2;
                    Integer n2 = ((WasmElement.Mode.Active)mode).getTable().getId();
                    if (n2 == null || n2 != 0) {
                        Iterator<WasmTable.Value> iterator2 = this;
                        name$iv2 = "table";
                        $i$f$sameLineList = false;
                        SExpressionBuilder.access$getStringBuilder(this_$iv2).append(" (" + name$iv2);
                        boolean bl4 = false;
                        this.appendModuleFieldReference(((WasmElement.Mode.Active)mode).getTable());
                        SExpressionBuilder.access$getStringBuilder(this_$iv2).append(")");
                    }
                    this_$iv2 = this;
                    name$iv2 = "";
                    $i$f$sameLineList = false;
                    SExpressionBuilder.access$getStringBuilder(this_$iv2).append(" (" + name$iv2);
                    boolean bl5 = false;
                    this.appendInstr((WasmInstr)CollectionsKt.single(((WasmElement.Mode.Active)mode).getOffset()));
                    SExpressionBuilder.access$getStringBuilder(this_$iv2).append(")");
                } else if (Intrinsics.areEqual((Object)mode, (Object)WasmElement.Mode.Declarative.INSTANCE)) {
                    this.appendElement("declare");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable $this$all$iv = element.getValues();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    WasmTable.Value it = (WasmTable.Value)element$iv;
                    boolean bl6 = false;
                    if (it instanceof WasmTable.Value.Function) continue;
                    bl = false;
                    break block15;
                }
                bl = allFunctions = true;
            }
        }
        if (allFunctions) {
            this.appendElement("func");
            for (WasmTable.Value value2 : element.getValues()) {
                if (!(value2 instanceof WasmTable.Value.Function)) {
                    String element$iv = "Failed requirement.";
                    throw new IllegalArgumentException(element$iv.toString());
                }
                this.appendModuleFieldReference(((WasmTable.Value.Function)value2).getFunction().getOwner());
            }
        } else {
            this.appendType(element.getType());
            for (WasmTable.Value value3 : element.getValues()) {
                void this_$iv3;
                if (!(value3 instanceof WasmTable.Value.Expression)) {
                    String element$iv = "Failed requirement.";
                    throw new IllegalArgumentException(element$iv.toString());
                }
                SExpressionBuilder $i$f$sameLineList = this;
                String name$iv = "item";
                boolean $i$f$sameLineList2 = false;
                SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv3).append(" (" + name$iv);
                boolean bl = false;
                this.appendInstr((WasmInstr)CollectionsKt.single(((WasmTable.Value.Expression)value3).getExpr()));
                SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv3).append(")");
            }
        }
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendStartFunction(WasmFunction startFunction) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "start";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(startFunction);
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendData(WasmData wasmData) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "data";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        WasmDataMode mode = wasmData.getMode();
        if (mode instanceof WasmDataMode.Active) {
            SExpressionBuilder this_$iv2;
            boolean $i$f$sameLineList;
            String name$iv2;
            if (((WasmDataMode.Active)mode).getMemoryIdx() != 0) {
                SExpressionBuilder sExpressionBuilder2 = this;
                name$iv2 = "memory";
                $i$f$sameLineList = false;
                SExpressionBuilder.access$getStringBuilder(this_$iv2).append(" (" + name$iv2);
                boolean bl3 = false;
                this.appendElement(String.valueOf(((WasmDataMode.Active)mode).getMemoryIdx()));
                SExpressionBuilder.access$getStringBuilder(this_$iv2).append(")");
            }
            this_$iv2 = this;
            name$iv2 = "";
            $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder(this_$iv2).append(" (" + name$iv2);
            boolean bl4 = false;
            this.appendInstr((WasmInstr)CollectionsKt.single(((WasmDataMode.Active)mode).getOffset()));
            SExpressionBuilder.access$getStringBuilder(this_$iv2).append(")");
        } else if (!Intrinsics.areEqual((Object)mode, (Object)WasmDataMode.Passive.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        this.appendElement(WasmIrToTextKt.access$toWatString(wasmData.getBytes()));
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendTag(WasmTag wasmTag) {
        void this_$iv;
        void this_$iv2;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "tag";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv2);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append('(' + name$iv);
        void this_$iv$iv = this_$iv2;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendModuleFieldReference(wasmTag);
        WasmImportDescriptor wasmImportDescriptor = wasmTag.getImportPair();
        if (wasmImportDescriptor != null) {
            this.appendImportPair(wasmImportDescriptor);
        }
        WasmTypeDeclaration wasmTypeDeclaration = this.resolver.resolve(wasmTag.getType());
        Intrinsics.checkNotNull((Object)wasmTypeDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.wasm.ir.WasmFunctionType");
        WasmFunctionType tagType = (WasmFunctionType)wasmTypeDeclaration;
        SExpressionBuilder sExpressionBuilder2 = this;
        String name$iv2 = "param";
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv2);
        boolean bl3 = false;
        Iterable $this$forEach$iv = tagType.getParameterTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmType it = (WasmType)element$iv;
            boolean bl4 = false;
            this.appendType(it);
        }
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        if (!tagType.getResultTypes().isEmpty()) {
            boolean bl5 = false;
            String string = "must be as per spec";
            throw new IllegalStateException(string.toString());
        }
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv2).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendLocal(WasmLocal local) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = local.isParameter() ? "param" : "local";
        boolean $i$f$newLineList = false;
        SExpressionBuilder.access$newLine((SExpressionBuilder)this_$iv);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append('(' + name$iv);
        void this_$iv$iv = this_$iv;
        boolean $i$f$indented = false;
        int n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + 1);
        boolean bl = false;
        boolean bl2 = false;
        this.appendLocalReference(local);
        this.appendType(local.getType());
        n = SExpressionBuilder.access$getIndent((SExpressionBuilder)this_$iv$iv);
        SExpressionBuilder.access$setIndent((SExpressionBuilder)this_$iv$iv, n + -1);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    public final void appendHeapType(@NotNull WasmHeapType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmHeapType wasmHeapType = type;
        if (wasmHeapType instanceof WasmHeapType.Simple) {
            this.appendElement(((WasmHeapType.Simple)type).getName());
        } else if (wasmHeapType instanceof WasmHeapType.Type) {
            this.appendModuleFieldReference(this.resolver.resolve((WasmHeapType.Type)type));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void appendReferencedType(@NotNull WasmType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmType wasmType = type;
        if (wasmType instanceof WasmFuncRef) {
            this.appendElement("func");
        } else if (wasmType instanceof WasmAnyRef) {
            this.appendElement("any");
        } else if (wasmType instanceof WasmExternRef) {
            this.appendElement("extern");
        } else {
            throw new NotImplementedError(null, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendType(@NotNull WasmType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WasmType wasmType = type;
        if (wasmType instanceof WasmRefType) {
            void this_$iv;
            SExpressionBuilder sExpressionBuilder = this;
            String name$iv = "ref";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
            boolean bl = false;
            this.appendHeapType(((WasmRefType)type).getHeapType());
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        } else if (wasmType instanceof WasmRefNullType) {
            SExpressionBuilder this_$iv = this;
            String name$iv = "ref null";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder(this_$iv).append(" (" + name$iv);
            boolean bl = false;
            this.appendHeapType(((WasmRefNullType)type).getHeapType());
            SExpressionBuilder.access$getStringBuilder(this_$iv).append(")");
        } else if (!Intrinsics.areEqual((Object)wasmType, (Object)WasmUnreachableType.INSTANCE)) {
            this.appendElement(type.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendStructField(WasmStructFieldDeclaration field) {
        void this_$iv;
        SExpressionBuilder sExpressionBuilder = this;
        String name$iv = "field";
        boolean $i$f$sameLineList = false;
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
        boolean bl = false;
        this.appendFieldType(field);
        SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
    }

    /*
     * WARNING - void declaration
     */
    private final void appendFieldType(WasmStructFieldDeclaration field) {
        if (field.isMutable()) {
            void this_$iv;
            SExpressionBuilder sExpressionBuilder = this;
            String name$iv = "mut";
            boolean $i$f$sameLineList = false;
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(" (" + name$iv);
            boolean bl = false;
            this.appendType(field.getType());
            SExpressionBuilder.access$getStringBuilder((SExpressionBuilder)this_$iv).append(")");
        } else {
            this.appendType(field.getType());
        }
    }

    public final void appendLocalReference(@NotNull WasmLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        this.appendElement("" + '$' + local.getId() + '_' + WasmIrToTextKt.sanitizeWatIdentifier(local.getName()));
    }

    public final void appendLocalReference(int local) {
        WasmFunction.Defined defined = this.currentFunction;
        Intrinsics.checkNotNull((Object)defined);
        this.appendLocalReference(defined.getLocals().get(local));
    }

    public final void appendIdxIfNotZero(int id) {
        if (id != 0) {
            this.appendElement(String.valueOf(id));
        }
    }

    public final void appendCatch(@NotNull WasmImmediate.Catch catch_) {
        Intrinsics.checkNotNullParameter((Object)catch_, (String)"catch");
        this.appendElement(catch_.getType().getMnemonic());
        Iterable $this$forEach$iv = catch_.getImmediates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WasmImmediate p0 = (WasmImmediate)element$iv;
            boolean bl = false;
            this.appendImmediate(p0);
        }
    }

    public final void appendModuleFieldReference(@NotNull WasmSymbolReadOnly<? extends WasmNamedModuleField> field) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        this.appendModuleFieldReference(field.getOwner());
    }

    public final void appendModuleFieldReference(@NotNull WasmNamedModuleField field) {
        String string;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Integer n = field.getId();
        if (n == null) {
            throw new IllegalStateException((Reflection.getOrCreateKotlinClass(field.getClass()) + ' ' + field.getName() + " ID is unlinked").toString());
        }
        int id = n;
        WasmNamedModuleField wasmNamedModuleField = field;
        if (wasmNamedModuleField instanceof WasmData) {
            string = "data";
        } else if (wasmNamedModuleField instanceof WasmFunction) {
            string = "fun";
        } else if (wasmNamedModuleField instanceof WasmMemory) {
            string = "mem";
        } else if (wasmNamedModuleField instanceof WasmTable) {
            string = "table";
        } else if (wasmNamedModuleField instanceof WasmElement) {
            string = "elem";
        } else if (wasmNamedModuleField instanceof WasmGlobal) {
            string = "g";
        } else if (wasmNamedModuleField instanceof WasmTypeDeclaration) {
            string = "type";
        } else if (wasmNamedModuleField instanceof WasmTag) {
            string = "tag";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String indexSpaceKind = string;
        this.appendElement('$' + WasmIrToTextKt.sanitizeWatIdentifier(field.getName()) + "___" + indexSpaceKind + '_' + id);
    }

    private final void appendWatString(String s) {
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.appendElement(WasmIrToTextKt.access$toWatString(byArray));
    }

    private static final String appendInstr$commentText(WasmInstr $wasmInstr) {
        WasmImmediate wasmImmediate = WasmInstructionKt.firstImmediateOrNull($wasmInstr);
        WasmImmediate.ConstString constString = wasmImmediate instanceof WasmImmediate.ConstString ? (WasmImmediate.ConstString)wasmImmediate : null;
        String comment = constString != null ? constString.getValue() : null;
        if (!(comment != null)) {
            throw new IllegalStateException("Check failed.");
        }
        return comment;
    }

    private static final Unit appendInstr$lambda$4(WasmIrToText this$0, WasmImmediate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.appendImmediate(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WasmOp.values().length];
            try {
                nArray[WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.PSEUDO_COMMENT_GROUP_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.PSEUDO_COMMENT_GROUP_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

