/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J.\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaTypeAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "<init>", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "findInaccessibleJavaClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "findInaccessibleJavaClassesRec", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "inaccessibleClasses", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
public final class JavaTypeAccessibilityChecker
implements AdditionalTypeChecker {
    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Collection<ClassDescriptor> inaccessibleClassesWithSmartCast;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.isDebuggerContext) {
            return;
        }
        Collection<ClassDescriptor> inaccessibleClasses = this.findInaccessibleJavaClasses(expressionType, c);
        if (!inaccessibleClasses.isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression2), expressionType, inaccessibleClasses));
            return;
        }
        if (!Intrinsics.areEqual((Object)expressionTypeWithSmartCast, (Object)expressionType) && !(inaccessibleClassesWithSmartCast = this.findInaccessibleJavaClasses(expressionTypeWithSmartCast, c)).isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression2), expressionType, inaccessibleClassesWithSmartCast));
        }
    }

    private final Collection<ClassDescriptor> findInaccessibleJavaClasses(KotlinType type2, ResolutionContext<?> c) {
        DeclarationDescriptor scopeOwner = c.scope.getOwnerDescriptor();
        LinkedHashSet inaccessibleJavaClasses = new LinkedHashSet();
        Collection collection = inaccessibleJavaClasses;
        LanguageVersionSettings languageVersionSettings = c.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.findInaccessibleJavaClassesRec(type2, scopeOwner, collection, languageVersionSettings);
        return inaccessibleJavaClasses;
    }

    private final void findInaccessibleJavaClassesRec(KotlinType type2, DeclarationDescriptor scopeOwner, Collection<ClassDescriptor> inaccessibleClasses, LanguageVersionSettings languageVersionSettings) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof JavaClassDescriptor && !DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((Object)declarationDescriptor), scopeOwner, languageVersionSettings)) {
            inaccessibleClasses.add((ClassDescriptor)declarationDescriptor);
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection()) continue;
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            this.findInaccessibleJavaClassesRec(kotlinType, scopeOwner, inaccessibleClasses, languageVersionSettings);
        }
    }
}

