/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.metadata.KotlinMetadataCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteEnumWhenTracker;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteInlineConstTracker;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.RunningCompilations;
import org.jetbrains.kotlin.daemon.common.BuildMetricsValue;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.JpsCompilerServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.util.PerformanceManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J<\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u001d\u0010 \u001a\u0019\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001d0!\u00a2\u0006\u0002\b#H\u0082\bJ\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001dH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u001dH\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001dH\u0016J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\b\u00100\u001a\u0004\u0018\u00010+H\u0016J\u0014\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+020\u001dH\u0016J\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\b\u00100\u001a\u0004\u0018\u00010+H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\bH\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020%0\u001d2\u0006\u00109\u001a\u000206H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020/0\u001dH\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002060\u001d2\u0006\u0010<\u001a\u000206H\u0016J*\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0>0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0>H\u0016JE\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016\u00a2\u0006\u0002\u0010JJO\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010I2\b\u0010K\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010LJ\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\u000eH\u0016J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J \u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0002JS\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\b\u00100\u001a\u0004\u0018\u00010+2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020@022\u0006\u0010Y\u001a\u00020+H\u0016\u00a2\u0006\u0002\u0010ZJ\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J&\u0010]\u001a\b\u0012\u0004\u0012\u00020^0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020aH\u0016J&\u0010b\u001a\b\u0012\u0004\u0012\u00020c0\u001d2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020aH\u0016J\b\u0010d\u001a\u00020\u0013H\u0014J\b\u0010e\u001a\u00020\u0013H\u0014J\b\u0010f\u001a\u00020\u0013H\u0014J\b\u0010g\u001a\u00020\u0013H\u0002J\b\u0010h\u001a\u00020\u0013H\u0002J\u0010\u0010i\u001a\u0002062\u0006\u0010j\u001a\u000206H\u0002J\b\u0010k\u001a\u00020\u0013H\u0016J3\u0010l\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\b\b\u0002\u0010m\u001a\u00020n2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001d0\u0012H\u0082\bJ!\u0010o\u001a\u00020\u00132\b\b\u0002\u0010m\u001a\u00020n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ3\u0010p\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\b\b\u0002\u0010m\u001a\u00020n2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001d0\u0012H\u0082\bJ!\u0010q\u001a\u00020\u00132\b\b\u0002\u0010m\u001a\u00020n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010$\u001a\u00020%8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "<init>", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getRegistry", "()Ljava/rmi/registry/Registry;", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "withValidRepl", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "R", "sessionId", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getDaemonInfo", "", "getKotlinVersion", "getDaemonOptions", "registerClient", "", "aliveFlagPath", "getClients", "", "leaseCompileSession", "releaseCompileSession", "checkCompilerId", "", "expectedCompilerId", "getUsedMemory", "withGC", "shutdown", "scheduleShutdown", "graceful", "classesFqNamesByFiles", "", "sourceFiles", "Ljava/io/File;", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "compilationId", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "cancelCompilation", "releaseReplSession", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "replCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "replStateId", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "replCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "initiateElections", "shutdownNow", "shutdownWithDelay", "gracefulShutdown", "onAnotherThread", "clearJarCache", "ifAlive", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "ifAliveUnit", "ifAliveExclusive", "ifAliveExclusiveUnit", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n+ 2 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 6 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n+ 7 IncrementalJsCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunnerKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1267:1\n1217#1,2:1280\n1219#1:1305\n1214#1,5:1306\n1219#1:1334\n1214#1,5:1335\n1219#1:1363\n1214#1,5:1364\n1219#1:1392\n1217#1,2:1393\n1219#1:1418\n1214#1,5:1419\n1219#1:1447\n1217#1,2:1448\n1219#1:1473\n1217#1,2:1474\n1219#1:1499\n1214#1,5:1503\n1219#1:1536\n1231#1,2:1537\n1233#1:1562\n1217#1,2:1563\n1219#1:1588\n1214#1,5:1589\n1219#1:1627\n1214#1,5:1628\n1219#1:2122\n1214#1,5:2123\n1219#1:2161\n1217#1,2:2162\n1219#1:2187\n1217#1,2:2188\n765#1:2210\n1219#1:2226\n1217#1,2:2227\n765#1:2249\n1219#1:2265\n1217#1,2:2266\n765#1:2288\n1219#1:2304\n1221#1,2:2305\n1223#1,2:2327\n1226#1:2332\n1221#1,2:2333\n1223#1,2:2355\n1226#1:2360\n1221#1,2:2361\n1223#1,2:2383\n1226#1:2388\n1221#1,2:2389\n1223#1:2411\n1224#1:2419\n1226#1:2423\n1235#1,2:2606\n1237#1,2:2628\n1240#1:2633\n745#2:1268\n627#2,2:1269\n626#2,6:1271\n747#2:1277\n633#2:1278\n748#2:1279\n595#2,7:1282\n602#2,15:1290\n595#2,7:1311\n602#2,15:1319\n595#2,7:1340\n602#2,15:1348\n595#2,7:1369\n602#2,15:1377\n595#2,7:1395\n602#2,15:1403\n595#2,7:1424\n602#2,15:1432\n595#2,7:1450\n602#2,15:1458\n595#2,7:1476\n602#2,15:1484\n595#2,7:1508\n602#2,12:1516\n614#2,3:1533\n595#2,7:1539\n602#2,15:1547\n595#2,7:1565\n602#2,15:1573\n595#2,7:1594\n602#2,12:1602\n627#2,2:1614\n626#2,8:1616\n614#2,3:1624\n595#2,7:1633\n602#2,12:1641\n351#2,26:1653\n377#2:1687\n474#2,3:1688\n627#2,2:1691\n626#2,6:1693\n477#2,14:1699\n512#2,4:1713\n491#2:1719\n378#2,6:1720\n384#2,2:1727\n386#2,3:1730\n517#2:1735\n519#2,36:1741\n493#2,8:1777\n633#2:1785\n501#2,2:1786\n389#2:1788\n393#2:1790\n474#2,3:1791\n627#2,2:1794\n626#2,6:1796\n477#2,14:1802\n512#2,4:1816\n491#2:1820\n394#2,3:1821\n397#2,12:1825\n517#2:1839\n519#2,36:1845\n493#2,8:1881\n633#2:1889\n501#2,2:1890\n412#2,5:1892\n417#2:1906\n474#2,3:1907\n627#2,2:1910\n626#2,6:1912\n477#2,14:1918\n512#2,4:1932\n491#2:1936\n418#2,11:1937\n517#2:1950\n519#2,36:1956\n493#2,8:1992\n633#2:2000\n501#2,2:2001\n429#2:2003\n431#2:2005\n432#2:2015\n474#2,3:2016\n627#2,2:2019\n626#2,6:2021\n477#2,14:2027\n512#2,4:2041\n491#2:2045\n433#2,10:2046\n517#2:2058\n519#2,36:2064\n493#2,8:2100\n633#2:2108\n501#2,2:2109\n443#2:2111\n445#2,6:2113\n614#2,3:2119\n595#2,7:2128\n602#2,12:2136\n627#2,2:2148\n626#2,8:2150\n614#2,3:2158\n595#2,7:2164\n602#2,15:2172\n595#2,7:2190\n602#2,12:2198\n745#2:2211\n627#2,2:2212\n626#2,6:2214\n747#2:2220\n633#2:2221\n748#2:2222\n614#2,3:2223\n595#2,7:2229\n602#2,12:2237\n745#2:2250\n627#2,2:2251\n626#2,6:2253\n747#2:2259\n633#2:2260\n748#2:2261\n614#2,3:2262\n595#2,7:2268\n602#2,12:2276\n745#2:2289\n627#2,2:2290\n626#2,6:2292\n747#2:2298\n633#2:2299\n748#2:2300\n614#2,3:2301\n595#2,7:2307\n602#2,12:2315\n614#2,3:2329\n595#2,7:2335\n602#2,12:2343\n614#2,3:2357\n595#2,7:2363\n602#2,12:2371\n614#2,3:2385\n595#2,7:2391\n602#2,12:2399\n614#2,3:2420\n595#2,7:2426\n602#2,15:2434\n595#2,22:2449\n595#2,7:2471\n602#2,15:2479\n595#2,22:2494\n595#2,7:2516\n602#2,15:2524\n595#2,22:2539\n595#2,7:2561\n602#2,15:2569\n595#2,22:2584\n595#2,7:2608\n602#2,12:2616\n614#2,3:2630\n1#3:1289\n1#3:1318\n1#3:1347\n1#3:1376\n1#3:1402\n1#3:1431\n1#3:1457\n1#3:1483\n1#3:1515\n1#3:1546\n1#3:1572\n1#3:1601\n1#3:1640\n1#3:1824\n1#3:2135\n1#3:2171\n1#3:2197\n1#3:2236\n1#3:2275\n1#3:2314\n1#3:2342\n1#3:2370\n1#3:2398\n1#3:2413\n1#3:2433\n1#3:2478\n1#3:2523\n1#3:2568\n1#3:2615\n1786#4,3:1500\n1915#4:1726\n1916#4:1729\n1915#4:2412\n1915#4,2:2414\n1916#4:2416\n1915#4,2:2417\n90#5,5:1528\n44#5,2:1717\n46#5,2:1733\n90#5,5:1736\n46#5,2:1837\n90#5,5:1840\n46#5,2:1948\n90#5,5:1951\n46#5,2:2056\n90#5,5:2059\n79#6,8:1679\n88#6:1789\n78#6,9:1897\n88#6:2004\n64#7,9:2006\n74#7:2112\n14048#8,2:2424\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n*L\n775#1:1280,2\n775#1:1305\n779#1:1306,5\n779#1:1334\n787#1:1335,5\n787#1:1363\n791#1:1364,5\n791#1:1392\n797#1:1393,2\n797#1:1418\n803#1:1419,5\n803#1:1447\n808#1:1448,2\n808#1:1473\n824#1:1474,2\n824#1:1499\n837#1:1503,5\n837#1:1536\n839#1:1537,2\n839#1:1562\n844#1:1563,2\n844#1:1588\n858#1:1589,5\n858#1:1627\n879#1:1628,5\n879#1:2122\n895#1:2123,5\n895#1:2161\n950#1:2162,2\n950#1:2187\n967#1:2188,2\n968#1:2210\n967#1:2226\n974#1:2227,2\n975#1:2249\n974#1:2265\n983#1:2266,2\n984#1:2288\n983#1:2304\n997#1:2305,2\n997#1:2327,2\n997#1:2332\n1019#1:2333,2\n1019#1:2355,2\n1019#1:2360\n1037#1:2361,2\n1037#1:2383,2\n1037#1:2388\n1051#1:2389,2\n1051#1:2411\n1051#1:2419\n1051#1:2423\n1158#1:2606,2\n1158#1:2628,2\n1158#1:2633\n765#1:1268\n765#1:1269,2\n765#1:1271,6\n765#1:1277\n765#1:1278\n765#1:1279\n775#1:1282,7\n775#1:1290,15\n779#1:1311,7\n779#1:1319,15\n787#1:1340,7\n787#1:1348,15\n791#1:1369,7\n791#1:1377,15\n797#1:1395,7\n797#1:1403,15\n803#1:1424,7\n803#1:1432,15\n808#1:1450,7\n808#1:1458,15\n824#1:1476,7\n824#1:1484,15\n837#1:1508,7\n837#1:1516,12\n837#1:1533,3\n839#1:1539,7\n839#1:1547,15\n844#1:1565,7\n844#1:1573,15\n858#1:1594,7\n858#1:1602,12\n859#1:1614,2\n859#1:1616,8\n858#1:1624,3\n879#1:1633,7\n879#1:1641,12\n880#1:1653,26\n880#1:1687\n880#1:1688,3\n880#1:1691,2\n880#1:1693,6\n880#1:1699,14\n880#1:1713,4\n880#1:1719\n880#1:1720,6\n880#1:1727,2\n880#1:1730,3\n880#1:1735\n880#1:1741,36\n880#1:1777,8\n880#1:1785\n880#1:1786,2\n880#1:1788\n880#1:1790\n880#1:1791,3\n880#1:1794,2\n880#1:1796,6\n880#1:1802,14\n880#1:1816,4\n880#1:1820\n880#1:1821,3\n880#1:1825,12\n880#1:1839\n880#1:1845,36\n880#1:1881,8\n880#1:1889\n880#1:1890,2\n880#1:1892,5\n880#1:1906\n880#1:1907,3\n880#1:1910,2\n880#1:1912,6\n880#1:1918,14\n880#1:1932,4\n880#1:1936\n880#1:1937,11\n880#1:1950\n880#1:1956,36\n880#1:1992,8\n880#1:2000\n880#1:2001,2\n880#1:2003\n880#1:2005\n880#1:2015\n880#1:2016,3\n880#1:2019,2\n880#1:2021,6\n880#1:2027,14\n880#1:2041,4\n880#1:2045\n880#1:2046,10\n880#1:2058\n880#1:2064,36\n880#1:2100,8\n880#1:2108\n880#1:2109,2\n880#1:2111\n880#1:2113,6\n879#1:2119,3\n895#1:2128,7\n895#1:2136,12\n896#1:2148,2\n896#1:2150,8\n895#1:2158,3\n950#1:2164,7\n950#1:2172,15\n967#1:2190,7\n967#1:2198,12\n968#1:2211\n968#1:2212,2\n968#1:2214,6\n968#1:2220\n968#1:2221\n968#1:2222\n967#1:2223,3\n974#1:2229,7\n974#1:2237,12\n975#1:2250\n975#1:2251,2\n975#1:2253,6\n975#1:2259\n975#1:2260\n975#1:2261\n974#1:2262,3\n983#1:2268,7\n983#1:2276,12\n984#1:2289\n984#1:2290,2\n984#1:2292,6\n984#1:2298\n984#1:2299\n984#1:2300\n983#1:2301,3\n997#1:2307,7\n997#1:2315,12\n997#1:2329,3\n1019#1:2335,7\n1019#1:2343,12\n1019#1:2357,3\n1037#1:2363,7\n1037#1:2371,12\n1037#1:2385,3\n1051#1:2391,7\n1051#1:2399,12\n1051#1:2420,3\n1218#1:2426,7\n1218#1:2434,15\n1218#1:2449,22\n1222#1:2471,7\n1222#1:2479,15\n1222#1:2494,22\n1232#1:2516,7\n1232#1:2524,15\n1232#1:2539,22\n1236#1:2561,7\n1236#1:2569,15\n1236#1:2584,22\n1158#1:2608,7\n1158#1:2616,12\n1158#1:2630,3\n775#1:1289\n779#1:1318\n787#1:1347\n791#1:1376\n797#1:1402\n803#1:1431\n808#1:1457\n824#1:1483\n837#1:1515\n839#1:1546\n844#1:1572\n858#1:1601\n879#1:1640\n880#1:1824\n895#1:2135\n950#1:2171\n967#1:2197\n974#1:2236\n983#1:2275\n997#1:2314\n1019#1:2342\n1037#1:2370\n1051#1:2398\n1218#1:2433\n1222#1:2478\n1232#1:2523\n1236#1:2568\n1158#1:2615\n833#1:1500,3\n880#1:1726\n880#1:1729\n1072#1:2412\n1075#1:2414,2\n1072#1:2416\n1106#1:2417,2\n837#1:1528,5\n880#1:1717,2\n880#1:1733,2\n880#1:1736,5\n880#1:1837,2\n880#1:1840,5\n880#1:1948,2\n880#1:1951,5\n880#1:2056,2\n880#1:2059,5\n880#1:1679,8\n880#1:1789\n880#1:1897,9\n880#1:2004\n880#1:2006,9\n880#1:2112\n1131#1:2424,2\n*E\n"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        super(daemonOptions, compilerId, port, timer, onShutdown);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        CompileService stub = (CompileService)remote;
        this.registry.rebind("KotlinJvmCompilerService", stub);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        void this_$iv$iv;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        void this_$iv;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase compileServiceImplBase = this;
        int sessionId$iv = sessionId;
        boolean $i$f$withValidReplImpl = false;
        void var7_7 = this_$iv;
        int sessionId$iv$iv = sessionId$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId$iv$iv == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get(sessionId$iv$iv);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv);
                return object;
            }
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy;
        try {
            Object object2;
            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv;
            Object object3 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
            if (object3 == null) {
                object3 = object2 = null;
            }
            if (object3 == null || (object2 = (CompileService.CallResult)body.invoke(object2)) == null) {
                object2 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv);
            }
            Object object4 = object2;
            object = object4;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<String>("Kotlin daemon on port " + this.getPort());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getKotlinVersion() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    CompileService.CallResult callResult4;
                    boolean bl = false;
                    try {
                        callResult4 = new CompileService.CallResult.Good<String>(KotlinCompilerVersion.VERSION);
                    }
                    catch (Exception e) {
                        callResult4 = new CompileService.CallResult.Error("Unknown Kotlin version");
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getLog().info("getDaemonJVMOptions: " + this.daemonJVMOptions);
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.daemonJVMOptions);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info("Registered a client alive file: " + aliveFlagPath);
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    CompileServiceImpl compileServiceImpl2 = this;
                    CompileServiceImplBase.SessionsContainer sessionsContainer = this.getState().getSessions();
                    boolean bl3 = false;
                    RunningCompilations runningCompilations = new RunningCompilations();
                    Integer n = sessionsContainer.leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<RunningCompilations>(aliveFlagPath, runningCompilations, new Disposable(runningCompilations){
                        final /* synthetic */ RunningCompilations $runningCompilations;
                        {
                            this.$runningCompilations = $runningCompilations;
                        }

                        public void dispose() {
                            this.$runningCompilations.cancelAll();
                        }
                    }));
                    int $this$leaseCompileSession_u24lambda_u240_u241 = ((Number)n).intValue();
                    boolean bl4 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u240_u241 + ", session alive file: " + aliveFlagPath);
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block8: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block8;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info("cleaning after session " + sessionId);
                    this.clearJarCache();
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expectedCompilerId, (String)"expectedCompilerId");
        if (!(((CharSequence)this.getCompilerId().getCompilerVersion()).length() == 0)) {
            if (!Intrinsics.areEqual((Object)this.getCompilerId().getCompilerVersion(), (Object)expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory(boolean withGC) {
        CompileService.CallResult callResult;
        CompileServiceImpl $this$iv = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$iv.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    boolean withGC$iv = withGC;
                    boolean $i$f$usedMemory = false;
                    if (withGC$iv) {
                        System.gc();
                    }
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block14: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block11: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block13: {
                        block12: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block11;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block12;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block13;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block14;
                }
                try {
                    boolean bl;
                    boolean bl3 = false;
                    if (graceful) {
                        bl = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl = true;
                    }
                    boolean res = bl;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var6_6 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var6_6.lock();
        try {
            block19: {
                block16: {
                    block18: {
                        block17: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var8_9 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block16;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block17;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block18;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block19;
                }
                try {
                    block20: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        var18_22 = this;
                        sessionId$iv = sessionId;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv != 0) break block20;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getSessions().get(sessionId$iv);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var22_26 = new CompileService.CallResult.Good<Set>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v5 = var22_26;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var12_15 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var12_15 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var12_15;
            }
            var7_8 = v3;
        }
        finally {
            var6_6.unlock();
        }
        return var7_8;
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        return this.compile(sessionId, compilerArguments, compilationOptions, servicesFacade, compilationResults, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults, @Nullable Integer compilationId) {
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var10_10 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var10_10.lock();
        try {
            block124: {
                block121: {
                    block123: {
                        block122: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var12_13 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block121;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block122;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block123;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block124;
                }
                try {
                    block126: {
                        block125: {
                            $i$a$-ifAlive$default-CompileServiceImpl$compile$1 = false;
                            var22_26 = this;
                            var23_27 = sessionId;
                            var24_28 = compilerArguments;
                            var25_29 = compilationOptions;
                            var26_30 = servicesFacade;
                            var27_31 = compilationResults;
                            var28_32 = compilationId;
                            $i$f$compileImpl = false;
                            $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                            this_$iv.maybeWaitForTestStart();
                            var31_35 = compilationOptions$iv;
                            p0 /* !! */  = servicesFacade$iv;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$2 = false;
                            messageCollector$iv = new CompileServicesFacadeMessageCollector(p0 /* !! */ , (CompilationOptions)p1);
                            p1 = compilationOptions$iv;
                            p0 /* !! */  = servicesFacade$iv;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = false;
                            daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter(p0 /* !! */ , (CompilationOptions)p1);
                            targetPlatform$iv = compilationOptions$iv.getTargetPlatform();
                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments$iv, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                            var37_47 = targetPlatform$iv;
                            var38_48 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[var37_47.ordinal()];
                            switch (var38_48) {
                                case 1: {
                                    v4 = (CLICompiler)new K2JVMCompiler();
                                    break;
                                }
                                case 2: {
                                    v4 = (CLICompiler)new K2JSCompiler();
                                    break;
                                }
                                case 3: {
                                    v4 = (CLICompiler)new KotlinMetadataCompiler();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compiler$iv = var39_50 = v4;
                            k2PlatformArgs$iv = compiler$iv.createArguments();
                            ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments$iv), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs$iv), (boolean)false, (int)4, null);
                            argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs$iv.getErrors());
                            if (argumentParseError$iv == null) break block125;
                            MessageCollector.report$default((MessageCollector)messageCollector$iv, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError$iv, null, (int)4, null);
                            v5 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                            break block126;
                        }
                        var38_49 = compilationOptions$iv.getCompilerMode();
                        var41_52 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$2[var38_49.ordinal()];
                        block22 : switch (var41_52) {
                            case 1: {
                                (Object)servicesFacade$iv;
                                var42_53 = k2PlatformArgs$iv;
                                p0 /* !! */  = (JpsCompilerServicesFacade)servicesFacade$iv;
                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = false;
                                enabled$iv$iv = p0 /* !! */ .hasIncrementalCaches();
                                $i$f$withIncrementalCompilation = false;
                                isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                try {
                                    if (args$iv$iv.getIncrementalCompilation() == null) {
                                        args$iv$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                    }
                                    $i$a$-withIncrementalCompilation-CompileServiceImplBase$compileImpl$1$1$iv = false;
                                    var47_69 = this_$iv;
                                    var48_73 = sessionId$iv;
                                    var49_77 = daemonReporter$iv;
                                    var50_81 = null;
                                    compilationId$iv$iv = compilationId$iv;
                                    $i$f$doCompile = false;
                                    $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                    var55_101 = $this$doCompile_u24lambda_u240$iv$iv;
                                    sessionId$iv$iv$iv = sessionId$iv$iv;
                                    $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId$iv$iv$iv != false) ** GOTO lbl119
                                    v6 = null;
                                    ** GOTO lbl123
lbl119:
                                    // 1 sources

                                    v6 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                    if (v6 != null) ** GOTO lbl123
                                    v7 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                    ** GOTO lbl275
lbl123:
                                    // 2 sources

                                    session$iv$iv$iv = v6;
                                    try {
                                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                        session$iv$iv = session$iv$iv$iv;
                                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                        v8 = compilationId$iv$iv;
                                        if (v8 != null) {
                                            compilationId$iv$iv = ((Number)v8).intValue();
                                            $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv$iv = false;
                                            v9 = session$iv$iv;
                                            var63_141 = v9 != null ? v9.getData() : null;
                                            v10 = var63_141 instanceof RunningCompilations != false ? (RunningCompilations)var63_141 : null;
                                            if (v10 != null) {
                                                runningCompilations$iv$iv = var63_141 = v10;
                                                $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv$iv = false;
                                                runningCompilations$iv$iv.add(compilationId$iv$iv);
                                                v11 = var63_141;
                                            } else {
                                                v11 = null;
                                            }
                                        } else {
                                            v11 = null;
                                        }
                                        v12 = runningCompilations$iv$iv = v11;
                                        compilationCanceledStatus$iv$iv = v12 != null ? v12.getCompilationCanceledStatus(compilationId$iv$iv.intValue()) : null;
                                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                        eventManager$iv$iv = new EventManagerImpl();
                                        try {
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                            runningCompilations$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                            $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv$iv = daemonMessageReporter$iv$iv;
                                            rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                            $i$f$checkedCompile = false;
                                            try {
                                                var71_188 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                obj$iv$iv$iv$iv = null;
                                                $i$f$withMeasure = false;
                                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                var76_211 = rpcProfiler$iv$iv;
                                                eventManger$iv = eventManager$iv$iv;
                                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = profiler$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = eventManger$iv;
                                                p0 /* !! */  = (CompilerCallbackServicesFacade)servicesFacade$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$4 = false;
                                                services$iv = this.createCompileServices(p0 /* !! */ , (EventManager)p1, (Profiler)p2);
                                                exitCode$iv = compiler$iv.exec(messageCollector$iv, services$iv, k2PlatformArgs$iv);
                                                it$iv = var82_238 = compilationResults$iv;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                compilationResult$iv = it$iv;
                                                $this$forEach$iv$iv = CompileServiceImplBase.access$getPerformanceMetrics((CompileServiceImplBase)this_$iv, compiler$iv);
                                                $i$f$forEach = false;
                                                for (T element$iv$iv : $this$forEach$iv$iv) {
                                                    it$iv = (BuildMetricsValue)element$iv$iv;
                                                    $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1$iv = false;
                                                    compilationResult$iv.add(CompilationResultCategory.BUILD_METRICS.getCode(), it$iv);
                                                }
                                                res$iv$iv$iv$iv = exitCode$iv.getCode();
                                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    withGC$iv$iv$iv$iv = false;
                                                    $i$f$usedMemory = false;
                                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                    v13 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                } else {
                                                    v13 = 0L;
                                                }
                                                endMem$iv$iv$iv = v13;
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                    rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                    v14 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                    rt$iv$iv$iv$iv = "%+d";
                                                    var96_288 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                    v15 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(var96_288, ((Object[])var96_288).length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"format(...)");
                                                    it$iv$iv$iv = v14.append(v15).append(" kb)").toString();
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                    daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    for (Object var96_288 : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                        obj$iv$iv$iv = var96_288.getKey();
                                                        counters$iv$iv$iv = (PerfCounters)var96_288.getValue();
                                                        it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                        daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    }
                                                }
                                                v16 = res$iv$iv$iv;
                                            }
                                            catch (Throwable e$iv$iv$iv) {
                                                v17 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                v18 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                v19 = e$iv$iv$iv.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"getStackTrace(...)");
                                                v20 = v18.append(ArraysKt.joinToString$default((Object[])v19, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                    v21 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                    v22 = e$iv$iv$iv.getCause();
                                                    Intrinsics.checkNotNull((Object)v22);
                                                    v23 = v22.getStackTrace();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"getStackTrace(...)");
                                                    v24 = v21.append(ArraysKt.joinToString$default((Object[])v23, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                } else {
                                                    v24 = "";
                                                }
                                                v17.log(Level.SEVERE, v20.append(v24).toString());
                                                throw e$iv$iv$iv;
                                            }
                                            exitCode$iv$iv = ((Number)v16).intValue();
                                            exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                            v25 = runningCompilations$iv$iv;
                                        }
                                        catch (Throwable this_$iv$iv$iv) {
                                            v26 = runningCompilations$iv$iv;
                                            if (v26 != null) {
                                                v26.remove(compilationId$iv$iv.intValue());
                                                v27 = Unit.INSTANCE;
                                            } else {
                                                v27 = null;
                                            }
                                            ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                            eventManager$iv$iv.fireCompilationFinished();
                                            throw this_$iv$iv$iv;
                                        }
                                        if (v25 != null) {
                                            v25.remove(compilationId$iv$iv.intValue());
                                            v28 = Unit.INSTANCE;
                                        } else {
                                            v28 = null;
                                        }
                                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                        eventManager$iv$iv.fireCompilationFinished();
                                        var101_294 = exitCode$iv$iv;
                                        v7 = var101_294;
                                    }
                                    finally {
                                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                    }
lbl275:
                                    // 2 sources

                                    var31_38 = v7;
                                    v5 = var31_38;
                                    break;
                                }
                                finally {
                                    IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                }
                            }
                            case 2: {
                                args$iv$iv = this_$iv;
                                enabled$iv$iv = sessionId$iv;
                                $i$f$withIncrementalCompilation = daemonReporter$iv;
                                isEnabledBackup$iv$iv = null;
                                compilationId$iv$iv = compilationId$iv;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                tracer$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                sessionId$iv$iv$iv = sessionId$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv$iv == false) {
                                    v29 = null;
                                } else {
                                    v29 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                    if (v29 == null) {
                                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                        break;
                                    }
                                }
                                session$iv$iv$iv = v29;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    session$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    v30 = compilationId$iv$iv;
                                    if (v30 != null) {
                                        compilationId$iv$iv = ((Number)v30).intValue();
                                        $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv$iv = false;
                                        v31 = session$iv$iv;
                                        session$iv$iv$iv = v31 != null ? v31.getData() : null;
                                        v32 = session$iv$iv$iv instanceof RunningCompilations != false ? (RunningCompilations)session$iv$iv$iv : null;
                                        if (v32 != null) {
                                            runningCompilations$iv$iv = session$iv$iv$iv = v32;
                                            $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv$iv = false;
                                            runningCompilations$iv$iv.add(compilationId$iv$iv);
                                            v33 = session$iv$iv$iv;
                                        } else {
                                            v33 = null;
                                        }
                                    } else {
                                        v33 = null;
                                    }
                                    v34 = runningCompilations$iv$iv = v33;
                                    compilationCanceledStatus$iv$iv = v34 != null ? v34.getCompilationCanceledStatus(compilationId$iv$iv.intValue()) : null;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                        runningCompilations$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                        $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv$iv = daemonMessageReporter$iv$iv;
                                        rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            runningCompilations$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            $this$withMeasure$iv$iv$iv$iv = compilationCanceledStatus$iv$iv;
                                            obj$iv$iv$iv$iv = rpcProfiler$iv$iv;
                                            pc$iv$iv$iv = eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                            v35 = compiler$iv;
                                            v36 = messageCollector$iv;
                                            v37 = compilationCanceled$iv;
                                            if (v37 == null) ** GOTO lbl364
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = v37;
                                            profiler$iv = v36;
                                            eventManger$iv = v35;
                                            $i$a$-let-CompileServiceImplBase$compileImpl$1$2$exitCode$1$iv = false;
                                            services$iv = new Services.Builder().register(CompilationCanceledStatus.class, (Object)it$iv).build();
                                            v35 = eventManger$iv;
                                            v36 = profiler$iv;
                                            v38 = services$iv;
                                            v37 = v38;
                                            if (v38 != null) ** GOTO lbl365
lbl364:
                                            // 2 sources

                                            v37 = Services.EMPTY;
lbl365:
                                            // 2 sources

                                            exitCode$iv = v35.exec(v36, v37, k2PlatformArgs$iv);
                                            perfString$iv = compiler$iv.getDefaultPerformanceManager().createPerformanceReport(PerformanceManager.DumpFormat.PlainText);
                                            v39 = compilationResults$iv;
                                            if (v39 != null) {
                                                it$iv = it$iv = v39;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1$iv = new String[]{perfString$iv};
                                                it$iv.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])$i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1$iv));
                                                v40 = it$iv;
                                            } else {
                                                v40 = null;
                                            }
                                            res$iv$iv$iv$iv = exitCode$iv.getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v41 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v41 = 0L;
                                            }
                                            endMem$iv$iv$iv = v41;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                v42 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                var85_252 = "%+d";
                                                element$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                v43 = String.format(var85_252, Arrays.copyOf(element$iv$iv, element$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"format(...)");
                                                it$iv$iv$iv = v42.append(v43).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                for (Object it$iv$iv$iv : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                    it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v44 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v45 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v46 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            v47 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"getStackTrace(...)");
                                            v48 = v46.append(ArraysKt.joinToString$default((Object[])v47, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v49 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v50 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v50);
                                                v51 = v50.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v51, (String)"getStackTrace(...)");
                                                v52 = v49.append(ArraysKt.joinToString$default((Object[])v51, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v52 = "";
                                            }
                                            v45.log(Level.SEVERE, v48.append(v52).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v44).intValue();
                                        exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                        v53 = runningCompilations$iv$iv;
                                    }
                                    catch (Throwable this_$iv$iv$iv) {
                                        v54 = runningCompilations$iv$iv;
                                        if (v54 != null) {
                                            v54.remove(compilationId$iv$iv.intValue());
                                            v55 = Unit.INSTANCE;
                                        } else {
                                            v55 = null;
                                        }
                                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                        eventManager$iv$iv.fireCompilationFinished();
                                        throw this_$iv$iv$iv;
                                    }
                                    if (v53 != null) {
                                        v53.remove(compilationId$iv$iv.intValue());
                                        v56 = Unit.INSTANCE;
                                    } else {
                                        v56 = null;
                                    }
                                    ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                    eventManager$iv$iv.fireCompilationFinished();
                                    var104_296 = exitCode$iv$iv;
                                    v5 = var104_296;
                                    break;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
                            }
                            case 3: {
                                gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions$iv;
                                gradleIncrementalServicesFacade$iv = servicesFacade$iv;
                                var44_61 = targetPlatform$iv;
                                var45_64 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[var44_61.ordinal()];
                                switch (var45_64) {
                                    case 1: {
                                        args$iv$iv = k2PlatformArgs$iv;
                                        enabled$iv$iv = true;
                                        $i$f$withIncrementalCompilation = false;
                                        isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                        IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                        try {
                                            if (args$iv$iv.getIncrementalCompilation() == null) {
                                                args$iv$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withIncrementalCompilation$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                            sessionId$iv$iv$iv = this_$iv;
                                            $i$f$withValidClientOrSessionProxy = sessionId$iv;
                                            session$iv$iv$iv = daemonReporter$iv;
                                            session$iv$iv = null;
                                            compilationId$iv$iv = compilationId$iv;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                            sessionId$iv$iv$iv = sessionId$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId$iv$iv$iv != false) ** GOTO lbl495
                                            v57 = null;
                                            ** GOTO lbl499
lbl495:
                                            // 1 sources

                                            v57 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                            if (v57 != null) ** GOTO lbl499
                                            v58 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                            ** GOTO lbl649
lbl499:
                                            // 2 sources

                                            session$iv$iv$iv = v57;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                session$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                v59 = compilationId$iv$iv;
                                                if (v59 != null) {
                                                    compilationId$iv$iv = ((Number)v59).intValue();
                                                    $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv$iv = false;
                                                    v60 = session$iv$iv;
                                                    obj$iv$iv$iv$iv = v60 != null ? v60.getData() : null;
                                                    v61 = obj$iv$iv$iv$iv instanceof RunningCompilations != false ? (RunningCompilations)obj$iv$iv$iv$iv : null;
                                                    if (v61 != null) {
                                                        runningCompilations$iv$iv = obj$iv$iv$iv$iv = v61;
                                                        $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv$iv = false;
                                                        runningCompilations$iv$iv.add(compilationId$iv$iv);
                                                        v62 = obj$iv$iv$iv$iv;
                                                    } else {
                                                        v62 = null;
                                                    }
                                                } else {
                                                    v62 = null;
                                                }
                                                v63 = runningCompilations$iv$iv = v62;
                                                compilationCanceledStatus$iv$iv = v63 != null ? v63.getCompilationCanceledStatus(compilationId$iv$iv.intValue()) : null;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                                    runningCompilations$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                                    $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv$iv = daemonMessageReporter$iv$iv;
                                                    rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        it$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        exitCode$iv = compilationCanceledStatus$iv$iv;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                                        v64 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                                        v65 = compilationResults$iv;
                                                        Intrinsics.checkNotNull((Object)v65);
                                                        var106_301 = gradleIncrementalArgs$iv;
                                                        var107_303 = v65;
                                                        var108_304 = gradleIncrementalServicesFacade$iv;
                                                        var109_305 = messageCollector$iv;
                                                        var110_307 = gradleIncrementalArgs$iv;
                                                        var111_309 = v64;
                                                        var112_311 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v66 = b;
                                                        Intrinsics.checkNotNull((Object)v66);
                                                        var114_315 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v66, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler((CompileServiceImplBase)var112_311, var111_309, var110_307, var109_305, var114_315, (CompilationCanceledStatus)compilationCanceled$iv).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v67 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v67 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v67;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                            v68 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            rt$iv$iv$iv$iv = "%+d";
                                                            $i$f$forEach = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v69 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf($i$f$forEach, $i$f$forEach.length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v69, (String)"format(...)");
                                                            it$iv$iv$iv = v68.append(v69).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                            for (Object it$iv$iv$iv : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v70 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v71 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v72 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v73 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v73, (String)"getStackTrace(...)");
                                                        v74 = v72.append(ArraysKt.joinToString$default((Object[])v73, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v75 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v76 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v76);
                                                            v77 = v76.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v77, (String)"getStackTrace(...)");
                                                            v78 = v75.append(ArraysKt.joinToString$default((Object[])v77, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v78 = "";
                                                        }
                                                        v71.log(Level.SEVERE, v74.append(v78).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v70).intValue();
                                                    exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                    v79 = runningCompilations$iv$iv;
                                                }
                                                catch (Throwable this_$iv$iv$iv) {
                                                    v80 = runningCompilations$iv$iv;
                                                    if (v80 != null) {
                                                        v80.remove(compilationId$iv$iv.intValue());
                                                        v81 = Unit.INSTANCE;
                                                    } else {
                                                        v81 = null;
                                                    }
                                                    ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                    throw this_$iv$iv$iv;
                                                }
                                                if (v79 != null) {
                                                    v79.remove(compilationId$iv$iv.intValue());
                                                    v82 = Unit.INSTANCE;
                                                } else {
                                                    v82 = null;
                                                }
                                                ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                                eventManager$iv$iv.fireCompilationFinished();
                                                var92_280 = exitCode$iv$iv;
                                                v58 = var92_280;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl649:
                                            // 2 sources

                                            var104_297 = v58;
                                            v5 = var104_297;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                        }
                                    }
                                    case 2: {
                                        args$iv$iv = k2PlatformArgs$iv;
                                        enabled$iv$iv = true;
                                        $i$f$withJsIC = false;
                                        isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                                        IncrementalCompilation.setIsEnabledForJs((boolean)true);
                                        try {
                                            if (args$iv$iv.getIncrementalCompilation() == null) {
                                                args$iv$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                            this_$iv$iv = this_$iv;
                                            sessionId$iv$iv = sessionId$iv;
                                            daemonMessageReporter$iv$iv = daemonReporter$iv;
                                            tracer$iv$iv = null;
                                            compilationId$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u240$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                            sessionId$iv$iv$iv = sessionId$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId$iv$iv$iv != false) ** GOTO lbl681
                                            v83 = null;
                                            ** GOTO lbl685
lbl681:
                                            // 1 sources

                                            v83 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get((int)sessionId$iv$iv$iv);
                                            if (v83 != null) ** GOTO lbl685
                                            v84 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv$iv);
                                            ** GOTO lbl803
lbl685:
                                            // 2 sources

                                            session$iv$iv$iv = v83;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                session$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                runningCompilations$iv$iv = null;
                                                compilationCanceledStatus$iv$iv = null;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u240$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u240$iv$iv;
                                                    daemonMessageReporter$iv$iv$iv = daemonMessageReporter$iv$iv;
                                                    rpcProfiler$iv$iv$iv = rpcProfiler$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        $this$withMeasure$iv$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                                        v85 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                                        v86 = compilationResults$iv;
                                                        Intrinsics.checkNotNull((Object)v86);
                                                        var117_318 = gradleIncrementalArgs$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = v86;
                                                        c = gradleIncrementalServicesFacade$iv;
                                                        var109_306 = messageCollector$iv;
                                                        var110_308 = gradleIncrementalArgs$iv;
                                                        var111_310 = v85;
                                                        var112_312 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v87 = b;
                                                        Intrinsics.checkNotNull((Object)v87);
                                                        var114_316 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v87, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler((CompileServiceImplBase)var112_312, var111_310, var110_308, var109_306, var114_316).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v88 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v88 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v88;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv$iv.getTotalCounters();
                                                            v89 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            var82_241 = "%+d";
                                                            e$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v90 = String.format(var82_241, Arrays.copyOf(e$iv$iv$iv, e$iv$iv$iv.length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v90, (String)"format(...)");
                                                            it$iv$iv$iv = v89.append(v90).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            for (Map.Entry var86_256 : rpcProfiler$iv$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = var86_256.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)var86_256.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonMessageReporter$iv$iv$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v91 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v92 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v93 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v94 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v94, (String)"getStackTrace(...)");
                                                        v95 = v93.append(ArraysKt.joinToString$default((Object[])v94, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v96 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v97 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v97);
                                                            v98 = v97.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v98, (String)"getStackTrace(...)");
                                                            v99 = v96.append(ArraysKt.joinToString$default((Object[])v98, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v99 = "";
                                                        }
                                                        v92.log(Level.SEVERE, v95.append(v99).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v91).intValue();
                                                    var67_169 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var91_277 = var67_169;
                                                v84 = var91_277;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl803:
                                            // 2 sources

                                            var93_286 = v84;
                                            v5 = var93_286;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv$iv);
                                        }
                                    }
                                }
                                throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform$iv);
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    var16_19 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var16_19 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var16_19;
            }
            var11_12 = v3;
        }
        finally {
            var10_10.unlock();
        }
        return var11_12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult cancelCompilation(int sessionId, int compilationId) {
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var6_6 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var6_6.lock();
        try {
            block20: {
                block17: {
                    block19: {
                        block18: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var8_9 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block17;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block18;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block19;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    block21: {
                        $i$a$-ifAlive$default-CompileServiceImpl$cancelCompilation$1 = false;
                        var18_22 = this;
                        sessionId$iv = sessionId;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv != 0) break block21;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getSessions().get(sessionId$iv);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv).incrementAndGet();
                            session = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$cancelCompilation$1$1 = false;
                            v6 = session;
                            var24_29 = v6 != null ? v6.getData() : null;
                            v7 = var24_29 instanceof RunningCompilations != false ? (RunningCompilations)var24_29 : null;
                            if (v7 != null) {
                                v7.remove(compilationId);
                            }
                            var22_26 = new CompileService.CallResult.Ok();
                            v5 = var22_26;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var12_15 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var12_15 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var12_15;
            }
            var7_8 = v3;
        }
        finally {
            var6_6.unlock();
        }
        return var7_8;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder.register(IncrementalCompilationComponents.class, (Object)new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder.register(LookupTracker.class, (Object)new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, (Object)new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder.register(ExpectActualTracker.class, (Object)new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasInlineConstTracker()) {
            builder.register(InlineConstTracker.class, (Object)new RemoteInlineConstTracker(facade, rpcProfiler));
        }
        if (facade.hasEnumWhenTracker()) {
            builder.register(EnumWhenTracker.class, (Object)new RemoteEnumWhenTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder.register(IncrementalResultsConsumer.class, (Object)new RemoteIncrementalResultsConsumer(facade, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder.register(IncrementalDataProvider.class, (Object)new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block14: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block11: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block13: {
                        block12: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block11;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block12;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block13;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block14;
                }
                try {
                    CompileService.CallResult callResult4;
                    boolean bl = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable((String)("Disposable for " + Reflection.getOrCreateKotlinClass(CompileServiceImpl.class).getSimpleName() + ".leaseReplSession"));
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv).readLock();
        var5_5.lock();
        try {
            block22: {
                block19: {
                    block21: {
                        block20: {
                            $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                            var7_8 = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block19;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block20;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block21;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    v3 = new CompileService.CallResult.Dying();
                    break block22;
                }
                try {
                    block23: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        var17_21 = this;
                        sessionId$iv = sessionId;
                        $i$f$withValidRepl = false;
                        var20_24 = (CompileServiceImplBase)this_$iv;
                        sessionId$iv$iv = sessionId$iv;
                        $i$f$withValidReplImpl = false;
                        var23_27 = this_$iv$iv;
                        sessionId$iv$iv$iv = sessionId$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv$iv$iv != 0) break block23;
                        v4 = null;
                        ** GOTO lbl-1000
                    }
                    v4 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId$iv$iv$iv);
                    if (v4 == null) {
                        v5 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv$iv$iv = v4;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            v6 = session$iv$iv;
                            v7 = v6 != null ? v6.getData() : null;
                            if (v7 == null) {
                                v7 = null;
                            }
                            if (v7 != null) {
                                $this$replCreateState_u24lambda_u240_u240 = (KotlinJvmReplService)v7;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v8 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u240_u240.createRemoteState(this.getPort()));
                            } else {
                                v8 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv$iv);
                            }
                            var31_36 = v8;
                            v5 = var31_36;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var11_14 = v5;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var11_14 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v3 = var11_14;
            }
            var6_7 = v3;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block20: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block17: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block19: {
                        block18: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block17;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block18;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block19;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    CompileService.CallResult callResult4;
                    block15: {
                        void this_$iv$iv$iv;
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        int sessionId$iv$iv;
                        block22: {
                            int sessionId$iv$iv$iv;
                            block21: {
                                void this_$iv$iv2;
                                void this_$iv2;
                                boolean bl = false;
                                CompileServiceImpl compileServiceImpl2 = this;
                                int sessionId$iv = sessionId;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv2;
                                sessionId$iv$iv = sessionId$iv;
                                boolean $i$f$withValidReplImpl = false;
                                void var25_29 = this_$iv$iv2;
                                sessionId$iv$iv$iv = sessionId$iv$iv;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv$iv != 0) break block21;
                                clientOrSessionProxy = null;
                                break block22;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId$iv$iv$iv);
                            if (clientOrSessionProxy != null) break block22;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv$iv);
                            break block15;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block24: {
                                block23: {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block23;
                                    KotlinJvmReplService $this$replCheck_u24lambda_u240_u240 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl3 = false;
                                    CompileService.CallResult callResult7 = $this$replCheck_u24lambda_u240_u240.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCheck$lambda$0$0$0($this$replCheck_u24lambda_u240_u240, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block24;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv$iv);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block20: {
                CompileService.CallResult callResult3;
                void this_$iv$iv;
                block17: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block19: {
                        block18: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block17;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block18;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block19;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block20;
                }
                try {
                    CompileService.CallResult callResult4;
                    block15: {
                        void this_$iv$iv$iv;
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        int sessionId$iv$iv;
                        block22: {
                            int sessionId$iv$iv$iv;
                            block21: {
                                void this_$iv$iv2;
                                void this_$iv2;
                                boolean bl = false;
                                CompileServiceImpl compileServiceImpl2 = this;
                                int sessionId$iv = sessionId;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv2;
                                sessionId$iv$iv = sessionId$iv;
                                boolean $i$f$withValidReplImpl = false;
                                void var25_29 = this_$iv$iv2;
                                sessionId$iv$iv$iv = sessionId$iv$iv;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv$iv != 0) break block21;
                                clientOrSessionProxy = null;
                                break block22;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId$iv$iv$iv);
                            if (clientOrSessionProxy != null) break block22;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv$iv);
                            break block15;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block24: {
                                block23: {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block23;
                                    KotlinJvmReplService $this$replCompile_u24lambda_u240_u240 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl3 = false;
                                    CompileService.CallResult callResult7 = $this$replCompile_u24lambda_u240_u240.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCompile$lambda$0$0$0($this$replCompile_u24lambda_u240_u240, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block24;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId$iv$iv);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block28: {
            block27: {
                block26: {
                    block31: {
                        block33: {
                            block32: {
                                if (this.getState().getDelayedShutdownQueued().get()) {
                                    return;
                                }
                                anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                                var2_2 = this;
                                minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                                $i$f$ifAliveUnit = false;
                                var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
                                var5_5.lock();
                                $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                                var7_10 = this_$iv;
                                minAliveness$iv$iv = minAliveness$iv;
                                $i$f$ifAliveChecksImpl = false;
                                curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                                if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block31;
                                stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                                rmiBusinessCallDepth$iv$iv = 1;
                                Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                                v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                                if (v0 == null) break block32;
                                it$iv$iv = v0;
                                $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                                v1 = " Operation: " + it$iv$iv;
                                v0 = v1;
                                if (v1 != null) break block33;
                            }
                            v2 = Thread.currentThread().getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                            v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                        }
                        callSource$iv$iv = v0;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl79
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block26;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var5_5.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block27;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var5_5.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block28;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var5_5.unlock();
            return;
        }
        try {
            stackTrace$iv$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    stackTrace$iv$iv = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
lbl79:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable this_$iv$iv) {
            throw this_$iv$iv;
        }
        finally {
            var5_5.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
        var5_5.lock();
        try {
            block37: {
                block34: {
                    block36: {
                        block35: {
                            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                            this_$iv$iv = this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block34;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v3 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v3 == null) break block35;
                            it$iv$iv = v3;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v4 = " Operation: " + it$iv$iv;
                            v3 = v4;
                            if (v4 != null) break block36;
                        }
                        v5 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getStackTrace(...)");
                        v3 = ArraysKt.joinToString$default((Object[])v5, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v3;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block37;
                }
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != 0 && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var11_16 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var11_16 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var6_9 = Unit.INSTANCE;
        }
        finally {
            var5_5.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            block13: {
                void this_$iv$iv;
                block10: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    boolean bl3 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void initiateElections() {
        $this$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAliveUnit = false;
        var4_4 = CompileServiceImpl.access$getRwlock$p($this$iv).readLock();
        var4_4.lock();
        try {
            block21: {
                block18: {
                    block20: {
                        block19: {
                            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                            var6_7 = $this$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block18;
                            stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            v0 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (v0 == null) break block19;
                            it$iv$iv = v0;
                            $i$a$-let-CompileServiceImplBase$ifAliveChecksImpl$callSource$1$iv$iv = false;
                            v1 = " Operation: " + it$iv$iv;
                            v0 = v1;
                            if (v1 != null) break block20;
                        }
                        v2 = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        v0 = ArraysKt.joinToString$default((Object[])v2, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    callSource$iv$iv = v0;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block21;
                }
                try {
                    block22: {
                        block23: {
                            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                            $i$a$-ifAliveUnit$default-CompileServiceImpl$initiateElections$1 = false;
                            this.getLog().info("initiate elections");
                            aliveWithOpts = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$0$0(org.jetbrains.kotlin.daemon.CompileServiceImpl java.io.File int ), (Ljava/io/File;Ljava/lang/Integer;)Ljava/lang/Boolean;)((CompileServiceImpl)this), (Function2<? super DaemonReportCategory, ? super String, Unit>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$0$1(org.jetbrains.kotlin.daemon.CompileServiceImpl org.jetbrains.kotlin.daemon.common.DaemonReportCategory java.lang.String ), (Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;Ljava/lang/String;)Lkotlin/Unit;)((CompileServiceImpl)this)));
                            var18_23 = new DaemonJVMOptionsMemoryComparator();
                            var18_23 = new Comparator(var18_23){
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                                    Comparator comparator = this.$comparator;
                                    boolean bl = false;
                                    DaemonWithMetadata it = (DaemonWithMetadata)a;
                                    DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                                    bl = false;
                                    DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                                    return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
                                }
                            };
                            var19_24 = new FileAgeComparator();
                            comparator = new Comparator(var18_23, var19_24){
                                final /* synthetic */ Comparator $this_thenBy;
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$this_thenBy = $receiver;
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    int n;
                                    int previousCompare = this.$this_thenBy.compare(a, b);
                                    if (previousCompare != 0) {
                                        n = previousCompare;
                                    } else {
                                        DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                        Comparator comparator = this.$comparator;
                                        boolean bl = false;
                                        DaemonWithMetadata it = (DaemonWithMetadata)b;
                                        File file = it.getRunFile();
                                        bl = false;
                                        File file2 = it.getRunFile();
                                        n = comparator.compare(file, file2);
                                    }
                                    return n;
                                }
                            };
                            v3 = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts, (Comparator)comparator);
                            if (v3 == null) break block22;
                            bestDaemonWithMetadata = v3;
                            $i$a$-let-CompileServiceImpl$initiateElections$1$1 = false;
                            fattestOpts = bestDaemonWithMetadata.getJvmOptions();
                            if (!DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.daemonJVMOptions)) break block23;
                            if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) >= 0) break block23;
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            $this$forEach$iv = aliveWithOpts;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                var28_36 = (DaemonWithMetadata)element$iv;
                                $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1 = false;
                                daemon = var28_36.component1();
                                runFile = var28_36.component2();
                                try {
                                    it = var32_44 = daemon.getClients();
                                    $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$1$1 = false;
                                    v4 = it.isGood() != false ? var32_44 : null;
                                    if (v4 != null) {
                                        it = v4;
                                        $i$a$-let-CompileServiceImpl$initiateElections$1$1$1$2 = false;
                                        $this$forEach$iv = it.get();
                                        $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            clientAliveFile = (String)element$iv;
                                            $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1$2$1 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + FilesKt.normalize((File)runFile).getAbsolutePath() + "'): " + e.getMessage());
                                }
                            }
                            break block22;
                        }
                        if (!DaemonParamsKt.memorywiseFitsInto(this.daemonJVMOptions, fattestOpts)) ** GOTO lbl-1000
                        if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) > 0) {
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            it = var25_31 = this.getClients();
                            $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$2 = false;
                            v5 = it.isGood() != false ? var25_31 : null;
                            if (v5 != null) {
                                it = v5;
                                $i$a$-let-CompileServiceImpl$initiateElections$1$1$3 = false;
                                $this$forEach$iv = it.get();
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$3$1 = false;
                                    bestDaemonWithMetadata.getDaemon().registerClient(it);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                        }
                    }
                    var10_13 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_14 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var5_6 = Unit.INSTANCE;
        }
        finally {
            var4_4.unlock();
        }
    }

    private final void shutdownNow() {
        this.getLog().info("Shutdown started");
        Runtime $this$shutdownNow_u24lambda_u240 = Runtime.getRuntime();
        boolean bl = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u240.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u240.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u240.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.getOnShutdown().invoke();
        Handler[] handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl2 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        TimerTask timerTask = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                block9: {
                    void this_$iv;
                    TimerTask $this$shutdownWithDelay_u24lambda_u240 = this;
                    boolean bl = false;
                    this.this$0.getState().getDelayedShutdownQueued().set(false);
                    if (this.$currentClientsCount$inlined != this.this$0.getState().getClientsCounter() || this.$currentCompilationsCount$inlined != this.this$0.getCompilationsCounter().get() || this.$currentSessionId$inlined != this.this$0.getState().getSessions().getLastSessionId()) break block9;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        block13: {
                            CompileService.CallResult callResult;
                            void this_$iv$iv;
                            block10: {
                                Object object;
                                int curState$iv$iv;
                                CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                                block12: {
                                    block11: {
                                        boolean bl2 = false;
                                        CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                                        minAliveness$iv$iv = minAliveness$iv;
                                        boolean $i$f$ifAliveChecksImpl = false;
                                        curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                                        if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block10;
                                        Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                                        int rmiBusinessCallDepth$iv$iv = 1;
                                        Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                                        object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                                        if (object == null) break block11;
                                        StackTraceElement it$iv$iv = object;
                                        boolean bl3 = false;
                                        String string = " Operation: " + it$iv$iv;
                                        object = string;
                                        if (string != null) break block12;
                                    }
                                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                                    object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                                }
                                Object callSource$iv$iv = object;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                                CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                                break block13;
                            }
                            try {
                                boolean bl4 = false;
                                boolean bl5 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info("Invalid state for graceful shutdown: " + this.toAlivenessName(this.getState().getAlive().get()));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            TimerTask timerTask = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                public void run() {
                    TimerTask $this$gracefulShutdown_u24lambda_u241 = this;
                    boolean bl = false;
                    CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle(this.this$0);
                }
            };
            timer.schedule(timerTask, l);
        }
        return true;
    }

    @Override
    public void clearJarCache() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCache_u24lambda_u240 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCache_u24lambda_u240.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCache_u24lambda_u240.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCache_u24lambda_u240.idleCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block11: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block8: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block10: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block11;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            block11: {
                void this_$iv;
                block8: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block10: {
                        block9: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block8;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block9;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block10;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block11;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            block13: {
                void this_$iv;
                block10: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block11;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block13: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block10: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                void this_$iv;
                block12: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block14: {
                        block13: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block12;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block13;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block14;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            block13: {
                CompileService.CallResult callResult;
                void this_$iv;
                block10: {
                    Object object;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block12: {
                        block11: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block10;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object == null) break block11;
                            StackTraceElement it$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object = string;
                            if (string != null) break block12;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            block15: {
                CompileService.CallResult callResult;
                void this_$iv;
                block12: {
                    Object object2;
                    int curState$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv;
                    block14: {
                        block13: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = $this;
                            minAliveness$iv = minAliveness;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv).getAlive().get();
                            if (curState$iv >= minAliveness$iv.ordinal()) break block12;
                            Object[] stackTrace$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv);
                            object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv, (int)rmiBusinessCallDepth$iv);
                            if (object2 == null) break block13;
                            StackTraceElement it$iv = object2;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv;
                            object2 = string;
                            if (string != null) break block14;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv = object2;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv, curState$iv) + "\n                    |" + (String)callSource$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    boolean bl = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final ReplCheckResult replCheck$lambda$0$0$0(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.check(state, $codeLine);
    }

    private static final ReplCompileResult replCompile$lambda$0$0$0(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.compile(state, $codeLine);
    }

    private static final boolean initiateElections$lambda$0$0(CompileServiceImpl this$0, File file, int p) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<unused var>");
        return p != this$0.getPort();
    }

    private static final Unit initiateElections$lambda$0$1(CompileServiceImpl this$0, DaemonReportCategory daemonReportCategory, String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)daemonReportCategory), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.getLog().info(msg);
        return Unit.INSTANCE;
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this$0;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            block16: {
                CompileService.CallResult callResult;
                void this_$iv$iv;
                block13: {
                    Object object;
                    int curState$iv$iv;
                    CompileServiceImplBase.Aliveness minAliveness$iv$iv;
                    block15: {
                        block14: {
                            boolean bl = false;
                            CompileServiceImplBase compileServiceImplBase = (CompileServiceImplBase)this_$iv;
                            minAliveness$iv$iv = minAliveness$iv;
                            boolean $i$f$ifAliveChecksImpl = false;
                            curState$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getAlive().get();
                            if (curState$iv$iv >= minAliveness$iv$iv.ordinal()) break block13;
                            Object[] stackTrace$iv$iv = Thread.currentThread().getStackTrace();
                            int rmiBusinessCallDepth$iv$iv = 1;
                            Intrinsics.checkNotNull((Object)stackTrace$iv$iv);
                            object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace$iv$iv, (int)rmiBusinessCallDepth$iv$iv);
                            if (object == null) break block14;
                            StackTraceElement it$iv$iv = object;
                            boolean bl2 = false;
                            String string = " Operation: " + it$iv$iv;
                            object = string;
                            if (string != null) break block15;
                        }
                        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                    }
                    Object callSource$iv$iv = object;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness$iv$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName((CompileServiceImplBase)this_$iv$iv, curState$iv$iv) + "\n                    |" + (String)callSource$iv$iv + "\n                    "), null, (int)1, null));
                    CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    boolean bl = false;
                    boolean bl3 = false;
                    if (this$0.getState().getSessions().isEmpty()) {
                        this$0.shutdownWithDelay();
                    } else {
                        this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
                        this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
                        this$0.getLog().info("Some sessions are active, waiting for them to finish");
                        this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                    }
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

