/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.buildtools.api.CompilationResult;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.CompilerExecutionStrategyConfiguration;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.SharedApiClassesClassLoader;
import org.jetbrains.kotlin.buildtools.api.SourcesChanges;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalCompilationApproachParameters;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.IncrementalCompilationApproachParameters;
import org.jetbrains.kotlin.buildtools.api.jvm.IncrementalJvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmCompilationConfiguration;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.maven.KotlinArtifactResolver;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.maven.LegacyKotlinMavenLogger;
import org.jetbrains.kotlin.maven.Util;
import org.jetbrains.kotlin.maven.incremental.FileCopier;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;
    @Parameter(property="kotlin.compiler.jvmTarget")
    protected String jvmTarget;
    @Parameter(property="kotlin.compiler.jdkHome")
    protected String jdkHome;
    @Parameter(property="kotlin.compiler.scriptTemplates")
    protected List<String> scriptTemplates;
    @Parameter(property="kotlin.compiler.incremental", defaultValue="false")
    private boolean myIncremental;
    @Parameter(property="kotlin.compiler.incremental.cache.root", defaultValue="${project.build.directory}/kotlin-ic")
    public String incrementalCachesRoot;
    @Parameter(property="kotlin.compiler.javaParameters")
    protected boolean javaParameters;
    @Parameter(property="kotlin.compiler.daemon", defaultValue="true")
    protected boolean useDaemon;
    @Parameter(property="kotlin.compiler.daemon.jvmArgs")
    protected List<String> kotlinDaemonJvmArgs;
    @Parameter(property="kotlin.compiler.daemon.shutdownDelayMs")
    protected Long daemonShutdownDelayMs;
    private static final Duration DEFAULT_NON_MAVEN_DAEMON_SHUTDOWN_DELAY = Duration.ofMinutes(30L);
    private static final Duration DEFAULT_MAVEN_DAEMON_SHUTDOWN_DELAY = Duration.ofSeconds(1L);
    private static final String MAVEN_DAEMON_PROPERTY_NAME = "mvnd.home";
    @Inject
    private KotlinArtifactResolver kotlinArtifactResolver;

    @NotNull
    private File getCachesDir() {
        return new File(this.incrementalCachesRoot, this.getSourceSetName());
    }

    protected boolean isIncremental() {
        return this.myIncremental;
    }

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected List<String> getSourceFilePaths() {
        File kotlinSourcesDir;
        ArrayList<String> paths = new ArrayList<String>(super.getSourceFilePaths());
        File sourcesDir = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, this.getSourceSetName());
        if (sourcesDir.isDirectory()) {
            paths.add(sourcesDir.getAbsolutePath());
        }
        if ((kotlinSourcesDir = AnnotationProcessingManager.getGeneratedKotlinSourcesDirectory(this.project, this.getSourceSetName())).isDirectory()) {
            paths.add(kotlinSourcesDir.getAbsolutePath());
        }
        return paths;
    }

    protected List<String> getClasspath() {
        return Util.filterClassPath(this.project.getBasedir(), this.classpath);
    }

    @NotNull
    protected String getSourceSetName() {
        return "compile";
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        List<String> classpathList;
        arguments.setDestination(this.output);
        arguments.setNoStdlib(true);
        arguments.setJavaParameters(this.javaParameters);
        if (this.module != null || this.testModule != null) {
            this.getLog().warn((CharSequence)"Parameters module and testModule are deprecated and ignored, they will be removed in further release.");
        }
        if (!(classpathList = this.getClasspath()).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            if (this.isJava9Module(sourceRoots)) {
                this.getLog().debug((CharSequence)("Module path: " + classPathString));
                arguments.setJavaModulePath(classPathString);
            } else {
                this.getLog().debug((CharSequence)("Classpath: " + classPathString));
                arguments.setClasspath(classPathString);
            }
        }
        this.getLog().debug((CharSequence)("Classes directory is " + this.output));
        arguments.setDestination(this.output);
        arguments.setModuleName(this.moduleName);
        this.getLog().debug((CharSequence)("Module name is " + this.moduleName));
        if (arguments.getNoOptimize()) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
        if (this.jvmTarget != null) {
            arguments.setJvmTarget(this.jvmTarget);
        } else {
            arguments.setJvmTarget(JvmTarget.DEFAULT.getDescription());
        }
        if (this.jdkHome != null) {
            this.getLog().info((CharSequence)("Overriding JDK home path with: " + this.jdkHome));
            arguments.setJdkHome(this.jdkHome);
        }
        if (this.scriptTemplates != null && !this.scriptTemplates.isEmpty()) {
            arguments.setScriptTemplates(this.scriptTemplates.toArray(new String[0]));
        }
    }

    private boolean isJava9Module(@NotNull List<File> sourceRoots) {
        return sourceRoots.stream().anyMatch(file -> file.getName().equals("module-info.java") || file.isDirectory() && Arrays.stream(file.listFiles()).anyMatch(child -> child.getName().equals("module-info.java")));
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.args != null && this.args.contains("-Xuse-javac")) {
            try {
                URL toolsJar = this.getJdkToolsJarURL();
                if (toolsJar != null) {
                    this.project.getClassRealm().addURL(toolsJar);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.execute();
    }

    private CompilationService getCompilationService() throws MojoExecutionException {
        try {
            Set artifacts = Stream.concat(this.kotlinArtifactResolver.resolveArtifact("org.jetbrains.kotlin", "kotlin-build-tools-impl", Util.getMavenPluginVersion()).stream(), this.kotlinArtifactResolver.resolveArtifact("org.jetbrains.kotlin", "kotlin-scripting-compiler-embeddable", Util.getMavenPluginVersion()).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            URL[] urls = (URL[])artifacts.stream().map(artifact -> {
                File file = artifact.getFile();
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Failed to convert file to URL: " + file, e);
                }
            }).toArray(URL[]::new);
            URLClassLoader btaClassLoader = new URLClassLoader(urls, SharedApiClassesClassLoader.newInstance());
            return CompilationService.loadImplementation((ClassLoader)btaClassLoader);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load Kotlin Build Tools API implementation", e);
        }
    }

    private static String getFileExtension(File file) {
        String fileName = file.getName();
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return "";
        }
        return fileName.substring(lastDotIndex + 1);
    }

    @Override
    @NotNull
    protected ExitCode execCompiler(CLICompiler<K2JVMCompilerArguments> compiler, MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        try {
            ProjectId.ProjectUUID projectId = ProjectId.Companion.RandomProjectUUID();
            CompilationService compilationService = this.getCompilationService();
            CompilerExecutionStrategyConfiguration strategyConfig = compilationService.makeCompilerExecutionStrategyConfiguration();
            if (this.useDaemon) {
                boolean inMavenDaemon;
                boolean bl = inMavenDaemon = System.getProperty(MAVEN_DAEMON_PROPERTY_NAME) != null;
                Duration usedDaemonShutdownDelay = this.daemonShutdownDelayMs != null ? Duration.ofMillis(this.daemonShutdownDelayMs) : (inMavenDaemon ? DEFAULT_MAVEN_DAEMON_SHUTDOWN_DELAY : DEFAULT_NON_MAVEN_DAEMON_SHUTDOWN_DELAY);
                this.getLog().debug((CharSequence)("Using Kotlin compiler daemon with shutdown delay " + usedDaemonShutdownDelay + " ms" + (inMavenDaemon ? " (in Maven daemon)" : " (outside Maven daemon)")));
                strategyConfig.useDaemonStrategy(this.kotlinDaemonJvmArgs, usedDaemonShutdownDelay);
            } else {
                this.getLog().debug((CharSequence)"Using in-process Kotlin compiler");
                strategyConfig.useInProcessStrategy();
            }
            JvmCompilationConfiguration compileConfig = compilationService.makeJvmCompilationConfiguration();
            LegacyKotlinMavenLogger kotlinMavenLogger = new LegacyKotlinMavenLogger(messageCollector, this.getLog());
            compileConfig.useLogger((KotlinLogger)kotlinMavenLogger);
            HashSet<Consumer<CompilationResult>> resultHandlers = new HashSet<Consumer<CompilationResult>>();
            if (this.isIncremental()) {
                resultHandlers.add(this.configureIncrementalCompilation(compileConfig, arguments));
            }
            Set kotlinExtensions = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
            HashSet<String> allExtensions = new HashSet<String>(kotlinExtensions);
            allExtensions.add("java");
            ArrayList allSources = new ArrayList();
            for (File sourceRoot : sourceRoots) {
                Stream<Path> files = Files.walk(sourceRoot.toPath(), new FileVisitOption[0]);
                try {
                    allSources.addAll(files.map(Path::toFile).filter(file -> allExtensions.contains(K2JVMCompileMojo.getFileExtension(file).toLowerCase(Locale.ROOT))).filter(File::isFile).collect(Collectors.toList()));
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            List myArguments = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)arguments);
            CompilationResult result = compilationService.compileJvm((ProjectId)projectId, strategyConfig, compileConfig, allSources, myArguments);
            compilationService.finishProjectCompilation((ProjectId)projectId);
            resultHandlers.forEach(handler -> handler.accept(result));
            switch (result) {
                case COMPILATION_SUCCESS: {
                    return ExitCode.OK;
                }
                case COMPILATION_ERROR: {
                    return ExitCode.COMPILATION_ERROR;
                }
                case COMPILATION_OOM_ERROR: {
                    return ExitCode.OOM_ERROR;
                }
            }
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Internal Kotlin compilation error", t);
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private Consumer<CompilationResult> configureIncrementalCompilation(JvmCompilationConfiguration compileConfig, K2JVMCompilerArguments arguments) {
        this.getLog().warn((CharSequence)"Using experimental Kotlin incremental compilation");
        File cachesDir = this.getCachesDir();
        cachesDir.mkdirs();
        String originalDestination = arguments.getDestination();
        assert (originalDestination != null) : "output is not specified!";
        File classesDir = new File(originalDestination);
        File kotlinClassesDir = new File(cachesDir, "classes");
        File snapshotsFile = new File(cachesDir, "snapshots.bin");
        String originalClasspath = arguments.getClasspath();
        arguments.setDestination(kotlinClassesDir.getAbsolutePath());
        if (originalClasspath != null) {
            ArrayList<String> filteredClasspath = new ArrayList<String>();
            for (String path : originalClasspath.split(File.pathSeparator)) {
                if (classesDir.equals(new File(path))) continue;
                filteredClasspath.add(path);
            }
            arguments.setClasspath(StringUtil.join(filteredClasspath, (String)File.pathSeparator));
        }
        ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration icConf = compileConfig.makeClasspathSnapshotBasedIncrementalCompilationConfiguration();
        ClasspathSnapshotBasedIncrementalCompilationApproachParameters classpathSnapshotParams = new ClasspathSnapshotBasedIncrementalCompilationApproachParameters(Collections.EMPTY_LIST, new File(cachesDir, "shrunk-classpath-snapshot.bin"));
        compileConfig.useIncrementalCompilation(cachesDir, (SourcesChanges)SourcesChanges.ToBeCalculated.INSTANCE, (IncrementalCompilationApproachParameters)classpathSnapshotParams, (IncrementalJvmCompilationConfiguration)icConf);
        return compilationResult -> {
            if (compilationResult == CompilationResult.COMPILATION_SUCCESS) {
                new FileCopier(this.getLog()).syncDirs(kotlinClassesDir, classesDir, snapshotsFile);
            }
            arguments.setDestination(originalDestination);
            arguments.setClasspath(originalClasspath);
        };
    }

    @Nullable
    private URL getJdkToolsJarURL() throws IOException {
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getCanonicalFile().toURI().toURL();
        }
        if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getCanonicalFile().toURI().toURL();
        }
        return null;
    }
}

